/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commoncomponents.codecoverage.core.exporters.events;

import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.model.EventSeverity;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class FopEventListener
implements EventListener {
    private static ILog fLog;
    public static final String PLUGIN_ID = "com.ibm.commoncomponents.codecoverage.core.exporters";

    static {
        try {
            fLog = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processEvent(Event event) {
        String msg = EventFormatter.format((Event)event);
        EventSeverity severity = event.getSeverity();
        if (fLog == null) {
            boolean trace;
            String traceString = System.getProperty("trace");
            boolean bl = trace = traceString != null && Boolean.TRUE.equals(Boolean.parseBoolean(traceString));
            if (severity == EventSeverity.FATAL || severity == EventSeverity.ERROR || trace) {
                System.out.println(msg);
            }
        } else if (severity == EventSeverity.INFO) {
            fLog.log((IStatus)new Status(1, PLUGIN_ID, msg));
        } else if (severity == EventSeverity.WARN) {
            fLog.log((IStatus)new Status(2, PLUGIN_ID, msg));
        } else if (severity == EventSeverity.ERROR) {
            fLog.log((IStatus)new Status(4, PLUGIN_ID, msg));
        } else if (severity == EventSeverity.FATAL) {
            fLog.log((IStatus)new Status(4, PLUGIN_ID, msg));
        } else {
            fLog.log((IStatus)new Status(1, PLUGIN_ID, msg));
        }
    }
}

