/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug;

import com.ibm.cdz.remote.debug.DebugEngineDefaultPath;
import com.ibm.cdz.remote.debug.IRemotePDTCommandLauncher;
import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.impl.RemoteDBXCommandLauncherImpl;
import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.IPDTDebuggerEngine;
import com.ibm.debug.pdt.internal.core.IDebugSessionStartupInfo;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.etools.systems.launch.IRemoteCommandLauncher;
import com.ibm.etools.systems.launch.RemoteProcess;
import com.ibm.etools.systems.launch.UniversalLaunchUtil;
import com.ibm.etools.systems.launch.impl.RemoteCommandLauncherImpl;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.HybridStartupInfo;
import com.ibm.ftt.debug.ui.util.RemoteUtil;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteSystemEnvVar;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;

public class UniversalPDTLaunchBaseDelegate
implements ILaunchConfigurationDelegate,
IUniversalPDTLaunchConstants {
    private static final char SEMICOLON = ';';
    private static final String LIBPATH = "LIBPATH";
    private static final String PATH = "PATH";
    private static final char QUOTE = '\"';
    private static final String EMPTY = "";
    protected ResourceBundle stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
    protected IRemoteCommandLauncher remoteCommandLauncher = null;
    private String pathSeparator = ":";
    private String engineExecutablePath = null;
    private static DebugEngineDefaultPath[] defaultEnginePaths;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.engineExecutablePath = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.info.launching.begin") + configuration.getName(), 2);
        monitor.subTask(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.info.launching.verifyLC"));
        String mainType = this.verifyMainTypeName(configuration);
        Shell shell = PDTLaunchPlugin.getActiveWorkbenchShell();
        if (mainType == null) {
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.noMain"), null, 101);
        }
        String systemConnectionProfileName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionProfileName", EMPTY);
        String systemConnectionAliasName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
        IHost systemConnection = UniversalLaunchUtil.getSystemConnection((String)systemConnectionProfileName, (String)systemConnectionAliasName);
        IRemoteFileSubSystem fileSubSystem = RemoteFileUtility.getFileSubSystem((IHost)systemConnection);
        this.pathSeparator = fileSubSystem.getPathSeparator();
        String programArguments = this.getProgramArguments(configuration);
        String workingPath = this.getRemoteWorkingDirectory(configuration);
        if (!this.pathExist(workingPath, systemConnection, monitor)) {
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.workingDirectoryNotExist"), null, 107);
        }
        Map<String, String> environments = this.getEnvironments(configuration);
        try {
            RemoteCommandHelpers.getCmdSubSystem((IHost)systemConnection).connect(monitor, false);
        }
        catch (Exception e) {
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.invalidRSEConnection"), null, 102);
        }
        if (monitor.isCanceled()) {
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.launchCanceled"), null, 103);
        }
        monitor.worked(1);
        monitor.subTask(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.info.launching.invokeApp"));
        boolean useDebugTool = UniversalPDTLaunchBaseDelegate.isUseDebugTool(configuration);
        boolean useID = UniversalPDTLaunchBaseDelegate.isUseIntegratedDebugger(configuration);
        boolean isCCMode = mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode());
        this.remoteCommandLauncher = mode.equals("debug") || isCCMode ? new RemoteDBXCommandLauncherImpl(shell, systemConnection, null, workingPath) : new RemoteCommandLauncherImpl(shell, systemConnection, null, workingPath);
        PICLEngineParameters configurationParameters = new PICLEngineParameters(mainType, programArguments);
        boolean append = true;
        if (configuration.hasAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES)) {
            append = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        }
        IRemoteCmdSubSystem cmdSubSystem = RemoteCommandHelpers.getCmdSubSystem((IHost)systemConnection);
        IRemoteSystemEnvVar[] oldVars = cmdSubSystem.getEnvironmentVariableList();
        Object setEnvCmd = EMPTY;
        if (mode.equals("debug") || mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode())) {
            String dPort = RemoteUtil.getLocalClientPort();
            if (!CoreDaemon.startListening()) {
                this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.pdtDaemonFailed"), null, 108);
                return;
            }
            String uiHost = this.resolveHost(configuration, systemConnection);
            String uiPort = dPort;
            configurationParameters.setUIHost(uiHost);
            configurationParameters.setUIPort(uiPort);
            boolean runToMain = this.getRuntoMain(configuration);
            int debugTargetKey = CoreDaemon.generateKey();
            configurationParameters.setKey(debugTargetKey);
            HybridStartupInfo loadInfo = null;
            loadInfo = new HybridStartupInfo(useID);
            if (useID) {
                loadInfo.setProcessID("1");
            } else {
                loadInfo.setProgramName(configurationParameters.getMainType());
                loadInfo.setProgramParms(configurationParameters.getProgramArguments());
            }
            loadInfo.setLaunchConfig(configuration);
            if (runToMain) {
                loadInfo.setStartupBehaviour(1);
            } else {
                loadInfo.setStartupBehaviour(2);
            }
            IPDTDebugTarget debugTarget = this.getDebugTarget(launch, (PICLAbstractStartupInfo)loadInfo, configuration, debugTargetKey);
            CoreDaemon.storeDebugTarget((IDebugTarget)debugTarget, (int)debugTargetKey);
            if (isCCMode) {
                CCLaunchUtils.getCCInfoProvider().updateCCOptions(debugTarget, configuration, useDebugTool);
            }
            if (this.remoteCommandLauncher instanceof RemoteDBXCommandLauncherImpl) {
                ((RemoteDBXCommandLauncherImpl)this.remoteCommandLauncher).setDebugTarget(debugTarget);
            }
            String dbxLocation = this.getDBXLocation(configuration, systemConnection);
            Object dbxLibpath = this.getDBXLibpath(configuration);
            StringBuilder stepLib = new StringBuilder();
            if (useDebugTool || useID) {
                StringBuffer hostBuffer = new StringBuffer();
                boolean isDbmActive = DebugLaunchUtils.isDebugManagerReady((String)systemConnection.getName());
                IZOSSystemImage systemImage = DebugLaunchUtils.getConnection((String)systemConnection.getName());
                String testOption = DebugLaunchUtils.getTestParm((boolean)isDbmActive, (IZOSSystemImage)systemImage, (boolean)useID, null, null, null, null, null, null);
                hostBuffer.append('\"');
                hostBuffer.append(testOption);
                hostBuffer.append('\"');
                if (useID) {
                    stepLib.append("export STEPLIB=\"$STEPLIB:$RSE_DSN_SFELLOAD:$RSE_DSN_SFEKLOAD\";");
                }
                String key = (mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode()) && useDebugTool ? "CC," : EMPTY) + configurationParameters.getKey();
                setEnvCmd = stepLib.toString() + "export EQA_STARTUP_KEY=" + key + ";export _CEE_RUNOPTS=" + hostBuffer.toString();
            } else {
                int index;
                environments.put("_DBX_EPDCSTARTUP", "-startupKey=" + debugTargetKey);
                char sep = fileSubSystem.getSeparatorChar();
                if (dbxLocation != null && dbxLocation.length() > 0 && (index = dbxLocation.lastIndexOf(sep)) > 0) {
                    String dbxPath = dbxLocation.substring(0, index);
                    this.appendWorkingPathToPath(environments, dbxPath);
                }
                if (((String)dbxLibpath).length() > 0) {
                    dbxLibpath = (String)dbxLibpath + ":$LIBPATH";
                    environments.put(LIBPATH, (String)dbxLibpath);
                }
            }
            String[] environmentNames = this.getEnvironmentNames(environments);
            String[] environmentValues = this.getEnvironmentValues(environmentNames, environments);
            setEnvCmd = this.getEnvironmentVariableListCommand(append, (String)setEnvCmd, oldVars, environmentNames, environmentValues);
            if (!useDebugTool && !useID) {
                IRemoteFile dbxExecutable = null;
                try {
                    dbxExecutable = fileSubSystem.getRemoteFileObject(dbxLocation, monitor);
                }
                catch (Exception e) {
                    PDTLaunchPlugin.logError((String)e.getMessage());
                }
                if (dbxExecutable == null || !dbxExecutable.exists() || !dbxExecutable.isFile()) {
                    this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.dbxNotExist"), null, 109);
                    return;
                }
                launch.addDebugTarget((IDebugTarget)debugTarget);
                ((IRemotePDTCommandLauncher)this.remoteCommandLauncher).setDebugTarget(debugTarget);
                configurationParameters.setEnginePath(dbxLocation);
                Object cmdString = this.createDBGCmdString(configurationParameters, this.pathSeparator);
                if (!((String)setEnvCmd).trim().isEmpty()) {
                    cmdString = (String)setEnvCmd + ";" + (String)cmdString;
                }
                if (PDTLaunchPlugin.isTracingON()) {
                    String info = "UniversalPDTLaunchBaseDelegate.launch() \nPICL debug engine launch command : " + (String)cmdString;
                    PDTLaunchPlugin.logInfo((String)info);
                }
                this.remoteCommandLauncher.setCommandString((String)cmdString);
                if (monitor.isCanceled()) {
                    return;
                }
            } else {
                launch.addDebugTarget((IDebugTarget)debugTarget);
                ((IRemotePDTCommandLauncher)this.remoteCommandLauncher).setDebugTarget(debugTarget);
                Object cmdString = this.createRunCmdString(configurationParameters, RemoteFileUtility.getFileSubSystem((IHost)systemConnection).getPathSeparator());
                if (PDTLaunchPlugin.isTracingON()) {
                    String info = "UniversalPDTLaunchBaseDelegate.launch() \nProgram launch command : " + (String)cmdString;
                    PDTLaunchPlugin.logInfo((String)info);
                }
                cmdString = (String)setEnvCmd + ";" + (String)cmdString;
                this.remoteCommandLauncher.setCommandString((String)cmdString);
            }
        } else {
            String[] environmentNames = this.getEnvironmentNames(environments);
            String[] environmentValues = this.getEnvironmentValues(environmentNames, environments);
            setEnvCmd = this.getEnvironmentVariableListCommand(append, (String)setEnvCmd, oldVars, environmentNames, environmentValues);
            Object cmdString = this.createRunCmdString(configurationParameters, RemoteFileUtility.getFileSubSystem((IHost)systemConnection).getPathSeparator());
            cmdString = (String)setEnvCmd + ";" + (String)cmdString;
            if (PDTLaunchPlugin.isTracingON()) {
                String info = "UniversalPDTLaunchBaseDelegate.launch() \nProgram launch command : " + (String)cmdString;
                System.out.println(info);
                PDTLaunchPlugin.logInfo((String)info);
            }
            this.remoteCommandLauncher.setCommandString((String)cmdString);
            RemoteProcess remoteProcess = this.remoteCommandLauncher.getProcess();
            if (remoteProcess != null) {
                IProcess runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)remoteProcess, (String)mainType);
                launch.addProcess(runtimeProcess);
            }
        }
        OpenPerspectiveThread openThread = new OpenPerspectiveThread(launch);
        Display.getDefault().syncExec((Runnable)openThread);
        RemoteCommandLaunchThread remoteCommandLaunchThread = new RemoteCommandLaunchThread(this.remoteCommandLauncher);
        Display.getDefault().syncExec((Runnable)remoteCommandLaunchThread);
        if (monitor.isCanceled()) {
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.launchCanceled"), null, 103);
            return;
        }
        monitor.worked(1);
        monitor.done();
    }

    private IPDTDebugTarget getDebugTarget(ILaunch launch, PICLAbstractStartupInfo loadInfo, ILaunchConfiguration configuration, int debugTargetKey) {
        IPDTDebugTarget target = PDTCorePlugin.getSpecializedDebugTarget((ILaunch)launch, (IDebugSessionStartupInfo)loadInfo, (ILaunchConfiguration)configuration, (int)debugTargetKey);
        if (target == null) {
            target = new PICLDebugTarget(launch, loadInfo, loadInfo.getEngineConnection());
        }
        return target;
    }

    public static boolean isUseIntegratedDebugger(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.hasAttribute("com.ibm.cdz.remote.debug.attr.ENGINE")) {
            return configuration.getAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", 0) == 0;
        }
        return false;
    }

    public static boolean isUseDebugTool(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.hasAttribute("com.ibm.cdz.remote.debug.attr.ENGINE")) {
            return configuration.getAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", 0) == 1;
        }
        return configuration.getAttribute("com.ibm.cdz.remote.debug.attr.UseDebugTool", false);
    }

    private String getEnvironmentVariableListCommand(boolean append, String setEnvCmd, IRemoteSystemEnvVar[] oldVars, String[] environmentNames, String[] environmentValues) {
        StringBuilder sb = new StringBuilder();
        if (environmentNames != null && environmentNames.length > 0) {
            int i = 0;
            while (i < environmentNames.length) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append("export ");
                sb.append(environmentNames[i]);
                sb.append('=');
                sb.append(environmentValues[i]);
                ++i;
            }
        }
        if (setEnvCmd != null && !setEnvCmd.trim().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(setEnvCmd);
        }
        return sb.toString();
    }

    private boolean getRuntoMain(ILaunchConfiguration configuration) {
        try {
            boolean runToMain = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.stopInMain", true);
            return runToMain;
        }
        catch (CoreException e) {
            return true;
        }
    }

    private String getDBXLocation(ILaunchConfiguration configuration, IHost systemConnection) {
        block5: {
            try {
                boolean isAutoDebugEnginePath = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", true);
                if (isAutoDebugEnginePath) {
                    String connectionType = systemConnection.getSystemType().getId();
                    boolean isLocalEngine = connectionType.equalsIgnoreCase("org.eclipse.rse.systemtype.local");
                    boolean isLocalWindows = UniversalLaunchUtil.isLocalWindows((IHost)systemConnection);
                    if (!isLocalEngine) {
                        return this.getDBXExecutablePath(systemConnection);
                    }
                    if (isLocalWindows) {
                        return this.resolveLocalWindowsEnginePath();
                    }
                    break block5;
                }
                String path = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.DebugEnginePath", EMPTY).trim();
                return path;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return EMPTY;
    }

    private String getDBXLibpath(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute("com.ibm.cdz.remote.debug.attr.dbxLibPath", EMPTY);
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    private String resolveLocalWindowsEnginePath() {
        IPDTDebuggerEngine piclLauncher = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.debuggerengines");
        if (extensionPoint == null) {
            return EMPTY;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getAttribute("os").equals(Platform.getOS()) && element.getAttribute("arch").equals(Platform.getOSArch()) && element.getAttribute("type").equals("picl")) {
                try {
                    Object callback = element.createExecutableExtension("class");
                    if (callback instanceof IPDTDebuggerEngine) {
                        piclLauncher = (IPDTDebuggerEngine)callback;
                        break;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (piclLauncher == null) {
            return EMPTY;
        }
        String enginePath = piclLauncher.getInstallDirectory().getPath();
        if (enginePath.indexOf(47) >= 0) {
            enginePath = enginePath.indexOf(47) == 0 ? enginePath.substring(1).replace('/', '\\') : enginePath.replace('/', '\\');
        }
        return enginePath + "bin" + File.separator;
    }

    private String getProgramArguments(ILaunchConfiguration configuration) {
        String programArguments = EMPTY;
        try {
            programArguments = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.ProgramArguments", EMPTY);
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)e.getMessage(), (Throwable)e);
        }
        return programArguments;
    }

    protected void abort(String errorString, Throwable exception, int err_code_invalid_rseconnection) throws CoreException {
        if (PDTLaunchPlugin.isTracingON() || PDTLaunchPlugin.isErrorLoggingON()) {
            String info = "UniversalPDTLaunchBaseDelegate.abort() \n throws exception " + errorString + "\nerror code: " + err_code_invalid_rseconnection;
            PDTLaunchPlugin.logError((String)info);
        }
        throw new CoreException((IStatus)new Status(4, PDTLaunchPlugin.getPluginID(), err_code_invalid_rseconnection, errorString, exception));
    }

    private String verifyMainTypeName(ILaunchConfiguration configuration) {
        String mainType = EMPTY;
        try {
            mainType = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.Main", EMPTY);
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)e.getMessage(), (Throwable)e);
        }
        return mainType;
    }

    private String resolveHost(ILaunchConfiguration configuration, IHost connection) throws CoreException {
        IConnectorService service = RemoteFileUtility.getFileSubSystem((IHost)connection).getConnectorService();
        if (service instanceof DStoreConnectorService) {
            return ((DStoreConnectorService)service).getClientIP();
        }
        this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.error.invalidHost"), null, 105);
        return EMPTY;
    }

    protected void cleanuUp(ILaunch launch) {
        try {
            IProcess[] processList = launch.getProcesses();
            if (processList == null) {
                return;
            }
            IProcess activeIseriesProcess = processList[0];
            IDebugTarget activeDebugTarget = launch.getDebugTarget();
            if (activeIseriesProcess != null) {
                activeIseriesProcess.terminate();
                if (activeDebugTarget != null) {
                    activeDebugTarget.terminate();
                }
            }
        }
        catch (DebugException debugException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] getEnvironmentNames(Map<String, String> environments) {
        if (environments != null && environments.size() > 0) {
            String[] names = new String[environments.size()];
            environments.keySet().toArray(names);
            return names;
        }
        return new String[0];
    }

    private String[] getEnvironmentValues(String[] keys, Map<String, String> environments) {
        if (keys != null && keys.length > 0) {
            String[] values = new String[keys.length];
            int i = 0;
            while (i < values.length) {
                values[i] = environments.get(keys[i]);
                ++i;
            }
            return values;
        }
        return new String[0];
    }

    public String createDBGCmdString(PICLEngineParameters configurationParameters, String pathSeperator) {
        StringBuffer cmdStringBuffer = new StringBuffer();
        cmdStringBuffer.append(configurationParameters.getDebugEnginePath().trim());
        cmdStringBuffer.append(" -p ");
        cmdStringBuffer.append(configurationParameters.getUIHost());
        cmdStringBuffer.append(':');
        cmdStringBuffer.append(configurationParameters.getUIPort());
        cmdStringBuffer.append(' ');
        cmdStringBuffer.append(' ');
        cmdStringBuffer.append(configurationParameters.getMainType());
        cmdStringBuffer.append(' ');
        cmdStringBuffer.append(configurationParameters.getProgramArguments());
        return cmdStringBuffer.toString();
    }

    public String createRunCmdString(PICLEngineParameters configurationParameters, String pathSeperator) {
        Object cmdString = EMPTY;
        cmdString = ((String)cmdString).trim() + " ./" + configurationParameters.getMainType() + " ";
        cmdString = ((String)cmdString).trim() + " " + configurationParameters.getProgramArguments();
        return ((String)cmdString).trim();
    }

    protected Map<String, String> getEnvironments(ILaunchConfiguration configuration) throws CoreException {
        try {
            Map environments = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
            return environments;
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)"Failed to retrieve attributes from launch configuration", (Throwable)e);
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.unexpected"), e, 106);
            return null;
        }
    }

    public void appendWorkingPathToPath(Map<String, String> environments, String workingPath) {
        String existingPath = environments.get(PATH);
        if (existingPath == null) {
            environments.put(PATH, "$PATH" + this.pathSeparator + workingPath);
        } else {
            environments.put(PATH, existingPath + this.pathSeparator + workingPath);
        }
    }

    public String getDBXExecutablePath(IHost systemConnection) {
        String picl_default_path;
        String connectionType = systemConnection.getSystemType().getId();
        this.engineExecutablePath = picl_default_path = UniversalPDTLaunchBaseDelegate.loadEngineDefaultPathExtension(connectionType);
        return this.engineExecutablePath;
    }

    private static synchronized String loadEngineDefaultPathExtension(String connectionType) {
        if (defaultEnginePaths == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("com.ibm.cdz.remote.debug.debugLocator");
            if (point != null) {
                IExtension[] extensions = point.getExtensions();
                defaultEnginePaths = new DebugEngineDefaultPath[extensions.length];
                String id = EMPTY;
                String connection = EMPTY;
                String defaultPath = EMPTY;
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    if (elements != null && elements.length > 0) {
                        if ("engineLocator".equals(elements[0].getName())) {
                            id = elements[0].getAttribute("id");
                            connection = elements[0].getAttribute("systemType");
                            defaultPath = elements[0].getAttribute("defaultPath");
                            UniversalPDTLaunchBaseDelegate.defaultEnginePaths[i] = new DebugEngineDefaultPath(id, connection, defaultPath);
                        }
                    } else {
                        PDTLaunchPlugin.logError((String)"UniversalPDTLaunchBaseDelegate.loadEngineDefaultPathExtension:  Error loading source locator", null);
                    }
                    ++i;
                }
            } else {
                PDTLaunchPlugin.logError((String)"UniversalPDTLaunchBaseDelegate.loadEngineDefaultPathExtension:  Error loading debugLocator extension point", null);
            }
        }
        int i = 0;
        while (i < defaultEnginePaths.length) {
            if (defaultEnginePaths[i] != null && defaultEnginePaths[i].getSystemType().equalsIgnoreCase(connectionType)) {
                return defaultEnginePaths[i].getDefaultPath();
            }
            ++i;
        }
        return EMPTY;
    }

    protected String getRemoteWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workingDirectory = null;
        try {
            workingDirectory = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.WorkingDirectory", null);
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)"Failed to retrieve attributes from launch configuration", (Throwable)e);
            this.abort(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.launching.unexpected"), e, 106);
            return EMPTY;
        }
        return workingDirectory;
    }

    private boolean pathExist(String remoteFolder, IHost systemConnection, IProgressMonitor monitor) {
        if (remoteFolder.trim().equals(EMPTY)) {
            return false;
        }
        IRemoteFile remoteFile = null;
        try {
            remoteFile = RemoteFileUtility.getFileSubSystem((IHost)systemConnection).getRemoteFileObject(remoteFolder, monitor);
        }
        catch (SystemMessageException e) {
            return false;
        }
        if (remoteFile == null) {
            return false;
        }
        return remoteFile.exists();
    }

    private static class OpenPerspectiveThread
    extends Thread {
        public OpenPerspectiveThread(ILaunch launch) {
        }

        @Override
        public void run() {
            this.openPerspective(DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.show_debug_perspective_default"));
        }

        public void openPerspective(String perspectiveID) {
            IWorkbench workbench = RSEUIPlugin.getDefault().getWorkbench();
            IWorkbenchWindow workbenchWindow = RSEUIPlugin.getActiveWorkbenchWindow();
            try {
                workbench.showPerspective(perspectiveID, workbenchWindow);
            }
            catch (WorkbenchException excp) {
                PDTLaunchPlugin.logError((String)("Failed to switch to perspective " + perspectiveID), (Throwable)excp);
            }
        }
    }

    private static class PICLEngineParameters {
        private String mainType = "";
        private String programArguments = "";
        private String uiHost = "";
        private String uiPort = "";
        private String enginePath = "";
        private int key = 0;

        public PICLEngineParameters(String mainType, String programArguments) {
            this.mainType = mainType;
            this.programArguments = programArguments;
        }

        public String getKey() {
            return Integer.toString(this.key);
        }

        public void setKey(int debugTargetKey) {
            this.key = debugTargetKey;
        }

        public void setEnginePath(String enginePath) {
            this.enginePath = enginePath;
        }

        public void setUIPort(String uiPort) {
            this.uiPort = uiPort;
        }

        public void setUIHost(String uiHost) {
            this.uiHost = uiHost;
        }

        public String getDebugEnginePath() {
            return this.enginePath;
        }

        public String getMainType() {
            return this.mainType;
        }

        public String getProgramArguments() {
            return this.programArguments;
        }

        public String getUIHost() {
            return this.uiHost;
        }

        public String getUIPort() {
            return this.uiPort;
        }
    }

    private static class RemoteCommandLaunchThread
    extends Thread {
        IRemoteCommandLauncher remoteCommandLauncher = null;

        public RemoteCommandLaunchThread(IRemoteCommandLauncher remoteCommandLauncher) {
            this.remoteCommandLauncher = remoteCommandLauncher;
        }

        @Override
        public void run() {
            try {
                this.remoteCommandLauncher.runCommand((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Unknown error running command", (Throwable)e);
            }
        }
    }
}

