/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.core;

import com.ibm.debug.daemon.CoreDaemonListener;
import com.ibm.debug.daemon.DaemonConnectionInfo;
import com.ibm.debug.daemon.DaemonSocketConnection;
import com.ibm.debug.daemon.ICoreDaemonListenerRegistry;
import com.ibm.debug.daemon.IDaemonCore;
import com.ibm.debug.daemon.IDaemonDebugTarget;
import com.ibm.debug.daemon.IDaemonSupport;
import com.ibm.debug.daemon.IOldDaemonSupport;
import com.ibm.debug.daemon.NameValuePair;
import com.ibm.debug.daemon.internal.core.CoreDaemonPlugin;
import com.ibm.debug.daemon.internal.core.DaemonAuthenticator;
import com.ibm.debug.daemon.internal.core.DaemonException;
import com.ibm.debug.daemon.internal.core.DaemonLabels;
import com.ibm.debug.daemon.internal.core.DaemonMessages;
import com.ibm.debug.daemon.internal.core.IAlternateLaunchType;
import com.ibm.debug.daemon.internal.core.IExtendedDaemonService;
import com.ibm.debug.daemon.internal.core.IOldDaemonDefaultSupportCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;

public class DaemonCore
implements IDaemonCore {
    private static final Object fLock = new Object();
    private static final Object fLock2 = new Object();
    private static final Object fLock3 = new Object();
    public static final int PORT_NOT_LISTENING = -1;
    public static final String DEFAULTPORT = "8001";
    public static final String DEFAULTSECUREPORT = "8002";
    public static final String DEFAULTPORTRANGE = "8001-8010";
    private static int fListeningPortSecure = -1;
    private static final NameValuePair[] EMPTYNAMEVALUEPAIRS = new NameValuePair[0];
    private static volatile boolean isListeningSecure = false;
    private static ServerSocket secureServerSocket;
    private static final Map<Integer, ServerSocket> fServerSockets;
    private static final List<Thread> fThreads;
    private static volatile boolean fAcceptConnections;
    private static InetAddress fBindAddress;
    private static final HashMap<Integer, InetAddress> fBindAddresses;
    protected static volatile int currentKey;
    private static int maxParameterBufferSize;
    private static final Hashtable<Integer, IDebugTarget> targetHashtable;
    protected static final Hashtable<Integer, OldDaemonInput> oldDaemonInputHashtable;
    protected static final Hashtable<Integer, NewDaemonInput> newDaemonInputHashtable;
    private static final Object fListenerRegistryLock;
    private static CoreDaemonListenerRegistry fListenerRegistry;
    private static DaemonCore fInstance;
    private static final Object fDaemonExtendersLock;
    private static IExtendedDaemonService[] fDaemonExtenders;
    private static final Object fAlternateLaunchTypeLock;
    private static IAlternateLaunchType[] fAlternateLaunchTypes;
    private static final Object fAuthenticatorLock;
    private static String[] fAuthenticators;
    private String fAuthKeystoreFile;
    private byte[] fAuthPassword;

    static {
        fServerSockets = new HashMap<Integer, ServerSocket>();
        fThreads = new ArrayList<Thread>();
        fAcceptConnections = true;
        fBindAddress = null;
        fBindAddresses = new HashMap();
        currentKey = 0;
        maxParameterBufferSize = 32000;
        targetHashtable = new Hashtable();
        oldDaemonInputHashtable = new Hashtable();
        newDaemonInputHashtable = new Hashtable();
        fListenerRegistryLock = new Object();
        fListenerRegistry = null;
        fDaemonExtendersLock = new Object();
        fDaemonExtenders = null;
        fAlternateLaunchTypeLock = new Object();
        fAlternateLaunchTypes = null;
        fAuthenticatorLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DaemonCore() {
        Object object = fListenerRegistryLock;
        synchronized (object) {
            if (fListenerRegistry == null) {
                fListenerRegistry = new CoreDaemonListenerRegistry(this);
            }
        }
    }

    public ICoreDaemonListenerRegistry getListenerRegistry() {
        return fListenerRegistry;
    }

    public static synchronized boolean isListening() {
        return !fServerSockets.isEmpty();
    }

    public static synchronized boolean isListeningOnPort(int port) {
        return fServerSockets.containsKey(port);
    }

    public static boolean isListeningSecure() {
        return isListeningSecure;
    }

    public static synchronized int getCurrentPort() {
        if (fServerSockets.isEmpty()) {
            return -1;
        }
        return fServerSockets.keySet().iterator().next();
    }

    public static synchronized Integer[] getCurrentPorts() {
        return fServerSockets.keySet().toArray(new Integer[fServerSockets.size()]);
    }

    public static int getCurrentPortSecure() {
        return fListeningPortSecure;
    }

    public static InetAddress getBindAddress() {
        return fBindAddress;
    }

    public static InetAddress getBindAddress(int port) {
        return fBindAddresses.get(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DaemonCore getInstance() {
        Object object = fLock;
        synchronized (object) {
            if (fInstance == null) {
                fInstance = new DaemonCore();
            }
            return fInstance;
        }
    }

    public static InetAddress[] getLocalAddress() throws UnknownHostException {
        HashSet<InetAddress> list = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = netInterfaces.nextElement();
                if (netInterface.isLoopback()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress()) continue;
                    list.add(addr);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (list.isEmpty()) {
            list.add(InetAddress.getLocalHost());
        }
        return list.toArray(new InetAddress[0]);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws Exception {
        return NetworkInterface.getNetworkInterfaces();
    }

    public static boolean startListening(int port) throws DaemonException {
        return DaemonCore.startListening(port, null);
    }

    public static Integer[] startListening(int[] ports) throws DaemonException {
        return DaemonCore.startListening(ports, null);
    }

    public static boolean startListening(int port, InetAddress bindAddr) throws DaemonException {
        DaemonCore.getInstance().startDaemon(new int[]{port}, bindAddr);
        if (DaemonCore.isListening()) {
            return true;
        }
        throw new DaemonException(NLS.bind((String)DaemonMessages.CRRDG1117, (Object)port));
    }

    public static Integer[] startListening(int[] ports, InetAddress bindAddr) throws DaemonException {
        return DaemonCore.getInstance().startDaemon(ports, bindAddr);
    }

    public static Integer[] startListening(int[] ports, InetAddress[] bindAddresses) throws DaemonException {
        return DaemonCore.getInstance().startDaemon(ports, bindAddresses);
    }

    protected synchronized Integer[] startDaemon(int[] ports, InetAddress bindAddr) {
        Object[] bindAddresses = new InetAddress[ports.length];
        Arrays.fill(bindAddresses, bindAddr);
        return this.startDaemon(ports, (InetAddress[])bindAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Integer[] startDaemon(int[] ports, InetAddress[] bindAddresses) {
        if (DaemonCore.isListening()) {
            return DaemonCore.getCurrentPorts();
        }
        if (bindAddresses != null && bindAddresses.length > 0) {
            Object object = fLock3;
            synchronized (object) {
                fBindAddress = bindAddresses[0];
            }
        }
        int i = 0;
        while (i < ports.length) {
            int port = ports[i];
            try {
                InetAddress bindAddr = bindAddresses[i];
                ServerSocket ss = new ServerSocket(port, 0, bindAddr);
                fServerSockets.put(ss.getLocalPort(), ss);
                fBindAddresses.put(port, bindAddr);
            }
            catch (IOException e) {
                if (CoreDaemonPlugin.fLogging) {
                    CoreDaemonPlugin.log("Could not start daemon listening on port (" + port + "):" + e.getMessage(), e);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                CoreDaemonPlugin.logError("Could not start daemon listening on port (" + port + "):" + e.getMessage(), e);
            }
            ++i;
        }
        if (!fServerSockets.isEmpty() && CoreDaemonPlugin.fLogging) {
            for (Integer port : fServerSockets.keySet()) {
                CoreDaemonPlugin.log("Daemon is now listening on port " + String.valueOf(port), null);
            }
        }
        if (ports.length != fServerSockets.size() && CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Not all of the requested ports (" + ports.length + ") were available, only (" + fServerSockets.size() + ") were allocated");
        }
        Object port = fLock2;
        synchronized (port) {
            fAcceptConnections = true;
        }
        for (ServerSocket ss : fServerSockets.values()) {
            ListenerThread thread = new ListenerThread(ss, false);
            fThreads.add(thread);
            thread.start();
        }
        return fServerSockets.keySet().toArray(new Integer[fServerSockets.size()]);
    }

    public static void stopListening() {
        DaemonCore.getInstance().stopDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopDaemon() {
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Daemon has requested to stop listening", null);
        }
        if (!DaemonCore.isListening()) {
            return;
        }
        Object object = fLock2;
        synchronized (object) {
            fAcceptConnections = false;
        }
        for (ServerSocket serverSocket : fServerSockets.values()) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        fServerSockets.clear();
        Object object2 = fLock3;
        synchronized (object2) {
            fBindAddress = null;
        }
        fBindAddresses.clear();
        for (Thread thread : fThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        fThreads.clear();
        fListenerRegistry.notifyListeners(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startDaemonSecure(int port, String keystoreFileName, char[] keystorePassword) throws SocketException, DaemonException {
        DaemonCore daemonCore = this;
        synchronized (daemonCore) {
            block18: {
                if (!DaemonCore.isListeningSecure()) break block18;
                return true;
            }
            isListeningSecure = true;
        }
        try {
            SSLContext sslContext = DaemonCore.getSSLContext(keystoreFileName, keystorePassword);
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Using protocol: " + sslContext.getProtocol());
            }
            secureServerSocket = sslContext.getServerSocketFactory().createServerSocket(port);
            fListeningPortSecure = port == 0 ? secureServerSocket.getLocalPort() : port;
        }
        catch (FileNotFoundException e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = e.toString();
            }
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Could not start secure daemon listening:" + exceptionMessage, e);
            }
            fListeningPortSecure = -1;
            isListeningSecure = false;
            throw new DaemonException(exceptionMessage);
        }
        catch (SocketException e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = e.toString();
            }
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Could not start secure daemon listening:" + exceptionMessage, e);
            }
            fListeningPortSecure = -1;
            isListeningSecure = false;
            throw e;
        }
        catch (IOException e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = e.toString();
            }
            CoreDaemonPlugin.log("Could not start secure daemon listening:" + exceptionMessage, e);
            fListeningPortSecure = -1;
            isListeningSecure = false;
            throw new DaemonException(NLS.bind((String)DaemonMessages.CRRDG1122, (Object)keystoreFileName));
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = e.toString();
            }
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Could not start secure daemon listening:" + exceptionMessage, e);
            }
            fListeningPortSecure = -1;
            isListeningSecure = false;
            throw new DaemonException(exceptionMessage);
        }
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Secure Daemon is now listening on port " + fListeningPortSecure, null);
        }
        fAcceptConnections = true;
        new ListenerThread(secureServerSocket, true).start();
        return true;
    }

    public static synchronized void stopListeningSecure() {
        if (!isListeningSecure) {
            return;
        }
        fAcceptConnections = false;
        fListeningPortSecure = -1;
        isListeningSecure = false;
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Secure daemon has requested to stop listening", null);
        }
        try {
            secureServerSocket.close();
            secureServerSocket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fListenerRegistry.notifyListeners(4);
    }

    private void readAndProcessRequest(DaemonSocketConnection connection) throws IOException {
        ILaunchConfigurationWorkingCopy copy;
        block68: {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Connection request received!", null);
            }
            int version = connection.beginRead();
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Version: " + version, null);
            }
            if (!this.chkVersion(version)) {
                connection.close();
                return;
            }
            IExtendedDaemonService service = this.getExtendedService(version);
            if (service != null) {
                service.startService(version, connection);
                return;
            }
            if (version == -3) {
                this.processControl(connection);
                return;
            }
            ILaunchConfigurationType type = null;
            ILaunchConfiguration config = null;
            copy = null;
            ILaunchDelegate[] delegates = new ILaunchDelegate[]{};
            HashSet<String> modes = new HashSet<String>();
            modes.add("debug");
            try {
                int key;
                NameValuePair[] pairs;
                block71: {
                    block70: {
                        String configId;
                        block69: {
                            InputStream inputStream = connection.getInputStream();
                            if (version >= 0) {
                                String launchType = DaemonCore.getLaunchConfigurationType();
                                if (CoreDaemonPlugin.fLogging) {
                                    CoreDaemonPlugin.log("Using default launch config " + launchType, null);
                                }
                                if ((type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchType)) == null) {
                                    this.displayError(DaemonLabels.DefaultConfigNotFound_title, DaemonMessages.CRRDG1104);
                                    if (CoreDaemonPlugin.fLogging) {
                                        CoreDaemonPlugin.log("Launch configuration type not found: " + launchType, null);
                                    }
                                    connection.close();
                                    return;
                                }
                                try {
                                    delegates = type.getDelegates(modes);
                                }
                                catch (CoreException e) {
                                    this.displayError(DaemonLabels.DefaultConfigDelegateNotFound_title, DaemonMessages.CRRDG1105);
                                    if (CoreDaemonPlugin.fLogging) {
                                        CoreDaemonPlugin.log("Delegate not found for type " + type.getName(), e);
                                    }
                                    connection.close();
                                }
                                if (delegates.length == 0) {
                                    this.displayError(DaemonLabels.DefaultConfigDelegateNotFound_title, DaemonMessages.CRRDG1105);
                                    if (CoreDaemonPlugin.fLogging) {
                                        CoreDaemonPlugin.log("Delegate not found for type " + type.getName(), null);
                                    }
                                    connection.close();
                                    return;
                                }
                                String[] input = null;
                                if (DaemonCore.hasAuthenticators()) {
                                    int errorCode;
                                    DaemonAuthenticator authenticator = new DaemonAuthenticator(connection, this.fAuthKeystoreFile, this.fAuthPassword);
                                    input = DaemonCore.readOldStyleStrings(inputStream, version, authenticator);
                                    if (authenticator.isAuthenticationRequired() && (errorCode = authenticator.authenticate()) != 0) {
                                        if (errorCode == 21 || errorCode == 22 || errorCode == 23) {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1140);
                                        } else if (errorCode == 20) {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1139);
                                        } else if (errorCode == 1 || errorCode == 2) {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1141);
                                        } else if (errorCode == 3 || errorCode == 4 || errorCode == 5) {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1142);
                                        } else if (errorCode == -4) {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1143);
                                        } else {
                                            this.displayError(DaemonLabels.AuthenticationFailed, DaemonMessages.CRRDG1136);
                                        }
                                        if (errorCode < 0) {
                                            DaemonCore.writeErrorToSocket(errorCode, connection);
                                        } else {
                                            connection.close();
                                        }
                                        return;
                                    }
                                } else {
                                    input = DaemonCore.readOldStyleStrings(inputStream, version, null);
                                }
                                ILaunchConfigurationDelegate delegate = null;
                                try {
                                    delegate = delegates[0].getDelegate();
                                }
                                catch (CoreException e1) {
                                    this.displayError(DaemonLabels.DefaultConfigDelegateNotFound_title, DaemonMessages.CRRDG1105);
                                    if (CoreDaemonPlugin.fLogging) {
                                        CoreDaemonPlugin.log("Delegate not found for type " + type.getName(), null);
                                    }
                                    connection.close();
                                    return;
                                }
                                if (delegate instanceof IOldDaemonDefaultSupportCore) {
                                    ((IOldDaemonDefaultSupportCore)delegate).figureOutWhatToDo(new OldDaemonInput(connection, input, version));
                                } else {
                                    this.compatibilityDelegate(delegate, connection, input, version);
                                }
                                fListenerRegistry.notifyListeners(2);
                                return;
                            }
                            if (version != -2) break block68;
                            pairs = this.readNameValuePairs(inputStream);
                            key = DaemonCore.findKey(pairs);
                            if (key > 0) {
                                IDaemonDebugTarget debugTarget = (IDaemonDebugTarget)DaemonCore.retrieveDebugTarget(key);
                                if (debugTarget != null) {
                                    if (CoreDaemonPlugin.fLogging) {
                                        CoreDaemonPlugin.log("Target found and notified of connection", null);
                                    }
                                    DaemonConnectionInfo info = new DaemonConnectionInfo(connection.getSocket().getInetAddress().getHostName(), "" + connection.getSocket().getPort());
                                    info.setConnection(connection);
                                    debugTarget.engineIsWaiting(info, true);
                                    fListenerRegistry.notifyListeners(2);
                                    return;
                                }
                                if (CoreDaemonPlugin.fLogging) {
                                    CoreDaemonPlugin.log("Target not found-invalid key specified", null);
                                }
                                this.displayError(DaemonLabels.InvalidKey_title, DaemonMessages.CRRDG1111);
                                DaemonCore.writeErrorToSocket(-3, connection);
                                connection.close();
                                return;
                            }
                            configId = DaemonCore.findLaunchConfigID(pairs);
                            try {
                                config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(configId);
                            }
                            catch (Exception e) {
                                if (!CoreDaemonPlugin.fLogging) break block69;
                                CoreDaemonPlugin.log("Exception getting launch configuration " + configId, e);
                            }
                        }
                        if (config == null) {
                            type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(configId);
                            if (type == null) {
                                if (CoreDaemonPlugin.fLogging) {
                                    CoreDaemonPlugin.log("Specified ID not a configuration or a configuration type", null);
                                }
                                this.displayError(DaemonLabels.NotConfigOrType_title, NLS.bind((String)DaemonMessages.CRRDG1107, (Object)configId));
                                return;
                            }
                            try {
                                config = type.newInstance(null, "tmp");
                            }
                            catch (CoreException e) {
                                if (CoreDaemonPlugin.fLogging) {
                                    CoreDaemonPlugin.log("Could not create configuration", e);
                                }
                                this.displayError(DaemonLabels.NotConfigOrType_title, DaemonMessages.CRRDG1108);
                                return;
                            }
                        }
                        try {
                            if (type == null) {
                                type = config.getType();
                            }
                            delegates = type.getDelegates(modes);
                        }
                        catch (CoreException e) {
                            if (!CoreDaemonPlugin.fLogging) break block70;
                            CoreDaemonPlugin.log("Could not get type or delegate", e);
                        }
                    }
                    if (delegates.length == 0) {
                        this.displayError(DaemonLabels.ConfigDelegateNotFound_title, DaemonMessages.CRRDG1109);
                        if (CoreDaemonPlugin.fLogging) {
                            CoreDaemonPlugin.log("Delegate was not found for type" + type.getName(), null);
                        }
                        return;
                    }
                    try {
                        if (!(delegates[0].getDelegate() instanceof IDaemonSupport)) {
                            this.displayError(DaemonLabels.LauncherNotIDaemonSupport_title, DaemonMessages.CRRDG1106);
                            if (CoreDaemonPlugin.fLogging) {
                                CoreDaemonPlugin.log("Specified configuration does not support daemon " + DaemonCore.findLaunchConfigID(pairs), null);
                            }
                            DaemonCore.writeErrorToSocket(-3, connection);
                            connection.close();
                        }
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                    key = DaemonCore.generateKey();
                    DaemonCore.writeKeyToSocket(key, connection);
                    try {
                        copy = config.getWorkingCopy();
                        copy.setAttribute("Key", key);
                        copy.setAttribute("org.eclipse.debug.ui.private", true);
                        copy.doSave();
                    }
                    catch (CoreException e) {
                        if (!CoreDaemonPlugin.fLogging) break block71;
                        CoreDaemonPlugin.log("Exception saving configuration.", e);
                    }
                }
                NewDaemonInput input = new NewDaemonInput(connection, pairs, version);
                DaemonCore.storeNewDaemonInput(key, input);
                connection.endRead();
            }
            catch (IOException e) {
                try {
                    if (version < 0) {
                        DaemonCore.writeErrorToSocket(-2, connection);
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Telling LauncherDelegate to launch", null);
        }
        try {
            if (copy != null) {
                ILaunch launch = null;
                launch = copy.getType().isPublic() ? copy.launch("debug", null) : copy.launch("debug", null, false, false);
                if (launch == null) {
                    connection.close();
                } else {
                    fListenerRegistry.notifyListeners(2);
                }
            }
        }
        catch (CoreException e) {
            connection.close();
        }
    }

    protected void compatibilityDelegate(ILaunchConfigurationDelegate delegate, DaemonSocketConnection connection, String[] input, int version) {
    }

    public static synchronized int generateKey() {
        return currentKey < Integer.MAX_VALUE ? (currentKey = currentKey + 1) : 1;
    }

    public static void storeDebugTarget(IDebugTarget target, int key) {
        targetHashtable.put(key, target);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Target stored in hashtable, key=" + key, null);
        }
    }

    public static void removeDebugTarget(int key) {
        targetHashtable.remove(key);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Target removed from hashtable, key=" + key, null);
        }
    }

    public static IDebugTarget retrieveDebugTarget(int key) {
        IDebugTarget target = targetHashtable.get(key);
        int repeated = 0;
        while (target == null && repeated < 6) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++repeated;
            target = targetHashtable.get(key);
        }
        if (target != null) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Target retrieved from hashtable, key=" + key, null);
            }
            DaemonCore.removeDebugTarget(key);
        } else if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Target NOT FOUND in hashtable, key=" + key, null);
        }
        return target;
    }

    public static void storeOldDaemonInput(int key, OldDaemonInput input) {
        oldDaemonInputHashtable.put(key, input);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Input stored in hashtable, key=" + key, null);
        }
    }

    public static void removeOldDaemonInput(int key) {
        oldDaemonInputHashtable.remove(key);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Input removed from hashtable, key=" + key, null);
        }
    }

    public static OldDaemonInput retrieveOldDaemonInput(int key) {
        OldDaemonInput input = oldDaemonInputHashtable.get(key);
        if (input != null) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Input retrieved from hashtable, key=" + key, null);
            } else if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Input NOT FOUND in hashtable, key=" + key, null);
            }
        }
        return input;
    }

    public static void storeNewDaemonInput(int key, NewDaemonInput input) {
        newDaemonInputHashtable.put(key, input);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Input stored in hashtable, key=" + key, null);
        }
    }

    public static NewDaemonInput retrieveNewDaemonInput(int key) {
        return newDaemonInputHashtable.get(key);
    }

    public static void removeNewDaemonInput(int key) {
        newDaemonInputHashtable.remove(key);
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Input removed from hashtable, key=" + key, null);
        }
    }

    public static void setMaxParameterBuffer(int maxParameterBufferSize) {
        DaemonCore.maxParameterBufferSize = maxParameterBufferSize;
    }

    private static int findKey(NameValuePair[] pairs) {
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i].getName().equalsIgnoreCase("Key")) {
                return Integer.parseInt(pairs[i].getValue());
            }
            ++i;
        }
        return -1;
    }

    private static String findLaunchConfigID(NameValuePair[] pairs) {
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i].getName().equalsIgnoreCase("LaunchConfigTypeID")) {
                return pairs[i].getValue();
            }
            ++i;
        }
        return null;
    }

    private NameValuePair[] readNameValuePairs(InputStream inputStream) {
        DataInputStream dataStream = new DataInputStream(inputStream);
        try {
            int numPairs = dataStream.readInt();
            NameValuePair[] pairs = new NameValuePair[numPairs];
            int i = 0;
            while (i < numPairs) {
                pairs[i] = new NameValuePair(inputStream);
                if (CoreDaemonPlugin.fLogging) {
                    CoreDaemonPlugin.log("Read pair from stream: name=" + pairs[i].getName() + " value=" + pairs[i].getValue());
                }
                ++i;
            }
            return pairs;
        }
        catch (Exception e) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Exception reading pairs from stream:" + e.getMessage(), e);
            }
            return EMPTYNAMEVALUEPAIRS;
        }
    }

    private static String[] readOldStyleStrings(InputStream inputStream, int version, DaemonAuthenticator authenticator) throws IOException {
        int argCount = 0;
        boolean readNull = false;
        String[] buffer = new String[1];
        String[] input = new String[5];
        int i = 0;
        while (i <= 3) {
            readNull = DaemonCore.readLineOrNull(inputStream, buffer, i >= 2);
            input[i] = buffer[0];
            ++i;
        }
        String argCountString = input[3];
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("DebugDaemon Argcount =" + argCountString, null);
        }
        if (argCountString == null || readNull) {
            return input;
        }
        if (argCountString.length() > 0) {
            try {
                argCount = Integer.parseInt(argCountString);
            }
            catch (NumberFormatException e) {
                if (CoreDaemonPlugin.fLogging) {
                    CoreDaemonPlugin.log("Invalid format for number of arguments " + e.getMessage(), e);
                }
                return buffer;
            }
        }
        StringBuilder arguments = new StringBuilder();
        while (argCount-- > 0) {
            readNull = DaemonCore.readLineOrNull(inputStream, buffer, false);
            if (authenticator != null && buffer[0].equals("-qauth")) {
                authenticator.setAuthenticationRequired();
            } else {
                arguments.append(" ");
                arguments.append(buffer[0]);
            }
            if (readNull) break;
        }
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("DebugDaemon Arguments =" + String.valueOf(arguments), null);
        }
        input[4] = arguments.toString();
        return input;
    }

    private static boolean readLineOrNull(InputStream inputStream, String[] answer, boolean blockOnRead) {
        char currentByte;
        int i;
        StringBuffer buffer;
        block7: {
            block6: {
                buffer = new StringBuffer(1024);
                i = 0;
                currentByte = '\u0000';
                if (CoreDaemonPlugin.fLogging) {
                    CoreDaemonPlugin.log("Input stream bytes still available:" + inputStream.available(), null);
                }
                if (!blockOnRead || inputStream.available() != 0) break block6;
                answer[0] = null;
                return true;
            }
            try {
                i = 0;
                currentByte = (char)inputStream.read();
                while (currentByte != '\n' && currentByte != '\r' && currentByte != '\u0000') {
                    buffer.append(currentByte);
                    currentByte = (char)inputStream.read();
                    ++i;
                }
            }
            catch (IOException e) {
                if (!CoreDaemonPlugin.fLogging) break block7;
                CoreDaemonPlugin.log("Error reading line from stream:" + e.getMessage(), e);
            }
        }
        answer[0] = i == 0 ? null : buffer.toString();
        if (CoreDaemonPlugin.fLogging) {
            CoreDaemonPlugin.log("Line read:" + answer[0], null);
        }
        return currentByte == '\u0000';
    }

    private static void writeKeyToSocket(int key, DaemonSocketConnection connection) {
        block14: {
            FilterOutputStream outputStream = null;
            try {
                try {
                    if (CoreDaemonPlugin.fLogging) {
                        CoreDaemonPlugin.log("Writing key to socket: " + key, null);
                    }
                    outputStream = new DataOutputStream(connection.getOutputStreamBuffer());
                    ((DataOutputStream)outputStream).writeInt(key);
                    connection.endWrite();
                }
                catch (Exception e) {
                    if (CoreDaemonPlugin.fLogging) {
                        CoreDaemonPlugin.log("Exception writing key to socket:" + e.getMessage(), e);
                    }
                    if (outputStream == null) break block14;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void writeErrorToSocket(int errorCode, DaemonSocketConnection connection) {
        block14: {
            FilterOutputStream outputStream = null;
            try {
                try {
                    if (CoreDaemonPlugin.fLogging) {
                        CoreDaemonPlugin.log("Writing return code to socket:" + errorCode, null);
                    }
                    outputStream = new DataOutputStream(connection.getOutputStreamBuffer());
                    ((DataOutputStream)outputStream).writeInt(errorCode);
                    connection.endWrite();
                }
                catch (Exception e) {
                    if (CoreDaemonPlugin.fLogging) {
                        CoreDaemonPlugin.log("Exception writing return code " + errorCode + " to socket: " + e.getMessage(), e);
                    }
                    if (outputStream == null) break block14;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean chkVersion(int version) {
        if (version >= 0) {
            if (this.isHandledByExtension(version)) {
                return true;
            }
            if (version < maxParameterBufferSize) {
                return true;
            }
            CoreDaemonPlugin.logError("Incoming debug session parameter buffer size " + version + " is not valid.  Most likely, it is not a valid debug daemon connection.", null);
            return false;
        }
        switch (version) {
            case -1: {
                CoreDaemonPlugin.logError("The communication version " + version + " for Debug Daemon is not supported.", null);
                return false;
            }
            case -2: {
                return true;
            }
            case -3: {
                return true;
            }
        }
        CoreDaemonPlugin.logError("The communication version " + version + " for Debug Daemon is not supported.   Most likely, it is not a valid debug daemon connection.", null);
        return false;
    }

    public void displayError(String label, String message) {
        System.out.println(message);
    }

    private static SSLContext getSSLContext(String keystoreFileName, char[] keystorePassword) throws Exception {
        SSLContext result = null;
        KeyStore keystore = DaemonCore.getKeyStore(keystoreFileName, keystorePassword);
        String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        keyManagerFactory.init(keystore, keystorePassword);
        if (DaemonCore.isIBMVM()) {
            try {
                result = SSLContext.getInstance("SSL_TLSv2");
            }
            catch (NoSuchAlgorithmException e) {
                if (CoreDaemonPlugin.fLogging) {
                    String version = System.getProperty("java.version");
                    CoreDaemonPlugin.log("Error initializing SSL: " + String.valueOf(e) + "\nJava version detected: " + version);
                }
                result = SSLContext.getInstance("TLS");
            }
        } else {
            result = SSLContext.getInstance("SSL");
        }
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        result.init(keyManagers, null, null);
        return result;
    }

    protected static boolean isIBMVM() {
        String vmvendor = System.getProperty("java.vendor");
        boolean result = vmvendor != null && vmvendor.toUpperCase().contains("IBM");
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static KeyStore getKeyStore(String keystoreFileName, char[] keystorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keystore = null;
        FileInputStream fileInputStream = null;
        File keystoreFile = new File(keystoreFileName);
        if (!keystoreFile.exists()) throw new FileNotFoundException(NLS.bind((String)DaemonMessages.CRRDG1115, (Object)keystoreFileName));
        try {
            try {
                fileInputStream = new FileInputStream(keystoreFile);
                keystore = KeyStore.getInstance("JKS");
                keystore.load(fileInputStream, keystorePassword);
                return keystore;
            }
            catch (IOException e) {
                CoreDaemonPlugin.log("Keystore type JKS is not supported, using PKCS12 type instead");
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                fileInputStream = new FileInputStream(keystoreFile);
                keystore = KeyStore.getInstance("PKCS12");
                keystore.load(fileInputStream, keystorePassword);
                if (fileInputStream == null) return keystore;
                fileInputStream.close();
            }
            return keystore;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void processControl(DaemonSocketConnection connection) {
        DataInputStream dis = new DataInputStream(connection.getInputStream());
        try {
            connection.getSocket().setSoTimeout(1000);
            long signature = dis.readLong();
            if (signature != 3141592653589793238L) {
                CoreDaemonPlugin.log("Invalid control signature, request cancelled");
                return;
            }
            try {
                int control = dis.readInt();
                switch (control) {
                    case 2: {
                        if (CoreDaemonPlugin.fLogging) {
                            CoreDaemonPlugin.log("Daemon ping control request");
                        }
                        InetAddress localAddress = connection.getSocket().getLocalAddress();
                        int localPort = connection.getSocket().getLocalPort();
                        DataOutputStream dos = new DataOutputStream(connection.getOutputStreamBuffer());
                        dos.writeInt(2);
                        NameValuePair nvp = new NameValuePair("localAddress", localAddress.getHostAddress());
                        nvp.write(dos);
                        nvp = new NameValuePair("localPort", String.valueOf(localPort));
                        nvp.write(dos);
                        connection.flush();
                        break;
                    }
                    case 1: {
                        if (CoreDaemonPlugin.fLogging) {
                            CoreDaemonPlugin.log("Daemon stop control request");
                        }
                        DaemonCore.stopListening();
                        break;
                    }
                    default: {
                        CoreDaemonPlugin.log("Invalid control code, no change to daemon processing");
                        break;
                    }
                }
            }
            catch (SocketTimeoutException stoe) {
                CoreDaemonPlugin.log("Read timed out.   Possible invalid control request, no change to daemon processing");
            }
            catch (IOException ioe) {
                CoreDaemonPlugin.log("Invalid control request, no change to daemon processing");
            }
        }
        finally {
            try {
                connection.close();
                dis.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDaemonExtenders() {
        Object object = fDaemonExtendersLock;
        synchronized (object) {
            if (fDaemonExtenders == null) {
                ArrayList<IExtendedDaemonService> extenders = new ArrayList<IExtendedDaemonService>();
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.daemon.core.extendedDaemon");
                if (ep != null) {
                    IConfigurationElement[] configElements;
                    IConfigurationElement[] iConfigurationElementArray = configElements = ep.getConfigurationElements();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        try {
                            extenders.add((IExtendedDaemonService)element.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            CoreDaemonPlugin.log(e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                fDaemonExtenders = extenders.toArray(new IExtendedDaemonService[extenders.size()]);
            }
        }
    }

    private boolean isHandledByExtension(int version) {
        DaemonCore.loadDaemonExtenders();
        IExtendedDaemonService[] iExtendedDaemonServiceArray = fDaemonExtenders;
        int n = fDaemonExtenders.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedDaemonService extender = iExtendedDaemonServiceArray[n2];
            if (extender.isHandled(version)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IExtendedDaemonService getExtendedService(int version) {
        DaemonCore.loadDaemonExtenders();
        IExtendedDaemonService[] iExtendedDaemonServiceArray = fDaemonExtenders;
        int n = fDaemonExtenders.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedDaemonService extender = iExtendedDaemonServiceArray[n2];
            if (extender.isHandled(version)) {
                return extender;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAlternateLaunchType() {
        Object object = fAlternateLaunchTypeLock;
        synchronized (object) {
            if (fAlternateLaunchTypes == null) {
                ArrayList<IAlternateLaunchType> types = new ArrayList<IAlternateLaunchType>();
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.daemon.core.alternateLaunchType");
                if (ep != null) {
                    IConfigurationElement[] configElements;
                    IConfigurationElement[] iConfigurationElementArray = configElements = ep.getConfigurationElements();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        try {
                            types.add((IAlternateLaunchType)element.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            CoreDaemonPlugin.log(e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                fAlternateLaunchTypes = types.toArray(new IAlternateLaunchType[types.size()]);
            }
        }
    }

    private static String getLaunchConfigurationType() {
        DaemonCore.loadAlternateLaunchType();
        if (fAlternateLaunchTypes != null) {
            IAlternateLaunchType[] iAlternateLaunchTypeArray = fAlternateLaunchTypes;
            int n = fAlternateLaunchTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IAlternateLaunchType altType = iAlternateLaunchTypeArray[n2];
                String alternate = altType.getAlternateLaunchType();
                if (alternate != null) {
                    return alternate;
                }
                ++n2;
            }
        }
        return "com.ibm.debug.OldDaemonDefaultLaunchConfiguration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getAuthenticators() {
        Object object = fAuthenticatorLock;
        synchronized (object) {
            if (fAuthenticators == null) {
                ArrayList<String> ids = new ArrayList<String>();
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.daemon.core.daemonAuthenticator");
                if (ep != null) {
                    IConfigurationElement[] configElements;
                    IConfigurationElement[] iConfigurationElementArray = configElements = ep.getConfigurationElements();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        ids.add(element.getAttribute("id"));
                        ++n2;
                    }
                }
                fAuthenticators = ids.toArray(new String[ids.size()]);
            }
        }
        return fAuthenticators;
    }

    public static boolean hasAuthenticators() {
        String[] authenticators = DaemonCore.getAuthenticators();
        return authenticators != null && authenticators.length > 0;
    }

    public void setAuthenticatorKeystore(String keystoreFile, char[] password) {
        if (DaemonCore.hasAuthenticators()) {
            this.fAuthKeystoreFile = keystoreFile;
            this.fAuthPassword = password == null ? null : Base64.getEncoder().encode(new String(password).getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class CoreDaemonListenerRegistry
    implements ICoreDaemonListenerRegistry {
        private final DaemonCore _coreDaemon;
        private final Set<CoreDaemonListener> fListeners = Collections.synchronizedSet(new HashSet());

        public CoreDaemonListenerRegistry(DaemonCore coreDaemon) {
            this._coreDaemon = coreDaemon;
        }

        @Override
        public DaemonCore getCoreDaemon() {
            return this._coreDaemon;
        }

        @Override
        public void addListener(CoreDaemonListener listener) {
            this.fListeners.add(listener);
        }

        @Override
        public void removeListener(CoreDaemonListener listener) {
            this.fListeners.remove(listener);
        }

        @Override
        public void removeAllListeners() {
            this.fListeners.clear();
        }

        public void notifyListeners(int event) {
            class Notifier
            implements Runnable {
                int _event;

                public Notifier(int daemonEvent) {
                    this._event = daemonEvent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set<CoreDaemonListener> set = CoreDaemonListenerRegistry.this.fListeners;
                    synchronized (set) {
                        for (CoreDaemonListener listener : CoreDaemonListenerRegistry.this.fListeners) {
                            switch (Integer.valueOf(this._event)) {
                                case 0: {
                                    listener.startedListening(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                                case 1: {
                                    listener.stoppedListening(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                                case 2: {
                                    listener.connectionOccurred(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                                case 3: {
                                    listener.startedListeningSecure(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                                case 4: {
                                    listener.stoppedListeningSecure(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                                case 5: {
                                    listener.connectionOccurredSecure(CoreDaemonListenerRegistry.this._coreDaemon);
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            Notifier notifier = new Notifier(event);
            new Thread(notifier).start();
        }
    }

    private class DaemonProcessThread
    extends Thread {
        private DaemonSocketConnection fConn;

        DaemonProcessThread(DaemonSocketConnection conn) {
            super("Debug connection on " + conn.getSocket().getLocalPort());
            this.fConn = null;
            this.setDaemon(true);
            this.fConn = conn;
        }

        @Override
        public void run() {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Daemon thread started", null);
            }
            if (this.fConn != null) {
                try {
                    DaemonCore.this.readAndProcessRequest(this.fConn);
                }
                catch (IOException e) {
                    if (CoreDaemonPlugin.fLogging || e instanceof SSLHandshakeException) {
                        CoreDaemonPlugin.log(e.getMessage(), e);
                    }
                    try {
                        this.fConn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class ListenerThread
    extends Thread {
        private final boolean fSecure;
        private final ServerSocket fServerSocket;

        public ListenerThread(ServerSocket serverSocket, boolean secure) {
            super("Debug listener on " + serverSocket.getLocalPort());
            this.setDaemon(true);
            this.fSecure = secure;
            this.fServerSocket = serverSocket;
        }

        @Override
        public void run() {
            if (this.fSecure) {
                fListenerRegistry.notifyListeners(3);
            } else {
                fListenerRegistry.notifyListeners(0);
            }
            try {
                while (fAcceptConnections) {
                    Socket tmpSocket;
                    try {
                        tmpSocket = this.fServerSocket.accept();
                    }
                    catch (IOException e) {
                        break;
                    }
                    DaemonSocketConnection dsc = new DaemonSocketConnection(tmpSocket);
                    new DaemonProcessThread(dsc).start();
                }
            }
            finally {
                try {
                    this.fServerSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class NewDaemonInput
    implements IDaemonSupport.INewDaemonInput {
        private final DaemonSocketConnection socket;
        private final NameValuePair[] input;
        private final int version;

        public NewDaemonInput(DaemonSocketConnection socket, NameValuePair[] input, int version) {
            this.socket = socket;
            this.input = Arrays.copyOf(input, input.length);
            this.version = version;
        }

        public DaemonSocketConnection getSocket() {
            return this.socket;
        }

        public NameValuePair[] getInputArray() {
            return Arrays.copyOf(this.input, this.input.length);
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static class OldDaemonInput
    implements IOldDaemonSupport.IOldDaemonInput {
        private final DaemonSocketConnection socket;
        private final String[] input;
        private final int version;

        public OldDaemonInput(DaemonSocketConnection socket, String[] input, int version) {
            this.socket = socket;
            this.input = Arrays.copyOf(input, input.length);
            this.version = version;
        }

        @Override
        public DaemonSocketConnection getSocket() {
            return this.socket;
        }

        @Override
        public String[] getInputArray() {
            return Arrays.copyOf(this.input, this.input.length);
        }

        public int getVersion() {
            return this.version;
        }
    }
}

