/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.core;

import com.ibm.debug.daemon.DaemonSocketConnection;
import com.ibm.debug.daemon.internal.core.CoreDaemonPlugin;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;

class DaemonAuthenticator {
    private boolean fAuthenticationRequired = false;
    private DaemonSocketConnection fConnection;
    private String fKeyStoreFile;
    private byte[] fKeyStorePassword;

    DaemonAuthenticator(DaemonSocketConnection connection, String keyStoreFile, byte[] fAuthPassword) {
        this.fConnection = connection;
        this.fKeyStoreFile = keyStoreFile;
        this.fKeyStorePassword = fAuthPassword;
    }

    public boolean isAuthenticationRequired() {
        return this.fAuthenticationRequired;
    }

    public void setAuthenticationRequired() {
        this.fAuthenticationRequired = true;
    }

    public int authenticate() throws IOException {
        int maxRetCode;
        InputStream inputStream = this.fConnection.getInputStream();
        int rndLen = new DataInputStream(inputStream).readInt();
        if (rndLen < (maxRetCode = 10)) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Authority engine returned rndLen = " + rndLen);
            }
            return 1;
        }
        byte[] rnd = new byte[rndLen];
        inputStream.read(rnd);
        if (this.fKeyStoreFile == null || this.fKeyStorePassword == null) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Authority keystore error " + (this.fKeyStoreFile == null) + "  " + (this.fKeyStorePassword == null));
            }
            return -4;
        }
        try {
            Iterator<String> iterator;
            char[] password = new String(Base64.getDecoder().decode(this.fKeyStorePassword), StandardCharsets.UTF_8).toCharArray();
            KeyStore keyStore = DaemonCore.getKeyStore(this.fKeyStoreFile, password);
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Authority alias count = " + Collections.list(keyStore.aliases()).size());
            }
            if ((iterator = Collections.list(keyStore.aliases()).iterator()).hasNext()) {
                String alias = iterator.next();
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
                String sigAlg = ((X509Certificate)keyStore.getCertificate(alias)).getSigAlgName();
                Signature sig = Signature.getInstance(sigAlg);
                sig.initSign(privateKey);
                sig.update(rnd);
                byte[] signature = sig.sign();
                new DataOutputStream(this.fConnection.getOutputStreamBuffer()).writeInt(signature.length);
                this.fConnection.getOutputStreamBuffer().write(signature);
                this.fConnection.endWrite();
                int result = new DataInputStream(inputStream).readInt();
                if (CoreDaemonPlugin.fLogging) {
                    CoreDaemonPlugin.log("Authority engine check rc = " + result);
                }
                if (result != 0) {
                    this.fConnection.close();
                    return result;
                }
                return 0;
            }
            return 0;
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | UnrecoverableKeyException | CertificateException e) {
            if (CoreDaemonPlugin.fLogging) {
                CoreDaemonPlugin.log("Authority exception", e);
            }
            return -5;
        }
    }
}

