/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class NameValuePair {
    private static final int MAXNAMELENGTH = 65536;
    private static final int MAXVALUELENGTH = 0x100000;
    private static final String ENCODING = "UTF-8";
    private String fName;
    private String fValue;
    private byte[] fValueBytes;

    public NameValuePair(String name, String value) {
        this.fName = name;
        this.fValue = value;
    }

    public NameValuePair(InputStream inputStream) throws IOException, ConstructionException {
        DataInputStream dis = new DataInputStream(inputStream);
        int length = dis.readInt();
        if (length <= 0 || length > 65536) {
            throw new ConstructionException();
        }
        byte[] bytes = new byte[length];
        dis.readFully(bytes);
        this.fName = new String(bytes, ENCODING);
        length = dis.readInt();
        if (length <= 0 || length >= 0x100000) {
            throw new ConstructionException();
        }
        this.fValueBytes = new byte[length];
        dis.readFully(this.fValueBytes);
        this.fValue = new String(this.fValueBytes, ENCODING);
    }

    public String getName() {
        return this.fName;
    }

    public String getValue() {
        return this.fValue;
    }

    public byte[] getValueArray() {
        return this.fValueBytes == null ? null : Arrays.copyOf(this.fValueBytes, this.fValueBytes.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.fName);
        sb.append(",");
        sb.append("Value: ").append(this.fValue);
        return sb.toString();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.fName.length());
        dos.write(this.fName.getBytes(ENCODING));
        dos.writeInt(this.fValue.length());
        dos.write(this.fValue.getBytes(ENCODING));
    }

    public static class ConstructionException
    extends Exception {
        private static final long serialVersionUID = 2604727232338168634L;
    }
}

