/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class DaemonSocketConnection {
    private final Socket socket;
    private OutputStream _outputStream;
    protected InputStream _inputStream;
    protected ByteArrayOutputStream _outputStreamBuffer = new ByteArrayOutputStream();

    public DaemonSocketConnection(Socket socket) {
        this.socket = socket;
        try {
            this.setOutputStream(socket.getOutputStream());
            this.setInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public DaemonSocketConnection(Socket socket, boolean kicker) {
        this.socket = socket;
        try {
            this.setOutputStream(socket.getOutputStream());
            this.setInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void close() throws IOException {
        this.flush();
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public final ByteArrayOutputStream getOutputStreamBuffer() {
        return this._outputStreamBuffer;
    }

    public final InputStream getInputStream() {
        return this._inputStream;
    }

    protected void setOutputStream(OutputStream outputStream) {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._outputStream = outputStream;
    }

    protected void setInputStream(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public int beginRead() throws IOException {
        DataInputStream dataStream = new DataInputStream(this._inputStream);
        return dataStream.readInt();
    }

    public void endRead() {
    }

    public void endWrite() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this._outputStream != null && this._outputStreamBuffer.size() > 0) {
            this._outputStream.write(this._outputStreamBuffer.toByteArray());
        }
        this._outputStreamBuffer.reset();
    }
}

