/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.core;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseCheckerFactory;
import com.ibm.cic.licensing.common.core.Messages;
import com.ibm.cic.licensing.common.util.ComponentInfo;
import com.ibm.cic.licensing.common.util.ComponentKey;
import com.ibm.cic.licensing.common.util.ComponentKeyVO;
import com.ibm.cic.licensing.common.util.Constants;
import com.ibm.cic.licensing.common.util.LicenseInfoData;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.common.util.SigVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegScanner
implements Constants {
    private static List piList = new LinkedList();
    private static Hashtable piMap = new Hashtable();
    private static boolean regScanned = false;
    private static RegScanner instance = null;
    private static boolean licenseChecksSuppressed = false;
    private static final String COM_IBM_INTERNEL_CASPIAN_LICENSE_ENABLER = "com.ibm.internel.caspian.license.enabler";
    private static boolean everythingLicensed = true;
    private static HashMap<ComponentKeyVO, ComponentInfo> componentMap = new HashMap();
    private static List<ProductInformation> checkedOutProductList = new ArrayList<ProductInformation>();

    private RegScanner() {
    }

    public static synchronized RegScanner getInstance() {
        if (instance == null) {
            instance = new RegScanner();
        }
        return instance;
    }

    public static synchronized void scan(String extPoint) {
        if (regScanned) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(extPoint);
        IExtension[] ext = ep.getExtensions();
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            if (ext.length > 0) {
                Logger.logNtrace((String)"start collecting licenseInformation extensions");
            } else {
                Logger.logNtrace((int)Logger.WARNING, (String)"There is no licenseInformation extentsions found.");
            }
        }
        int i = 0;
        while (i < ext.length) {
            ProductInformation pi = new ProductInformation();
            IConfigurationElement[] elements = ext[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String bundleSymbolicName = element.getContributor().getName();
                Bundle extendeeBundle = Platform.getBundle((String)bundleSymbolicName);
                pi.setProductName((String)extendeeBundle.getHeaders(Platform.getNL()).get("Bundle-Name"));
                if (element.getName().compareTo("configuration") == 0) {
                    if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                        Logger.trace((String)("  ext[" + i + "] -> " + ext[i].getContributor().getName()));
                    }
                    String file = element.getAttribute("file");
                    String digest = element.getAttribute("digest");
                    RegScanner.processProductConfiguration(pi, bundleSymbolicName, file, digest);
                }
                ++j;
            }
            ++i;
        }
        RegScanner.resolveProductPluginIdReferences(ext);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS) && ext.length > 0) {
            Logger.trace((String)"end collecting licenseInformation extensions");
        }
        regScanned = true;
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)"List of products: ");
            for (Object o : RegScanner.getPiList()) {
                ProductInformation p = (ProductInformation)o;
                Logger.logNtrace((String)p.toString());
            }
            Logger.trace((String)"List of components: ");
            for (ComponentInfo cInfo : componentMap.values()) {
                Logger.logNtrace((String)cInfo.printCInfo());
                Logger.logNtrace((String)cInfo.getProducts().toString());
            }
        }
    }

    public static ProductInformation getPiById(String prodID) {
        if (RegScanner.getPiList() != null) {
            for (ProductInformation pi : RegScanner.getPiList()) {
                if (!pi.getProductId().equalsIgnoreCase(prodID.trim())) continue;
                return pi;
            }
        }
        return null;
    }

    private static void resolveProductPluginIdReferences(IExtension[] ext) {
        int i = 0;
        while (i < ext.length) {
            IConfigurationElement[] elements = ext[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                ProductInformation parent;
                ProductInformation pi;
                String productPluginId;
                IConfigurationElement element = elements[j];
                String bundleSymbolicName = element.getContributor().getName();
                if (element.getName().compareTo("configuration") == 0 && (productPluginId = element.getAttribute("productPluginId")) != null && (pi = RegScanner.findPiByContributor(bundleSymbolicName)) != null && (parent = RegScanner.findPiByContributor(productPluginId)) != null) {
                    parent.addSubProductInformation(pi);
                }
                ++j;
            }
            ++i;
        }
    }

    private static ProductInformation findPiByContributor(String symbolicName) {
        if (symbolicName == null) {
            return null;
        }
        for (ProductInformation info : piList) {
            if (!symbolicName.equals(info.getExtensionContributor())) continue;
            return info;
        }
        return null;
    }

    private static void processProductConfiguration(ProductInformation pi, String symbolicName, String filename, String digest) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        pi.setExtensionContributor(symbolicName);
        if (SigVerifier.isCfgFileValid((Bundle)bundle, (String)filename, (String)digest)) {
            try {
                URL url = bundle.getResource(filename);
                InputStream stream = url.openStream();
                RegScanner.parseConfigXmlFile(stream, bundle.getSymbolicName(), pi);
                stream.close();
            }
            catch (Exception exception) {
                try {
                    URL absurl = FileLocator.toFileURL((URL)bundle.getEntry(filename));
                    RegScanner.parseConfigXmlFile(absurl.openStream(), bundle.getSymbolicName(), pi);
                }
                catch (IOException ioe) {
                    Logger.logNtrace((String)"RegScanner.processProductConfiguration() failed", (Exception)ioe);
                }
            }
        } else {
            Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.Signature_Invalid, (Object)bundle.getSymbolicName(), (Object)pi.getProductName()));
        }
    }

    private static void parseConfigXmlFile(InputStream stream, String symbolicName, ProductInformation pi) {
        NodeList nodelist;
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            Logger.trace((String)"ParserConfigurationException in RegScanner.parseConfigXmlFile()", (Exception)e);
        }
        catch (SAXException e) {
            Logger.trace((String)"SAXException in RegScanner.parseConfigXmlFile()", (Exception)e);
        }
        catch (IOException e) {
            Logger.trace((String)"IOException in RegScanner.parseConfigXmlFile()", (Exception)e);
        }
        if (doc == null) {
            Logger.logNtrace((int)Logger.ERROR, (String)"FAILURE in RegScanner.parseConfigXmlFile(): doc == null!");
            return;
        }
        Element docElement = doc.getDocumentElement();
        if (docElement.hasAttribute("id")) {
            pi.setProductId(docElement.getAttribute("id"));
        }
        if (docElement.hasAttribute("version")) {
            pi.setProductVersion(docElement.getAttribute("version"));
        }
        if (docElement.hasAttribute("displayversion")) {
            pi.setDisplayVersion(docElement.getAttribute("displayversion"));
        }
        if ((nodelist = doc.getElementsByTagName("licenses")) != null && nodelist.getLength() > 0) {
            Element licensesNode = (Element)nodelist.item(0);
            if (licensesNode.hasAttribute("startupcheck")) {
                String startupcheck = licensesNode.getAttribute("startupcheck");
                Logger.trace((String)("startupcheck attribut defined and set to : " + startupcheck));
                pi.setStartupCheckFlag(startupcheck);
            } else {
                pi.setStartupCheckFlag("");
                Logger.trace((String)"startupcheck startupcheck attribute is NOT defined");
            }
            nodelist = doc.getElementsByTagName("luminfo");
            if (nodelist != null && nodelist.getLength() > 0) {
                Element lumnode = (Element)nodelist.item(0);
                if (lumnode.hasAttribute("lumid")) {
                    pi.setLumProductId(lumnode.getAttribute("lumid"));
                } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((int)Logger.INFO, (String)"RegScanner.parseConfigXmlFile(): lum product id is not defined");
                }
                if (lumnode.hasAttribute("lumversion")) {
                    pi.setLumVersionId(lumnode.getAttribute("lumversion"));
                } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((int)Logger.INFO, (String)"RegScanner.parseConfigXmlFile(): lum product version is not defined");
                }
            } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.INFO, (String)"luminfo is not defined.");
            }
            nodelist = doc.getElementsByTagName("flexinfo");
            if (nodelist != null && nodelist.getLength() > 0) {
                Element flexnode = (Element)nodelist.item(0);
                if (flexnode.hasAttribute("flexid")) {
                    pi.setFlexFeatureId(flexnode.getAttribute("flexid"));
                } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((int)Logger.INFO, (String)"RegScanner.parseConfigXmlFile(): flex feature id is not defined");
                }
                if (flexnode.hasAttribute("flexversion")) {
                    pi.setFlexVersionId(flexnode.getAttribute("flexversion"));
                } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((int)Logger.INFO, (String)"RegScanner.parseConfigXmlFile(): flex feature version is not defined");
                }
            } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.INFO, (String)"flexinfo is not defined.");
            }
            nodelist = doc.getElementsByTagName("purchaseinfo");
            if (nodelist != null && nodelist.getLength() > 0) {
                Element pnode = (Element)nodelist.item(0);
                if (pnode.hasAttribute("url")) {
                    pi.setPurchaseUrl(pnode.getAttribute("url"));
                } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((int)Logger.INFO, (String)"RegScanner.parseConfigXmlFile(): product purchase url is not defined");
                }
            } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.INFO, (String)"purchaseinfo is not defined.");
            }
            RegScanner.setLicenseType(pi);
        } else {
            pi.setLicType("FREE");
            pi.setLicOrder(String.valueOf(-100));
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)(pi.getProductId() + " is license free"));
            }
        }
        piList.add(pi);
        if (COM_IBM_INTERNEL_CASPIAN_LICENSE_ENABLER.equals(pi.getProductId())) {
            licenseChecksSuppressed = true;
        }
        nodelist = doc.getElementsByTagName("component");
        int k = 0;
        while (k < nodelist.getLength()) {
            Element currNode = (Element)nodelist.item(k);
            String currID = "";
            String currVersion = "";
            if (currNode.hasAttribute("id")) {
                currID = currNode.getAttribute("id");
            } else {
                Logger.logNtrace((int)Logger.ERROR, (String)"component id attribute is null");
            }
            if (currNode.hasAttribute("version")) {
                currVersion = currNode.getAttribute("version");
            } else {
                Logger.logNtrace((int)Logger.ERROR, (String)"component version attribute is null");
            }
            ComponentKeyVO pkey = new ComponentKeyVO(currID, currVersion);
            ComponentInfo cInfo = componentMap.get(pkey);
            if (cInfo == null) {
                cInfo = new ComponentInfo(currID, currVersion, pi);
                componentMap.put(pkey, cInfo);
            } else {
                cInfo.addProduct(pi);
            }
            pi.addToComponents(cInfo);
            if (piMap != null && piMap.containsKey(pkey)) {
                pis = (List)piMap.get(pkey);
                pis.add(pi);
                Collections.sort(pis);
            } else {
                pis = new LinkedList<ProductInformation>();
                pis.add(pi);
                piMap.put(pkey, pis);
            }
            ++k;
        }
    }

    private static void setLicenseType(ProductInformation pi) {
        Version offeringversion;
        String offeringid = pi.getProductId();
        LicensePolicyData.OfferingData offering = PolicyManager.getOffering((String)offeringid, (Version)(offeringversion = pi.getProductVersion()));
        if (offering != null) {
            if (PolicyManager.isFlexEnabled()) {
                RegScanner.setFlexType(pi, offering.getOrder());
            } else {
                RegScanner.setLumType(pi);
            }
        } else {
            RegScanner.setLumType(pi);
        }
    }

    private static void setFlexType(ProductInformation pi, int order) {
        pi.setLicType("FLEX");
        pi.setLicOrder(String.valueOf(order));
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("Flexlm enabled for " + pi.getProductId()));
        }
    }

    private static void setLumType(ProductInformation pi) {
        if (pi.getLumProductId() == null && pi.getLumVersionId() == null) {
            pi.setLicType("FREE");
            pi.setLicOrder(String.valueOf(-100));
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)("LUM Free Pass for " + pi.getProductId()));
            }
        } else {
            pi.setLicType("LUM");
            pi.setLicOrder(String.valueOf(-1));
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)("LUM enabled for " + pi.getProductId()));
            }
        }
    }

    private static LicenseInfoData[] gatherLicenseInfo() {
        if (!regScanned) {
            RegScanner.scan("com.ibm.cic.licensing.common.licenseInformation");
        }
        RegScanner.setEverythingLicensed(true);
        ProductInformation[] prodinfos = RegScanner.getPiRoots();
        LicenseInfoData[] licdatas = new LicenseInfoData[prodinfos.length];
        int i = 0;
        while (i < prodinfos.length) {
            licdatas[i] = RegScanner.createLicenseInfoData(prodinfos[i]);
            if ((prodinfos[i].getStartupCheckFlag().equalsIgnoreCase("true") || prodinfos[i].getStartupCheckFlag().equalsIgnoreCase("")) && licdatas[i] != null && licdatas[i].getStatusCode() == 2) {
                RegScanner.setEverythingLicensed(false);
            }
            ++i;
        }
        return licdatas;
    }

    private static LicenseInfoData createLicenseInfoData(ProductInformation pi) {
        LicenseStatus licstatus = RegScanner.getLicenseStatus(pi);
        String localizedLicType = licstatus.getLocalizedLicenseType();
        String licStatus = licstatus.getLocalizedStatusString();
        String expirationDateStr = licstatus.getExpireDateString();
        LicenseInfoData licdata = new LicenseInfoData(pi.getProductId(), pi.getProductName(), pi.getProductVersionStr(), pi.getDisplayVersion(), localizedLicType, licStatus, expirationDateStr, licstatus.isLumTrial(), pi.getPurchaseUrl(), licstatus.getStatusCode());
        ProductInformation[] subProductInformation = pi.getSubProductInformation();
        int i = 0;
        while (i < subProductInformation.length) {
            licdata.addSubLicenseInfoData(RegScanner.createLicenseInfoData(subProductInformation[i]));
            ++i;
        }
        return licdata;
    }

    private static LicenseStatus getLicenseStatus(ProductInformation pi) {
        String licType = pi.getLicType() != null ? pi.getLicType() : "LUM";
        ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker(licType);
        LicenseStatus licstatus = licenseChecker.checkStatus(pi);
        return licstatus;
    }

    public static List getPiList() {
        return piList;
    }

    public static ProductInformation[] getPiRoots() {
        ArrayList<ProductInformation> roots = new ArrayList<ProductInformation>();
        for (ProductInformation info : piList) {
            if (info.getParentProductInformation() != null) continue;
            roots.add(info);
        }
        return roots.toArray(new ProductInformation[roots.size()]);
    }

    public static Hashtable getPiMap() {
        return piMap;
    }

    public static boolean isRegScanned() {
        return regScanned;
    }

    public static LicenseInfoData[] getLicInfoData() {
        return RegScanner.gatherLicenseInfo();
    }

    public static LicenseStatus[] getEarlyLicenseStatusCheckArray(IProgressMonitor monitor) {
        LicenseStatus status;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RegScanner_checkingLicenseStatusTask, (int)100);
        if (!regScanned) {
            subMonitor.subTask(Messages.RegScanner_scanning);
            RegScanner.scan("com.ibm.cic.licensing.common.licenseInformation");
        }
        subMonitor.worked(10);
        SubMonitor sub = subMonitor.split(90).setWorkRemaining(piList.size());
        ArrayList<LicenseStatus> result = new ArrayList<LicenseStatus>();
        for (ProductInformation info : piList) {
            if (info.getStartupCheckFlag().equalsIgnoreCase("false") || info.getParentProductInformation() != null) continue;
            sub.subTask(NLS.bind((String)Messages.RegScanner_checkingLicenseStatusSubTask, (Object)info.getProductName()));
            status = RegScanner.getLicenseStatus(info);
            if (RegScanner.canAddStatus(status, info)) {
                result.add(status);
            }
            sub.worked(1);
        }
        for (ProductInformation info : piList) {
            if (info.getStartupCheckFlag().equalsIgnoreCase("false") || info.getParentProductInformation() == null) continue;
            sub.subTask(NLS.bind((String)Messages.RegScanner_checkingLicenseStatusSubTask, (Object)info.getProductName()));
            status = RegScanner.getLicenseStatus(info);
            if (RegScanner.canAddStatus(status, info)) {
                status.setLicensedFeature(true);
                result.add(status);
            }
            sub.worked(1);
        }
        sub.done();
        monitor.done();
        return result.toArray(new LicenseStatus[result.size()]);
    }

    public static void setExpirationWarned() {
        for (ProductInformation info : piList) {
            info.setExpirationWarned(true);
        }
    }

    public static void refreshLicenseStatus() {
        PolicyManager.reload((String)PolicyManager.getLicensePolicyFilePath());
        for (ProductInformation info : piList) {
            RegScanner.setLicenseType(info);
        }
    }

    private static void setEverythingLicensed(boolean b) {
        everythingLicensed = b;
    }

    public static boolean isEverythingLicensed() {
        return everythingLicensed;
    }

    public static boolean areLicenseChecksSuppressed() {
        return licenseChecksSuppressed;
    }

    public static boolean licenseInfoExtensionsExist() {
        if (regScanned) {
            return piList.size() != 0;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint("com.ibm.cic.licensing.common.licenseInformation");
        IExtension[] ext = ep.getExtensions();
        return ext.length != 0;
    }

    private static boolean canAddStatus(LicenseStatus status, ProductInformation pi) {
        boolean check3;
        boolean check2;
        boolean check;
        if (status == null || pi == null) {
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)"Either status is null or product info is null");
            }
            return false;
        }
        boolean bl = check = System.getProperty("LicenseCheckCanBeIgnore", "false").equalsIgnoreCase("true") && status.getStatusCode() != 2;
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("check : " + check));
        }
        if (check) {
            return true;
        }
        boolean check1 = pi.getStartupCheckFlag().equalsIgnoreCase("true");
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("check1 : " + check1));
        }
        if (check1) {
            return true;
        }
        boolean bl2 = check2 = pi.getStartupCheckFlag().equalsIgnoreCase("falseWithTrialLicenseCheck") && status.getStatusCode() != 2;
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("check2 : " + check2));
        }
        if (check2) {
            return true;
        }
        boolean bl3 = check3 = pi.getStartupCheckFlag().equals("") && System.getProperty("LicenseCheckCanBeIgnore", "false").equalsIgnoreCase("false");
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("check3 : " + check3));
        }
        return check3;
    }

    public static List getProductList() {
        return RegScanner.getPiList();
    }

    public static List getCheckedOutProductList() {
        return checkedOutProductList;
    }

    public static ComponentInfo getComponentInfo(String name, String version) {
        ComponentKey cKey = new ComponentKey(name, version);
        Set<ComponentKeyVO> keys = componentMap.keySet();
        for (ComponentKeyVO key : keys) {
            if (!key.getId().equalsIgnoreCase(cKey.getId()) && !key.getId().equals("*") || !key.getVersion().isIncluded(cKey.getVersion())) continue;
            try {
                ComponentInfo cInfo = componentMap.get(key);
                return cInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

