/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.core;

import com.ibm.cic.licensing.common.core.DefaultLicenseCheckProviderImpl;
import com.ibm.cic.licensing.common.core.FreeLicenseCheckProviderImpl;
import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.util.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class LicenseCheckerFactory {
    private static LicenseCheckerFactory instance = new LicenseCheckerFactory();
    private static ILicenseCheckProvider[] licenseCheckerCandidates;
    private static boolean checkersLoaded;

    static {
        checkersLoaded = false;
    }

    private LicenseCheckerFactory() {
    }

    public static LicenseCheckerFactory getInstance() {
        return instance;
    }

    private static void loadCheckerCandidates() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.licensing.common.core.licenseCheckProvider");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            licenseCheckerCandidates = new ILicenseCheckProvider[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement config = configElements[j];
                    if (config.getName().equals("licenseChecker")) {
                        try {
                            LicenseCheckerFactory.licenseCheckerCandidates[i] = (ILicenseCheckProvider)config.createExecutableExtension("class");
                            break;
                        }
                        catch (CoreException e) {
                            Logger.trace((String)"LicenseCheckerFactory.loadCheckerCandidates() encountered error", (Exception)((Object)e));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            Logger.trace((String)"LicenseCheckerFactory.loadCheckerCandidates() found 0 extension!");
        }
        checkersLoaded = true;
    }

    public static synchronized ILicenseCheckProvider getLicenseChecker(String lictype) {
        if (!checkersLoaded) {
            LicenseCheckerFactory.loadCheckerCandidates();
        }
        ILicenseCheckProvider checker = null;
        if (lictype.equalsIgnoreCase("FREE")) {
            return new FreeLicenseCheckProviderImpl();
        }
        int i = 0;
        while (i < licenseCheckerCandidates.length) {
            checker = licenseCheckerCandidates[i];
            if (checker != null && checker.canHandle(lictype)) {
                return checker;
            }
            ++i;
        }
        return new DefaultLicenseCheckProviderImpl();
    }
}

