/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.core;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.Messages;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.ProductInformation;
import org.eclipse.core.runtime.IStatus;

public class DefaultLicenseCheckProviderImpl
implements ILicenseCheckProvider {
    @Override
    public LicenseStatus checkout(ProductInformation pi) {
        LicenseStatus licstatus = new LicenseStatus(pi);
        licstatus.setLicenseGranted(false);
        licstatus.setLicenseWillExpire(false);
        licstatus.setLocalizedLicenseType(Messages.LicenseType_Unknown);
        licstatus.setLocalizedStatusString(Messages.License_Info_Unknown);
        licstatus.setStatusCode(2);
        licstatus.setErrException(new Exception(Messages.License_Info_Unknown));
        licstatus.setErrMsg(Messages.License_Info_Unknown);
        pi.setLicenseStatus(licstatus);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("DefaultLicenseCheckProviderImpl performed license checkout for " + pi.getProductId() + " " + String.valueOf(pi.getProductVersion())));
        }
        return licstatus;
    }

    @Override
    public boolean checkin(ProductInformation pi) {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("DefaultLicenseCheckProviderImpl performed license checkin for " + pi.getProductId() + " " + String.valueOf(pi.getProductVersion())));
        }
        return true;
    }

    @Override
    public boolean canHandle(String lictype) {
        return true;
    }

    @Override
    public LicenseStatus checkStatus(ProductInformation pi) {
        LicenseStatus licstatus = new LicenseStatus(pi);
        licstatus.setLicenseWillExpire(false);
        licstatus.setLocalizedLicenseType(Messages.LicenseType_Unknown);
        licstatus.setLocalizedStatusString(Messages.License_Info_Unknown);
        licstatus.setStatusCode(2);
        licstatus.setErrException(new Exception(Messages.License_Info_Unknown));
        licstatus.setErrMsg(Messages.License_Info_Unknown);
        pi.setLicenseStatus(licstatus);
        return licstatus;
    }

    @Override
    public IStatus testConnection(ProductInformation pi, String serverName, String portNum) {
        return null;
    }

    @Override
    public LicenseStatus checkStatus(ProductInformation pi, String licenseLocation) {
        return this.checkStatus(pi);
    }

    @Override
    public boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        return true;
    }
}

