/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commoncomponents.ccaas.core.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.ibm.commoncomponents.ccaas.core.manager.LoggerUtilities;
import com.ibm.commoncomponents.ccaas.core.server.JettyServerFactory;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.slf4j.LoggerFactory;

class JettyTrace {
    private static boolean fTracing = false;
    private static boolean fTracingInitialized = false;
    private static boolean fLogged = false;

    JettyTrace() {
    }

    static synchronized void configureTracing(boolean tracingEnabled, String traceFile, LoggerUtilities.ICCSLogger logger) {
        block15: {
            if (fTracing != tracingEnabled || !fTracingInitialized) {
                fTracingInitialized = true;
                fTracing = tracingEnabled;
                if (LoggerFactory.getILoggerFactory() instanceof LoggerContext) {
                    LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
                    JoranConfigurator jc = new JoranConfigurator();
                    jc.setContext((Context)context);
                    context.reset();
                    File logFile = null;
                    if (tracingEnabled) {
                        if (traceFile != null && !traceFile.trim().isEmpty()) {
                            logFile = new File(traceFile);
                        }
                        if (logFile != null && logFile.exists() && !logFile.delete()) {
                            logFile = null;
                        }
                        if (logFile == null) {
                            logFile = new File(Platform.getInstanceLocation().getURL().getFile() + "/ccsjetty.log");
                        }
                        int i = 0;
                        while (logFile.exists() && !logFile.delete()) {
                            logFile = new File(Platform.getInstanceLocation().getURL().getFile() + "/ccsjetty" + i++ + ".log");
                        }
                        context.putProperty("LOG_FILE", logFile.getAbsolutePath());
                    }
                    context.putProperty("JETTY_TRACE", tracingEnabled ? "TRACE" : "OFF");
                    URL logbackConfig = JettyServerFactory.class.getResource("logback.xml");
                    try {
                        jc.doConfigure(logbackConfig);
                        if (!tracingEnabled) break block15;
                        System.out.println("CCS Jetty trace file: " + logFile.getAbsolutePath());
                        if (logger != null) {
                            logger.log("CCS Jetty trace file: " + logFile.getAbsolutePath());
                        }
                        break block15;
                    }
                    catch (JoranException e) {
                        if (logger != null) {
                            logger.log((Throwable)e);
                        }
                        break block15;
                    }
                }
                if (tracingEnabled) {
                    String className = LoggerFactory.getILoggerFactory().getClass().getCanonicalName();
                    if (!fLogged) {
                        fLogged = true;
                        if (logger != null) {
                            logger.log("Conflicting slf4j binding found: " + className);
                        }
                        if (tracingEnabled) {
                            System.out.println("Conflicting slf4j binding found: " + className);
                        }
                    }
                }
            }
        }
    }

    protected static void cleanup() {
        if (LoggerFactory.getILoggerFactory() instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.stop();
        }
    }
}

