/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commoncomponents.ccaas.core.server;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.ccaas.core.manager.LoggerUtilities;
import com.ibm.commoncomponents.ccaas.core.server.AbstractIdeServlet;
import com.ibm.commoncomponents.ccaas.core.server.CCSWorkspaceLogger;
import com.ibm.commoncomponents.ccaas.core.server.IJettyHeaderConstants;
import com.ibm.commoncomponents.ccaas.core.server.IJettyServerSecurity;
import com.ibm.commoncomponents.ccaas.core.server.JettyTrace;
import com.ibm.commoncomponents.ccaas.core.server.LoginServlet;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jetty.ee8.nested.ServletConstraint;
import org.eclipse.jetty.ee8.security.ConstraintMapping;
import org.eclipse.jetty.ee8.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee8.security.SecurityHandler;
import org.eclipse.jetty.ee8.servlet.DefaultServlet;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.ee8.servlets.DoSFilter;
import org.eclipse.jetty.ee8.servlets.HeaderFilter;
import org.eclipse.jetty.ee8.webapp.Configuration;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.ee8.webapp.WebInfConfiguration;
import org.eclipse.jetty.ee8.webapp.WebXmlConfiguration;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.QoSHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.osgi.framework.Bundle;

public class JettyServerFactory
implements IJettyHeaderConstants {
    public static final String DISALLOW_IP_ADDRESS = "CCSblockIPAccess";
    private static final JettyServerFactory fInstance = new JettyServerFactory();
    private static final LoggerUtilities.ICCSLogger fLogger = new CCSWorkspaceLogger();
    private Server fServer = null;
    private static final String HOST = "localhost";
    private static final String LOCALHOST = "localhost";
    private HttpClient fHttpClient;
    private int fPort;
    private WebAppContext ccaasContext = null;
    private WebAppContext ccreportContext = null;

    public static JettyServerFactory getInstance() {
        LoggerUtilities.addLogger((LoggerUtilities.ICCSLogger)fLogger);
        return fInstance;
    }

    private JettyServerFactory() {
    }

    public HttpClient getHttpClient() {
        return this.fHttpClient;
    }

    public boolean isRunning() {
        if (this.fServer == null) {
            return false;
        }
        return this.fServer.isRunning();
    }

    public void startServer(int port, Properties properties) throws Exception {
        this.startServer(port, properties, false, null);
    }

    public void startServer(int port, Properties properties, boolean supportReports) throws Exception {
        this.startServer(port, properties, supportReports, null);
    }

    public void startServer(int port, Properties properties, IJettyServerSecurity securitySettings) throws Exception {
        this.startServer(port, properties, false, securitySettings);
    }

    public void startServer(int port, Properties properties, boolean supportReports, IJettyServerSecurity securitySettings) throws Exception {
        String basedir;
        boolean isSecureNeeded;
        this.configureTracing();
        boolean bl = isSecureNeeded = securitySettings != null && securitySettings.isSSLNeeded();
        if (this.fServer == null) {
            if (isSecureNeeded) {
                this.fServer = new Server(null);
                this.configureSSL(this.fServer, securitySettings.getSSLSettings());
            } else {
                this.fServer = new Server(port);
                this.configure(this.fServer);
                this.fPort = port;
            }
        }
        if (this.fServer.isRunning()) {
            return;
        }
        this.ccaasContext = new WebAppContext(JettyServerFactory.getWar("ccaas.war"), "/ccaas");
        this.ccaasContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration()});
        this.ccaasContext.setClassLoader(this.getClass().getClassLoader());
        this.ccaasContext.setParentLoaderPriority(false);
        this.ccaasContext.setDefaultsDescriptor(null);
        this.ccaasContext.setExtractWAR(true);
        if (securitySettings != null && securitySettings.isAuthenticationNeeded()) {
            this.ccaasContext.addServlet(new ServletHolder((Servlet)new LoginServlet()), "/login");
        }
        if (supportReports) {
            this.ccreportContext = new WebAppContext(JettyServerFactory.getWar("ccreport.war"), "/ccreport");
            this.ccreportContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration()});
            this.ccreportContext.setClassLoader(this.getClass().getClassLoader());
            this.ccreportContext.setParentLoaderPriority(false);
            this.ccreportContext.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            this.ccreportContext.setPersistTempDirectory(false);
            this.ccreportContext.setDefaultsDescriptor(null);
            this.ccreportContext.setExtractWAR(true);
            this.configureReportVersion();
        }
        String ccstempdir = System.getenv("CCSworkdir");
        Object zostempdir = System.getProperty("CC_WRK_DIR_EXTENDED", null);
        if (zostempdir == null) {
            zostempdir = System.getProperty("EQARMTD_WRK_DIR_EXTENDED", null);
        }
        if (zostempdir != null) {
            zostempdir = (String)zostempdir + File.separator + "CCS";
        }
        String string = basedir = ccstempdir != null ? ccstempdir : zostempdir;
        if (basedir != null) {
            File dir = new File(basedir);
            if (!dir.exists() && !dir.mkdirs()) {
                fLogger.log("Unable to create " + basedir);
            }
            this.ccaasContext.setTempDirectory(dir);
            if (supportReports) {
                this.ccreportContext.setTempDirectory(dir);
            }
            this.ccaasContext.setPersistTempDirectory(true);
            if (supportReports) {
                this.ccreportContext.setPersistTempDirectory(true);
            }
        } else {
            this.ccaasContext.setPersistTempDirectory(false);
            if (supportReports) {
                this.ccreportContext.setPersistTempDirectory(false);
            }
        }
        if (securitySettings != null && securitySettings.isAuthenticationNeeded()) {
            securitySettings.configureBearerAuth(this.ccaasContext);
            if (supportReports) {
                securitySettings.configureBearerAuth(this.ccreportContext);
            }
        }
        FilterHolder holder = new FilterHolder((Filter)new DoSFilter());
        String maxRequestsPerSec = System.getProperty("CCSmaxRequestsPerSec", "25");
        holder.setInitParameter("maxRequestsPerSec", maxRequestsPerSec);
        holder.setInitParameter("delayMs", "-1");
        holder.setName("DOS Limiter");
        this.ccaasContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (supportReports) {
            this.ccreportContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        String maxRequests = System.getProperty("CCSmaxConcurRequests", "20");
        QoSHandler qos = new QoSHandler();
        qos.setMaxRequestCount(Integer.parseInt(maxRequests));
        qos.setMaxSuspend(Duration.ofMillis(200L));
        holder = new FilterHolder((Filter)new HeaderFilter());
        holder.setInitParameter("headerConfig", this.getCCSHeaders(isSecureNeeded));
        holder.setName("CCS Headers");
        this.ccaasContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (supportReports) {
            this.ccreportContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if (isSecureNeeded) {
            this.disableTrace(this.ccaasContext);
            if (supportReports) {
                this.disableTrace(this.ccreportContext);
            }
        }
        if (supportReports) {
            this.ccaasContext.setAttribute("ccreport", (Object)this.ccreportContext);
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)new BiConsumer<Object, Object>(){

            @Override
            public void accept(Object t, Object u) {
                if (t instanceof String && u instanceof String) {
                    JettyServerFactory.this.ccaasContext.setInitParameter((String)t, (String)u);
                }
            }
        });
        if (Boolean.getBoolean(DISALLOW_IP_ADDRESS)) {
            this.ccaasContext.getCoreContextHandler().addVirtualHosts(new String[]{JettyServerFactory.getHostName()});
            if (supportReports) {
                this.ccreportContext.getCoreContextHandler().addVirtualHosts(new String[]{JettyServerFactory.getHostName()});
            }
        }
        ContextHandlerCollection handlers = null;
        handlers = supportReports ? new ContextHandlerCollection(new ContextHandler[]{this.ccaasContext.getCoreContextHandler(), this.ccreportContext.getCoreContextHandler(), new ContextHandler((Handler)qos)}) : new ContextHandlerCollection(new ContextHandler[]{this.ccaasContext.getCoreContextHandler(), new ContextHandler((Handler)qos)});
        this.fServer.setHandler((Handler)handlers);
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            this.fServer.start();
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
        }
        this.fHttpClient = isSecureNeeded ? new HttpClient("localhost", String.valueOf(port), true, securitySettings.getSSLSettings().getSocketFactory(), securitySettings.getSSLSettings().getHostNameVerifier()) : new HttpClient("localhost", String.valueOf(port));
    }

    private void configureReportVersion() {
        String manifestPath = "/META-INF/MANIFEST.MF";
        Bundle bundle = Platform.getBundle((String)"com.ibm.commoncomponents.ccaas.core");
        String version = null;
        try {
            URL bundleURL = FileLocator.toFileURL((URL)bundle.getEntry("lib/ccreport.war"));
            bundleURL = new URL("jar:" + bundleURL.toString() + "!/META-INF/MANIFEST.MF");
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (InputStream stream = bundleURL.openStream();){
                    Properties p = new Properties();
                    p.load(stream);
                    version = p.getProperty("version").replace("-SNAPSHOT", "");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                fLogger.log("Unable to find cc report version in manifest" + String.valueOf(e));
            }
        }
        catch (Exception e) {
            fLogger.log("Unable to find cc report war file" + String.valueOf(e));
        }
        if (version != null) {
            this.ccaasContext.getServletContext().setAttribute("ccreport", version);
        }
    }

    private void disableTrace(WebAppContext context) {
        ConstraintSecurityHandler constraintSecurityHandler = context.getSecurityHandler() instanceof ConstraintSecurityHandler ? (ConstraintSecurityHandler)context.getSecurityHandler() : new ConstraintSecurityHandler();
        ServletConstraint constraintDisableTrace = new ServletConstraint();
        constraintDisableTrace.setAuthenticate(true);
        ConstraintMapping mappingDisableTrace = new ConstraintMapping();
        mappingDisableTrace.setPathSpec("/*");
        mappingDisableTrace.setMethod("TRACE");
        mappingDisableTrace.setConstraint(constraintDisableTrace);
        constraintSecurityHandler.addConstraintMapping(mappingDisableTrace);
        ServletConstraint constraintEnabledEverythingButTrace = new ServletConstraint();
        ConstraintMapping mappingEnableEverythingButTrace = new ConstraintMapping();
        mappingEnableEverythingButTrace.setPathSpec("/*");
        mappingEnableEverythingButTrace.setMethodOmissions(new String[]{"TRACE"});
        mappingEnableEverythingButTrace.setConstraint(constraintEnabledEverythingButTrace);
        constraintSecurityHandler.addConstraintMapping(mappingEnableEverythingButTrace);
        context.setSecurityHandler((SecurityHandler)constraintSecurityHandler);
    }

    public static String getHostName() throws UnknownHostException {
        String ipAddress;
        String name = InetAddress.getLocalHost().getHostName();
        String canonicalName = InetAddress.getLocalHost().getCanonicalHostName();
        if (canonicalName.equals(ipAddress = InetAddress.getLocalHost().getHostAddress())) {
            return name;
        }
        return canonicalName;
    }

    public void startServerForIde(int port, Properties properties, AbstractIdeServlet ideRedirectServlet) throws Exception {
        this.configureTracing();
        if (this.fServer == null) {
            this.fServer = new Server(port);
        }
        if (this.fServer.isRunning()) {
            return;
        }
        String basedir = this.getWorkspaceJettyTempLocation();
        final WebAppContext ccaasContext = new WebAppContext(JettyServerFactory.getWar("ccaas.war"), "/ccaas");
        ccaasContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration()});
        ccaasContext.setClassLoader(this.getClass().getClassLoader());
        ccaasContext.setParentLoaderPriority(false);
        ccaasContext.setTempDirectory(new File(basedir + "/ccaas"));
        ccaasContext.setPersistTempDirectory(false);
        ccaasContext.setDefaultsDescriptor(null);
        ccaasContext.setExtractWAR(true);
        FilterHolder holder = new FilterHolder((Filter)new HeaderFilter());
        holder.setInitParameter("headerConfig", this.getCCSHeaders(false));
        holder.setName("CCS Headers");
        ccaasContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        properties.forEach((BiConsumer<? super Object, ? super Object>)new BiConsumer<Object, Object>(){

            @Override
            public void accept(Object t, Object u) {
                if (t instanceof String && u instanceof String) {
                    ccaasContext.setInitParameter((String)t, (String)u);
                }
            }
        });
        this.ccreportContext = new WebAppContext(JettyServerFactory.getWar("ccreport.war"), "/ccreport");
        this.ccreportContext.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration()});
        this.ccreportContext.setClassLoader(this.getClass().getClassLoader());
        this.ccreportContext.setParentLoaderPriority(false);
        this.ccreportContext.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        this.ccreportContext.addServlet(new ServletHolder((Servlet)ideRedirectServlet), "/redirectAction");
        this.ccreportContext.setTempDirectory(new File(basedir + "/ccreport"));
        this.ccreportContext.setPersistTempDirectory(false);
        this.ccreportContext.setDefaultsDescriptor(null);
        this.ccreportContext.setExtractWAR(true);
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[]{this.ccreportContext.getCoreContextHandler(), ccaasContext.getCoreContextHandler()});
        this.fServer.setHandler((Handler)handlers);
        ServerConnector connector = (ServerConnector)this.fServer.getConnectors()[0];
        connector.setHost("localhost");
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            this.fServer.start();
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
        }
        this.fPort = port == 0 ? connector.getLocalPort() : port;
        this.fHttpClient = new HttpClient("localhost", String.valueOf(this.fPort));
    }

    private String getWorkspaceJettyTempLocation() {
        File cleanup;
        Bundle bundle = Platform.getBundle((String)"com.ibm.commoncomponents.ccaas.core");
        String baseDir = Platform.getStateLocation((Bundle)bundle).append("jetty_cache").toOSString();
        String userOverridetempdir = System.getProperty("CC_JETTY_CACHE", null);
        if (userOverridetempdir != null) {
            baseDir = userOverridetempdir;
        }
        if ((cleanup = new File(baseDir)).exists()) {
            this.clean(cleanup);
        }
        if (!cleanup.mkdirs()) {
            fLogger.log("Unable to create temp dir: " + String.valueOf(cleanup));
        }
        cleanup.deleteOnExit();
        return cleanup.getAbsolutePath();
    }

    private void clean(File cleanup) {
        File[] children;
        if (cleanup.isDirectory() && (children = cleanup.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.clean(f);
                ++n2;
            }
        }
        if (!cleanup.delete()) {
            fLogger.log("JettyServerFactory: Unable it to delete:" + String.valueOf(cleanup));
        }
    }

    private void configureSSL(Server server, IJettyServerSecurity.IJettySSLSettings sslSettings) {
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        contextFactory.setKeyStorePath(sslSettings.getKeyStorePath());
        contextFactory.setKeyStorePassword(String.valueOf(sslSettings.getKeyStorePassword()));
        contextFactory.setExcludeCipherSuites(new String[]{"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA256", "SSL_DHE_DSS_WITH_AES_128_GCM_SHA256", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA256", "SSL_DHE_DSS_WITH_AES_256_GCM_SHA384", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_ECDH_RSA_WITH_AES_128_CBC_SHA", "SSL_ECDH_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDH_RSA_WITH_AES_128_GCM_SHA256", "SSL_ECDH_RSA_WITH_AES_256_CBC_SHA", "SSL_ECDH_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDH_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA256", "SSL_RSA_WITH_AES_128_GCM_SHA256", "SSL_RSA_WITH_AES_256_CBC_SHA256", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256"});
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(sslSettings.getSecurePort());
        this.fPort = sslSettings.getSecurePort();
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(8192);
        httpConfig.setResponseHeaderSize(8192);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        String maxIdleTimeout = System.getProperty("CCSmaxIdleTimeout", "30000");
        int maxIdleTimeoutValue = 30000;
        try {
            maxIdleTimeoutValue = Integer.parseInt(maxIdleTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        httpConfig.setIdleTimeout((long)maxIdleTimeoutValue);
        HttpConfiguration https_config = new HttpConfiguration(httpConfig);
        https_config.setSendServerVersion(false);
        SecureRequestCustomizer customizer = new SecureRequestCustomizer();
        customizer.setSniHostCheck(false);
        https_config.addCustomizer((HttpConfiguration.Customizer)customizer);
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        sslConnector.setPort(this.fPort);
        server.setConnectors(new Connector[]{sslConnector});
    }

    private void configure(Server server) {
        Connector[] connectorArray = server.getConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector c = connectorArray[n2];
            for (ConnectionFactory f : c.getConnectionFactories()) {
                if (!(f instanceof HttpConnectionFactory)) continue;
                ((HttpConnectionFactory)f).getHttpConfiguration().setSendServerVersion(false);
            }
            ++n2;
        }
    }

    public String getCCSHeaders(boolean secure) {
        Object result = "add X-XSS-Protection: 1, add X-Content-Type-Options: nosniff, add Content-Security-Policy: default-src 'self'; script-src 'none'; object-src 'none'; style-src 'none'; img-src 'none'; media-src 'none'; frame-src 'none'; font-src 'none'; connect-src 'none'; form-action 'none'; sandbox 'none'; script-nonce 'none', add X-Frame-Options: DENY";
        if (secure) {
            result = (String)result + ", add Strict-Transport-Security: max-age=31536000; includeSubDomains";
        }
        return result;
    }

    public int getPort() {
        return this.fPort;
    }

    public String getHost() {
        return "localhost";
    }

    public static String getWar(String war) throws Exception {
        Bundle bundle = Platform.getBundle((String)"com.ibm.commoncomponents.ccaas.core");
        URL bundleURL = FileLocator.toFileURL((URL)bundle.getEntry("lib/" + war));
        File f = new File(URIUtil.toURI((URL)bundleURL));
        IPath p = Path.fromOSString((String)f.getAbsolutePath());
        return p.toPortableString();
    }

    public void stop() {
        if (this.ccaasContext != null) {
            try {
                this.ccaasContext.stop();
            }
            catch (Exception e) {
                fLogger.log((Throwable)e);
            }
        }
        if (this.ccreportContext != null) {
            try {
                this.ccreportContext.stop();
            }
            catch (Exception e) {
                fLogger.log((Throwable)e);
            }
        }
        if (this.fServer != null) {
            try {
                this.fServer.stop();
            }
            catch (Exception e) {
                fLogger.log((Throwable)e);
            }
        }
    }

    public static void configureTracing(boolean tracingEnabled, String traceFile) {
        block2: {
            try {
                JettyTrace.configureTracing(tracingEnabled, traceFile, fLogger);
            }
            catch (NoClassDefFoundError e) {
                fLogger.log("No slf4j binding found for jetty logging.");
                if (!tracingEnabled) break block2;
                System.out.println("No slf4j binding found for jetty logging.");
            }
        }
    }

    private void configureTracing() {
        String logFileName = Platform.getDebugOption((String)"com.ibm.commoncomponents.ccaas.core/jetty_trace_file");
        JettyServerFactory.configureTracing(Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.commoncomponents.ccaas.core/jetty")), logFileName);
    }
}

