/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.engine.internal.dt;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import java.net.Socket;
import java.util.HashMap;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;

public class DBMConnectionRegistry
implements IDebugEventSetListener {
    private static DBMConnectionRegistry instance = null;
    private HashMap<Integer, String> connectionRegistry = new HashMap();

    private DBMConnectionRegistry() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public static DBMConnectionRegistry getInstance() {
        if (instance == null) {
            instance = new DBMConnectionRegistry();
        }
        return instance;
    }

    public void setDBMRegistry(int hostPort, String hostName) {
        this.connectionRegistry.put(hostPort, hostName);
    }

    public String getHostFromPort(int hostPort) {
        if (this.connectionRegistry.containsKey(hostPort)) {
            return this.connectionRegistry.get(hostPort);
        }
        return null;
    }

    public void removeDBMRegistry(int hostPort) {
        if (this.connectionRegistry.containsKey(hostPort)) {
            this.connectionRegistry.remove(hostPort);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            PDTDebugTarget sourceTgt;
            Socket engineSocket;
            IDebugTarget debugTarget;
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getKind() == 8 && debugEvent.getSource() instanceof DebuggeeProcess && (debugTarget = ((DebuggeeProcess)debugEvent.getSource()).getDebugTarget()) instanceof PDTDebugTarget && (engineSocket = (Socket)(sourceTgt = (PDTDebugTarget)((DebuggeeProcess)debugEvent.getSource()).getDebugTarget()).getProperty("ENGINE_SOCKET")).getInetAddress().isLoopbackAddress()) {
                this.removeDBMRegistry(engineSocket.getPort());
            }
            ++n2;
        }
    }
}

