/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc.handlers;

import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.DCCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.Labels;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ToggleCCHandler
extends AbstractHandler
implements IElementUpdater,
IDebugContextListener {
    private static final ImageDescriptor START_CC_ENABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.codecoverage.ui.dcc", (String)"/icons/elcl16/coverage_start.png");
    private static final ImageDescriptor STOP_CC_ENABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.codecoverage.ui.dcc", (String)"/icons/elcl16/coverage_stop.png");
    private static final ImageDescriptor START_CC_DISABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.codecoverage.ui.dcc", (String)"/icons/dlcl16/coverage_start_d.png");
    private static final ImageDescriptor STOP_CC_DISABLED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.debug.pdt.codecoverage.ui.dcc", (String)"/icons/dlcl16/coverage_stop_d.png");
    private DCC_STATE fState;

    public ToggleCCHandler() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.fState = DCC_STATE.DCC_MIXED_MODE_NOT_SUPPORTED;
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAdaptable contextElement = DebugUITools.getDebugContext();
        PDTDebugTarget debugTarget = this.getContextDebugTarget(contextElement);
        if (debugTarget != null) {
            boolean needUpdate = false;
            if (this.fState == DCC_STATE.DCC_MIXED_MODE_NOT_SUPPORTED) {
                this.fState = this.checkDCCState(debugTarget);
            }
            if (this.fState == DCC_STATE.DCC_MIXED_MODE_OFF) {
                EPDC_Reply reply = null;
                try {
                    reply = DCCUtilities.getInstance().startCC(HandlerUtil.getActiveShell((ExecutionEvent)event), debugTarget);
                }
                catch (DebugException ex) {
                    CCUtilities.log((Throwable)ex);
                }
                if (reply != null) {
                    needUpdate = true;
                    this.fState = DCC_STATE.DCC_MIXED_MODE_ON;
                    debugTarget.setMixedCCEnabled(true);
                }
            } else if (this.fState == DCC_STATE.DCC_MIXED_MODE_ON) {
                this.fState = DCC_STATE.DCC_MIXED_MODE_OFF;
                debugTarget.setMixedCCEnabled(false);
                DCCUtilities.getInstance().stopCC(debugTarget);
                needUpdate = true;
            }
            if (needUpdate) {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                commandService.refreshElements("com.ibm.debug.pdt.codecoverage.dcc.command.togglecc", null);
            }
        }
        return null;
    }

    private PDTDebugTarget getContextDebugTarget(Object element) {
        PDTDebugTarget debugTarget = null;
        if (element instanceof PDTDebugElement && ((PDTDebugElement)element).getDebugTarget() instanceof PDTDebugTarget) {
            debugTarget = (PDTDebugTarget)((PDTDebugElement)element).getDebugTarget();
        } else if (element instanceof ILaunch && ((ILaunch)element).getDebugTarget() instanceof PDTDebugTarget) {
            debugTarget = (PDTDebugTarget)((ILaunch)element).getDebugTarget();
        }
        return debugTarget;
    }

    public void debugContextChanged(DebugContextEvent event) {
        Object element;
        PDTDebugTarget debugTarget;
        ISelection selection = event.getContext();
        DCC_STATE currentState = DCC_STATE.DCC_MIXED_MODE_NOT_SUPPORTED;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0 && (currentState = this.checkDCCState(debugTarget = this.getContextDebugTarget(element = ((IStructuredSelection)selection).getFirstElement()))) != this.fState) {
            this.fState = currentState;
            IWorkbench workbench = PlatformUI.getWorkbench();
            ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
            Command command = commandService.getCommand("com.ibm.debug.pdt.codecoverage.dcc.command.togglecc");
            commandService.refreshElements(command.getId(), null);
        }
    }

    private DCC_STATE checkDCCState(PDTDebugTarget debugTarget) {
        if (debugTarget != null && debugTarget.getEngineSession() != null && debugTarget.getEngineSession().supportsMixedCC()) {
            if (debugTarget.isSuspended()) {
                return debugTarget.isMixedCCEnabled() ? DCC_STATE.DCC_MIXED_MODE_ON : DCC_STATE.DCC_MIXED_MODE_OFF;
            }
            if (debugTarget.isTerminated()) {
                return DCC_STATE.DCC_MIXED_MODE_NOT_SUPPORTED;
            }
            return debugTarget.isMixedCCEnabled() ? DCC_STATE.DCC_DEBUG_TARGET_RUNNING_WITH_MIXED_MODE_ON : DCC_STATE.DCC_DEBUG_TARGET_RUNNING_WITH_MIXED_MODE_OFF;
        }
        return DCC_STATE.DCC_MIXED_MODE_NOT_SUPPORTED;
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService commandService = (ICommandService)element.getServiceLocator().getService(ICommandService.class);
        if (commandService != null) {
            switch (this.fState) {
                case DCC_MIXED_MODE_OFF: {
                    element.setTooltip(Labels.START_CC_TOOLTIP);
                    element.setText(Labels.START_CC_LABEL);
                    element.setIcon(START_CC_ENABLED_ICON);
                    break;
                }
                case DCC_MIXED_MODE_ON: {
                    element.setTooltip(Labels.STOP_CC_TOOLTIP);
                    element.setText(Labels.STOP_CC_LABEL);
                    element.setIcon(STOP_CC_ENABLED_ICON);
                    break;
                }
                case DCC_DEBUG_TARGET_RUNNING_WITH_MIXED_MODE_ON: {
                    element.setDisabledIcon(STOP_CC_DISABLED_ICON);
                    element.setTooltip(Labels.STOP_CC_TOOLTIP);
                    element.setText(Labels.STOP_CC_LABEL);
                    break;
                }
                default: {
                    element.setDisabledIcon(START_CC_DISABLED_ICON);
                    element.setTooltip(Labels.START_CC_TOOLTIP);
                    element.setText(Labels.START_CC_LABEL);
                }
            }
        }
    }

    private static enum DCC_STATE {
        DCC_MIXED_MODE_OFF,
        DCC_MIXED_MODE_ON,
        DCC_MIXED_MODE_NOT_SUPPORTED,
        DCC_DEBUG_TARGET_RUNNING_WITH_MIXED_MODE_ON,
        DCC_DEBUG_TARGET_RUNNING_WITH_MIXED_MODE_OFF;

    }
}

