/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportResult;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.DCCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model.DCCData;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.RulerAnnotationUtilities;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DCCPartListener
implements IPartListener2 {
    private static final ICCTestcase[] EMPTY_TEST = new ICCTestcase[0];
    private IWorkbenchPage fActivePage;
    private boolean fIsPartListenerRegistered = false;

    public void registerPartListener() {
        if (this.fIsPartListenerRegistered) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = this.fActivePage = windows.length > 0 ? windows[0].getActivePage() : null;
        if (this.fActivePage != null) {
            this.fActivePage.addPartListener((IPartListener2)this);
            this.fIsPartListenerRegistered = true;
        }
    }

    public void removePartListener() {
        if (this.fActivePage != null && this.fIsPartListenerRegistered) {
            this.fActivePage.removePartListener((IPartListener2)this);
            this.fIsPartListenerRegistered = false;
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(true);
        if (part instanceof ITextEditor) {
            this.updateCCAnnotations((ITextEditor)part);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(true);
        if (part instanceof ITextEditor) {
            this.updateCCAnnotations((ITextEditor)part);
        }
    }

    private void updateCCAnnotations(ITextEditor editor) {
        IDebugTarget debugTarget;
        ViewFile viewFile = PICLUtils.getViewFile((IEditorInput)editor.getEditorInput());
        if (viewFile != null && (debugTarget = viewFile.getDebugTarget()) instanceof PDTDebugTarget) {
            PDTDebugTarget pdtTarget = (PDTDebugTarget)debugTarget;
            DCCData ccData = DCCUtilities.getInstance().getCCData(pdtTarget);
            if (ccData != null) {
                ICCFile[] ccFiles;
                ICCFile matchedCCFile = null;
                ICCImportResult result = ccData.getResults();
                ICCFile[] iCCFileArray = ccFiles = result.getFiles();
                int n = ccFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    ICCFile ccFile = iCCFileArray[n2];
                    if (ccFile.getProperty("T_ViewFile") == viewFile) {
                        matchedCCFile = ccFile;
                        break;
                    }
                    ++n2;
                }
                if (matchedCCFile != null) {
                    IEditorInput editorInput = editor.getEditorInput();
                    if (editorInput instanceof EngineSuppliedViewEditorInput && editor instanceof DebuggerEditor && pdtTarget.isMixedCCEnabled()) {
                        try {
                            DCCUtilities.getInstance().loadEntireFile((DebuggerEditor)editor, (EngineSuppliedViewEditorInput)editorInput, pdtTarget);
                        }
                        catch (DebugException ex) {
                            PICLUtils.logError((Exception)((Object)ex));
                        }
                    }
                    RulerAnnotationUtilities.generateAnnotations((Integer[])matchedCCFile.getLines(true), (Integer[])matchedCCFile.getLines(false), (ICCTestcase[])EMPTY_TEST, (ICCFile)matchedCCFile, (ITextEditor)editor);
                }
            }
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }
}

