/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionStart;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventComplete;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCoverageChange;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventReportEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.ICCListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.RulerAnnotationUtilities;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DCCCodeCoverageListener
implements ICCListener {
    private static final ICCTestcase[] EMPTY_TEST = new ICCTestcase[0];

    public void collectionStart(CCEventCollectionStart event) {
    }

    public void collectionEnd(CCEventCollectionEnd event) {
    }

    public void error(CCEventError event) {
    }

    public void reportEnd(CCEventReportEnd event) {
    }

    public void complete(CCEventComplete event) {
    }

    public void coverageChanged(CCEventCoverageChange event) {
        final ICCFile[] files = event.getChangedFiles();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ICCFile[] iCCFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    ICCFile ccFile = iCCFileArray[n2];
                    ITextEditor textEditor = null;
                    try {
                        textEditor = DCCCodeCoverageListener.this.findMatchingEditor(ccFile);
                    }
                    catch (CoreException e) {
                        CCUtilities.log((Throwable)e);
                    }
                    if (textEditor != null) {
                        RulerAnnotationUtilities.generateAnnotations((Integer[])ccFile.getLines(true), (Integer[])ccFile.getLines(false), (ICCTestcase[])EMPTY_TEST, (ICCFile)ccFile, (ITextEditor)textEditor);
                    }
                    ++n2;
                }
            }
        });
    }

    private ITextEditor findMatchingEditor(ICCFile ccFile) throws CoreException {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (activePage = window.getActivePage()) != null) {
            IEditorReference[] editorRefs;
            IEditorReference[] iEditorReferenceArray = editorRefs = activePage.getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorInput input = editorRef.getEditorInput();
                ViewFile viewFile = PICLUtils.getViewFile((IEditorInput)input);
                if (viewFile != null && ccFile.getProperty("T_ViewFile") == viewFile) {
                    IEditorPart editor = editorRef.getEditor(true);
                    return editor instanceof ITextEditor ? (ITextEditor)editor : null;
                }
                ++n2;
            }
        }
        return null;
    }
}

