/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.web.editor;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.CCWebViewActivator;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ICCWebViewerConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ReportType;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.editor.CCReportEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class CCReportViewer
extends EditorPart
implements ICCWebViewerConstants {
    private Browser fBrowser = null;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        CCWebViewActivator.getTrace().traceEntry("/editor", new Object[]{site, input});
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof CCReportEditorInput) {
            this.setPartName(((CCReportEditorInput)input).getName());
        }
        CCWebViewActivator.getTrace().traceExit("/editor");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        CCWebViewActivator.getTrace().traceEntry("/editor");
        try {
            this.fBrowser = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? new Browser(parent, 264192) : new Browser(parent, 67584);
        }
        catch (SWTError | SWTException e) {
            ResultsViewPlugin.log((int)4, (String)"Fail to create embeded browser with selected browser type", (Throwable)e);
            CCWebViewActivator.getTrace().trace("/editor", "Fail to create embeded browser with selected browser type", e);
            this.fBrowser = new Browser(parent, 2048);
        }
        IEditorInput input = this.getEditorInput();
        if (input instanceof CCReportEditorInput) {
            CCReportEditorInput ccEditorInput = (CCReportEditorInput)input;
            String url = ccEditorInput.getUrl();
            if (url != null) {
                this.fBrowser.setUrl(url);
            }
            String csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_result_web_report";
            switch (this.getType()) {
                case report: {
                    csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_result_web_report";
                    break;
                }
                case report_program_flow: {
                    csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_result_web_report_flowpoint";
                    break;
                }
                case compare: {
                    csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_compare_web_report";
                    break;
                }
                case comparedFile: {
                    csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_comparedfile_web_report";
                    break;
                }
                default: {
                    csHelpId = "com.ibm.debug.pdt.codecoverage.ui.view.web.cc_result_web_report";
                }
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, csHelpId);
        }
        this.fBrowser.addOpenWindowListener(event -> {
            CCWebViewActivator.getTrace().traceEntry("/editor");
            String name = this.getPartName();
            String link = null;
            if (event.browser != null) {
                link = event.browser.getUrl();
            } else if (event.getSource() instanceof Browser) {
                link = ((Browser)event.getSource()).getUrl();
            }
            ReportType type = link != null && link.contains("/ccreport/diff/") ? ReportType.comparedFile : this.getType();
            CCReportEditorInput openedEditorInput = new CCReportEditorInput(link, name, null, type);
            try {
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)openedEditorInput, (String)"com.ibm.debug.pdt.codecoverage.ui.view.web.browserviewer", (boolean)true);
                if (editor instanceof CCReportViewer) {
                    event.browser = ((CCReportViewer)editor).fBrowser;
                }
            }
            catch (PartInitException e) {
                CCWebViewActivator.getTrace().trace("/editor", e.getMessage(), (Throwable)e);
                ResultsViewPlugin.log((Throwable)e);
            }
            CCWebViewActivator.getTrace().traceExit("/editor");
        });
        CCWebViewActivator.getTrace().traceExit("/editor");
    }

    public void setFocus() {
        this.fBrowser.setFocus();
    }

    private ReportType getType() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CCReportEditorInput) {
            return ((CCReportEditorInput)input).getType();
        }
        return null;
    }

    public Browser getBrowser() {
        return this.fBrowser;
    }
}

