/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.web.dialogs;

import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsModifierFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultModifier;
import com.ibm.debug.pdt.codecoverage.core.results.filters.CCFilterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.filters.ICCFilter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ReportCcsServerFactory;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FilteredReportWizard
extends Wizard {
    boolean fIsRegex = false;
    String fFilterString = null;
    private IResultAdapter[] fAdapters;
    private boolean fComplete;
    private IDialogSettings settings = ResultsViewPlugin.getDefault().getDialogSettings();
    private String REG_EX_CHECK = "regEx";
    private String FILTER_TEXT = "filterText";

    public void saveSettings() {
        this.settings.put(this.REG_EX_CHECK, this.fIsRegex);
        this.settings.put(this.FILTER_TEXT, this.fFilterString);
    }

    public FilteredReportWizard(IResultAdapter[] adapters) {
        this.fAdapters = (IResultAdapter[])adapters.clone();
        this.setWindowTitle(Labels.FILTERED_RESULT);
    }

    public boolean performFinish() {
        if (!this.fComplete) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Labels.FILTERING_RESULTS, 100);
                        monitor.setTaskName(Labels.FETCHING_PATHS);
                        final String[] resultPaths = FilteredReportWizard.this.getResultPaths();
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        monitor.setTaskName(Labels.FILTERING_RESULTS);
                        FilteredReportWizard.this.saveSettings();
                        ICCResultModifier modifier = null;
                        if (FilteredReportWizard.this.fFilterString != null && !FilteredReportWizard.this.fFilterString.isEmpty()) {
                            ICCFilter filter = FilteredReportWizard.this.fIsRegex ? CCFilterFactory.createRegexLineContentFilter((String)FilteredReportWizard.this.fFilterString) : CCFilterFactory.createLineContentFilter((String)FilteredReportWizard.this.fFilterString);
                            modifier = CCResultsModifierFactory.createFilterModifier((ICCFilter)filter);
                        }
                        final ICCResultModifier filterModifer = modifier;
                        monitor.worked(80);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.setTaskName(Labels.OPENING_FILE);
                        Display.getDefault().syncExec(new Runnable(){

                            /*
                             * Unable to fully structure code
                             */
                            @Override
                            public void run() {
                                block4: {
                                    block6: {
                                        block5: {
                                            try {
                                                ReportCcsServerFactory.getInstance().openReport(resultPaths, filterModifer);
                                                break block4;
                                            }
                                            catch (Exception e) {
                                                ResultsViewPlugin.log((Throwable)e);
                                                errorMessageBuilder = new StringBuilder();
                                                if (!(e instanceof CCResultException)) break block5;
                                                var7_4 = eMessages = ((CCResultException)e).getMessages();
                                                var6_5 = eMessages.length;
                                                var5_6 = 0;
                                                ** while (var5_6 < var6_5)
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                subExceptionMsg = var7_4[var5_6];
                                                if (subExceptionMsg != null) {
                                                    errorMessageBuilder.append(CCMessageUtilities.getMessage((String)subExceptionMsg)).append(System.lineSeparator());
                                                }
                                                ++var5_6;
                                                continue;
lbl18:
                                                // 1 sources

                                                break block6;
                                            }
                                        }
                                        errorMessageBuilder.append(e.getMessage());
                                    }
                                    formattedErrorMessages = errorMessageBuilder.toString();
                                    workbenchDisplay = PlatformUI.getWorkbench().getDisplay();
                                    workbenchDisplay.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)workbenchDisplay.getActiveShell(), (String)Labels.REPORT_ERROR, (String)formattedErrorMessages);
                                        }
                                    });
                                    return;
                                }
                            }
                        });
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        FilteredReportWizard.this.fComplete = true;
                    }
                });
            }
            catch (InvocationTargetException e) {
                ResultsViewPlugin.log((Throwable)e);
                return false;
            }
            catch (InterruptedException e) {
                ResultsViewPlugin.log((Throwable)e);
                return false;
            }
        }
        return this.fComplete;
    }

    protected String[] getResultPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        IResultAdapter[] iResultAdapterArray = this.fAdapters;
        int n = this.fAdapters.length;
        int n2 = 0;
        while (n2 < n) {
            IResultAdapter adapter = iResultAdapterArray[n2];
            if (!adapter.isAnalyzed()) {
                adapter.analyze(true);
            }
            paths.add(adapter.getResultPath(true));
            ++n2;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public void addPages() {
        this.addPage((IWizardPage)new FilteredReportWizardPage());
    }

    class FilteredReportWizardPage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        Label fFilterLabel;
        Text fFilterText;
        Button fRegExButton;

        protected FilteredReportWizardPage() {
            super("FilteredReportWizardPage");
            this.setTitle(Labels.FILTERED_RESULT);
            this.setMessage(Labels.FILTER_TIP);
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            FilteredReportWizard.this.setNeedsProgressMonitor(true);
            this.getShell().setText(Labels.FILTERED_RESULT);
            Composite main = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
            this.fFilterLabel = new Label(main, 0);
            this.fFilterLabel.setText(Labels.FILTER_LABEL);
            this.fFilterText = new Text(main, 2048);
            this.fFilterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    FilteredReportWizardPage.this.setErrorMessage(null);
                    if (FilteredReportWizardPage.this.fRegExButton.getSelection()) {
                        try {
                            Pattern.compile(FilteredReportWizardPage.this.fFilterText.getText());
                        }
                        catch (PatternSyntaxException ex) {
                            FilteredReportWizardPage.this.setErrorMessage(ex.getMessage());
                        }
                    }
                    FilteredReportWizardPage.this.setPageComplete(FilteredReportWizardPage.this.getErrorMessage() == null);
                    if (FilteredReportWizardPage.this.fFilterText.getText().trim().isEmpty()) {
                        if (((FilteredReportWizardPage)FilteredReportWizardPage.this).FilteredReportWizard.this.settings.get(((FilteredReportWizardPage)FilteredReportWizardPage.this).FilteredReportWizard.this.FILTER_TEXT) != null) {
                            ((FilteredReportWizardPage)FilteredReportWizardPage.this).FilteredReportWizard.this.fFilterString = "";
                        }
                    } else {
                        ((FilteredReportWizardPage)FilteredReportWizardPage.this).FilteredReportWizard.this.fFilterString = FilteredReportWizardPage.this.fFilterText.getText();
                    }
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fFilterText);
            Label spacer = new Label(main, 0);
            GridDataFactory.fillDefaults().hint(0, 0).applyTo((Control)spacer);
            this.fRegExButton = new Button(main, 32);
            this.fRegExButton.setText(Labels.REG_EX);
            this.fRegExButton.addSelectionListener((SelectionListener)this);
            this.initializeControls(FilteredReportWizard.this.settings);
            this.setControl((Control)main);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)main, "com.ibm.debug.pdt.codecoverage.ui.view.filter_result_wizard");
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            FilteredReportWizard.this.fIsRegex = this.fRegExButton.getSelection();
        }

        public void modifyText(ModifyEvent arg0) {
        }

        protected void initializeControls(IDialogSettings settings) {
            if (settings.get(FilteredReportWizard.this.REG_EX_CHECK) != null) {
                this.fRegExButton.setSelection(Boolean.valueOf(settings.get(FilteredReportWizard.this.REG_EX_CHECK)).booleanValue());
            } else {
                this.fRegExButton.setSelection(false);
            }
            FilteredReportWizard.this.fIsRegex = this.fRegExButton.getSelection();
            if (settings.get(FilteredReportWizard.this.FILTER_TEXT) != null) {
                this.fFilterText.setText(settings.get(FilteredReportWizard.this.FILTER_TEXT));
            } else {
                this.fFilterText.setText("");
            }
        }
    }
}

