/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.web;

import com.ibm.commoncomponents.ccaas.core.http.request.HttpClient;
import com.ibm.commoncomponents.ccaas.core.json.CCResultEntrySerializable;
import com.ibm.commoncomponents.ccaas.core.server.AbstractIdeServlet;
import com.ibm.commoncomponents.ccaas.core.server.JettyServerFactory;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultModifier;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterInfo;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCFileMismatchException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.preferences.ThresholdPreferencePage;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.CCWebViewActivator;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ICCWebViewerConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.RedirectedServlet;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.ReportType;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.editor.CCReportEditorInput;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.web.editor.CCReportViewer;
import com.ibm.debug.pdt.codecoverage.ui.CCResultsViewException;
import com.ibm.debug.pdt.codecoverage.ui.ICCResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.Bundle;

public class ReportCcsServerFactory
implements ICCWebViewerConstants {
    private final IPropertyChangeListener fPropertyListener = new ColorPropertyListener();
    private RGB fFailCoverageColor = null;
    private RGB fWarnCoverageColor = null;
    private RGB fPassCoverageColor = null;
    protected static final String IDE_HOST = "localhost";
    private static final ReportCcsServerFactory fInstance = new ReportCcsServerFactory();
    private String fCcsResultsDir = null;
    private String fCcsWorkingDir = null;
    private static Map<ICCResult, CCResultEntrySerializable> fResults;
    private HttpClient fHttpClient;
    private String fHost;
    private int fPort;
    private boolean fWebView2RuntimeReqAndInstalled;
    private static final String REGKEYHKLM = "HKLM\\SOFTWARE\\WOW6432Node\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5}";
    private static final String REGKEYHKCU = "HKCU\\Software\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5}";
    private static final String RDI_PRODUCT_ID = "com.ibm.rational.developer.ibmi.product.ide";

    private ReportCcsServerFactory() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        fResults = Collections.synchronizedMap(new HashMap());
        IThemeManager manager = PlatformUI.getWorkbench().getThemeManager();
        manager.addPropertyChangeListener(this.fPropertyListener);
        ITheme fCurrentTheme = manager.getCurrentTheme();
        ColorRegistry colors = fCurrentTheme.getColorRegistry();
        this.fFailCoverageColor = colors.get("com.ibm.rational.llc.color.fail").getRGB();
        this.fWarnCoverageColor = colors.get("com.ibm.rational.llc.color.warning").getRGB();
        this.fPassCoverageColor = colors.get("com.ibm.rational.llc.color.pass").getRGB();
        try {
            this.fWebView2RuntimeReqAndInstalled = this.isWebView2RuntimeReqAndInstalled();
        }
        catch (IOException e) {
            ResultsViewPlugin.log((Throwable)e);
            this.fWebView2RuntimeReqAndInstalled = false;
        }
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    public static ReportCcsServerFactory getInstance() {
        return fInstance;
    }

    private Path getCcsDir() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        Bundle ccsBundle = Platform.getBundle((String)"com.ibm.commoncomponents.ccaas.core");
        if (ccsBundle != null) {
            IPath ccsBundleDir = Platform.getStateLocation((Bundle)ccsBundle);
            Path ccsBundleDirPath = ccsBundleDir.toFile().toPath();
            CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsBundleDirPath);
            return ccsBundleDirPath;
        }
        Path result = new File(System.getProperty("java.io.tmpdir")).toPath();
        CCWebViewActivator.fTrace.traceExit("/ccs", (Object)result);
        return result;
    }

    private String getCcsResultsDir() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        try {
            if (this.fCcsResultsDir == null) {
                Path ccsDir = this.getCcsDir();
                Path ccsResultsDirPath = ccsDir.toFile().exists() ? Files.createTempDirectory(ccsDir, "results", new FileAttribute[0]) : Files.createTempDirectory("results", new FileAttribute[0]);
                File ccResultsDirFile = ccsResultsDirPath.toFile();
                ccResultsDirFile.deleteOnExit();
                this.fCcsResultsDir = ccResultsDirFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            CCWebViewActivator.fTrace.trace("/ccs", "Fail to create Results View's CCS Server's result directory", (Throwable)e);
            ResultsViewPlugin.log((int)4, (String)"Fail to create Results View's CCS Server's result directory", (Throwable)e);
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", (Object)this.fCcsResultsDir);
        return this.fCcsResultsDir;
    }

    private String getCcsWorkingDir() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        if (this.fCcsWorkingDir == null) {
            try {
                Path ccsDir = this.getCcsDir();
                Path ccsWorkingDirPath = ccsDir.toFile().exists() ? Files.createTempDirectory(ccsDir, "ccaas", new FileAttribute[0]) : Files.createTempDirectory("ccaas", new FileAttribute[0]);
                File ccsWorkingDir = ccsWorkingDirPath.toFile();
                ccsWorkingDir.deleteOnExit();
                this.fCcsWorkingDir = ccsWorkingDir.getAbsolutePath();
            }
            catch (Exception e) {
                CCWebViewActivator.fTrace.trace("/ccs", "Fail to create Results View's CCS Server's working directory", (Throwable)e);
                ResultsViewPlugin.log((int)4, (String)"Fail to create Results View's CCS Server's working directory", (Throwable)e);
            }
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", (Object)this.fCcsWorkingDir);
        return this.fCcsWorkingDir;
    }

    private void clearDirs() {
        Path ccsWorkingDirPath;
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        if (this.fCcsWorkingDir != null) {
            ccsWorkingDirPath = Paths.get(this.fCcsWorkingDir, new String[0]);
            try {
                Files.walk(ccsWorkingDirPath, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                this.fCcsWorkingDir = null;
            }
            catch (IOException e) {
                CCWebViewActivator.fTrace.trace("/ccs", "Error when clearing ccs working directory", (Throwable)e);
                ResultsViewPlugin.log((int)4, (String)"Error when clearing ccs working directory", (Throwable)e);
            }
        }
        if (this.fCcsResultsDir != null) {
            ccsWorkingDirPath = Paths.get(this.fCcsResultsDir, new String[0]);
            try {
                Files.walk(ccsWorkingDirPath, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                this.fCcsWorkingDir = null;
            }
            catch (IOException e) {
                CCWebViewActivator.fTrace.trace("/ccs", "Error when clearing ccs results directory", (Throwable)e);
                ResultsViewPlugin.log((int)4, (String)"Error when clearing ccs results directory", (Throwable)e);
            }
        }
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    private void clearPriorDirs() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        Path parentDirPath = this.getCcsDir();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> walk = Files.walk(parentDirPath, new FileVisitOption[0]);){
                walk.map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CCWebViewActivator.fTrace.trace("/ccs", "Error when clearing prior dirs", (Throwable)e);
            ResultsViewPlugin.log((int)4, (String)"Error when clearing prior dirs", (Throwable)e);
        }
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    private void startServer() throws Exception {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        JettyServerFactory ccsServer = JettyServerFactory.getInstance();
        if (!ccsServer.isRunning()) {
            this.clearPriorDirs();
            RedirectedServlet redirectServlet = new RedirectedServlet();
            Properties properties = new Properties();
            String resultDir = this.getCcsResultsDir();
            if (resultDir == null) {
                CCWebViewActivator.fTrace.trace("/ccs", "Fail to create result directory for ccs");
                CCWebViewActivator.fTrace.traceExit("/ccs");
                throw new Exception("Fail to create result directory for ccs");
            }
            String workingDir = this.getCcsWorkingDir();
            if (workingDir == null) {
                CCWebViewActivator.fTrace.trace("/ccs", "Fail to create result directory for ccs");
                CCWebViewActivator.fTrace.traceExit("/ccs");
                throw new Exception("Fail to create working directory for ccs");
            }
            properties.setProperty("results.dir", resultDir);
            properties.setProperty("working.dir", workingDir);
            ccsServer.startServerForIde(0, properties, (AbstractIdeServlet)redirectServlet);
            this.fHost = ccsServer.getHost();
            this.fPort = ccsServer.getPort();
            this.fHttpClient = ccsServer.getHttpClient();
        } else if (this.fCcsResultsDir == null) {
            CCWebViewActivator.fTrace.trace("/ccs", "Has detected ccs server started, but result directory not set yet");
            throw new Exception("Has detected ccs server started, but result directory not set yet");
        }
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    protected void handleStopServer() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        this.clearDirs();
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    private CCResultEntrySerializable uploadCcResult(String resultPath) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)resultPath);
        File resultFile = new File(resultPath);
        if (resultFile.exists()) {
            try {
                CCResultEntrySerializable ccsResult = this.fHttpClient.uploadResult(resultFile, true, false);
                CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsResult);
                return ccsResult;
            }
            catch (IOException e) {
                CCWebViewActivator.fTrace.trace("/ccs", "Fail to upload result to ccs server", (Throwable)e);
                ResultsViewPlugin.log((int)4, (String)"Fail to upload result to ccs server", (Throwable)e);
            }
        } else {
            CCWebViewActivator.fTrace.trace("/ccs", "Unable to upload result to ccs server because fail to find cc result");
            ResultsViewPlugin.log((int)4, (String)"Unable to upload result to ccs server because fail to find cc result");
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", null);
        return null;
    }

    private CCResultEntrySerializable uploadCcResult(IResultAdapter resultAdapter) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)resultAdapter);
        String resultPath = resultAdapter.getLocalPath();
        CCResultEntrySerializable result = this.uploadCcResult(resultPath);
        CCWebViewActivator.fTrace.traceExit("/ccs", (Object)result);
        return result;
    }

    private CCResultEntrySerializable getCcsResult(ICCResult ccResult) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)ccResult);
        int toSearchId = ccResult.getID();
        for (Map.Entry<ICCResult, CCResultEntrySerializable> entry : fResults.entrySet()) {
            ICCResult currResult = entry.getKey();
            if (currResult.getID() != toSearchId) continue;
            CCResultEntrySerializable result = entry.getValue();
            CCWebViewActivator.fTrace.traceExit("/ccs", (Object)result);
            return result;
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", null);
        return null;
    }

    protected static ICCResult getCcResult(String ccsResultId) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)ccsResultId);
        ICCResult result = null;
        Iterator<Map.Entry<ICCResult, CCResultEntrySerializable>> iterator = fResults.entrySet().iterator();
        while (iterator.hasNext() && result == null) {
            Map.Entry<ICCResult, CCResultEntrySerializable> entry = iterator.next();
            if (!ccsResultId.equalsIgnoreCase(entry.getValue().getId())) continue;
            result = entry.getKey();
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", result);
        return result;
    }

    private String getWebReportUrl() {
        return "http://" + this.fHost + ":" + this.fPort + "/ccreport/result";
    }

    private String getCompareWebReportUrl() {
        return "http://" + this.fHost + ":" + this.fPort + "/ccreport/compare";
    }

    private String getTheme() {
        CCWebViewActivator.fTrace.traceEntry("/url");
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
        String curTheme = prefs.get("themeid", "DEFAULT");
        boolean useDark = curTheme.equals("DEFAULT") && Display.isSystemDarkTheme();
        String themeIdString = curTheme.startsWith("org.eclipse.e4.ui.css.theme.e4_dark") || useDark ? "dark" : "light";
        CCWebViewActivator.fTrace.traceExit("/url", (Object)themeIdString);
        return themeIdString;
    }

    private String getThresholdQueryString() {
        CCWebViewActivator.fTrace.traceEntry("/url");
        int failThreshold = ThresholdPreferencePage.getThreshold();
        int warningThreshold = ThresholdPreferencePage.getWarningThreshold();
        String thresholdQuery = "thresholdError=" + failThreshold + "&thresholdWarning=" + warningThreshold;
        CCWebViewActivator.fTrace.traceExit("/url", (Object)thresholdQuery);
        return thresholdQuery;
    }

    private IEditorReference getCCWebEditor(String urlLink) {
        IEditorReference[] editors;
        CCWebViewActivator.fTrace.traceEntry("/editor", (Object)urlLink);
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                CCReportViewer ccEditor;
                Browser ccBrowser;
                String link;
                if (editor.getEditorInput() instanceof CCReportEditorInput && (link = (ccBrowser = (ccEditor = (CCReportViewer)editor.getEditor(false)).getBrowser()).getUrl()) != null && link.equals(urlLink)) {
                    CCWebViewActivator.fTrace.traceExit("/editor", (Object)editor);
                    return editor;
                }
            }
            catch (PartInitException e) {
                CCWebViewActivator.fTrace.trace("/editor", e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        CCWebViewActivator.fTrace.traceExit("/editor", null);
        return null;
    }

    private boolean isCCWebEditorIsOpen() {
        IEditorReference[] editors;
        CCWebViewActivator.fTrace.traceEntry("/editor");
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                if (editor.getEditorInput() instanceof CCReportEditorInput) {
                    CCWebViewActivator.fTrace.traceExit("/editor", (Object)true);
                    return true;
                }
            }
            catch (PartInitException e) {
                CCWebViewActivator.fTrace.trace("/editor", e.getMessage(), (Throwable)e);
                ResultsViewPlugin.log((Throwable)e);
            }
            ++n2;
        }
        CCWebViewActivator.fTrace.traceExit("/editor", (Object)false);
        return false;
    }

    private String convertStringCharset(String input, Charset charset) {
        return new String(input.getBytes(Charset.defaultCharset()), StandardCharsets.UTF_8);
    }

    private String convertStringCharset(String input) {
        return this.convertStringCharset(input, StandardCharsets.UTF_8);
    }

    private boolean isWebView2RuntimeReqAndInstalled() throws IOException {
        CCWebViewActivator.fTrace.traceEntry("/editor");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            boolean result;
            String err;
            BufferedReader reader;
            Process process = Runtime.getRuntime().exec("REG QUERY HKLM\\SOFTWARE\\WOW6432Node\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5}");
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), Charset.defaultCharset()));
                try {
                    err = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    result = err.trim().isEmpty();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!result) {
                process = Runtime.getRuntime().exec("REG QUERY HKCU\\Software\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5}");
                throwable = null;
                var4_5 = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), Charset.defaultCharset()));
                    try {
                        err = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                        result = err.trim().isEmpty();
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            CCWebViewActivator.fTrace.traceEntry("/editor");
            return result;
        }
        CCWebViewActivator.fTrace.traceEntry("/editor");
        return true;
    }

    private String RGBToHex(RGB RGBcolor) {
        return String.format("%02x%02x%02x", RGBcolor.red, RGBcolor.green, RGBcolor.blue);
    }

    private void refreshCCEditors() {
        IEditorReference[] editors;
        CCWebViewActivator.fTrace.traceEntry("/editor");
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                if (editor.getEditorInput() instanceof CCReportEditorInput) {
                    CCReportViewer ccEditor = (CCReportViewer)editor.getEditor(false);
                    Browser ccBrowser = ccEditor.getBrowser();
                    String currentUrl = ccBrowser.getUrl();
                    String failColorHex = this.RGBToHex(this.fFailCoverageColor);
                    String warnColorHex = this.RGBToHex(this.fWarnCoverageColor);
                    String passColorHex = this.RGBToHex(this.fPassCoverageColor);
                    String newUrl = currentUrl.replaceAll("failColor=\\w+", "failColor=" + failColorHex).replaceAll("warningColor=\\w+", "warningColor=" + warnColorHex).replaceAll("passColor=\\w+", "passColor=" + passColorHex);
                    ccBrowser.setUrl(newUrl);
                }
            }
            catch (PartInitException e) {
                ResultsViewPlugin.log((Throwable)e);
            }
            ++n2;
        }
        CCWebViewActivator.fTrace.traceExit("/editor");
    }

    private void openCcsResultBrowser(CCResultEntrySerializable ccsResult) throws PartInitException, IOException {
        CCWebViewActivator.fTrace.traceEntry("/editor", (Object)ccsResult);
        String failColorHex = this.RGBToHex(this.fFailCoverageColor);
        String warnColorHex = this.RGBToHex(this.fWarnCoverageColor);
        String passColorHex = this.RGBToHex(this.fPassCoverageColor);
        String ccsResultId = ccsResult.getId();
        String theme = this.getTheme();
        String resultAddress = this.getWebReportUrl() + "/" + ccsResultId + "?theme=" + theme + "&" + this.getThresholdQueryString() + "&lang=" + Locale.getDefault().toLanguageTag() + "&hidetree=true&failColor=" + failColorHex + "&warningColor=" + warnColorHex + "&passColor=" + passColorHex;
        if (Platform.getProduct() != null && RDI_PRODUCT_ID.equals(Platform.getProduct().getId())) {
            resultAddress = resultAddress + "&p=rdi";
        }
        if (!this.fWebView2RuntimeReqAndInstalled) {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            browserSupport.getExternalBrowser().openURL(new URL(resultAddress));
            CCWebViewActivator.fTrace.traceExit("/editor");
            return;
        }
        IEditorReference editor = this.getCCWebEditor(resultAddress);
        if (editor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop(editor.getPart(true));
            CCWebViewActivator.fTrace.traceExit("/editor");
            return;
        }
        String name = this.convertStringCharset(ccsResult.getName());
        CCReportEditorInput input = new CCReportEditorInput(resultAddress, name, ccsResultId, ccsResult.getLevel().equals(ICCConstants.COVERAGE_LEVEL.FUNCTION.toString()) ? ReportType.report_program_flow : ReportType.report);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.debug.pdt.codecoverage.ui.view.web.browserviewer");
        CCWebViewActivator.fTrace.traceExit("/editor");
    }

    private void openCcsCompareResultBrowser(CCResultEntrySerializable prevResult, CCResultEntrySerializable currResult) throws PartInitException, MalformedURLException {
        CCWebViewActivator.fTrace.traceEntry("/editor", new Object[]{prevResult, currResult});
        String failColorHex = this.RGBToHex(this.fFailCoverageColor);
        String warnColorHex = this.RGBToHex(this.fWarnCoverageColor);
        String passColorHex = this.RGBToHex(this.fPassCoverageColor);
        String prevId = prevResult.getId();
        String currId = currResult.getId();
        String theme = this.getTheme();
        String compareAddress = this.getCompareWebReportUrl() + "/" + currId + "?base=" + prevId + "&theme=" + theme + "&" + this.getThresholdQueryString() + "&lang=" + Locale.getDefault().toLanguageTag() + "&failColor=" + failColorHex + "&warningColor=" + warnColorHex + "&passColor=" + passColorHex;
        if (Platform.getProduct() != null && RDI_PRODUCT_ID.equals(Platform.getProduct().getId())) {
            compareAddress = compareAddress + "&p=rdi";
        }
        if (!this.fWebView2RuntimeReqAndInstalled) {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            browserSupport.getExternalBrowser().openURL(new URL(compareAddress));
            CCWebViewActivator.fTrace.traceExit("/editor");
            return;
        }
        IEditorReference editor = this.getCCWebEditor(compareAddress);
        if (editor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop(editor.getPart(true));
        } else {
            String partName = this.convertStringCharset(currResult.getName()) + " - " + this.convertStringCharset(prevResult.getName());
            String partId = currId + "-" + prevId;
            CCReportEditorInput input = new CCReportEditorInput(compareAddress, partName, partId, ReportType.compare);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.debug.pdt.codecoverage.ui.view.web.browserviewer");
        }
        CCWebViewActivator.fTrace.traceExit("/editor");
    }

    private CCResultEntrySerializable addResultToCcs(IResultAdapter resultAdapter) {
        ICCResult ccResult;
        CCResultEntrySerializable ccsResult;
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)resultAdapter);
        if (!resultAdapter.isAnalyzed()) {
            resultAdapter.analyze(true);
        }
        if ((ccsResult = this.getCcsResult(ccResult = resultAdapter.getResult())) == null) {
            ccsResult = this.uploadCcResult(resultAdapter);
            if (ccsResult != null) {
                ICCResult resultToRemove = ReportCcsServerFactory.getCcResult(ccsResult.getId());
                if (resultToRemove != null) {
                    fResults.remove(resultToRemove);
                }
                fResults.put(ccResult, ccsResult);
                CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsResult);
                return ccsResult;
            }
        } else {
            CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsResult);
            return ccsResult;
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", null);
        return null;
    }

    private CCResultEntrySerializable addResultToCcs(ICCResult result) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)result);
        try {
            CCResultEntrySerializable ccsResult = this.getCcsResult(result);
            if (ccsResult == null) {
                ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
                String resultPath = this.getCcsResultsDir();
                exporter.exportResult(result, null, resultPath, true);
                this.fHttpClient.update(false);
                ccsResult = this.fHttpClient.getResult(result.getUUID());
                fResults.put(result, ccsResult);
            }
            CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsResult);
            return ccsResult;
        }
        catch (CCExportException | IOException e) {
            CCWebViewActivator.fTrace.trace("/ccs", e.getMessage(), e);
            ResultsViewPlugin.log((Throwable)e);
            CCWebViewActivator.fTrace.traceExit("/ccs", null);
            return null;
        }
    }

    public void openReport(final ICCResultAdapter resultAdapter) throws CCResultsViewException {
        if (!(resultAdapter instanceof IResultAdapter)) {
            throw new ResultException(NLS.bind((String)CCResultViewMessages.CRRDG9335, (Object)resultAdapter.getResultPath()));
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CCWebViewActivator.fTrace.trace("/editor", "openReport(IResultAdapter resultAdapter)");
                CCWebViewActivator.fTrace.traceEntry("/editor", (Object)resultAdapter);
                try {
                    ReportCcsServerFactory.this.startServer();
                    CCResultEntrySerializable ccsResult = ReportCcsServerFactory.this.addResultToCcs((IResultAdapter)resultAdapter);
                    ReportCcsServerFactory.this.openCcsResultBrowser(ccsResult);
                }
                catch (Exception e) {
                    CCWebViewActivator.fTrace.trace("/editor", "Fail to open code coverage result", (Throwable)e);
                    ResultsViewPlugin.log((int)4, (String)"Fail to open code coverage result", (Throwable)e);
                }
                CCWebViewActivator.fTrace.trace("/editor", "openReport(IResultAdapter resultAdapter)");
                CCWebViewActivator.fTrace.traceExit("/editor");
            }
        });
    }

    public void openReport(final ICCResult result) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CCWebViewActivator.fTrace.trace("/editor", "openReport(ICCResult result)");
                CCWebViewActivator.fTrace.traceEntry("/editor", (Object)result);
                try {
                    ReportCcsServerFactory.this.startServer();
                    CCResultEntrySerializable ccsResult = ReportCcsServerFactory.this.getCcsResult(result);
                    if (ccsResult == null) {
                        ccsResult = ReportCcsServerFactory.this.addResultToCcs(result);
                    }
                    ReportCcsServerFactory.this.openCcsResultBrowser(ccsResult);
                }
                catch (Exception e) {
                    CCWebViewActivator.fTrace.trace("/editor", "Fail to open code coverage result", (Throwable)e);
                    ResultsViewPlugin.log((int)4, (String)"Fail top open filtered code coverage result", (Throwable)e);
                }
                CCWebViewActivator.fTrace.trace("/editor", "openReport(ICCResult result)");
                CCWebViewActivator.fTrace.traceExit("/editor", (Object)result);
            }
        });
    }

    public void openReport(String[] resultPaths, ICCResultModifier modifier) throws Exception {
        CCWebViewActivator.fTrace.traceEntry("/editor", new Object[]{resultPaths, modifier});
        this.startServer();
        ICCResult result = CCResultsFactory.getInstance().createResult(resultPaths, modifier);
        ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
        String resultPath = this.getCcsResultsDir();
        ICCExporterInfo info = exporter.exportResult(result, null, resultPath, true);
        this.fHttpClient.update(false);
        ICCResult filterResult = CCResultsFactory.getInstance().createResult(info.getDestination());
        CCResultEntrySerializable ccsResult = this.fHttpClient.getResult(filterResult.getUUID());
        fResults.put(filterResult, ccsResult);
        this.openCcsResultBrowser(ccsResult);
        CCWebViewActivator.fTrace.traceExit("/editor");
    }

    public void openCompareResults(final IResultAdapter prevResultAdapter, final IResultAdapter currResultAdapter) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CCWebViewActivator.fTrace.trace("/editor", "openCompareResults");
                CCWebViewActivator.fTrace.traceEntry("/editor", new Object[]{prevResultAdapter, currResultAdapter});
                try {
                    ReportCcsServerFactory.this.startServer();
                    CCResultEntrySerializable prevCcsResult = ReportCcsServerFactory.this.addResultToCcs(prevResultAdapter);
                    CCResultEntrySerializable currCcsResult = ReportCcsServerFactory.this.addResultToCcs(currResultAdapter);
                    if (prevCcsResult != null && currCcsResult != null) {
                        String prevCcsLevel = prevCcsResult.getLevel();
                        String currCcsLevel = currCcsResult.getLevel();
                        if (!prevCcsLevel.equalsIgnoreCase("line") || !currCcsLevel.equalsIgnoreCase("line")) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Labels.REPORT_ERROR, (String)CCResultViewMessages.CRRDG9334);
                            return;
                        }
                        ReportCcsServerFactory.this.openCcsCompareResultBrowser(prevCcsResult, currCcsResult);
                    }
                }
                catch (Exception e) {
                    CCWebViewActivator.fTrace.trace("/editor", "Fail to compare result", (Throwable)e);
                    ResultsViewPlugin.log((int)4, (String)"Fail to compare result", (Throwable)e);
                }
                CCWebViewActivator.fTrace.trace("/editor", "openCompareResults");
                CCWebViewActivator.fTrace.traceExit("/editor");
            }
        });
    }

    private boolean isResultFileNameExists(String fileName) {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object)fileName);
        File[] files = new File(this.fCcsResultsDir).listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(fileName)) {
                    CCWebViewActivator.fTrace.traceExit("/ccs", (Object)true);
                    return true;
                }
                ++n2;
            }
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", (Object)false);
        return false;
    }

    private CCResultEntrySerializable getCcsResultByFileName(String fileName, boolean refresh) throws IOException {
        CCWebViewActivator.fTrace.traceEntry("/ccs", new Object[]{fileName, refresh});
        if (refresh) {
            this.fHttpClient.update(false);
        }
        List resultsEntry = null;
        resultsEntry = this.fHttpClient.getResults();
        if (resultsEntry != null) {
            for (CCResultEntrySerializable resultEntry : resultsEntry) {
                if (!resultEntry.getFileName().equals(fileName)) continue;
                CCWebViewActivator.fTrace.traceExit("/ccs", (Object)resultEntry);
                return resultEntry;
            }
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", null);
        return null;
    }

    private ICCResult generateMergeResult(ICCResultAdapter[] resultAdapters) throws CCResultException {
        CCWebViewActivator.fTrace.traceEntry("/ccs", (Object[])resultAdapters);
        int numOfResults = resultAdapters.length;
        HashSet<String> resultPaths = new HashSet<String>();
        int i = 0;
        while (i < numOfResults) {
            IResultAdapter currResultAdapter = (IResultAdapter)resultAdapters[i];
            if (!currResultAdapter.isResultAvailable()) {
                currResultAdapter.getResult();
            }
            resultPaths.add(currResultAdapter.getResultPath(true));
            if (currResultAdapter.isBaselineUsed()) {
                resultPaths.add(currResultAdapter.getBaselineFileName());
            }
            ++i;
        }
        ICCResult result = null;
        try {
            result = CCResultsFactory.getInstance().createResult(resultPaths.toArray(new String[numOfResults]));
        }
        catch (CCResultException cCResultException) {
            // empty catch block
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", result);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private CCResultEntrySerializable generateMergeResultToCcsServer(ICCResultAdapter[] resultAdapters) throws CCResultException, CCExportException, IOException {
        block6: {
            CCWebViewActivator.fTrace.traceEntry("/ccs", (Object[])resultAdapters);
            result = null;
            try {
                result = this.generateMergeResult(resultAdapters);
                break block6;
            }
            catch (CCResultException e) {
                CCWebViewActivator.fTrace.trace("/ccs", "Error when generating merged results", (Throwable)e);
                ResultsViewPlugin.log((int)4, (String)"Error when generating merged results", (Throwable)e);
                sourceMismatchHandled = false;
                ConfirmOK = new boolean[]{true};
                var9_7 = e.getExceptions();
                var8_8 = var9_7.length;
                var7_9 = 0;
                ** while (var7_9 < var8_8)
            }
lbl-1000:
            // 1 sources

            {
                exception = var9_7[var7_9];
                ResultsViewPlugin.log((Throwable)exception);
                if (exception instanceof CCFileMismatchException && !sourceMismatchHandled) {
                    sourceMismatchHandled = true;
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public final void run() {
                            MessageDialog d = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Labels.ExportCCZipWizard_SrcFileInConflict_Title, null, CCResultViewMessages.CRRDG9316, 4, new String[]{Labels.ExportCCZipWizard_SrcFileInConflict_OK, Labels.ExportCCZipWizard_SrcFileInConflict_Cancel}, 0);
                            if (d.open() != 0) {
                                ConfirmOK[0] = false;
                            }
                        }
                    });
                    break;
                }
                ++var7_9;
                continue;
            }
lbl23:
            // 2 sources

            result = e.getResult();
        }
        fileName = result.getName() + ".cczip";
        idx = 1;
        while (this.isResultFileNameExists(fileName)) {
            fileName = result.getName() + "_" + idx++ + ".cczip";
        }
        outputPath = this.fCcsResultsDir + File.separator + fileName;
        exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
        exporter.exportResult(result, null, outputPath, true);
        this.fHttpClient.update(false);
        ccsResult = this.getCcsResultByFileName(fileName, true);
        if (ccsResult != null) {
            ReportCcsServerFactory.fResults.put(result, ccsResult);
            CCWebViewActivator.fTrace.traceExit("/ccs", (Object)ccsResult);
            return ccsResult;
        }
        CCWebViewActivator.fTrace.traceExit("/ccs", null);
        return null;
    }

    public void openMergedResults(final ICCResultAdapter[] resultAdapters) throws CCResultsViewException {
        ICCResultAdapter[] iCCResultAdapterArray = resultAdapters;
        int n = resultAdapters.length;
        int n2 = 0;
        while (n2 < n) {
            ICCResultAdapter r = iCCResultAdapterArray[n2];
            if (!(r instanceof IResultAdapter)) {
                throw new ResultException(NLS.bind((String)CCResultViewMessages.CRRDG9335, (Object)r.getResultPath()));
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CCWebViewActivator.fTrace.trace("/editor", "openMergedResults");
                CCWebViewActivator.fTrace.traceEntry("/editor", (Object[])resultAdapters);
                try {
                    ReportCcsServerFactory.this.startServer();
                    CCResultEntrySerializable ccsResult = null;
                    ccsResult = ReportCcsServerFactory.this.generateMergeResultToCcsServer(resultAdapters);
                    ReportCcsServerFactory.this.openCcsResultBrowser(ccsResult);
                }
                catch (Exception e) {
                    CCWebViewActivator.fTrace.trace("/editor", "Fail to open merge result", (Throwable)e);
                    ResultsViewPlugin.log((int)4, (String)"Fail to open merge result", (Throwable)e);
                }
                CCWebViewActivator.fTrace.trace("/editor", "openMergedResults");
                CCWebViewActivator.fTrace.traceExit("/editor");
            }
        });
    }

    protected void stopServer() {
        CCWebViewActivator.fTrace.traceEntry("/ccs");
        this.clearDirs();
        CCWebViewActivator.fTrace.traceExit("/ccs");
    }

    private final class ColorPropertyListener
    implements IPropertyChangeListener {
        private ColorPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Assert.isNotNull((Object)event);
            CCWebViewActivator.fTrace.traceEntry("/url", (Object)event);
            Object source = event.getSource();
            if (source instanceof ColorRegistry) {
                String property = event.getProperty();
                if (property.equals("com.ibm.rational.llc.color.pass")) {
                    ReportCcsServerFactory.this.fPassCoverageColor = (RGB)event.getNewValue();
                } else if (property.equals("com.ibm.rational.llc.color.fail")) {
                    ReportCcsServerFactory.this.fFailCoverageColor = (RGB)event.getNewValue();
                } else if (property.equals("com.ibm.rational.llc.color.warning")) {
                    ReportCcsServerFactory.this.fWarnCoverageColor = (RGB)event.getNewValue();
                }
                if (ReportCcsServerFactory.this.isCCWebEditorIsOpen() && (property.equals("com.ibm.rational.llc.color.warning") || property.equals("com.ibm.rational.llc.color.fail") || property.equals("com.ibm.rational.llc.color.pass"))) {
                    ReportCcsServerFactory.this.refreshCCEditors();
                }
            }
            CCWebViewActivator.fTrace.traceExit("/url");
        }
    }
}

