/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBSystemIFileProperties;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSetMember;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class LaunchShortcutUtils {
    private static final String EMPTY = "";

    public static String getQualifiedName(Object item) {
        Object newItem;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (item instanceof IPhysicalResource && ((IPhysicalResource)item).getFullPath() != null) {
            return DebugLaunchUIUtils.convertToDatasetName(((IPhysicalResource)item).getFullPath().toString());
        }
        if (item instanceof IFile) {
            return DebugLaunchUIUtils.convertToWorkspaceName((IFile)item);
        }
        if (item instanceof MVSFileResource) {
            return LaunchShortcutUtils.getQualifiedName(((MVSFileResource)item).getZOSResource());
        }
        if (provider != null && provider.handles(item) && (newItem = provider.getAdapter(item, IZOSDataSetMember.class)) != null) {
            return LaunchShortcutUtils.getQualifiedName(newItem);
        }
        return null;
    }

    public static String getName(Object item) {
        Object newItem;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (item instanceof IPhysicalResource && ((IPhysicalResource)item).getFullPath() != null) {
            return ((IPhysicalResource)item).getName();
        }
        if (item instanceof MVSFileResource) {
            return LaunchShortcutUtils.getName(((MVSFileResource)item).getZOSResource());
        }
        if (provider != null && provider.handles(item) && (newItem = provider.getAdapter(item, IZOSDataSetMember.class)) != null) {
            return LaunchShortcutUtils.getName(newItem);
        }
        return null;
    }

    public static ILaunchConfigurationWorkingCopy getLaunchConfiguration(IEditorPart editor, ILaunchConfiguration[] configs, String launchConfigType) throws CoreException {
        ILaunchConfigurationWorkingCopy result = null;
        if (configs != null && configs.length > 0) {
            result = configs[0].getWorkingCopy();
        } else {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                PBSystemIFileProperties props = new PBSystemIFileProperties((IResource)file);
                Object editObject = props.getRemoteEditObject();
                if (editObject instanceof IAbstractResource) {
                    IAbstractResource aRes = (IAbstractResource)editObject;
                    String mbrName = LaunchShortcutUtils.getQualifiedName(aRes);
                    ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchConfigType);
                    result = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(mbrName));
                } else if (file != null) {
                    String mbrName = LaunchShortcutUtils.getQualifiedName(file);
                    ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchConfigType);
                    result = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(mbrName));
                }
            }
        }
        return result;
    }

    public static ILaunchConfigurationWorkingCopy getLaunchConfiguration(ISelection selection, ILaunchShortcut2 shortcut, String launchConfigType) {
        ILaunchConfigurationWorkingCopy result;
        block4: {
            ILaunchConfiguration[] configs = shortcut.getLaunchConfigurations(selection);
            result = null;
            try {
                if (configs != null && configs.length > 0) {
                    result = configs[0].getWorkingCopy();
                    break block4;
                }
                if (!(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) break block4;
                Object item = ((IStructuredSelection)selection).getFirstElement();
                String name = LaunchShortcutUtils.getQualifiedName(item);
                if (name != null) {
                    ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchConfigType);
                    result = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name));
                    break block4;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", "Unable to determine name for :" + String.valueOf(item), null));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return result;
    }

    public static String getExtension(Object item) {
        String extension;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (item instanceof IZOSDataSetMember) {
            return ((IZOSDataSetMember)item).getFileExtension();
        }
        if (item instanceof IFile) {
            return ((IFile)item).getFileExtension();
        }
        if (provider != null && (extension = provider.getExtension(item)) != null) {
            return extension;
        }
        return EMPTY;
    }
}

