/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.IPDTDebugTargetWithLabelProvider;
import com.ibm.debug.pdt.internal.core.IPDTLabelProvider;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.etools.zos.subsystem.jes.zOSJESResources;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import com.ibm.ftt.debug.ui.HybridStartupInfo;
import com.ibm.ftt.debug.ui.ICCInfoProvider;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.zos.ZOSResourcesResources;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.ui.actions.PBJobSubmit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIMessages;

public class LaunchDelegateUtils
implements IJCLLaunchConstants,
ApplicationLaunchConstants {
    private static final String EMPTY = "";
    private static final String COLON = ":";

    public static int[] createDebugTarget(IZOSSystemImage connection, boolean debugUseIntegratedDebugger, ILaunchConfiguration configuration, String mode, ILaunch launch, Object ccProperties) throws CoreException {
        if (!CoreDaemon.startListening()) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(LaunchDelegateUtils.class, (String)"Debug Daemon failed to start!", (int)4);
            }
            PICLDebugPlugin.showMessageDialog(null, (String)PICLMessages.PICLLoadLaunchConfigTab1_daemonFailedToStartError, (boolean)false);
            return null;
        }
        boolean isUseProfile = configuration.getAttribute("USEPROFILE", false);
        JCLUtils.Step[] steps = JCLUtils.Step.createSteps(configuration.getAttribute("STEP", EMPTY));
        if (steps == null) {
            steps = JCLUtils.Step.createSteps("GO");
        }
        int[] keys = new int[steps.length];
        int i = 0;
        while (i < keys.length) {
            if (isUseProfile) {
                keys[i] = -1;
            } else {
                HybridStartupInfo info = new HybridStartupInfo(debugUseIntegratedDebugger);
                int key = CoreDaemon.generateKey();
                ICCInfoProvider provider = CCLaunchUtils.getCCInfoProvider();
                IPDTDebugTarget target = null;
                if (mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode())) {
                    target = provider.getTarget(launch, ccProperties, key);
                } else if (mode.equals("debug")) {
                    target = new PICLDebugTarget(launch, (PICLAbstractStartupInfo)info, null);
                } else if (mode.equals("run")) {
                    return new int[0];
                }
                if (target == null) {
                    return null;
                }
                if (target instanceof IPDTDebugTargetWithLabelProvider) {
                    final String name = steps[i].getName();
                    ((IPDTDebugTargetWithLabelProvider)target).setLabelProvider(new IPDTLabelProvider(){

                        public String getLabel(DebugElement element, String defaultString) {
                            if (element instanceof PDTDebugTarget) {
                                String prefix;
                                String string = prefix = ((PDTDebugTarget)element).isTerminated() ? DebugUIMessages.DefaultLabelProvider_1 : LaunchDelegateUtils.EMPTY;
                                if (((PDTDebugTarget)element).getEngineSession() == null) {
                                    return prefix + name + ": " + Labels.PENDING;
                                }
                                return prefix + name + ": " + defaultString;
                            }
                            if (element instanceof IPDTDebugTarget) {
                                return name + ": " + defaultString;
                            }
                            if (element instanceof DebuggeeProcess) {
                                if (((DebuggeeProcess)element).isTerminated()) {
                                    int bIdx = defaultString.indexOf(62);
                                    if (bIdx > -1) {
                                        return defaultString.substring(0, bIdx + 1) + name + LaunchDelegateUtils.COLON + defaultString.substring(bIdx + 1);
                                    }
                                    return defaultString;
                                }
                                return name + ": " + defaultString;
                            }
                            return defaultString;
                        }
                    });
                }
                info.setLaunchConfig(configuration);
                CoreDaemon.storeDebugTarget((IDebugTarget)target, (int)key);
                launch.addDebugTarget((IDebugTarget)target);
                keys[i] = key;
            }
            ++i;
        }
        if (keys.length == 0) {
            return null;
        }
        return keys;
    }

    public static boolean needsCompile(ILaunchConfiguration config) throws CoreException {
        return !config.getAttribute("USE_EXISTING", false) && !config.getAttribute("USE_PROGRAM", false);
    }

    public static String doSubmit(IOSImage image, String jclFilePath) throws CoreException {
        String systemName = image.getName();
        PBJobSubmit jobUtil = new PBJobSubmit();
        String jobId = jobUtil.submitLocal(jclFilePath, systemName);
        String myJobId = EMPTY;
        int index = jobId.indexOf(46);
        if (index > -1) {
            jobId = jobId.substring(0, index);
        }
        int j1 = jobId.indexOf("Job ");
        int j2 = jobId.indexOf(" accepted");
        myJobId = j1 > -1 && j2 > -1 ? jobId.substring(j1 + 4, j2) : jobId;
        if ((myJobId = myJobId.trim()).equals(EMPTY)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", zOSJESResources.PBRemoteJobSubmit_submitFailedMessage));
        }
        if (jobId.equalsIgnoreCase("RESULT_JMNOTCONNECTED") || jobId.equalsIgnoreCase("RESULT_JMEXCEPTION")) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", ZOSResourcesResources.jesNotConnected));
        }
        return jobId;
    }
}

