/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.debug.pdt.internal.ui.dialogs.DebugTitleAreaDialog;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.composites.RseConnectionsComposite;
import com.ibm.ftt.debug.ui.util.JCLStepException;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import com.ibm.lpex.core.LpexView;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class JCLUtils
implements IJCLLaunchConstants {
    private static final String EMPTY = "";
    private static final String WORKSPACE_VARIABLE = "{workspace_loc:%s}";
    public static final String WORKSPACE_VARIABLE_REGEX = "^\\{workspace_loc:(?i)(.*\\.jcl)\\}$";
    private static final Step[] EMPTY_STEPS = new Step[0];
    private static String fMessage = null;

    public static synchronized String loadSteps(final CheckboxTableViewer table, final IZOSSystemImage system, final String member, final Step current, final IFile localFile) {
        fMessage = null;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(table.getTable().getShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Labels.SEARCHING_JCL, -1);
                        Step[] steps = localFile != null ? JCLUtils.getSteps(system, localFile) : JCLUtils.getSteps(system, member);
                        GridData data = (GridData)table.getTable().getParent().getLayoutData();
                        int minRows = Math.min(steps.length, 10);
                        data.heightHint = table.getTable().getHeaderHeight() + table.getTable().computeSize((int)-1, (int)-1).y * minRows;
                        table.setInput((Object)steps);
                        if (current != null) {
                            table.setChecked((Object)current, true);
                            Object[] checkedItems = table.getCheckedElements();
                            if (checkedItems.length <= 0 || !checkedItems[0].equals(current)) {
                                fMessage = NLS.bind((String)DebugMessages.CRRDG8020, (Object)current.getName());
                            }
                        } else if (steps.length == 1) {
                            table.setChecked((Object)steps[0], true);
                            table.getTable().setEnabled(false);
                        }
                    }
                    catch (JCLStepException e) {
                        fMessage = e.getMessage();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            return e.getMessage();
        }
        return fMessage;
    }

    public static Step[] getSteps(IZOSSystemImage system, IFile localFile) throws JCLStepException {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (localFile != null) {
            JCLUtils.readJCLFileGetSteps(localFile, steps);
        }
        try {
            system.connect();
        }
        catch (Exception e) {
            throw new JCLStepException(NLS.bind((String)DebugMessages.CRRDG8019, (Object)system.getName()));
        }
        return steps.toArray(new Step[steps.size()]);
    }

    public static Step[] getSteps(IZOSSystemImage system, String member) throws JCLStepException {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (system == null) {
            return EMPTY_STEPS;
        }
        if (!member.isEmpty()) {
            IZOSCatalog root;
            if (!system.isConnected()) {
                try {
                    system.connect();
                }
                catch (Exception e) {
                    throw new JCLStepException(NLS.bind((String)DebugMessages.CRRDG8019, (Object)system.getName()));
                }
            }
            if ((root = (IZOSCatalog)system.getRoot()) != null) {
                IAdaptable dsm;
                int dsIndex = member.indexOf(40);
                IAdaptable iAdaptable = dsm = dsIndex == -1 ? root.findMember(member, (IProgressMonitor)new NullProgressMonitor()) : root.findMember(member.substring(0, dsIndex), (IProgressMonitor)new NullProgressMonitor());
                if (dsIndex > -1 && dsm instanceof IZOSPartitionedDataSet) {
                    dsm = ((IZOSPartitionedDataSet)dsm).findMember(member.substring(dsIndex + 1, member.length() - 1), (IProgressMonitor)new NullProgressMonitor());
                }
                if (dsm != null) {
                    MVSResource mvsResource = null;
                    if (dsm instanceof ZOSDataSetMember) {
                        mvsResource = ((ZOSDataSetMember)dsm).getMvsResource();
                    } else if (dsm instanceof ZOSSequentialDataSet) {
                        mvsResource = ((ZOSSequentialDataSet)dsm).getMvsResource();
                    } else {
                        throw new JCLStepException(NLS.bind((String)DebugMessages.CRRDG8020, (Object)member));
                    }
                    IFile file = null;
                    try {
                        file = mvsResource.getFile(null);
                        JCLUtils.readJCLFileGetSteps(file, steps);
                    }
                    catch (RemoteFileException e) {
                        Activator.log(e);
                        throw new JCLStepException(e.getMessage());
                    }
                    catch (InterruptedException e) {
                        throw new JCLStepException(e.getMessage());
                    }
                } else {
                    throw new JCLStepException(NLS.bind((String)DebugMessages.CRRDG8022, (Object)member));
                }
            }
        }
        return steps.toArray(new Step[steps.size()]);
    }

    private static void readJCLFileGetSteps(IFile file, List<Step> steps) {
        int stepNum = 1;
        LpexView view = new LpexView();
        view.doDefaultCommand("set name " + file.getLocationURI().getPath());
        String encoding = "UTF-8";
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        view.doDefaultCommand("load encoding " + encoding);
        long jclClass = view.classMask("jcl");
        long backClass = view.classMask("bwdLink");
        long ddClass = view.classMask("dd");
        long jobClass = view.classMask("job");
        long commentClass = view.classMask("comment");
        long condClass = view.classMask("cond");
        long libClass = view.classMask("lib");
        long invalidClasses = ddClass | backClass | jobClass | commentClass | condClass | libClass;
        int i = 1;
        while (i < view.elements() + 1) {
            String line;
            long elementClass;
            if (!view.show(i) && ((elementClass = view.elementClasses(i)) & jclClass) > 0L && (elementClass & invalidClasses) == 0L && (line = view.elementFullText(i)).trim().length() > 0 && line.startsWith("//")) {
                if (line.trim().equals("//")) break;
                String[] items = line.split(" ");
                String stepName = items[0].substring(2).trim();
                String rest = line.substring(stepName.length() + 2).trim();
                if (stepName.length() > 0 || rest.length() > 0) {
                    steps.add(new Step(stepNum++, stepName, rest.trim()));
                }
            }
            ++i;
        }
        view.dispose();
    }

    public static Object[] promptForSteps(String member, String connectionName, IFile jclFile) {
        IZOSSystemImage currentConnection = DebugLaunchUtils.getConnection(connectionName);
        StepDialog dialog = new StepDialog(Display.getDefault().getActiveShell(), member, jclFile, currentConnection);
        return dialog.open() == 0 ? dialog.fResult : null;
    }

    public static Object[] promptForStepsAndProfile(String member, String connectionName, IFile jclFile) {
        IZOSSystemImage currentConnection = DebugLaunchUtils.getConnection(connectionName);
        StepAndProfileDialog dialog = new StepAndProfileDialog(Display.getDefault().getActiveShell(), member, jclFile, currentConnection);
        return dialog.open() == 0 ? dialog.fResult : null;
    }

    public static List<IZOSSystemImage> getZSystems() {
        Object[] systems;
        ArrayList<IZOSSystemImage> zSystems = new ArrayList<IZOSSystemImage>();
        Object[] objectArray = systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            Object system = objectArray[n2];
            if (system instanceof IZOSSystemImage) {
                zSystems.add((IZOSSystemImage)system);
            }
            ++n2;
        }
        return zSystems;
    }

    public static CheckboxTableViewer createStepTable(Composite composite) {
        Composite tableComposite = new Composite(composite, 0);
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2052);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.getTable().setItemCount(3);
        int minHeight = viewer.getTable().computeSize((int)-1, (int)-1).y;
        viewer.getTable().setItemCount(0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, minHeight).applyTo((Control)tableComposite);
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Step) {
                    switch (columnIndex) {
                        case 0: {
                            return Integer.toString(((Step)element).getNum());
                        }
                        case 1: {
                            return ((Step)element).getName();
                        }
                        case 2: {
                            return ((Step)element).getBind();
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        TableColumn stepNumberCol = new TableColumn(viewer.getTable(), 16384);
        stepNumberCol.setText(Labels.STEP_NUM);
        TableColumn stepNameCol = new TableColumn(viewer.getTable(), 16384);
        stepNameCol.setText(Labels.STEP_NAME);
        TableColumn stepbindCol = new TableColumn(viewer.getTable(), 16384);
        stepbindCol.setText(Labels.DETAILS);
        TableColumnLayout layout = new TableColumnLayout(false);
        tableComposite.setLayout((Layout)layout);
        layout.setColumnData((Widget)stepNumberCol, (ColumnLayoutData)new ColumnWeightData(10, false));
        layout.setColumnData((Widget)stepNameCol, (ColumnLayoutData)new ColumnWeightData(20, false));
        layout.setColumnData((Widget)stepbindCol, (ColumnLayoutData)new ColumnWeightData(70, false));
        return viewer;
    }

    public static String getWorkspaceVariable() {
        return WORKSPACE_VARIABLE;
    }

    public static String getWorkspaceVariableRegex() {
        return WORKSPACE_VARIABLE_REGEX;
    }

    public static String removeWorkspaceVariable(String jclName) {
        if (jclName.startsWith(WORKSPACE_VARIABLE)) {
            jclName = jclName.substring(WORKSPACE_VARIABLE.length());
        } else if (jclName.matches(WORKSPACE_VARIABLE_REGEX)) {
            jclName = jclName.replaceAll(WORKSPACE_VARIABLE_REGEX, "$1");
        }
        return jclName;
    }

    public static String getFileWorkspacePath(String projectName) {
        return String.format(WORKSPACE_VARIABLE, projectName);
    }

    public static boolean isLocalPath(String projectPath) {
        return projectPath.startsWith(JCLUtils.getWorkspaceVariable()) || projectPath.matches(JCLUtils.getWorkspaceVariableRegex());
    }

    public static class Step {
        private static final String MULT_STEP_SEPARATOR = ":";
        private static final String STEP_SEPARATOR = ";";
        private static final int ANY = -1;
        private int fStepNum;
        private String fStepName;
        private String fStepBind;

        public Step(int num, String name, String bind) {
            this.fStepNum = num;
            this.fStepName = name;
            this.fStepBind = bind;
        }

        public int getNum() {
            return this.fStepNum;
        }

        public String getName() {
            return this.fStepName;
        }

        public String getBind() {
            return this.fStepBind;
        }

        public boolean equals(Object other) {
            if (other instanceof Step) {
                return (((Step)other).fStepNum == -1 || this.fStepNum == -1 || ((Step)other).fStepNum == this.fStepNum) && ((Step)other).fStepName.equals(this.fStepName);
            }
            return false;
        }

        public int hashCode() {
            return this.fStepNum + this.fStepName.hashCode() + this.fStepBind.hashCode();
        }

        public String toString() {
            return this.fStepNum + STEP_SEPARATOR + this.fStepName;
        }

        public static Step[] createSteps(String attribute) {
            if (attribute != null && !attribute.trim().isEmpty()) {
                String[] steps;
                ArrayList<Step> results = new ArrayList<Step>();
                String[] stringArray = steps = attribute.split(MULT_STEP_SEPARATOR);
                int n = steps.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    String[] segments = s.split(STEP_SEPARATOR);
                    if (segments.length == 2) {
                        try {
                            int stepNum = Integer.parseInt(segments[0]);
                            if (!segments[1].trim().isEmpty()) {
                                results.add(new Step(stepNum, segments[1].trim(), JCLUtils.EMPTY));
                            }
                        }
                        catch (NumberFormatException stepNum) {}
                    } else if (segments.length == 1) {
                        if (s.indexOf(STEP_SEPARATOR) > -1) {
                            try {
                                results.add(new Step(Integer.parseInt(segments[0].trim()), JCLUtils.EMPTY, JCLUtils.EMPTY));
                            }
                            catch (NumberFormatException e) {
                                results.add(new Step(-1, segments[0].trim(), JCLUtils.EMPTY));
                            }
                        } else {
                            results.add(new Step(-1, segments[0].trim(), JCLUtils.EMPTY));
                        }
                    }
                    ++n2;
                }
                if (results.size() > 0) {
                    return results.toArray(new Step[results.size()]);
                }
            }
            return null;
        }

        public static String getStepString(Step[] steps) {
            StringBuilder result = new StringBuilder();
            Step[] stepArray = steps;
            int n = steps.length;
            int n2 = 0;
            while (n2 < n) {
                Step s = stepArray[n2];
                if (result.length() > 0) {
                    result.append(MULT_STEP_SEPARATOR);
                }
                result.append(s);
                ++n2;
            }
            return result.toString();
        }

        public static Step[] getCheckedSteps(CheckboxTableViewer viewer) {
            if (viewer != null) {
                Object[] checked = viewer.getCheckedElements();
                ArrayList<Step> steps = new ArrayList<Step>();
                Object[] objectArray = checked;
                int n = checked.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray[n2];
                    if (s instanceof Step) {
                        steps.add((Step)s);
                    }
                    ++n2;
                }
                if (steps.size() > 0) {
                    return steps.toArray(new Step[steps.size()]);
                }
            }
            return null;
        }
    }

    static class StepAndProfileDialog
    extends StepDialog
    implements ICheckStateListener {
        private Label fDebugProfileLabel = null;
        private Combo fDebugProfileCombo = null;

        public StepAndProfileDialog(Shell activeShell, String member, IFile jclFile, IZOSSystemImage currConnection) {
            super(activeShell, member, jclFile, currConnection);
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            if (this.fLocalFile != null) {
                this.getShell().setText(Labels.CONFIGURATION_SELECTION_DIALOG);
                this.setTitle(Labels.CONFIGURATION_SELECTION_DIALOG);
                this.setMessage(Labels.CONFIGURATION_DIALOG_INSTRUCTION);
            } else {
                this.getShell().setText(Labels.STEP_PROFILE_SELECTION_TITLE);
                this.setTitle(Labels.STEP_PROFILE_SELECTION_TITLE);
                this.setMessage(Labels.STEP_PROFILE_SELECTION_DESCRIPTION);
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.idz.launches.mvsbatch.selectStepAndProfileDialog");
            Composite main = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
            this.fDebugProfileLabel = new Label(main, 0);
            this.fDebugProfileLabel.setText(Labels.DBG_PROFILE);
            this.fDebugProfileCombo = new Combo(main, 12);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDebugProfileCombo);
            for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles(this.currentConnection.getName(), false, true)) {
                this.fDebugProfileCombo.add(p.getName());
            }
            this.fDebugProfileCombo.addSelectionListener((SelectionListener)this);
            if (this.fDebugProfileCombo.getItemCount() > 0) {
                this.fDebugProfileCombo.select(0);
                this.fResult[2] = this.fDebugProfileCombo.getText();
            }
            if (this.fDebugProfileCombo.getItemCount() <= 1) {
                this.fDebugProfileCombo.setEnabled(false);
            }
            this.fDebugProfileLabel.setEnabled(false);
            this.fResult[1] = this.fSelectedStep;
            this.fResult[0] = this.currentConnection;
            return main;
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent event) {
            this.enableOk();
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            if (event.widget == this.fDebugProfileCombo) {
                this.fResult[2] = this.fDebugProfileCombo.getText();
            } else {
                String oldConnection = this.currentConnection.getName();
                int selectedDebugProfileItem = this.fDebugProfileCombo.getSelectionIndex();
                this.currentConnection = this.fConnection.getConnection();
                if (!oldConnection.equals(this.currentConnection.getName())) {
                    this.fDebugProfileCombo.clearSelection();
                    this.fDebugProfileCombo.removeAll();
                    for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles(this.currentConnection.getName(), false, true)) {
                        this.fDebugProfileCombo.add(p.getName());
                    }
                    boolean profileButtonEnabled = this.fDebugProfileCombo.getItemCount() > 1;
                    this.fDebugProfileCombo.setEnabled(profileButtonEnabled);
                    this.fDebugProfileLabel.setEnabled(profileButtonEnabled);
                    this.fDebugProfileCombo.select(0);
                    this.fResult[2] = this.fDebugProfileCombo.getText();
                } else {
                    this.fDebugProfileCombo.select(selectedDebugProfileItem);
                }
            }
            this.fResult[0] = this.fConnection.getConnection();
            this.enableOk();
        }

        @Override
        protected void enableOk() {
            this.getButton(0).setEnabled(this.fViewer.getCheckedElements().length > 0 && this.fDebugProfileCombo.getSelectionIndex() > -1);
        }

        @Override
        public void checkStateChanged(CheckStateChangedEvent event) {
            super.checkStateChanged(event);
        }

        @Override
        protected Control createButtonBar(Composite parent) {
            Control result = super.createButtonBar(parent);
            this.fResult[1] = this.fSelectedStep;
            return result;
        }
    }

    static class StepDialog
    extends DebugTitleAreaDialog
    implements ICheckStateListener,
    IConnectionSettingsCompositeListener {
        protected IFile fLocalFile;
        protected IZOSSystemImage currentConnection;
        private String fMember;
        protected CheckboxTableViewer fViewer;
        protected Step[] fSelectedStep = null;
        protected RseConnectionsComposite fConnection;
        protected Object[] fResult = new Object[3];

        public StepDialog(Shell parentShell, String member, IFile localFile, IZOSSystemImage currConnection) {
            super(parentShell);
            this.currentConnection = currConnection;
            this.fLocalFile = localFile;
            this.fMember = member;
            this.setHelpAvailable(true);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.idz.launches.mvsbatch.selectStepDialog");
            if (this.fLocalFile != null) {
                this.getShell().setText(Labels.CONNECTION_SELECTION_DIALOG);
                this.setTitle(Labels.CONNECTION_SELECTION_DIALOG);
                this.setMessage(Labels.CONECTION_DIALOG_INSTRUCTION);
            } else {
                this.getShell().setText(Labels.STEP_SELECTION);
                this.setTitle(Labels.STEP_SELECTION);
                this.setMessage(Labels.STEP_DIALOG_INSTRUCTION);
            }
            parent = (Composite)super.createDialogArea(parent);
            Composite main = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(main);
            if (this.fLocalFile != null) {
                Composite connectionMain = new Composite(main, 0);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)connectionMain);
                GridLayoutFactory.swtDefaults().numColumns(2).applyTo(connectionMain);
                this.fConnection = new RseConnectionsComposite(this, connectionMain, 0, false, false);
                this.fConnection.setConnection(this.currentConnection.getName(), true);
            }
            Group group = new Group(main, 0);
            group.setText(Labels.STEP_GROUP);
            GridLayoutFactory.swtDefaults().applyTo((Composite)group);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
            this.fViewer = JCLUtils.createStepTable((Composite)group);
            this.fViewer.addCheckStateListener((ICheckStateListener)this);
            this.fSelectedStep = Step.getCheckedSteps(this.fViewer);
            return main;
        }

        protected void enableOk() {
            this.getButton(0).setEnabled(this.fViewer.getCheckedElements().length > 0);
        }

        protected Control createButtonBar(Composite parent) {
            Control result = super.createButtonBar(parent);
            JCLUtils.loadSteps(this.fViewer, this.currentConnection, this.fMember, null, this.fLocalFile);
            this.enableOk();
            this.fSelectedStep = Step.getCheckedSteps(this.fViewer);
            this.fResult[0] = this.currentConnection;
            this.fResult[1] = this.fSelectedStep;
            return result;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.enableOk();
            this.fResult[1] = this.fSelectedStep = Step.getCheckedSteps(this.fViewer);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            this.enableOk();
            this.currentConnection = this.fConnection.getConnection();
            this.fResult[0] = this.currentConnection;
            this.fResult[1] = this.fSelectedStep;
        }

        public void modifyText(ModifyEvent event) {
            this.enableOk();
        }
    }
}

