/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites.dlydbg;

import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.dlydbg.DebugItem;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugEventListener;
import com.ibm.ftt.mvs.client.validation.IMVSNameValidator;
import com.ibm.ftt.resource.utils.validators.PBMVSNameValidator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class DelayDebugEditingSupport
extends EditingSupport {
    private static final String EMPTY = "";
    private int fIndex;
    private TextCellEditor fCellEditor;
    private ICellEditorValidator fValidator = new ICellEditorValidator(){

        public String isValid(Object value) {
            String result = null;
            if (!value.equals(DelayDebugEditingSupport.EMPTY) && DelayDebugEditingSupport.this.fProvider != null && DelayDebugEditingSupport.this.fIndex == 0 && value instanceof String) {
                if (value.equals("*")) {
                    result = null;
                } else {
                    String connection;
                    String codepage;
                    int rc;
                    if (DelayDebugEditingSupport.this.fAllowFinalWildcards && ((String)value).trim().endsWith("*")) {
                        value = ((String)value).trim();
                        value = ((String)value).substring(0, ((String)value).length() - 1);
                    }
                    if ((rc = IMVSNameValidator.singleton.validateMemberName((String)value, codepage = (connection = DelayDebugEditingSupport.this.fProvider.getConnection() != null ? DelayDebugEditingSupport.this.fProvider.getConnection().getName() : null) != null ? PBMVSNameValidator.getSingleton().getHostCodePage(connection) : "IBM-1047")) != 0) {
                        result = IMVSNameValidator.singleton.getErrorMessage(rc);
                    }
                }
            }
            if (result != null && DelayDebugEditingSupport.this.fListener != null) {
                DelayDebugEditingSupport.this.fListener.delayDebugValuesUpdated();
            }
            return result;
        }
    };
    private IDelayDebugEventListener fListener;
    private IConnectionProvider fProvider;
    private boolean fAllowFinalWildcards;

    public DelayDebugEditingSupport(ColumnViewer viewer, int columnIdx, IDelayDebugEventListener listener, IConnectionProvider provider, boolean allowFinalWildcards) {
        super(viewer);
        this.fIndex = columnIdx;
        this.fListener = listener;
        this.fProvider = provider;
        this.fAllowFinalWildcards = allowFinalWildcards;
    }

    protected void setValue(Object element, Object value) {
        Object input = this.getViewer().getInput();
        if (input instanceof List) {
            List debugItems = (List)input;
            if (value instanceof String) {
                String newValue = (String)value;
                if (element instanceof DebugItem) {
                    DebugItem lastItem;
                    boolean defaultAddItem;
                    DebugItem item = (DebugItem)element;
                    boolean update = false;
                    if (this.fIndex == 0) {
                        nvalue = newValue.trim().isEmpty() ? "*" : newValue;
                        update = !item.fLM.equals(nvalue);
                        item.fLM = nvalue;
                    } else if (this.fIndex == 1) {
                        nvalue = newValue.trim().isEmpty() ? "*" : newValue;
                        update = !item.fLM.equals(nvalue);
                        item.fProg = nvalue;
                        if (update && item.fLM.equals(Labels.ADD_NEW_ITEM)) {
                            item.fLM = "*";
                        }
                    }
                    if (item.fLM.trim().isEmpty() && item.fProg.trim().isEmpty()) {
                        debugItems.remove(element);
                        this.getViewer().refresh();
                    } else if (update) {
                        this.getViewer().refresh((Object)item);
                    }
                    if (debugItems.size() < 8 && !(defaultAddItem = DebugItem.isDefaultAddItem(lastItem = (DebugItem)debugItems.get(debugItems.size() - 1)))) {
                        debugItems.add(new DebugItem());
                        this.getViewer().refresh();
                    }
                    if (this.fListener != null) {
                        this.fListener.delayDebugValuesUpdated();
                    }
                }
            }
        }
    }

    protected Object getValue(Object element) {
        if (element instanceof DebugItem && !DebugItem.isDefaultAddItem((DebugItem)element)) {
            String value = EMPTY;
            if (this.fIndex == 0) {
                value = ((DebugItem)element).fLM;
            } else if (this.fIndex == 1) {
                value = ((DebugItem)element).fProg;
            }
            return value.trim().isEmpty() ? "*" : value;
        }
        return EMPTY;
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.fCellEditor == null) {
            this.fCellEditor = new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable()){

                protected Control createControl(Composite parent) {
                    Control text = super.createControl(parent);
                    if (text instanceof Text && DelayDebugEditingSupport.this.fIndex == 0) {
                        ((Text)text).setTextLimit(8);
                    }
                    return text;
                }
            };
            this.fCellEditor.setValidator(this.fValidator);
        }
        return this.fCellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    public String getErrorMessage() {
        return this.fCellEditor != null ? this.fCellEditor.getErrorMessage() : null;
    }
}

