/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites.dlydbg;

import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.dlydbg.DebugItem;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugContentProvider;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugEditingSupport;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugLabelProvider;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugEventListener;
import com.ibm.ftt.debug.ui.composites.dlydbg.IDelayDebugProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DelayDebugComposite
extends AbstractDebugComposite
implements ApplicationLaunchConstants,
IDelayDebugEventListener,
IDelayDebugProvider {
    private static final String COMMA = ",";
    public static final String VIEWER_DATA = "VIEWER_DATA";
    public static final List<DebugProfile.LoadModulePair> GENERIC = Arrays.asList(new DebugProfile.LoadModulePair("*", "*"));
    public static final int MAX_ITEMS = 8;
    static final int MODULE_COLUMN_IDX = 0;
    static final int PROGRAM_COLUMN_IDX = 1;
    private List<DebugItem> fDebugItems = new ArrayList<DebugItem>(8);
    private Button fDelayDebug;
    private DelayDebugEditingSupport fModuleEditingSupport;
    private DelayDebugEditingSupport fProgramEditorSupport;
    private String fError = null;
    private Set<IDelayDebugEventListener> fListeners = new HashSet<IDelayDebugEventListener>();
    private TableViewer fViewer;
    private boolean fAllowEmpty = false;

    public DelayDebugComposite(Composite parent, int style, IDelayDebugEventListener listener, IConnectionProvider cProvider, boolean showDelayDebugButton, boolean isCICS) {
        super(parent, style);
        String programColumnLabel;
        String moduleColumnLabel;
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this);
        if (listener != null) {
            this.fListeners.add(listener);
        }
        Composite tableComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tableComposite);
        this.fViewer = new TableViewer(tableComposite, 67584);
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.getTable().setLinesVisible(true);
        this.initMenuManager();
        if (isCICS) {
            moduleColumnLabel = Labels.LOAD_MODULE;
            programColumnLabel = Labels.COMPILE_UNIT;
        } else {
            moduleColumnLabel = Labels.LOAD_MODULE_OR_DLL;
            programColumnLabel = Labels.PROGRAM_FUNCTION;
        }
        TableViewerColumn moduleColumn = new TableViewerColumn(this.fViewer, 0);
        moduleColumn.getColumn().setText(moduleColumnLabel);
        moduleColumn.setLabelProvider((CellLabelProvider)new DelayDebugLabelProvider(0));
        this.fModuleEditingSupport = new DelayDebugEditingSupport((ColumnViewer)this.fViewer, 0, this, cProvider, true);
        moduleColumn.setEditingSupport((EditingSupport)this.fModuleEditingSupport);
        TableViewerColumn programColumn = new TableViewerColumn(this.fViewer, 0);
        programColumn.getColumn().setText(programColumnLabel);
        programColumn.setLabelProvider((CellLabelProvider)new DelayDebugLabelProvider(1));
        this.fProgramEditorSupport = new DelayDebugEditingSupport((ColumnViewer)this.fViewer, 1, this, cProvider, false);
        programColumn.setEditingSupport((EditingSupport)this.fProgramEditorSupport);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)moduleColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(49, false));
        layout.setColumnData((Widget)programColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(49, false));
        tableComposite.setLayout((Layout)layout);
        this.fViewer.setItemCount(7);
        Point size = this.fViewer.getTable().computeSize(-1, -1);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, size.y + 4).hint(size.x - 2, size.y + 4).applyTo((Control)tableComposite);
        this.fViewer.setItemCount(0);
        if (showDelayDebugButton) {
            this.fDelayDebug = new Button((Composite)this, 32);
            this.fDelayDebug.setText(Labels.DELAY_DEBUG);
            this.fDelayDebug.addSelectionListener((SelectionListener)this);
            for (IDelayDebugEventListener l : this.fListeners) {
                this.fDelayDebug.addSelectionListener((SelectionListener)l);
            }
        }
        this.makeTableAccessible();
        this.fDebugItems.add(new DebugItem());
        this.fViewer.setContentProvider((IContentProvider)new DelayDebugContentProvider());
        this.fViewer.setInput(this.fDebugItems);
    }

    public DelayDebugComposite(Composite parent, int style, IDelayDebugEventListener listener, IConnectionProvider cProvider, boolean showDelayDebugButton, boolean isCICS, int itemCount) {
        super(parent, style);
        String programColumnLabel;
        String moduleColumnLabel;
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this);
        if (listener != null) {
            this.fListeners.add(listener);
        }
        Composite tableComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tableComposite);
        this.fViewer = new TableViewer(tableComposite, 67584);
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.getTable().setLinesVisible(true);
        this.initMenuManager();
        if (isCICS) {
            moduleColumnLabel = Labels.LOAD_MODULE;
            programColumnLabel = Labels.COMPILE_UNIT;
        } else {
            moduleColumnLabel = Labels.LOAD_MODULE_OR_DLL;
            programColumnLabel = Labels.PROGRAM_FUNCTION;
        }
        TableViewerColumn moduleColumn = new TableViewerColumn(this.fViewer, 0);
        moduleColumn.getColumn().setText(moduleColumnLabel);
        moduleColumn.setLabelProvider((CellLabelProvider)new DelayDebugLabelProvider(0));
        this.fModuleEditingSupport = new DelayDebugEditingSupport((ColumnViewer)this.fViewer, 0, this, cProvider, true);
        moduleColumn.setEditingSupport((EditingSupport)this.fModuleEditingSupport);
        TableViewerColumn programColumn = new TableViewerColumn(this.fViewer, 0);
        programColumn.getColumn().setText(programColumnLabel);
        programColumn.setLabelProvider((CellLabelProvider)new DelayDebugLabelProvider(1));
        this.fProgramEditorSupport = new DelayDebugEditingSupport((ColumnViewer)this.fViewer, 1, this, cProvider, false);
        programColumn.setEditingSupport((EditingSupport)this.fProgramEditorSupport);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)moduleColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(49, false));
        layout.setColumnData((Widget)programColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(49, false));
        tableComposite.setLayout((Layout)layout);
        this.fViewer.setItemCount(itemCount);
        Point size = this.fViewer.getTable().computeSize(-1, -1);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, size.y + 4).hint(size.x - 2, size.y + 4).applyTo((Control)tableComposite);
        this.fViewer.setItemCount(0);
        if (showDelayDebugButton) {
            this.fDelayDebug = new Button((Composite)this, 32);
            this.fDelayDebug.setText(Labels.DELAY_DEBUG);
            this.fDelayDebug.addSelectionListener((SelectionListener)this);
            for (IDelayDebugEventListener l : this.fListeners) {
                this.fDelayDebug.addSelectionListener((SelectionListener)l);
            }
        }
        this.fDebugItems.add(new DebugItem());
        this.fViewer.setContentProvider((IContentProvider)new DelayDebugContentProvider());
        this.fViewer.setInput(this.fDebugItems);
        this.makeTableAccessible();
        this.fViewer.getTable().setData(VIEWER_DATA, (Object)this.fViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
    }

    private void initMenuManager() {
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new Action(Labels.REMOVE){

                    public ImageDescriptor getImageDescriptor() {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/remove_16.png");
                    }

                    public boolean isEnabled() {
                        ISelection selection = (this).DelayDebugComposite.this.fViewer.getSelection();
                        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                            Object item = ((IStructuredSelection)selection).getFirstElement();
                            return item instanceof DebugItem && !DebugItem.isDefaultAddItem((DebugItem)item);
                        }
                        return !selection.isEmpty();
                    }

                    public void run() {
                        Object item;
                        ISelection selection = (this).DelayDebugComposite.this.fViewer.getSelection();
                        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (item = ((IStructuredSelection)selection).getFirstElement()) instanceof DebugItem && !DebugItem.isDefaultAddItem((DebugItem)item)) {
                            (this).DelayDebugComposite.this.fDebugItems.remove(item);
                            if ((this).DelayDebugComposite.this.fDebugItems.size() == 7) {
                                (this).DelayDebugComposite.this.fDebugItems.add(new DebugItem());
                            }
                            (this).DelayDebugComposite.this.fViewer.refresh();
                            for (IDelayDebugEventListener l : (this).DelayDebugComposite.this.fListeners) {
                                l.delayDebugValuesUpdated();
                            }
                        }
                    }
                });
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.fViewer.getControl().setMenu(menuManager.createContextMenu(this.fViewer.getControl()));
    }

    private void makeTableAccessible() {
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    DelayDebugComposite.this.fViewer.getTable().showColumn(DelayDebugComposite.this.fViewer.getTable().getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.fViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fViewer), naviStrat);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 32 && event.stateMask == 262144) || event.eventType == 4;
            }
        };
        actSupport.setEnableEditorActivationWithKeyboard(true);
        int feature = 58;
        TableViewerEditor.create((TableViewer)this.fViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
    }

    public DelayDebugComposite(Composite parent, int style, IDelayDebugEventListener listener, IConnectionProvider cProvider) {
        this(parent, style, listener, cProvider, true, false);
    }

    public String getErrorMessage() {
        if (this.fModuleEditingSupport.getErrorMessage() != null) {
            return this.fModuleEditingSupport.getErrorMessage();
        }
        if (this.fProgramEditorSupport.getErrorMessage() != null) {
            return this.fProgramEditorSupport.getErrorMessage();
        }
        if (this.fError != null) {
            String error = this.fError;
            this.fError = null;
            return error;
        }
        return this.fDebugItems.size() == 1 && !this.fAllowEmpty ? DebugMessages.CRRDG8007 : null;
    }

    public void initOldStyle(ILaunchConfiguration configuration) throws CoreException {
        this.fDebugItems.clear();
        this.fDebugItems.add(new DebugItem());
        String loadModule = configuration.getAttribute("com.ibm.ftt.debug.loadmoduleprogramname", "");
        if (!loadModule.isEmpty()) {
            StringTokenizer st = new StringTokenizer(loadModule, COMMA);
            int idx = 0;
            while (st.hasMoreTokens()) {
                this.fDebugItems.add(idx++, new DebugItem("", st.nextToken()));
                if (idx != 8 || !st.hasMoreTokens()) continue;
                this.fDebugItems.remove(idx - 1);
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                    sb.append(COMMA);
                }
                sb.deleteCharAt(sb.length() - 1);
                this.fError = NLS.bind((String)DebugMessages.CRRDG8006, (Object)sb.toString());
                break;
            }
        }
        if (this.fDelayDebug != null) {
            this.fDelayDebug.setEnabled(false);
        }
        this.fViewer.refresh();
        for (IDelayDebugEventListener l : this.fListeners) {
            l.delayDebugValuesUpdated();
        }
    }

    public void init(ILaunchConfiguration configuration) throws CoreException {
        this.fDebugItems.clear();
        this.fDebugItems.add(new DebugItem());
        int listIdx = 0;
        int i = 0;
        while (i < 8) {
            String value;
            String key = "com.ibm.ftt.debug.lm_pgm_" + i;
            if (configuration.hasAttribute(key) && !(value = configuration.getAttribute(key, "")).isEmpty()) {
                int idx = value.indexOf(COMMA);
                if (idx > -1) {
                    this.fDebugItems.add(listIdx++, new DebugItem(value.substring(0, idx), value.substring(idx + 1)));
                } else {
                    this.fDebugItems.add(listIdx++, new DebugItem(value, ""));
                }
            }
            ++i;
        }
        if (this.fDelayDebug != null) {
            this.fDelayDebug.setSelection(configuration.getAttribute("com.ibm.ftt.debug.delayDebug", false));
        }
        this.fViewer.refresh();
        for (IDelayDebugEventListener l : this.fListeners) {
            l.delayDebugValuesUpdated();
        }
    }

    public void init(List<DebugProfile.LoadModulePair> loadModulePairs) {
        this.fDebugItems.clear();
        if (loadModulePairs != null) {
            int i = 0;
            while (i < loadModulePairs.size() && i < 8) {
                DebugProfile.LoadModulePair pair = loadModulePairs.get(i);
                this.fDebugItems.add(new DebugItem(pair.getLoadModule(), pair.getCompilationUnit()));
                ++i;
            }
        }
        this.fDebugItems.add(new DebugItem());
        this.fViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDelayDebug != null) {
            configuration.setAttribute("com.ibm.ftt.debug.delayDebug", this.fDelayDebug.getSelection());
        }
        int i = 0;
        while (i < 8) {
            DebugItem item;
            if (i < this.fDebugItems.size() && !DebugItem.isDefaultAddItem(item = this.fDebugItems.get(i)) && !item.toString().isEmpty()) {
                configuration.setAttribute("com.ibm.ftt.debug.lm_pgm_" + i, item.toString());
            } else {
                configuration.setAttribute("com.ibm.ftt.debug.lm_pgm_" + i, "");
            }
            ++i;
        }
    }

    public static void setConfigurationContents(ILaunchConfiguration configuration, Vector<String> configurationContents) throws CoreException {
        int i = 0;
        while (i < 8) {
            Object item;
            String key = "com.ibm.ftt.debug.lm_pgm_" + i;
            if (configuration.hasAttribute(key) && !((String)(item = configuration.getAttribute(key, ""))).isEmpty() && !((String)item).equals(COMMA)) {
                if (((String)item).startsWith(COMMA)) {
                    item = "*" + (String)item;
                }
                if (((String)item).endsWith(COMMA)) {
                    item = (String)item + "*";
                }
                configurationContents.add("<NM2>" + (String)item);
            }
            ++i;
        }
    }

    @Override
    public boolean isDelayDebugSelected() {
        return this.fDelayDebug != null ? this.fDelayDebug.getSelection() : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasLoadModules(ILaunchConfiguration configuration) {
        try {
            int i = 0;
            while (true) {
                String value;
                if (i >= 8) {
                    return false;
                }
                String key = "com.ibm.ftt.debug.lm_pgm_" + i;
                if (configuration.hasAttribute(key) && !(value = configuration.getAttribute(key, "")).trim().isEmpty()) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return false;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        for (IDelayDebugEventListener l : this.fListeners) {
            l.delayDebugValuesUpdated();
        }
    }

    public void widgetSelected(SelectionEvent arg0) {
        for (IDelayDebugEventListener l : this.fListeners) {
            l.delayDebugValuesUpdated();
        }
    }

    @Override
    public void delayDebugValuesUpdated() {
        for (IDelayDebugEventListener l : this.fListeners) {
            l.delayDebugValuesUpdated();
        }
    }

    @Override
    public void addDelayDebugListener(IDelayDebugEventListener listener) {
        this.fListeners.add(listener);
        if (this.fDelayDebug != null) {
            this.fDelayDebug.addSelectionListener((SelectionListener)listener);
        }
    }

    public void setAllowEmpty(boolean value) {
        this.fAllowEmpty = value;
    }

    public List<DebugItem> getDebugItems() {
        return this.fDebugItems;
    }

    public Control getTableControl() {
        return this.fViewer == null ? this : this.fViewer.getTable();
    }
}

