/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.composites;

import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.ConnectionSettingsComposite;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IDebugOptionsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IFieldUpdateNotifier;
import com.ibm.ftt.debug.ui.composites.IProfileProvider;
import com.ibm.ftt.debug.ui.tabs.HostFilter;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DebugOptionsComposite
extends AbstractDebugComposite
implements ApplicationLaunchConstants,
IDebugOptionsCompositeListener,
IConnectionSettingsCompositeListener {
    private static final String BLANK = " ";
    private static final String EMPTY = "";
    private IDebugOptionsCompositeListener fListener;
    private boolean fIsIntegratedDebugger;
    private String fErrorText;
    private Control fErrorControl;
    private Control fErrorResetControl;
    private Button fTestButton;
    private Button fNoTestButton;
    private Button fAllButton;
    private Button fErrorButton;
    private Button fNoneButton;
    private Button fPromptButton;
    private Button fNoPromptButton;
    private Text fListingDataSetText;
    private Text fCommandsDatasetText;
    private Button fCommandsDataSetBrowseButton;
    private Text fEqaoptsDatasetText;
    private Button fEqaoptsDataSetBrowseButton;
    private Text fDebugLibDatasetText;
    private Button fDebugLibDataSetBrowseButton;
    private Text fPreferenceDatasetText;
    private Button fPreferenceDataSetBrowseButton;
    private String fHostName;
    private ConnectionSettingsComposite fConnectionsSettingComposite;
    private Label fPreferenceDatasetLabel;
    private Label fCommandsDatasetLabel;
    private Label fEqaoptsDatasetTextLabel;
    private IProfileProvider fProfileProvider;
    private IFieldUpdateNotifier fNotifier;

    public DebugOptionsComposite(Composite parent, IDebugOptionsCompositeListener listener) {
        this(parent, listener, true, true, true, true, true, true, false, true);
    }

    public DebugOptionsComposite(Composite parent, IDebugOptionsCompositeListener listener, boolean showCommands, boolean showTestOptions, boolean showPreferences, boolean showEQAOpts, boolean showLeOptions, boolean showDebugOptions) {
        this(parent, listener, showCommands, showTestOptions, showPreferences, showEQAOpts, showLeOptions, showDebugOptions, false, false);
    }

    public DebugOptionsComposite(Composite parent, IDebugOptionsCompositeListener listener, boolean showCommands, boolean showTestOptions, boolean showPreferences, boolean showEQAOpts, boolean showLeOptions, boolean showDebugOptions, boolean showDebugLib, boolean showConnection) {
        super(parent, 0);
        Label label;
        int numColumns = showTestOptions ? 3 : 2;
        GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(true).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.fListener = listener;
        if (showTestOptions) {
            Group group1 = this.createGroup((Composite)this, 1, Messages.DebugOptionsComposite_0);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)group1);
            this.fTestButton = new Button((Composite)group1, 16);
            this.fTestButton.setSelection(true);
            this.fTestButton.addSelectionListener((SelectionListener)this);
            this.fTestButton.setText("TEST");
            this.fNoTestButton = new Button((Composite)group1, 16);
            this.fNoTestButton.addSelectionListener((SelectionListener)this);
            this.fNoTestButton.setText("NOTEST");
        }
        if (showDebugOptions) {
            Group group2 = this.createGroup((Composite)this, 1, Messages.DebugOptionsComposite_1);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)group2);
            this.fAllButton = new Button((Composite)group2, 16);
            this.fAllButton.setSelection(true);
            this.fAllButton.addSelectionListener((SelectionListener)this);
            this.fAllButton.setText("ALL");
            this.fAllButton.setToolTipText(Labels.ALL_TOOLTIP);
            this.fErrorButton = new Button((Composite)group2, 16);
            this.fErrorButton.addSelectionListener((SelectionListener)this);
            this.fErrorButton.setText("ERROR");
            this.fErrorButton.setToolTipText(Labels.ERROR_TOOLTIP);
            this.fNoneButton = new Button((Composite)group2, 16);
            this.fNoneButton.addSelectionListener((SelectionListener)this);
            this.fNoneButton.setText("NONE");
            this.fNoneButton.setToolTipText(Labels.NONE_TOOLTIP);
            Group group3 = this.createGroup((Composite)this, 1, Messages.DebugOptionsComposite_2);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)group3);
            this.fPromptButton = new Button((Composite)group3, 16);
            this.fPromptButton.addSelectionListener((SelectionListener)this);
            this.fPromptButton.setText("PROMPT");
            this.fPromptButton.setSelection(true);
            this.fPromptButton.setToolTipText(Labels.PROMPT_TOOLTIP);
            this.fNoPromptButton = new Button((Composite)group3, 16);
            this.fNoPromptButton.addSelectionListener((SelectionListener)this);
            this.fNoPromptButton.setText("NOPROMPT");
            this.fNoPromptButton.setToolTipText(Labels.NO_PROMPT_TOOLTIP);
        }
        if (showConnection) {
            Group advConnection = new Group((Composite)this, 0);
            advConnection.setText(Labels.ADVANCED_OPTIONS);
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)advConnection);
            GridDataFactory.fillDefaults().span(numColumns, 1).grab(true, false).applyTo((Control)advConnection);
            this.fConnectionsSettingComposite = new ConnectionSettingsComposite((Composite)advConnection, this, false);
            if (this.fProfileProvider != null) {
                this.fConnectionsSettingComposite.setProfileProvider(this.fProfileProvider);
            }
        }
        int numCols = 3;
        Composite comp = null;
        if (showLeOptions) {
            comp = new Composite((Composite)this, 0);
            GridLayoutFactory.fillDefaults().numColumns(numCols).equalWidth(false).applyTo(comp);
            GridDataFactory.fillDefaults().span(numColumns, 1).grab(true, true).applyTo((Control)comp);
            label = new Label(comp, 0);
            label.setText(Messages.DebugOptionsTab_6);
            this.fListingDataSetText = new Text(comp, 2048);
            this.fListingDataSetText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fListingDataSetText);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            this.fListingDataSetText.setLayoutData((Object)data);
        }
        if (showCommands) {
            comp = comp != null ? comp : new Composite((Composite)this, 0);
            this.fCommandsDatasetLabel = new Label(comp, 0);
            this.fCommandsDatasetLabel.setText(Messages.DebugOptionsComposite_4);
            this.fCommandsDatasetText = new Text(comp, 2048);
            this.fCommandsDatasetText.addModifyListener((ModifyListener)this);
            this.fCommandsDatasetText.setToolTipText(Labels.CMD_TOOLTIP);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fCommandsDatasetText);
            this.fCommandsDataSetBrowseButton = new Button(comp, 8);
            this.fCommandsDataSetBrowseButton.addSelectionListener((SelectionListener)this);
            this.fCommandsDataSetBrowseButton.setText(Messages.DebugOptionsComposite_14);
        }
        if (showPreferences) {
            comp = comp != null ? comp : new Composite((Composite)this, 0);
            this.fPreferenceDatasetLabel = new Label(comp, 0);
            this.fPreferenceDatasetLabel.setText(Messages.DebugOptionsComposite_6);
            this.fPreferenceDatasetText = new Text(comp, 2048);
            this.fPreferenceDatasetText.addModifyListener((ModifyListener)this);
            this.fPreferenceDatasetText.setToolTipText(Labels.PREF_TOOLTIP);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fPreferenceDatasetText);
            this.fPreferenceDataSetBrowseButton = new Button(comp, 8);
            this.fPreferenceDataSetBrowseButton.addSelectionListener((SelectionListener)this);
            this.fPreferenceDataSetBrowseButton.setText(Messages.DebugOptionsComposite_5);
        }
        if (showEQAOpts) {
            comp = comp != null ? comp : new Composite((Composite)this, 0);
            this.fEqaoptsDatasetTextLabel = new Label(comp, 0);
            this.fEqaoptsDatasetTextLabel.setText(Messages.DebugOptionsComposite_8);
            this.fEqaoptsDatasetText = new Text(comp, 2048);
            this.fEqaoptsDatasetText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEqaoptsDatasetText);
            this.fEqaoptsDataSetBrowseButton = new Button(comp, 8);
            this.fEqaoptsDataSetBrowseButton.addSelectionListener((SelectionListener)this);
            this.fEqaoptsDataSetBrowseButton.setText(Messages.DebugOptionsComposite_9);
        }
        if (showDebugLib) {
            comp = comp != null ? comp : new Composite((Composite)this, 0);
            label = new Label(comp, 0);
            label.setText(Labels.DEBUG_DATASET);
            this.fDebugLibDatasetText = new Text(comp, 2048);
            this.fDebugLibDatasetText.addModifyListener((ModifyListener)this);
            this.fDebugLibDatasetText.setToolTipText(Labels.DEBUG_DATASET_TOOLTIP);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDebugLibDatasetText);
            this.fDebugLibDataSetBrowseButton = new Button(comp, 8);
            this.fDebugLibDataSetBrowseButton.addSelectionListener((SelectionListener)this);
            this.fDebugLibDataSetBrowseButton.setText(Messages.DebugOptionsComposite_14);
        }
        if (comp != null) {
            GridLayoutFactory.fillDefaults().numColumns(numCols).applyTo(comp);
            GridDataFactory.fillDefaults().grab(true, false).span(numColumns, 1).applyTo((Control)comp);
        }
        this.updateFields();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (event.widget instanceof Control && !this.validateControls((Control)event.widget)) {
            this.validateControls(null);
        }
        if (event.widget != this.fEqaoptsDataSetBrowseButton && this.fListener != null) {
            this.fListener.widgetDefaultSelected(event);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget instanceof Control && !this.validateControls((Control)event.widget)) {
            this.validateControls(null);
        }
        if (event.widget == this.fEqaoptsDataSetBrowseButton || event.widget == this.fCommandsDataSetBrowseButton || event.widget == this.fPreferenceDataSetBrowseButton || event.widget == this.fDebugLibDataSetBrowseButton) {
            Object member;
            IHost host;
            RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(this.getShell(), true, false, true, false, false);
            IHost iHost = host = this.fHostName.equals("*") ? null : DebugOptionsComposite.getHost(this.fHostName);
            if (host != null) {
                d.addViewerFilter((ViewerFilter)new HostFilter(host));
            }
            d.setAllowFolderSelection(event.widget == this.fDebugLibDataSetBrowseButton);
            if (d.open() == 0 && (member = d.getOutputObject()) instanceof MVSFileResource) {
                String dsn = DebugLaunchUIUtils.convertToDatasetName(((MVSFileResource)member).getAbsolutePath());
                if (event.widget == this.fEqaoptsDataSetBrowseButton) {
                    this.fEqaoptsDatasetText.setText(dsn);
                }
                if (event.widget == this.fCommandsDataSetBrowseButton) {
                    this.fCommandsDatasetText.setText(dsn);
                }
                if (event.widget == this.fPreferenceDataSetBrowseButton) {
                    this.fPreferenceDatasetText.setText(dsn);
                }
                if (event.widget == this.fDebugLibDataSetBrowseButton) {
                    this.fDebugLibDatasetText.setText(dsn);
                }
            }
        } else if (this.fListener != null) {
            this.fListener.widgetSelected(event);
        }
        this.updateFields();
    }

    public static IHost getHost(String name) {
        if (name != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = SystemStartHere.getConnections();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost h = iHostArray[n2];
                if (h.getName().equals(name)) {
                    return h;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isIntegratedDebugger() {
        return this.fIsIntegratedDebugger;
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget instanceof Control && this.validateControls((Control)event.widget)) {
            this.validateControls(null);
        }
        if (this.fListener != null) {
            this.fListener.modifyText(event);
        }
    }

    public void setInitialValues(boolean isIntegratedDebugger, String test, String error, String prompt, String langenv, String trace, String commands, String preferences, String eqaopts) {
        this.setInitialValues(isIntegratedDebugger, test, error, prompt, langenv, trace, commands, preferences, eqaopts, null);
    }

    public void setInitialValues(boolean isIntegratedDebugger, String test, String error, String prompt, String langenv, String trace, String commands, String preferences, String eqaopts, String debugLib) {
        this.setInitialValues(isIntegratedDebugger, test, error, prompt, langenv, trace, commands, preferences, eqaopts, debugLib, null);
    }

    public void setInitialValues(boolean isIntegratedDebugger, String test, String error, String prompt, String langenv, String trace, String commands, String preferences, String eqaopts, String debugLib, IFieldUpdateNotifier notifier) {
        this.fNotifier = notifier;
        this.fIsIntegratedDebugger = isIntegratedDebugger;
        if (this.fTestButton != null) {
            boolean isTest = test.equalsIgnoreCase("TEST");
            this.fTestButton.setSelection(isTest);
            this.fNoTestButton.setSelection(!isTest);
        }
        if (error == null) {
            error = "ALL";
        }
        if (this.fAllButton != null) {
            this.fAllButton.setSelection(error.equalsIgnoreCase("ALL"));
        }
        if (this.fErrorButton != null) {
            this.fErrorButton.setSelection(error.equalsIgnoreCase("ERROR"));
        }
        if (this.fNoneButton != null) {
            this.fNoneButton.setSelection(error.equalsIgnoreCase("NONE"));
        }
        if (prompt == null) {
            prompt = "PROMPT";
        }
        if (this.fPromptButton != null) {
            this.fPromptButton.setSelection(prompt.equalsIgnoreCase("PROMPT"));
        }
        if (this.fNoPromptButton != null) {
            this.fNoPromptButton.setSelection(prompt.equalsIgnoreCase("NOPROMPT"));
        }
        if (commands != null && this.fCommandsDatasetText != null) {
            this.fCommandsDatasetText.setText(commands);
            if (notifier != null) {
                notifier.fieldUpdated();
            }
        }
        if (preferences != null && this.fPreferenceDatasetText != null) {
            this.fPreferenceDatasetText.setText(preferences);
            if (notifier != null) {
                notifier.fieldUpdated();
            }
        }
        if (eqaopts != null && this.fEqaoptsDatasetText != null) {
            this.fEqaoptsDatasetText.setText(eqaopts);
            if (notifier != null) {
                notifier.fieldUpdated();
            }
        }
        if (debugLib != null && this.fDebugLibDatasetText != null) {
            this.fDebugLibDatasetText.setText(debugLib);
            if (notifier != null) {
                notifier.fieldUpdated();
            }
        }
        if (langenv != null && this.fListingDataSetText != null) {
            this.fListingDataSetText.setText(langenv.trim());
        }
        this.updateFields();
    }

    public String getTestOption() {
        if (this.fTestButton == null) {
            return null;
        }
        if (this.fTestButton.getSelection()) {
            return "TEST";
        }
        return "NOTEST";
    }

    public String getTestLevel() {
        if (this.fAllButton.getSelection()) {
            return "ALL";
        }
        if (this.fErrorButton.getSelection()) {
            return "ERROR";
        }
        return "NONE";
    }

    public String getPrompt() {
        if (this.fPromptButton.getSelection()) {
            return "PROMPT";
        }
        return "NOPROMPT";
    }

    public String getLanguageEnvironmentString() {
        return this.fListingDataSetText == null ? EMPTY : this.fListingDataSetText.getText();
    }

    public String getCommandsDatasetString() {
        return this.fCommandsDatasetText == null ? EMPTY : this.fCommandsDatasetText.getText();
    }

    public String getPreferenceDatasetString() {
        return this.fPreferenceDatasetText == null ? EMPTY : this.fPreferenceDatasetText.getText();
    }

    public String getDebugLibDatasetString() {
        return this.fDebugLibDatasetText == null ? EMPTY : this.fDebugLibDatasetText.getText();
    }

    public String getEqaoptsDatasetString() {
        return this.fEqaoptsDatasetText == null ? EMPTY : this.fEqaoptsDatasetText.getText();
    }

    public boolean validateControls(Control control) {
        this.clearErrors();
        Object validationMessage = null;
        if (this.fEqaoptsDatasetText != null && (control == null || control == this.fEqaoptsDatasetText)) {
            if (!this.fEqaoptsDatasetText.getText().trim().equals(EMPTY)) {
                validationMessage = DebugLaunchUIUtils.validateDatasetOrMemberName(this.fHostName, this.fEqaoptsDatasetText.getText().trim());
            }
            if (validationMessage != null) {
                validationMessage = Messages.DebugOptionsTab_8 + BLANK + validationMessage;
            }
            this.fErrorText = validationMessage;
            if (validationMessage != null) {
                this.fErrorControl = this.fEqaoptsDatasetText;
                return false;
            }
            if (control != null) {
                this.fErrorResetControl = this.fEqaoptsDatasetText;
            }
        }
        if (this.fCommandsDatasetText != null && (control == null || control == this.fCommandsDatasetText)) {
            if (!this.fCommandsDatasetText.getText().trim().equals(EMPTY)) {
                String VADCP_PREFIX = "VADSCP";
                String dataset = this.fCommandsDatasetText.getText().trim().toUpperCase();
                validationMessage = dataset.startsWith(VADCP_PREFIX) && dataset.substring(VADCP_PREFIX.length()).matches("\\d+") ? null : DebugLaunchUIUtils.validateDatasetOrMemberName(this.fHostName, dataset);
            }
            if (validationMessage != null) {
                validationMessage = Messages.DebugOptionsTab_3 + BLANK + (String)validationMessage;
            }
            this.fErrorText = validationMessage;
            if (validationMessage != null) {
                this.fErrorControl = this.fCommandsDatasetText;
                return false;
            }
            if (control != null) {
                this.fErrorResetControl = this.fCommandsDatasetText;
            }
        }
        if (this.fPreferenceDatasetText != null && (control == null || control == this.fPreferenceDatasetText)) {
            if (!this.fPreferenceDatasetText.getText().trim().equals(EMPTY)) {
                validationMessage = DebugLaunchUIUtils.validateDatasetOrMemberName(this.fHostName, this.fPreferenceDatasetText.getText().trim());
            }
            if (validationMessage != null) {
                validationMessage = Messages.DebugOptionsTab_5 + BLANK + (String)validationMessage;
            }
            this.fErrorText = validationMessage;
            if (validationMessage != null) {
                this.fErrorControl = this.fPreferenceDatasetText;
                return false;
            }
            if (control != null) {
                this.fErrorResetControl = this.fPreferenceDatasetText;
            }
        }
        if (this.fDebugLibDatasetText != null && (control == null || control == this.fDebugLibDatasetText)) {
            if (!this.fDebugLibDatasetText.getText().trim().equals(EMPTY)) {
                validationMessage = DebugLaunchUIUtils.validateDatasetLibName(this.fHostName, this.fDebugLibDatasetText.getText().trim());
            }
            if (validationMessage != null) {
                validationMessage = Labels.DEBUG_DATASET + BLANK + (String)validationMessage;
            }
            this.fErrorText = validationMessage;
            if (validationMessage != null) {
                this.fErrorControl = this.fDebugLibDatasetText;
                return false;
            }
            if (control != null) {
                this.fErrorResetControl = this.fDebugLibDatasetText;
            }
        }
        return true;
    }

    public void notifyEngineChange() {
        this.updateFields();
    }

    private void clearErrors() {
        this.fErrorText = null;
        this.fErrorControl = null;
    }

    private void updateFields() {
        boolean isProfileSpecified;
        boolean isHostSet = this.fHostName != null && this.fHostName.equals("*") || DebugOptionsComposite.getHost(this.fHostName) != null;
        boolean bl = isProfileSpecified = this.fProfileProvider != null && this.fProfileProvider.isUseProfile();
        if (this.fCommandsDatasetText != null) {
            this.fCommandsDataSetBrowseButton.setEnabled(isHostSet && !this.fIsIntegratedDebugger && !isProfileSpecified);
            this.fCommandsDatasetText.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
            this.fCommandsDatasetLabel.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fPreferenceDatasetText != null) {
            this.fPreferenceDataSetBrowseButton.setEnabled(isHostSet && !this.fIsIntegratedDebugger && !isProfileSpecified);
            this.fPreferenceDatasetText.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
            this.fPreferenceDatasetLabel.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fEqaoptsDatasetText != null) {
            this.fEqaoptsDataSetBrowseButton.setEnabled(isHostSet && !this.fIsIntegratedDebugger);
            this.fEqaoptsDatasetText.setEnabled(!this.fIsIntegratedDebugger);
            this.fEqaoptsDatasetTextLabel.setEnabled(!this.fIsIntegratedDebugger);
        }
        if (this.fDebugLibDatasetText != null) {
            this.fDebugLibDataSetBrowseButton.setEnabled(isHostSet);
        }
        if (this.fIsIntegratedDebugger) {
            if (this.fAllButton != null && !this.fAllButton.getSelection()) {
                this.fAllButton.setSelection(true);
            }
            if (this.fErrorButton != null && this.fErrorButton.getSelection()) {
                this.fErrorButton.setSelection(false);
            }
            if (this.fNoneButton != null && this.fNoneButton.getSelection()) {
                this.fNoneButton.setSelection(false);
            }
            if (this.fPromptButton != null && !this.fPromptButton.getSelection()) {
                this.fPromptButton.setSelection(true);
            }
            if (this.fNoPromptButton != null && this.fNoPromptButton.getSelection()) {
                this.fNoPromptButton.setSelection(false);
            }
        }
        if (this.fTestButton != null) {
            this.fTestButton.setEnabled(!isProfileSpecified);
        }
        if (this.fNoTestButton != null) {
            this.fNoTestButton.setEnabled(!isProfileSpecified);
        }
        if (this.fAllButton != null) {
            this.fAllButton.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fErrorButton != null) {
            this.fErrorButton.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fNoneButton != null) {
            this.fNoneButton.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fPromptButton != null) {
            this.fPromptButton.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
        if (this.fNoPromptButton != null) {
            this.fNoPromptButton.setEnabled(!this.fIsIntegratedDebugger && !isProfileSpecified);
        }
    }

    public boolean canSave() {
        return this.validateControls(null);
    }

    public String getErrorText() {
        return this.fErrorText;
    }

    public Control getErrorControl() {
        return this.fErrorControl;
    }

    public Control getErrorResetControl() {
        return this.fErrorResetControl;
    }

    private Group createGroup(Composite parent, int numColumns, String label) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setText(label);
        return composite;
    }

    public void setSystemFilter(String system) {
        this.fHostName = system;
        if (this.fEqaoptsDatasetText != null && this.fNotifier != null) {
            this.validateControls((Control)this.fEqaoptsDatasetText);
            this.fNotifier.fieldUpdated();
        }
        if (this.fCommandsDatasetText != null && this.fNotifier != null) {
            this.validateControls((Control)this.fCommandsDatasetText);
            this.fNotifier.fieldUpdated();
        }
        if (this.fPreferenceDatasetText != null && this.fNotifier != null) {
            this.validateControls((Control)this.fPreferenceDatasetText);
            this.fNotifier.fieldUpdated();
        }
        if (this.fDebugLibDatasetText != null && this.fNotifier != null) {
            this.validateControls((Control)this.fDebugLibDatasetText);
            this.fNotifier.fieldUpdated();
        }
        this.updateFields();
    }

    public ConnectionSettingsComposite getConnectionsComposite() {
        return this.fConnectionsSettingComposite;
    }

    public void setProfileProvider(IProfileProvider provider) {
        this.fProfileProvider = provider;
        this.fProfileProvider.addProfileListener(this);
        if (this.fConnectionsSettingComposite != null) {
            this.fConnectionsSettingComposite.setProfileProvider(provider);
        }
    }
}

