/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicensePolicyDataParser;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.Messages;
import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class PolicyManager {
    private static String licenseLocation = LicUserUtils.getRuntimeLicenseLocation().toOSString();
    private static boolean licenseLocationWritable = PolicyManager.checkLocationWritable(licenseLocation);
    private static LicensePolicyData policyData = PolicyManager.parsePolicyFile(PolicyManager.getLicensePolicyFilePath());
    private static boolean flexEnabled = PolicyManager.checkFlexEnabled();

    public static void reload(String fullPath) {
        File optfpath = new File(fullPath);
        if (optfpath.getParentFile() != null) {
            licenseLocation = optfpath.getParentFile().getAbsolutePath();
        }
        if (optfpath.exists()) {
            policyData = PolicyManager.parsePolicyFile(fullPath);
        }
        flexEnabled = PolicyManager.checkFlexEnabled();
        licenseLocationWritable = PolicyManager.checkLocationWritable(licenseLocation);
    }

    public static String getLicenseLocation() {
        return licenseLocation;
    }

    public static LicensePolicyData getPolicyData() {
        return policyData;
    }

    public static boolean isLicPolicyWritable() {
        return licenseLocationWritable;
    }

    public static boolean isFlexEnabled() {
        return flexEnabled;
    }

    private static boolean checkFlexEnabled() {
        String optfpath = PolicyManager.getLicensePolicyFilePath();
        if (new File(optfpath).exists()) {
            return PolicyManager.getPolicyData().getFlexData().isEnabled() && PolicyManager.getFlexServers().length > 0;
        }
        return false;
    }

    private static boolean checkLocationWritable(String checkLicLocation) {
        File locationFile = new File(checkLicLocation);
        try {
            if (locationFile.canWrite()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logNtrace(1, "License location not writable", e);
        }
        return false;
    }

    public static LicensePolicyData parsePolicyFile(String fullPath) {
        LicensePolicyDataParser parser = new LicensePolicyDataParser();
        parser.parse(fullPath);
        return parser.getLicensePolicyData();
    }

    public static String getLicensePolicyFilePath() {
        return LicUserUtils.getRuntimeLicensePolicyFile().toFile().getAbsolutePath();
    }

    public static LicensePolicyData.ServerData[] getFlexServers() {
        return PolicyManager.getPolicyData().getFlexData().getServers();
    }

    public static LicensePolicyData.ComponentData getComponent(String id, String version) {
        String key = LicensePolicyData.ComponentData.toKeyString(id, version);
        return PolicyManager.getPolicyData().getComponentMapData().getComponent(key);
    }

    public static LicensePolicyData.OfferingData getOffering(String id, Version version) {
        String key = LicensePolicyData.OfferingData.toKeyString(id, version);
        LicensePolicyData.OfferingData od = PolicyManager.getPolicyData().getOfferingMapData().getOffering(key);
        if (od == null) {
            LicensePolicyData.OfferingData[] ods = PolicyManager.getPolicyData().getOfferingMapData().getOfferings();
            int i = 0;
            while (i < ods.length) {
                LicensePolicyData.OfferingData odi = ods[i];
                String idtmp = odi.getId();
                Version vertmp = odi.getVersion();
                if (id.equals(idtmp) && LicUserUtils.getMajorMinorVersion(version).equals((Object)LicUserUtils.getMajorMinorVersion(vertmp))) {
                    return odi;
                }
                ++i;
            }
        }
        return od;
    }

    public static String getLicSource() {
        if (!PolicyManager.isFlexEnabled()) {
            return null;
        }
        String licSource = null;
        LicensePolicyData.ServerData[] flexServers = PolicyManager.getFlexServers();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < flexServers.length) {
            LicensePolicyData.ServerData flexServer = flexServers[i];
            sb.append(PolicyManager.getFlexSvrStr(flexServer));
            sb.append("&");
            ++i;
        }
        if (sb.length() > 1) {
            licSource = sb.substring(0, sb.length() - 1);
        }
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("Flexlm licSource is " + licSource);
        }
        return licSource;
    }

    public static String getFlexSvrStr(LicensePolicyData.ServerData flexServer) {
        String hostname = flexServer.getName();
        String portnum = flexServer.getPort();
        if (portnum == null || portnum.length() < 1) {
            portnum = "27000";
        }
        if (flexServer.isCluster()) {
            String[] svrs = hostname.split(",");
            String[] ports = portnum.split(",");
            if (svrs.length == 3 && ports.length == 3) {
                return ports[0].trim() + "@" + svrs[0].trim() + "," + ports[1].trim() + "@" + svrs[1].trim() + "," + ports[2].trim() + "@" + svrs[2].trim();
            }
            Logger.logNtrace(Logger.ERROR, NLS.bind((String)Messages.invalid_redundant_servers, (Object)hostname));
        }
        return portnum + "@" + hostname;
    }

    public static String getFlexLicensePath(LicensePolicyData.ServerData[] serverDatas) {
        if (serverDatas == null || serverDatas.length <= 0) {
            return "";
        }
        StringBuffer sbr = new StringBuffer();
        sbr.append(PolicyManager.getFlexSvrStr(serverDatas[0]));
        int i = 1;
        while (i < serverDatas.length) {
            sbr.append(File.pathSeparator);
            sbr.append(PolicyManager.getFlexSvrStr(serverDatas[i]));
            ++i;
        }
        return sbr.toString().trim();
    }
}

