/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.Activator;
import com.ibm.cic.licensing.common.util.LicPlatformUtils;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class Logger {
    public static final String PLUGIN_ID = "com.ibm.cic.licensing.common.util";
    public static final String DEBUG_OPTION_TRACE_EXCEPTIONS = "com.ibm.cic.licensing.common.util/trace/exceptions";
    public static final String DEBUG_OPTION_TRACE_METHODS = "com.ibm.cic.licensing.common.util/trace/methods";
    public static boolean DEBUG_EXCEPTIONS;
    public static boolean DEBUG_METHODS;
    public static int ERROR;
    public static int WARNING;
    public static int INFO;
    private static final String DEBUG_REPORT_PATH_VAR = "SDPLIC_LOG";
    private static boolean DEBUG_REPORT;
    private static java.util.logging.Logger jlogger;

    static {
        String debug_rpt_path;
        DEBUG_EXCEPTIONS = false;
        DEBUG_METHODS = false;
        ERROR = 4;
        WARNING = 2;
        INFO = 1;
        DEBUG_REPORT = false;
        String debugOption = Platform.getDebugOption((String)DEBUG_OPTION_TRACE_EXCEPTIONS);
        if ("true".equalsIgnoreCase(debugOption)) {
            DEBUG_EXCEPTIONS = true;
        }
        if ("true".equalsIgnoreCase(debugOption = Platform.getDebugOption((String)DEBUG_OPTION_TRACE_METHODS))) {
            DEBUG_METHODS = true;
        }
        if ((debug_rpt_path = LicPlatformUtils.getEnvironmentVariable(DEBUG_REPORT_PATH_VAR)) != null) {
            try {
                DEBUG_REPORT = true;
                jlogger = java.util.logging.Logger.getLogger("com.ibm.cic.licensing");
                File dp = new File(debug_rpt_path);
                File dpp = dp.getParentFile();
                if (dp.exists()) {
                    dp.delete();
                } else if (dpp != null && !dpp.exists()) {
                    dpp.mkdirs();
                }
                FileHandler fh = new FileHandler(debug_rpt_path);
                jlogger.addHandler(fh);
                jlogger.setLevel(Level.ALL);
            }
            catch (Exception e) {
                DEBUG_REPORT = false;
                e.printStackTrace();
            }
        }
    }

    public static boolean isTracing(boolean flag) {
        return DEBUG_REPORT || Activator.getDefault().isDebugging() && flag;
    }

    public static void error(String message) {
        Logger.log(ERROR, message);
    }

    public static void error(Error error) {
        Exception wrapperEx = new Exception(error.getMessage());
        wrapperEx.setStackTrace(error.getStackTrace());
        Logger.log(ERROR, error.getMessage(), wrapperEx);
    }

    public static void error(Exception ex) {
        Logger.log(ERROR, ex.getMessage(), ex);
    }

    public static void log(String message) {
        Logger.log(INFO, message);
    }

    public static void log(int severity, String message) {
        Logger.log(severity, message, null);
    }

    public static void log(String message, Exception e) {
        Logger.log(ERROR, message, e);
    }

    public static void log(int severity, String message, Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, (Throwable)e));
    }

    public static void trace(String message) {
        Logger.trace(message, null);
    }

    public static void trace(String message, Exception e) {
        if (Activator.getDefault().isDebugging()) {
            SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
            System.out.println("CLTRC " + df.format(new Date()) + " :: " + message);
            if (e != null && Logger.isTracing(DEBUG_EXCEPTIONS)) {
                e.printStackTrace();
            }
        }
        if (DEBUG_REPORT) {
            jlogger.log(Level.ALL, message, e);
        }
    }

    public static void logNtrace(String message) {
        Logger.logNtrace(INFO, message);
    }

    public static void logNtrace(String message, Exception e) {
        Logger.logNtrace(ERROR, message, e);
    }

    public static void logNtrace(int severity, String message) {
        Logger.trace(message);
        Logger.log(severity, message);
    }

    public static void logNtrace(int severity, String message, Exception e) {
        Logger.trace(message, e);
        Logger.log(severity, message, e);
    }
}

