/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LicensePolicyDataParser
extends DefaultHandler {
    private String location;
    LicensePolicyData licensePolicyData = new LicensePolicyData();
    private ElemStack elemStack = new ElemStack();

    public void parse(String loc) {
        try {
            FileInputStream stream = new FileInputStream(loc);
            this.parse(loc, stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Logger.isTracing(Logger.DEBUG_METHODS)) {
                Logger.logNtrace(Messages.license_opt_not_found);
            }
        }
        catch (Exception e) {
            Logger.logNtrace(NLS.bind((String)Messages.parse_error, (Object)loc), e);
        }
    }

    public void parse(URL url) {
        String loc = url.toString();
        try {
            InputStream stream = url.openStream();
            this.parse(loc, stream);
        }
        catch (Exception e) {
            Logger.logNtrace(NLS.bind((String)Messages.parse_error, (Object)loc), e);
        }
    }

    public void parse(String loc, InputStream stream) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            this.location = loc;
            parser.parse(stream, (DefaultHandler)this);
        }
        catch (Exception e) {
            Logger.logNtrace(NLS.bind((String)Messages.parse_error, (Object)loc), e);
        }
    }

    public LicensePolicyData getLicensePolicyData() {
        return this.licensePolicyData;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elemStack.push(new ElemStackEntry(qName));
        if (qName.equals("license")) {
            this.handleLicensePolicyAttributes(attributes);
        } else if (qName.equals("flex")) {
            this.handleFlexAttributes(attributes);
        } else if (qName.equals("server")) {
            this.handleServerAttributes(attributes);
        } else if (qName.equals("offeringorder")) {
            this.handleOfferingMapAttributes(attributes);
        } else if (qName.equals("offering")) {
            if (this.isOfferingMapSubElement()) {
                this.handleOfferingAttributes(attributes);
            } else {
                this.handleComponentSubOfferingAttributes(attributes);
            }
        } else if (qName.equals("componentorder")) {
            this.handleComponentMapAttributes(attributes);
        } else if (qName.equals("component")) {
            this.handleComponentAttributes(attributes);
        } else {
            this.unexpectedElement(qName, attributes);
            throw new SAXException(NLS.bind((String)Messages.unexpected_element, (Object[])new Object[]{this.elemStack.top().toString(), qName, LicensePolicyDataParser.toString(attributes)}));
        }
    }

    private void handleLicensePolicyAttributes(Attributes attributes) {
        if (!this.isRootElement()) {
            this.unexpectedElement("license", attributes);
        }
        this.hasUnexpectedAttributes(attributes, "license", new String[0]);
    }

    private void handleFlexAttributes(Attributes attributes) {
        String enabledStr;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.unexpectedElement("flex", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "flex", new String[]{"enabled", "readonly"})) {
            hasErrors = true;
        }
        if ((enabledStr = attributes.getValue("enabled")) == null) {
            this.checkRequiredAttribute("flex", "enabled", enabledStr);
            hasErrors = true;
        }
        boolean enabled = Boolean.parseBoolean(enabledStr);
        String readonlyStr = attributes.getValue("readonly");
        boolean readonly = false;
        if (readonlyStr != null) {
            readonly = Boolean.parseBoolean(readonlyStr);
        }
        if (!hasErrors) {
            LicensePolicyData.FlexData data = this.licensePolicyData.getFlexData();
            data.setEnabled(enabled);
            data.setReadonly(readonly);
            this.elemStack.top().data = data;
        }
    }

    private void handleServerAttributes(Attributes attributes) {
        String port;
        String name;
        boolean hasErrors = false;
        if (!this.isFlexSubElement()) {
            this.unexpectedElement("server", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "server", new String[]{"name", "port"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.checkRequiredAttribute("server", "name", name);
            hasErrors = true;
        }
        if ((port = attributes.getValue("port")) == null) {
            this.checkRequiredAttribute("server", "port", port);
            hasErrors = true;
        }
        if (!hasErrors) {
            LicensePolicyData.ServerData data = new LicensePolicyData.ServerData(name, port);
            LicensePolicyData.AbstractData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleOfferingMapAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.unexpectedElement("offeringorder", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "offeringorder", new String[]{"readonly"})) {
            hasErrors = true;
        }
        String readonlyStr = attributes.getValue("readonly");
        boolean readonly = false;
        if (readonlyStr != null) {
            readonly = Boolean.parseBoolean(readonlyStr);
        }
        if (!hasErrors) {
            LicensePolicyData.OfferingMapData data = this.licensePolicyData.getOfferingMapData();
            data.setReadonly(readonly);
            this.elemStack.top().data = data;
        }
    }

    private void handleOfferingAttributes(Attributes attributes) {
        String displayableVer;
        String name;
        String version;
        String id;
        boolean hasErrors = false;
        if (!this.isOfferingMapSubElement()) {
            this.unexpectedElement("offering", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "offering", new String[]{"id", "version", "name", "displayVersion"})) {
            hasErrors = true;
        }
        if ((id = attributes.getValue("id")) == null) {
            this.checkRequiredAttribute("offering", "id", id);
            hasErrors = true;
        }
        if ((version = attributes.getValue("version")) == null) {
            this.checkRequiredAttribute("offering", "version", version);
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            name = id;
        }
        if ((displayableVer = attributes.getValue("displayVersion")) == null) {
            displayableVer = version;
        }
        if (!hasErrors) {
            LicensePolicyData.OfferingData data = new LicensePolicyData.OfferingData(id, new Version(version), name, displayableVer);
            LicensePolicyData.AbstractData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
        }
    }

    private void handleComponentMapAttributes(Attributes attributes) {
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.unexpectedElement("componentorder", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "componentorder", new String[]{"readonly"})) {
            hasErrors = true;
        }
        String readonlyStr = attributes.getValue("readonly");
        boolean readonly = false;
        if (readonlyStr != null) {
            readonly = Boolean.parseBoolean(readonlyStr);
        }
        if (!hasErrors) {
            LicensePolicyData.ComponentMapData data = this.licensePolicyData.getComponentMapData();
            data.setReadonly(readonly);
            this.elemStack.top().data = data;
        }
    }

    private void handleComponentAttributes(Attributes attributes) {
        String versionStr;
        String name;
        boolean hasErrors = false;
        if (!this.isComponentMapSubElement()) {
            this.unexpectedElement("component", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "component", new String[]{"id", "version"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("id")) == null) {
            this.checkRequiredAttribute("component", "id", name);
            hasErrors = true;
        }
        if ((versionStr = attributes.getValue("version")) == null) {
            this.checkRequiredAttribute("component", "version", versionStr);
            hasErrors = true;
        }
        Version version = new Version(versionStr);
        if (!hasErrors) {
            LicensePolicyData.ComponentData data = new LicensePolicyData.ComponentData(name, version);
            LicensePolicyData.AbstractData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleComponentSubOfferingAttributes(Attributes attributes) {
        String displayableVer;
        String name;
        String version;
        String id;
        boolean hasErrors = false;
        if (!this.isComponentSubElement()) {
            this.unexpectedElement("offering", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "offering", new String[]{"id", "version", "name", "displayVersion"})) {
            hasErrors = true;
        }
        if ((id = attributes.getValue("id")) == null) {
            this.checkRequiredAttribute("offering", "id", id);
            hasErrors = true;
        }
        if ((version = attributes.getValue("version")) == null) {
            this.checkRequiredAttribute("offering", "version", version);
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            name = id;
        }
        if ((displayableVer = attributes.getValue("displayVersion")) == null) {
            displayableVer = version;
        }
        if (!hasErrors) {
            LicensePolicyData.OfferingData data = new LicensePolicyData.OfferingData(id, new Version(version), name, displayableVer);
            LicensePolicyData.AbstractData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild(data);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.elemStack.pop();
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        String text = new String(chars, start, length);
        if (text.trim().length() != 0) {
            this.unexpectedCharacterData(text);
        }
    }

    @Override
    public void warning(SAXParseException e) {
        this.log(2, e);
    }

    @Override
    public void error(SAXParseException e) {
        this.log(4, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.log(4, e);
        throw e;
    }

    private void log(int severity, SAXParseException e) {
        String message = this.getMessage(e);
        Logger.logNtrace(severity, message, e);
    }

    private String getMessage(SAXParseException e) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.location);
        sb.append(": ");
        String systemId = e.getSystemId();
        if (systemId != null) {
            sb.append(systemId);
            sb.append(':');
        }
        sb.append(e.getLineNumber());
        sb.append(':');
        sb.append(e.getColumnNumber());
        sb.append(": ");
        sb.append(e.getMessage());
        return sb.toString();
    }

    public void error(String msg) {
        Logger.logNtrace(Logger.ERROR, msg);
    }

    public void checkRequiredAttribute(String element, String name, String value) {
        if (value == null) {
            this.error(NLS.bind((String)Messages.missing_required_attribute, (Object)element, (Object)name));
        }
    }

    public void unexpectedAttribute(String element, String attribute, String value) {
        this.error(NLS.bind((String)Messages.unexpected_attribute, (Object[])new Object[]{element, attribute, value}));
    }

    public void invalidAttributeValue(String element, String attribute, String value) {
        this.error(NLS.bind((String)Messages.illegal_value_for_attribute, (Object[])new Object[]{attribute, element, value}));
    }

    public void unexpectedElement(String element, Attributes attributes) {
        this.error(NLS.bind((String)Messages.unexpected_element, (Object[])new Object[]{this.elemStack.top().toString(), element, LicensePolicyDataParser.toString(attributes)}));
    }

    public void unexpectedCharacterData(String cdata) {
        this.error(NLS.bind((String)Messages.unexpected_character_data, (Object)this.elemStack.top().toString(), (Object)cdata.trim()));
    }

    private static String toString(Attributes attributes) {
        StringBuffer result = new StringBuffer();
        LicensePolicyDataParser.toString(result, attributes);
        return result.toString();
    }

    private static void toString(StringBuffer sb, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i).trim();
            sb.append(' ').append(name);
            sb.append('=').append('\"');
            sb.append(value);
            sb.append('\"');
            ++i;
        }
    }

    private boolean hasUnexpectedAttributes(Attributes attributes, String elemName, String[] expectedAttributes) {
        boolean result = false;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            boolean foundit = false;
            int j = 0;
            while (j < expectedAttributes.length) {
                String expectedAttribute = expectedAttributes[j];
                if (name.equals(expectedAttribute)) {
                    foundit = true;
                    break;
                }
                ++j;
            }
            if (!foundit) {
                String value = attributes.getValue(i).trim();
                this.unexpectedAttribute(elemName, name, value);
                result = true;
            }
            ++i;
        }
        return result;
    }

    private boolean isRootElement() {
        return this.elemStack.size() == 1;
    }

    private boolean isTopLevelElement() {
        return this.elemStack.size() == 2;
    }

    private boolean isFlexSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("flex");
    }

    private boolean isOfferingMapSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("offeringorder");
    }

    private boolean isComponentMapSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("componentorder");
    }

    private boolean isComponentSubElement() {
        ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("component");
    }

    private static class ElemStack
    extends Stack {
        private ElemStack() {
        }

        public ElemStackEntry top() {
            return (ElemStackEntry)this.peek();
        }

        public ElemStackEntry top(int topRelativeIndex) {
            int topIndex = this.size() - 1;
            int index = topIndex + topRelativeIndex;
            if (index < 0 || index > topIndex) {
                return null;
            }
            return (ElemStackEntry)this.get(index);
        }
    }

    private static class ElemStackEntry {
        public String name;
        public LicensePolicyData.AbstractData data = null;

        public ElemStackEntry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

