/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.PPLicUserUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Timer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class LicUserUtils {
    private static boolean isRunningHeadless = true;
    private static Timer timer;
    private static boolean uiActive;
    public static final String AGENT_APPDATA_LOCATION_KEY = "cic.appDataLocation";
    public static final String P2_DATA_LOCATION_KEY = "com.ibm.cic.licensing.p2.home.dir";
    protected static final String ALLUSERS = "All Users";
    protected static final String LUM = "LUM";
    protected static final String NODELOCK = "nodelock";
    protected static final String NODELOCK_P2 = "nodelockp2";
    protected static final String POLICY_FILE = "license.opt";
    protected static final String POLICY_FILE_P2 = "licensep2.opt";
    public static final String LICENSE = "license";
    public static final String FLEXLM_TS_FILE_NAME = "flexuse.ts";
    public static final String FLEXLM_TS_FILE_NAME_P2 = "flexusep2.ts";
    public static final String SDPLIC_COOKIE_FILE_NAME = ".sdplic";
    public static final boolean P2_INSTALL;
    private static IPath P2LicLocationPath;

    static {
        uiActive = false;
        P2_INSTALL = LicUserUtils.isP2Install();
        P2LicLocationPath = null;
    }

    private static IPath getAllUserLicenseLocation() {
        return PPLicUserUtils.getPolicy().getAllUserProductLocation().append(LICENSE);
    }

    private static IPath getRuntimeAgentAppDataLicenseLocation() {
        String agentDataLocation = System.getProperty(AGENT_APPDATA_LOCATION_KEY);
        if (agentDataLocation != null && agentDataLocation.length() > 0) {
            if (agentDataLocation.startsWith("file:")) {
                agentDataLocation = agentDataLocation.substring("file:".length());
            }
            return new Path(agentDataLocation).append(LICENSE);
        }
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace(4, "cic.appDataLocation is not defined in config.ini.");
        }
        return LicUserUtils.getRuntimeLicenseLocationFromCookie(LicUserUtils.getCommunicationChannelLocation().append(SDPLIC_COOKIE_FILE_NAME));
    }

    private static IPath getRuntimeLicenseLocationFromCookie(IPath path) {
        Properties prop = LicUserUtils.loadProperties(path.toFile().getAbsolutePath());
        String licdatapath = prop.getProperty(AGENT_APPDATA_LOCATION_KEY);
        if (licdatapath != null) {
            return new Path(licdatapath);
        }
        return LicUserUtils.getAllUserLicenseLocation();
    }

    public static IPath getRuntimeLicenseLocation(String existingP2HomeDir) {
        if (P2_INSTALL) {
            return LicUserUtils.getRuntimeP2LicenseLocation(existingP2HomeDir);
        }
        return LicUserUtils.getRuntimeAgentAppDataLicenseLocation();
    }

    public static IPath getRuntimeLicenseLocation() {
        return LicUserUtils.getRuntimeLicenseLocation(null);
    }

    private static IPath getRuntimeP2LicenseLocation(String existingP2HomeDir) {
        if (P2LicLocationPath != null) {
            Logger.trace("Existing P2 license location=" + P2LicLocationPath.toOSString());
            return P2LicLocationPath;
        }
        IPath p2DataLoc = LicUserUtils.getRuntimeP2DataLocation();
        if (p2DataLoc == null && existingP2HomeDir != null) {
            Logger.trace("P2 data location null. Using in location from in memory config data.");
            p2DataLoc = new Path(existingP2HomeDir);
        }
        File licLocFile = null;
        PPLicUserUtils.PPCommon userUtilPPcommon = PPLicUserUtils.getPolicy();
        if (p2DataLoc != null) {
            licLocFile = p2DataLoc.append(userUtilPPcommon.getIBMDirName()).append("p2").append(LICENSE).toFile();
        } else {
            Logger.trace("Config variable not set. Computing from user app data.");
            licLocFile = userUtilPPcommon.getUserAppDataLocation().append(userUtilPPcommon.getIBMDirName()).append("p2").append(LICENSE).toFile();
        }
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("Computed license location=" + licLocFile.getAbsolutePath());
        }
        if (!licLocFile.isDirectory()) {
            if (p2DataLoc == null) {
                Logger.trace("P2 loc is null. Creating sub dirs in users Loc. Is OK=" + licLocFile.mkdirs());
            } else if (p2DataLoc.toFile().canWrite()) {
                Logger.trace("Sub dirs does not exist. Is creating them OK=" + licLocFile.mkdirs());
            } else {
                Logger.logNtrace(Logger.WARNING, "License location sub dirs does not exist & is readonly.");
            }
        }
        P2LicLocationPath = new Path(licLocFile.getAbsolutePath());
        return P2LicLocationPath;
    }

    private static IPath getRuntimeP2DataLocation() {
        String p2DataLocation = System.getProperty(P2_DATA_LOCATION_KEY);
        Logger.trace("Get p2 lic data home dir from 'com.ibm.cic.licensing.p2.home.dir'=" + p2DataLocation);
        if (p2DataLocation != null && p2DataLocation.length() > 0) {
            File p2DataLocationFile;
            if (p2DataLocation.startsWith("file:")) {
                p2DataLocation = p2DataLocation.substring("file:".length());
            }
            if ((p2DataLocationFile = new File(p2DataLocation)).exists()) {
                Logger.trace("P2 data location exists.");
                return new Path(p2DataLocation);
            }
        }
        return null;
    }

    public static int isP2LicenseLocationValid() {
        return 0;
    }

    public static IPath getRuntimeLumNodeLockFile() {
        return LicUserUtils.getRuntimeLumNodeLockFile(null);
    }

    public static IPath getRuntimeLumNodeLockFile(String existingP2HomeDir) {
        if (P2_INSTALL) {
            return LicUserUtils.getRuntimeLicenseLocation(existingP2HomeDir).append(LUM).append(NODELOCK_P2);
        }
        return LicUserUtils.getRuntimeLicenseLocation().append(LUM).append(NODELOCK);
    }

    public static IPath getRuntimeLicensePolicyFile() {
        if (P2_INSTALL) {
            return LicUserUtils.getRuntimeLicenseLocation().append(POLICY_FILE_P2);
        }
        return LicUserUtils.getRuntimeLicenseLocation().append(POLICY_FILE);
    }

    public static IPath getRuntimeFlexlmTSFile() {
        if (P2_INSTALL) {
            return PPLicUserUtils.getPolicy().getUserLicenseLocation().append(FLEXLM_TS_FILE_NAME_P2);
        }
        return PPLicUserUtils.getPolicy().getUserLicenseLocation().append(FLEXLM_TS_FILE_NAME);
    }

    public static IPath getRuntimeFlexlmTSParentDir() {
        return new Path(LicUserUtils.getRuntimeFlexlmTSFile().toFile().getParent());
    }

    public static String getPluginID(Plugin aPlugin, String defaultStr) {
        String value = defaultStr;
        if (aPlugin != null && aPlugin.getBundle() != null) {
            value = aPlugin.getBundle().getSymbolicName();
        } else if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("getPluginID returned default string " + defaultStr);
        }
        return value;
    }

    public static boolean isP2Install() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.licensing.common.p2.lum.touchpoint.alternative");
        if (bundle != null) {
            Logger.trace("P2 based install. Found com.ibm.cic.licensing.common.p2.lum.touchpoint.alternative bundle.");
            return true;
        }
        Logger.trace("Non-P2 based install. No com.ibm.cic.licensing.common.p2.lum.touchpoint.alternative bundle found.");
        return false;
    }

    public static String getPluginName(Plugin aPlugin, String defaultStr) {
        Object value = defaultStr;
        if (aPlugin != null) {
            Bundle bundle = aPlugin.getBundle();
            if (bundle != null) {
                String bsn = bundle.getSymbolicName();
                value = bundle.getHeaders(Platform.getNL()) != null ? (String)bundle.getHeaders(Platform.getNL()).get("Bundle-Name") + " (" + bsn + ")" : bsn;
            }
        } else if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.trace("getPluginName returned default string " + defaultStr);
        }
        return value;
    }

    public static boolean isUiActive() {
        return uiActive;
    }

    public static void setUiActive(boolean uiActive) {
        LicUserUtils.uiActive = uiActive;
    }

    public static boolean isRunningHeadless() {
        return isRunningHeadless;
    }

    public static void setRunningHeadless(boolean isHeadless) {
        isRunningHeadless = isHeadless;
    }

    public static Timer getTimer() {
        if (timer == null) {
            timer = new Timer(true);
        }
        return timer;
    }

    public static void cancelTimer() {
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace("Cancelling timer..");
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        } else if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace("Timer not initialized..");
        }
    }

    public static Properties loadProperties(String filename) {
        Properties prop;
        block14: {
            prop = new Properties();
            if (new File(filename).exists()) {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(filename);
                        prop.load(stream);
                    }
                    catch (IOException ioe) {
                        if (Logger.isTracing(Logger.DEBUG_EXCEPTIONS)) {
                            Logger.logNtrace(ioe.getMessage(), ioe);
                        }
                        if (stream == null) break block14;
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return prop;
    }

    public static boolean storeProperties(String filename, String key, String value) {
        Properties prop = LicUserUtils.loadProperties(filename);
        prop.setProperty(key, value);
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(filename);
                prop.store(stream, null);
            }
            catch (IOException ioe) {
                if (Logger.isTracing(Logger.DEBUG_EXCEPTIONS)) {
                    Logger.logNtrace(ioe.getMessage(), ioe);
                }
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static IPath getCommunicationChannelLocation() {
        return PPLicUserUtils.getPolicy().getCommChannelDir();
    }

    public static IPath getInstallTimeLumNodeLockFile(IPath agentDataLicensePath) {
        return agentDataLicensePath.append(LUM).append(NODELOCK);
    }

    public static IPath getInstallTimeLicensePolicyFile(IPath agentDataLicensePath) {
        return agentDataLicensePath.append(POLICY_FILE);
    }

    public static Version getMajorMinorMicroVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    public static Version getMajorMinorVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), 0);
    }
}

