/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LPEXUtilities {
    public static void resetLPEXContent(LpexView view, String lpexContent) {
        int lines;
        boolean isReadonly = view.queryOn("readonly");
        if (isReadonly) {
            view.doDefaultCommand("set readonly off");
        }
        if ((lines = view.queryInt("lines")) > 0) {
            view.doDefaultCommand(new LpexDocumentLocation(1, 1), "delete " + lines);
        }
        view.doDefaultCommand(new LpexDocumentLocation(1, 1), "insert");
        view.doDefaultCommand(new LpexDocumentLocation(1, 1), "insertText " + lpexContent);
        view.doDefaultCommand("parse all");
        view.doDefaultCommand("screenShow view");
        if (isReadonly) {
            view.doDefaultCommand("set readonly on");
        }
    }

    public static LpexView createLpexWindowAndView(Composite main, Object parentDialog) {
        return LPEXUtilities.createLpexWindowAndView(main, parentDialog, true, null, 0, 1, 0);
    }

    public static LpexView createLpexWindowAndView(Composite main, Object parentDialog, boolean readonly, LpexDocumentListener lpexListener, int lines, int colSpan) {
        return LPEXUtilities.createLpexWindowAndView(main, parentDialog, readonly, lpexListener, lines, colSpan, 0);
    }

    public static LpexView createLpexWindowAndView(Composite main, final Object parentDialog, boolean readonly, LpexDocumentListener lpexListener, int lines, int colSpan, int indent) {
        main = new Composite(main, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        main.setLayout((Layout)gl);
        final Button prevHidden = new Button(main, 8);
        GridData hidden = new GridData();
        hidden.heightHint = 0;
        prevHidden.setLayoutData((Object)hidden);
        LpexWindow window = new LpexWindow(main, 2048);
        LpexView view = new LpexView(false);
        view.addThemeChangeListener();
        view.doDefaultCommand("set updateProfile.parser jcl");
        view.doDefaultCommand("updateProfile");
        if (view.parser() instanceof LpexCommonParser) {
            ((LpexCommonParser)view.parser()).setProperty("view.errorMessages", "off");
        }
        view.doDefaultCommand("set messageLine off");
        view.doDefaultCommand("set commandLine off");
        if (readonly) {
            view.doDefaultCommand("set readonly on");
        } else {
            view.addLpexDocumentListener(lpexListener);
        }
        view.setWindow(window);
        view.setBlockInstance(view);
        window.setLayoutData((Object)new GridData(1808));
        final Button nextHidden = new Button(main, 8);
        nextHidden.setLayoutData((Object)hidden);
        String actionName = view.query("keyAction.escape");
        view.defineAction(actionName, new LpexAction(){

            public void doAction(LpexView lpexView) {
                if (parentDialog instanceof Dialog) {
                    ((Dialog)parentDialog).close();
                }
            }

            public boolean available(LpexView lpexView) {
                return true;
            }
        });
        actionName = view.query("keyAction.s-tab");
        view.defineAction(actionName, new LpexAction(){

            public void doAction(LpexView lpexView) {
                prevHidden.forceFocus();
                prevHidden.traverse(8);
            }

            public boolean available(LpexView lpexView) {
                return true;
            }
        });
        actionName = view.query("keyAction.c-tab");
        if (actionName == null) {
            actionName = "nextField";
            view.doDefaultCommand("set keyAction.c-tab " + actionName);
        }
        view.defineAction(actionName, new LpexAction(){

            public void doAction(LpexView lpexView) {
                nextHidden.forceFocus();
                nextHidden.traverse(16);
            }

            public boolean available(LpexView lpexView) {
                return true;
            }
        });
        GridData gd = null;
        if (lines > 0) {
            gd = new GridData(4, 128, true, false, colSpan, 1);
            gd.heightHint = window.computeSize((int)-1, (int)-1).y + view.queryInt("rowHeight") * lines;
        } else {
            gd = new GridData(1808);
        }
        if (indent > 0) {
            gd.horizontalIndent = indent;
        }
        main.setLayoutData((Object)gd);
        return view;
    }
}

