/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrator;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class MvsBatchLaunchMigrationDelegate
implements ILaunchConfigurationMigrationDelegate,
IDebugProfileMigrator,
IJCLLaunchConstants,
ApplicationLaunchConstants {
    private static final Object fInstanceLock = new Object();
    private static MvsBatchLaunchMigrationDelegate fInstance = null;
    private static final Object fMigrationLock = new Object();
    private static int fMigratedProfiles = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MvsBatchLaunchMigrationDelegate() {
        Object object = fInstanceLock;
        synchronized (object) {
            if (fInstance == null) {
                fInstance = this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MvsBatchLaunchMigrationDelegate getInstance() {
        Object object = fInstanceLock;
        synchronized (object) {
            if (fInstance == null) {
                fInstance = new MvsBatchLaunchMigrationDelegate();
            }
            return fInstance;
        }
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        return !candidate.getAttribute("MIGRATED_ZPROFILES", false) && !candidate.getAttribute("USE_PROPERTY", false) && DelayDebugComposite.hasLoadModules((ILaunchConfiguration)candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        String profileName = candidate.getName();
        if (profileName.length() > 25) {
            profileName = profileName.substring(0, 25);
        }
        if (DebugProfileNameUtils.isNameInUse((String)profileName)) {
            profileName = DebugProfileNameUtils.generateNewName((String)profileName);
        }
        DebugProfileDTSP profile = new DebugProfileDTSP(profileName);
        profile.setConnectionName(candidate.getAttribute("CONNECTION", ""));
        profile.setLocation(candidate.getAttribute("com.ibm.ftt.debug.eqauoptsfile", "&USERID.DLAYDBG.EQAUOPTS"));
        this.addLoadmodCUPairs(profile, candidate);
        profile.setJobInfo(this.getJobInfo(candidate));
        profile.save();
        ILaunchConfigurationWorkingCopy copy = candidate instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)candidate : candidate.getWorkingCopy();
        copy.setAttribute("USEPROFILE", true);
        copy.setAttribute("PROFILE_NAME", profile.getName());
        copy.setAttribute("MIGRATED_ZPROFILES", true);
        copy.doSave();
        if (profile.isValid()) {
            Object object = fMigrationLock;
            synchronized (object) {
                ++fMigratedProfiles;
            }
            LogUtil.log((int)1, (String)String.format("Debug launch configuration '%s' of type '%s' is successfully migrated to a z/OS Debugger profile(%s).", candidate.getName(), "com.ibm.debug.pdt.launch.configType.mvsBatch", profile.getName()), (String)"com.ibm.debug.pdt.idz.launches.mvsbatch");
        } else {
            LogUtil.log((int)1, (String)String.format("Debug launch configuration '%s' of type '%s' is migrated to a z/OS Debugger profile(%s) with missing information.", candidate.getName(), "com.ibm.debug.pdt.launch.configType.mvsBatch", profile.getName()), (String)"com.ibm.debug.pdt.idz.launches.mvsbatch");
        }
    }

    private DebugProfileDTSP.JobInfo getJobInfo(ILaunchConfiguration candidate) throws CoreException {
        String stepName;
        boolean stepSpecified;
        boolean bl = stepSpecified = candidate.getAttribute("com.ibm.ftt.debug.eqauopts.step", 0) == 1;
        if (stepSpecified && !(stepName = candidate.getAttribute("com.ibm.ftt.debug.eqauopts.step.name", "")).isEmpty()) {
            return new DebugProfileDTSP.JobInfo("", stepName);
        }
        return null;
    }

    private void addLoadmodCUPairs(DebugProfileDTSP profile, ILaunchConfiguration candidate) throws CoreException {
        int i = 0;
        while (i < 8) {
            String value;
            String key = "com.ibm.ftt.debug.lm_pgm_" + i;
            if (candidate.hasAttribute(key) && !(value = candidate.getAttribute(key, "")).isEmpty()) {
                int idx = value.indexOf(",");
                if (idx > -1) {
                    profile.addLoadModulePair(value.substring(0, idx), value.substring(idx + 1));
                } else {
                    profile.addLoadModulePair(value, "");
                }
            }
            ++i;
        }
    }

    public int getNumberOfProfilesToMigrate() {
        if (fMigratedProfiles == 0) {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.ibm.debug.pdt.launch.configType.mvsBatch");
            try {
                ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                int numProfiles = 0;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration candidate = iLaunchConfigurationArray[n2];
                    if (this.isCandidate(candidate)) {
                        ++numProfiles;
                    }
                    ++n2;
                }
                return numProfiles;
            }
            catch (CoreException e) {
                MvsBatchLaunchPlugin.log(e);
            }
        }
        return fMigratedProfiles;
    }

    public void migrateProfiles(IProgressMonitor monitor) {
        if (fMigratedProfiles == 0) {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.ibm.debug.pdt.launch.configType.mvsBatch");
            try {
                ILaunchConfiguration[] configs;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration candidate = iLaunchConfigurationArray[n2];
                    if (this.isCandidate(candidate)) {
                        this.migrate(candidate);
                        monitor.worked(1);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                MvsBatchLaunchPlugin.log(e);
            }
        } else {
            monitor.worked(fMigratedProfiles);
        }
    }

    public int getNumberOfProfilesSuccessfullyMigrated() {
        return fMigratedProfiles;
    }

    public void setImportDirectory(String dir) {
    }

    public int getNumberOfProfilesToImport() {
        return 0;
    }

    public void importProfiles(IProgressMonitor monitor) {
    }

    public int getNumberOfProfilesSuccessfullyImported() {
        return 0;
    }
}

