/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.MVSBatchPreferenceUtils;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IDebugOptionsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IProfileProvider;
import com.ibm.ftt.debug.ui.tabs.DebugOptionsTab;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MVSBatchDebugOptionsTab
extends DebugOptionsTab
implements IConnectionSettingsCompositeListener {
    private static final String EMPTY = "";
    private IConnectionProvider fProvider;
    private IProfileProvider fProfileProvider;

    public MVSBatchDebugOptionsTab(IPropertyGroupProvider maintab) {
        super("ALL", maintab);
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.setControl((Control)parent);
        this.fOptionsComposite = new DebugOptionsComposite(parent, (IDebugOptionsCompositeListener)this, true, true, true, false, true, true, true, true);
        if (this.fProfileProvider != null) {
            this.fOptionsComposite.setProfileProvider(this.fProfileProvider);
            this.fProfileProvider = null;
        }
        this.fConnectionsComposite = this.fOptionsComposite.getConnectionsComposite();
        Link preferencesLink = new Link(parent, 0);
        preferencesLink.setText(Messages.MainTab_8);
        GridDataFactory.fillDefaults().align(131072, 1024).grab(true, true).applyTo((Control)preferencesLink);
        preferencesLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String preferencePageId = "com.ibm.debug.pdt.idz.launches.jclGeneration";
                PreferencesUtil.createPreferenceDialogOn((Shell)MVSBatchDebugOptionsTab.this.getShell(), (String)preferencePageId, (String[])new String[]{preferencePageId}, null).open();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.pdt.idz.launches.mvsbatch.debug_options_tab");
        this.doValidation();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("com.ibm.ftt.debug.debugLib", MVSBatchPreferenceUtils.getDebugLibrary());
        configuration.setAttribute("com.ibm.ftt.debug.testoption", MVSBatchPreferenceUtils.getTestOption());
        configuration.setAttribute("com.ibm.ftt.debug.testlevel", MVSBatchPreferenceUtils.getErrorLevel());
        configuration.setAttribute("com.ibm.ftt.debug.promptlevel", MVSBatchPreferenceUtils.getPromptLevel());
        configuration.setAttribute("com.ibm.ftt.debug.commandsfile", MVSBatchPreferenceUtils.getCommandsDataSet());
        configuration.setAttribute("com.ibm.ftt.debug.preferencefile", MVSBatchPreferenceUtils.getPreferencesDataSet());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String test = configuration.getAttribute("com.ibm.ftt.debug.testoption", MVSBatchPreferenceUtils.getTestOption());
            String error = configuration.getAttribute("com.ibm.ftt.debug.testlevel", MVSBatchPreferenceUtils.getErrorLevel());
            String prompt = configuration.getAttribute("com.ibm.ftt.debug.promptlevel", MVSBatchPreferenceUtils.getPromptLevel());
            String commands = configuration.getAttribute("com.ibm.ftt.debug.commandsfile", MVSBatchPreferenceUtils.getCommandsDataSet());
            String preferences = configuration.getAttribute("com.ibm.ftt.debug.preferencefile", MVSBatchPreferenceUtils.getPreferencesDataSet());
            String langenv = configuration.getAttribute("com.ibm.ftt.debug.langenvoptions", EMPTY);
            String eqaopts = configuration.getAttribute("com.ibm.ftt.debug.eqaoptsfile", EMPTY);
            String debugLib = configuration.getAttribute("com.ibm.ftt.debug.debugLib", MVSBatchPreferenceUtils.getDebugLibrary());
            boolean trace = configuration.getAttribute("com.ibm.ftt.debug.trace", false);
            boolean isIntegratedDebugger = !configuration.getAttribute("com.ibm.ftt.debug.dtCompatibility", true);
            String connectionString = configuration.getAttribute("com.ibm.ftt.debug.connection", EMPTY);
            String systemName = configuration.getAttribute("com.ibm.ftt.debug.remotemvsconnectionname", EMPTY);
            this.fOptionsComposite.setInitialValues(isIntegratedDebugger, test, error, prompt, langenv, trace ? Boolean.toString(trace) : null, commands, preferences, eqaopts, debugLib);
            this.fConnectionsComposite.setInitialValues(isIntegratedDebugger, systemName, connectionString);
        }
        catch (CoreException e) {
            MvsBatchLaunchPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.ibm.ftt.debug.debugLib", this.fOptionsComposite.getDebugLibDatasetString());
        super.performApply(configuration);
    }

    public void setConnectionProvider(IConnectionProvider provider) {
        this.fProvider = provider;
        provider.addConnectionsSettingCompositeListener((IConnectionSettingsCompositeListener)this);
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateConnection();
        super.widgetSelected(event);
    }

    private void updateConnection() {
        IZOSSystemImage system;
        if (this.fProvider != null && (system = this.fProvider.getConnection()) != null) {
            this.fOptionsComposite.setSystemFilter(system.getName());
            this.fConnectionsComposite.setConnection(system.getName(), true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.updateConnection();
        super.widgetDefaultSelected(event);
    }

    public void modifyText(ModifyEvent e) {
        this.updateConnection();
        super.modifyText(e);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void setProfileProvider(IProfileProvider provider) {
        if (this.fOptionsComposite != null) {
            this.fOptionsComposite.setProfileProvider(provider);
        } else {
            this.fProfileProvider = provider;
        }
    }
}

