/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences.MVSBatchPreferenceUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.ui.profile.internal.handlers.AbstractProfileHandler;
import com.ibm.debug.pdt.ui.profile.internal.handlers.DebugProfilePropertyTester;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.util.DebugJCLGenerationUtils;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.debug.ui.util.LaunchDelegateUtils;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.files.RemoteFileException;

public class JCLDelegateUtils
implements IJCLLaunchConstants,
ApplicationLaunchConstants {
    private static final String WILDCARD = "*";
    private static final String REGEX = "\n";
    private static final String STEPLIB_DD_DISP_SHR_DSN = "//STEPLIB   DD DISP=SHR,DSN=";
    private static final String PREFIX3 = "//*";
    private static final String DD_DISP_SHR_DSN = "  DD DISP=SHR,DSN=";
    private static final String PREFIX2 = "//        ";
    private static final String CEEOPTS2 = "CEEOPTS";
    private static final String STEPLIB2 = "STEPLIB";
    private static final String PREFIX = "//";
    private static final String EQADEBUG = "EQADEBUG";
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static String generateExistingAndSubmitJCL(IZOSSystemImage connection, ILaunchConfiguration config, ILaunch launch, String mode, int[] debugKey, IProgressMonitor progress) throws CoreException {
        progress.setTaskName(Labels.GENERATING_JCL);
        StringBuilder jobName = new StringBuilder();
        String filePath = JCLDelegateUtils.generateExistingJCL(connection, config, mode, debugKey, progress, jobName);
        progress.worked(5);
        boolean isCCMode = mode != null && mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode());
        JCLDelegateUtils.writeDebugProfile(config, launch, debugKey, jobName.toString(), isCCMode);
        progress.setTaskName(Labels.SUBMITTING_JCL);
        if (filePath != null) {
            return LaunchDelegateUtils.doSubmit((IOSImage)connection, (String)filePath);
        }
        return null;
    }

    public static void writeDebugProfile(ILaunchConfiguration configuration, ILaunch launch, int[] debugKey, String jobName, boolean isCCMode) throws CoreException {
        String profileName;
        if (configuration.getAttribute("USEPROFILE", false) && !(profileName = configuration.getAttribute("PROFILE_NAME", "")).isEmpty()) {
            for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles()) {
                if (!(p instanceof DebugProfileDTSP) || !p.getName().equals(profileName)) continue;
                try {
                    boolean isCC = isCCMode && DebugProfilePropertyTester.isConnectionSupportsDebugProfileServiceAPI((DebugProfile)p);
                    p.activate(isCC ? 2 : 1);
                    break;
                }
                catch (Exception e) {
                    AbstractProfileHandler.handleException((Exception)e);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", e.getMessage()));
                }
            }
        }
    }

    private static String generateExistingJCL(IZOSSystemImage connection, ILaunchConfiguration config, String mode, int[] debugKey, IProgressMonitor progress, StringBuilder jobname) throws CoreException {
        String newJcl = JCLDelegateUtils.getNewJCL(connection, config, mode, debugKey, progress, jobname);
        Writer writer = null;
        try {
            File tempFile = File.createTempFile(config.getName(), "jcl");
            tempFile.deleteOnExit();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), Charset.defaultCharset());
            writer.write(newJcl);
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", e.getMessage(), (Throwable)e));
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getNewJCL(IZOSSystemImage connection, ILaunchConfiguration config, String mode, int[] debugKey, IProgressMonitor progress, StringBuilder jobName, boolean jobNameOnly) throws CoreException {
        String member = config.getAttribute("JCL", "");
        JCLUtils.Step[] step = JCLUtils.Step.createSteps((String)config.getAttribute("STEP", ""));
        String debugLib = config.getAttribute("com.ibm.ftt.debug.debugLib", MVSBatchPreferenceUtils.getDebugLibrary());
        Map<String, String> debugOptions = JCLDelegateUtils.getDebugOptionsString(connection, config, debugKey, mode);
        String jobCard = config.getAttribute("JOB_CARD", MVSBatchPreferenceUtils.getJobCard());
        return JCLDelegateUtils.getNewJCL(connection, member, step, debugOptions, debugLib, mode, debugKey, progress, jobName, jobCard, jobNameOnly);
    }

    private static String getNewJCL(IZOSSystemImage connection, ILaunchConfiguration config, String mode, int[] debugKey, IProgressMonitor progress, StringBuilder jobName) throws CoreException {
        return JCLDelegateUtils.getNewJCL(connection, config, mode, debugKey, progress, jobName, false);
    }

    public static String getNewJCL(IZOSSystemImage connection, String member, JCLUtils.Step[] steps, Map<String, String> debugOptions, String debugLib, String mode, int[] debugKey, IProgressMonitor progress, StringBuilder jobName, String jobCard) throws CoreException {
        return JCLDelegateUtils.getNewJCL(connection, member, steps, debugOptions, debugLib, mode, debugKey, progress, jobName, jobCard, false);
    }

    public static String getNewJCL(IZOSSystemImage connection, String member, JCLUtils.Step[] desiredSteps, Map<String, String> debugOptions, String debugLib, String mode, int[] debugKey, IProgressMonitor progress, StringBuilder jobName, String jobCard, boolean jobNameOnly) throws CoreException {
        block64: {
            IZOSCatalog root = (IZOSCatalog)connection.getRoot();
            MVSResource mvsResource = null;
            if (root != null) {
                int dsIndex;
                IAdaptable dsm;
                if (member.isEmpty() || !"run".equals(mode) && (desiredSteps == null || desiredSteps.length == 0)) {
                    return null;
                }
                if (debugLib == null) {
                    debugLib = "";
                }
                IAdaptable iAdaptable = dsm = (dsIndex = member.indexOf(40)) == -1 ? root.findMember(member, (IProgressMonitor)new NullProgressMonitor()) : root.findMember(member.substring(0, dsIndex), (IProgressMonitor)new NullProgressMonitor());
                if (dsIndex > -1 && dsm instanceof IZOSPartitionedDataSet) {
                    dsm = ((IZOSPartitionedDataSet)dsm).findMember(member.substring(dsIndex + 1, member.length() - 1), (IProgressMonitor)new NullProgressMonitor());
                }
                if (dsm != null) {
                    if (dsm instanceof ZOSDataSetMember) {
                        mvsResource = ((ZOSDataSetMember)dsm).getMvsResource();
                    } else if (dsm instanceof ZOSSequentialDataSet) {
                        mvsResource = ((ZOSSequentialDataSet)dsm).getMvsResource();
                    } else {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", "Unable to determine resource:" + String.valueOf(dsm), null));
                    }
                }
                IFile file = null;
                LpexView view = null;
                try {
                    String result;
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
                    if (member.startsWith(JCLUtils.getWorkspaceVariable())) {
                        member = member.substring(JCLUtils.getWorkspaceVariable().length());
                        jclPath = new Path(member);
                        file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)jclPath);
                    } else if (member.matches(JCLUtils.getWorkspaceVariableRegex())) {
                        member = member.replaceAll(JCLUtils.getWorkspaceVariableRegex(), "$1");
                        jclPath = new Path(member);
                        file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)jclPath);
                    } else {
                        file = mvsResource.getFile((IProgressMonitor)monitor);
                    }
                    view = new LpexView();
                    view.doDefaultCommand("set name " + file.getLocationURI().getPath());
                    String encoding = "UTF-8";
                    try {
                        encoding = file.getCharset();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    view.doDefaultCommand("load encoding " + encoding);
                    long jclClass = view.classMask("jcl");
                    long backClass = view.classMask("bwdLink");
                    long ddClass = view.classMask("dd");
                    long jobClass = view.classMask("job");
                    long commentClass = view.classMask("comment");
                    long condClass = view.classMask("cond");
                    long instream = view.classMask("instream");
                    long libClass = view.classMask("lib");
                    long invalidClasses = ddClass | backClass | jobClass | commentClass | condClass | libClass;
                    boolean isJobCardFound = false;
                    int stepNum = 1;
                    int stepFound = 0;
                    int stepIdx = 0;
                    boolean cceoptsComplete = false;
                    ArrayList<JCLUtils.Step> allSteps = new ArrayList<JCLUtils.Step>();
                    int i = 1;
                    while (i <= view.elements() + 1) {
                        if (!view.show(i)) {
                            String line;
                            boolean isComment;
                            long elementClass = view.elementClasses(i);
                            if (!isJobCardFound && (elementClass & jobClass) > 0L) {
                                JCLDelegateUtils.updateJobName(view.elementText(i), jobName);
                                if (jobNameOnly) {
                                    return null;
                                }
                            }
                            if ("run".equals(mode) && (isJobCardFound |= (elementClass & jobClass) > 0L)) {
                                String string = view.text();
                                return string;
                            }
                            boolean bl = isComment = (elementClass & commentClass) > 0L;
                            if (!isComment && !isJobCardFound) {
                                if (!((String)jobCard).endsWith(NEW_LINE)) {
                                    jobCard = (String)jobCard + NEW_LINE;
                                }
                                JCLDelegateUtils.updateJobName((String)jobCard, jobName);
                                JCLDelegateUtils.insertText(view, i, true, (String)jobCard);
                                ++i;
                                isJobCardFound = true;
                                if ("run".equals(mode)) {
                                    String string = view.text();
                                    return string;
                                }
                            } else if ((elementClass & jclClass) > 0L && (elementClass & invalidClasses) == 0L && (line = view.elementFullText(i)).trim().length() > 0 && line.startsWith(PREFIX)) {
                                if (line.equals(PREFIX)) break;
                                String[] items = line.split(" ");
                                String currentStepName = items[0].substring(2).trim();
                                JCLUtils.Step currentStep = new JCLUtils.Step(stepNum++, currentStepName, line.substring(currentStepName.length() + 2));
                                allSteps.add(currentStep);
                                if (currentStep.equals((Object)desiredSteps[stepIdx])) {
                                    ++stepFound;
                                    i = JCLDelegateUtils.findEndStatement(view, i);
                                    int endStepElement = i++;
                                    int stepLibElement = -1;
                                    int sourceLookupElement = -1;
                                    int ceeoptsElement = -1;
                                    while (i <= view.elements()) {
                                        boolean first;
                                        long element2Class = view.elementClasses(i);
                                        String lineText = view.elementText(i);
                                        if (lineText.equals(PREFIX)) break;
                                        boolean bl2 = first = lineText.length() > 2 && lineText.startsWith(PREFIX) && !Character.isWhitespace(lineText.charAt(2));
                                        if (first && (element2Class & invalidClasses) == 0L) break;
                                        if (first) {
                                            int idx = lineText.indexOf(32);
                                            String name = lineText.substring(2, idx > -1 ? idx : lineText.length());
                                            if (name.equals(STEPLIB2)) {
                                                stepLibElement = i;
                                                if (!debugLib.isEmpty()) {
                                                    JCLDelegateUtils.insertText(view, stepLibElement, 10, DD_DISP_SHR_DSN + debugLib + "\n//        ");
                                                }
                                                debugOptions.remove(STEPLIB2 + stepIdx);
                                            } else if (name.equals(EQADEBUG) && debugOptions.containsKey(stepIdx + 95 + EQADEBUG)) {
                                                String lookup = debugOptions.get(stepIdx + 95 + EQADEBUG);
                                                int idx2 = lookup.indexOf(10);
                                                lookup = idx2 > -1 ? lookup.substring(idx) : lookup;
                                                sourceLookupElement = i;
                                                JCLDelegateUtils.insertText(view, sourceLookupElement, 10, DD_DISP_SHR_DSN + lookup + "\n//        ");
                                                debugOptions.remove(stepIdx + 95 + EQADEBUG);
                                            } else if (name.equals(CEEOPTS2) && !cceoptsComplete) {
                                                String ceeopts = debugOptions.get(stepIdx + 95 + CEEOPTS2);
                                                ceeoptsElement = i;
                                                if (ceeoptsElement > -1) {
                                                    boolean added = false;
                                                    int idx2 = ceeopts.indexOf(10);
                                                    String string = ceeopts = idx2 > -1 ? ceeopts.substring(idx2 + 1) : ceeopts;
                                                    if (ceeopts.trim().endsWith("/*")) {
                                                        idx2 = ceeopts.lastIndexOf("/*");
                                                        ceeopts = idx2 > -1 ? ceeopts.substring(0, idx2) : ceeopts;
                                                    }
                                                    int j = ceeoptsElement + 1;
                                                    while (j <= view.elements()) {
                                                        long element3Class = view.elementClasses(j);
                                                        if ((element3Class & instream) == 0L) {
                                                            JCLDelegateUtils.insertText(view, j - 1, false, ceeopts);
                                                            added = true;
                                                            break;
                                                        }
                                                        ++j;
                                                    }
                                                    if (!added) {
                                                        JCLDelegateUtils.insertText(view, view.elements(), false, ceeopts.trim());
                                                    }
                                                }
                                                cceoptsComplete = true;
                                                debugOptions.remove(stepIdx + 95 + CEEOPTS2);
                                            }
                                        }
                                        ++i;
                                    }
                                    if (debugOptions.containsKey(stepIdx + 95 + CEEOPTS2) && ceeoptsElement == -1) {
                                        String ceeopts = debugOptions.get(stepIdx + 95 + CEEOPTS2);
                                        if (!ceeopts.isEmpty()) {
                                            JCLDelegateUtils.insertText(view, endStepElement, false, ceeopts.trim());
                                        }
                                        debugOptions.remove(stepIdx + 95 + CEEOPTS2);
                                    }
                                    if (debugOptions.containsKey(stepIdx + 95 + EQADEBUG) && sourceLookupElement == -1) {
                                        String lookup = debugOptions.get(stepIdx + 95 + EQADEBUG);
                                        if (!lookup.isEmpty()) {
                                            JCLDelegateUtils.insertText(view, endStepElement, false, lookup.trim());
                                        }
                                        debugOptions.remove(stepIdx + 95 + EQADEBUG);
                                    }
                                    if (!debugLib.isEmpty() && stepLibElement == -1) {
                                        JCLDelegateUtils.insertText(view, endStepElement, false, STEPLIB_DD_DISP_SHR_DSN + debugLib + REGEX);
                                        debugOptions.remove(stepIdx + 95 + STEPLIB2);
                                    }
                                    for (Map.Entry<String, String> entry : debugOptions.entrySet()) {
                                        if (!entry.getKey().startsWith(" " + stepIdx + "_")) continue;
                                        JCLDelegateUtils.insertText(view, endStepElement, false, entry.getValue());
                                    }
                                    if (++stepIdx == desiredSteps.length) break;
                                }
                            }
                        }
                        ++i;
                    }
                    if (stepFound != desiredSteps.length) {
                        if (allSteps.size() == 1) {
                            String string = JCLDelegateUtils.getNewJCL(connection, member, allSteps.toArray(new JCLUtils.Step[allSteps.size()]), debugOptions, debugLib, mode, debugKey, progress, jobName, (String)jobCard, jobNameOnly);
                            return string;
                        }
                        Object[] selectedConnectionStep = JCLUtils.promptForSteps((String)member, (String)connection.getName(), null);
                        if (selectedConnectionStep != null && selectedConnectionStep[0] != null && selectedConnectionStep[1] != null) {
                            JCLUtils.Step[] promptedStep = (JCLUtils.Step[])selectedConnectionStep[1];
                            connection = (IZOSSystemImage)selectedConnectionStep[0];
                            if (promptedStep != null) {
                                String string = JCLDelegateUtils.getNewJCL(connection, member, promptedStep, debugOptions, debugLib, mode, debugKey, progress, jobName, (String)jobCard, jobNameOnly);
                                return string;
                            }
                        }
                        break block64;
                    }
                    i = 1;
                    while (i < view.elements()) {
                        if (!view.show(i) && view.elementText(i).trim().equals(PREFIX)) {
                            view.doCommand(new LpexDocumentLocation(i + 1, 1), "delete " + (view.elements() - i));
                            break;
                        }
                        ++i;
                    }
                    String string = result = view.text();
                    return string;
                }
                catch (RemoteFileException e) {
                    MvsBatchLaunchPlugin.log(e);
                }
                catch (InterruptedException e) {
                    MvsBatchLaunchPlugin.log(e);
                }
                finally {
                    if (view != null) {
                        view.dispose();
                    }
                }
            }
        }
        return null;
    }

    private static void updateJobName(String jobCard, StringBuilder jobName) {
        if (jobName.length() == 0) {
            String[] lines;
            String[] stringArray = lines = jobCard.split(REGEX);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.startsWith(PREFIX3) && line.startsWith(PREFIX)) {
                    int idx = line.indexOf(32);
                    if (idx > -1) {
                        jobName.append(line.substring(2, idx).trim().toUpperCase(Locale.getDefault()));
                        break;
                    }
                    jobName.append(line.substring(2, line.length()).trim().toUpperCase(Locale.getDefault()));
                    break;
                }
                ++n2;
            }
        }
    }

    private static int findEndStatement(LpexView view, int i) {
        long fwdClass = view.classMask("fwdLink");
        while (i < view.elements() && (view.elementClasses(i) & fwdClass) > 0L) {
            ++i;
        }
        return i;
    }

    private static void insertText(LpexView view, int i, boolean atBeginningOfLine, String text) {
        JCLDelegateUtils.insertText(view, i, atBeginningOfLine ? 1 : view.elementText(i).length() + 1, String.valueOf(atBeginningOfLine ? "" : Character.valueOf('\n')) + text);
    }

    private static void insertText(LpexView view, int i, int position, String text) {
        view.doCommand(new LpexDocumentLocation(i, position), "insertText " + text);
    }

    static Map<String, String> getDebugOptionsString(IZOSSystemImage connection, ILaunchConfiguration config, int[] startupKey, String mode) throws CoreException {
        boolean isUseDTCompat = config.getAttribute("com.ibm.ftt.debug.dtCompatibility", true);
        String override = config.getAttribute("com.ibm.ftt.debug.testoption", "TEST");
        String level = config.getAttribute("com.ibm.ftt.debug.testlevel", "ALL");
        String prompt = config.getAttribute("com.ibm.ftt.debug.promptlevel", "PROMPT");
        String prefFile = config.getAttribute("com.ibm.ftt.debug.preferencefile", "");
        String leOptions = config.getAttribute("com.ibm.ftt.debug.langenvoptions", "");
        boolean isProbeTrace = config.getAttribute("com.ibm.ftt.debug.trace", false);
        String sourceLookup = config.getAttribute("SOURCE_LOOKUP", "");
        String commandsFile = config.getAttribute("com.ibm.ftt.debug.commandsfile", "");
        boolean isUseProfile = config.getAttribute("USEPROFILE", false);
        boolean isAPIProfile = JCLDelegateUtils.isAPIProfile(config);
        String dbgconnection = config.hasAttribute("com.ibm.ftt.debug.userid") || config.hasAttribute("com.ibm.ftt.debug.workstationip") ? config.getAttribute("com.ibm.ftt.debug.connection", null) : null;
        return JCLDelegateUtils.getDebugOptionsString(isUseProfile, connection, isUseDTCompat, level, prompt, commandsFile, dbgconnection, prefFile, override, leOptions, isProbeTrace, sourceLookup, startupKey, mode, isAPIProfile);
    }

    public static boolean isAPIProfile(ILaunchConfiguration configuration) throws CoreException {
        String profileName;
        if (configuration.getAttribute("USEPROFILE", false) && !(profileName = configuration.getAttribute("PROFILE_NAME", "")).isEmpty()) {
            for (DebugProfile p : DebugProfileRoot.getInstance().getDebugProfiles()) {
                if (!(p instanceof DebugProfileDTSP) || !p.getName().equals(profileName)) continue;
                return DebugProfilePropertyTester.isConnectionSupportsDebugProfileServiceAPI((DebugProfile)p);
            }
        }
        return false;
    }

    public static Map<String, String> getDebugOptionsString(boolean isUseProfile, IZOSSystemImage connection, boolean isUseDTCompat, String level, String prompt, String commandsFile, String debugConnection, String prefFile, String override, String leOptions, boolean isProbeTrace, String sourceLookup, int[] startupKey, String mode, boolean isAPIProfile) throws CoreException {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < startupKey.length) {
            CharArrayWriter cWriter;
            block20: {
                boolean isRun = mode != null && mode.equals("run");
                cWriter = new CharArrayWriter();
                BufferedWriter writer = new BufferedWriter(cWriter);
                try {
                    try {
                        String[] pairs;
                        boolean dbmActive = DebugJCLGenerationUtils.isDebugManagerReady((String)connection.getName());
                        HashMap listItemMap = new HashMap();
                        String[] stringArray = pairs = sourceLookup.split(",");
                        int n = pairs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pair = stringArray[n2];
                            String[] pieces = pair.split(":");
                            if (pieces.length == 2) {
                                DebugJCLGenerationUtils.SourceLookupItem sItem = new DebugJCLGenerationUtils.SourceLookupItem(pieces[0], pieces[1]);
                                DebugJCLGenerationUtils.updateItemSet(listItemMap, (DebugJCLGenerationUtils.SourceLookupItem)sItem, (boolean)true);
                            }
                            ++n2;
                        }
                        String testOptions = isUseProfile ? "TEST()" : DebugJCLGenerationUtils.getTestParm((boolean)dbmActive, (IZOSSystemImage)connection, (!isUseDTCompat ? 1 : 0) != 0, (boolean)false, (boolean)false, (boolean)false, (String)commandsFile, (String)level, (String)prompt, (String)debugConnection, (String)prefFile, (String)override);
                        boolean isCCMode = mode != null && mode.equals(CCLaunchUtils.getCCInfoProvider().getCoverageMode());
                        Object ccoptions = "\"EQA_STARTUP_KEY=" + (isCCMode && isUseDTCompat ? "CC," : "") + String.valueOf(startupKey[i] == -1 ? "" : Integer.valueOf(startupKey[i])) + "\"";
                        if (isCCMode && isUseProfile && isAPIProfile) {
                            ccoptions = "";
                        }
                        String sourceLookupDD = DebugJCLGenerationUtils.getJCLString((boolean)true, (boolean)isUseDTCompat, listItemMap);
                        String sourceLookupEnv = DebugJCLGenerationUtils.getJCLString((boolean)false, (boolean)isUseDTCompat, listItemMap);
                        if (isRun) {
                            DebugJCLGenerationUtils.writeAdditionalDebugOptions((String)"NOTEST()", (String)leOptions, null, (String)"", (String)"", (String)"", (BufferedWriter)writer);
                        } else {
                            DebugJCLGenerationUtils.writeAdditionalDebugOptions((String)testOptions, (String)leOptions, (String)(isProbeTrace ? WILDCARD : null), (String)ccoptions, (String)sourceLookupDD, (String)sourceLookupEnv, (BufferedWriter)writer);
                        }
                    }
                    catch (IOException e) {
                        MvsBatchLaunchPlugin.log(e);
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StringTokenizer st = new StringTokenizer(cWriter.toString(), REGEX);
            String key = null;
            StringBuilder lines = new StringBuilder();
            while (st.hasMoreTokens()) {
                int idx;
                String next = st.nextToken();
                if (next.startsWith(PREFIX) && next.length() > 2 && !Character.isWhitespace(next.charAt(2)) && (idx = next.indexOf(32, 2)) > -1) {
                    if (key != null) {
                        result.put(key, lines.toString());
                    }
                    key = i + 95 + next.substring(2, idx);
                    lines = new StringBuilder();
                }
                lines.append(next);
                lines.append('\n');
            }
            result.put(key, lines.toString());
            ++i;
        }
        return result;
    }

    public static Object getFile(String jcl) {
        try {
            jcl = JCLUtils.removeWorkspaceVariable((String)jcl);
            Path jclPath = new Path(jcl);
            IFile jclFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)jclPath);
            if (jclFile != null && jclFile.exists()) {
                return jclFile;
            }
        }
        catch (Exception e) {
            MvsBatchLaunchPlugin.log(e);
        }
        return null;
    }

    public static String getResourceName(ILaunchConfiguration config) throws CoreException {
        String name = "";
        name = config.getAttribute("USE_EXISTING", false) ? config.getAttribute("JCL", "") : (config.getAttribute("USE_PROGRAM", false) ? config.getAttribute("PROGRAM", "") : config.getAttribute("SOURCE", ""));
        return name;
    }

    public static Object getResource(IZOSSystemImage connection, ILaunchConfiguration config) throws CoreException {
        String name = "";
        name = JCLDelegateUtils.getResourceName(config);
        if (!name.isEmpty()) {
            IAbstractResource resource;
            IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
            if (provider != null && (resource = provider.getResource(config, name)) != null) {
                return resource;
            }
            IZOSCatalog root = (IZOSCatalog)connection.getRoot();
            if (root != null) {
                ISubSystem ss;
                Properties props;
                int dsIndex = name.indexOf(40);
                IAdaptable dsm = dsIndex == -1 ? root.findMember(name, (IProgressMonitor)new NullProgressMonitor()) : root.findMember(name.substring(0, dsIndex), (IProgressMonitor)new NullProgressMonitor());
                int hlqIdx = name.indexOf(46);
                if (dsm instanceof IZOSDataSet && (props = ((MVSFileSubSystem)(ss = (ISubSystem)((IZOSDataSet)dsm).getSystem().getSystemImplementation())).getSystemProperties()) != null) {
                    ((ZOSResource)dsm).setDefaultResourceProperties((IZOSResource)((IZOSDataSet)dsm), props, hlqIdx > -1 ? name.substring(0, hlqIdx) : name);
                }
                if (dsIndex > -1 && dsm instanceof IZOSPartitionedDataSet) {
                    dsm = ((IZOSPartitionedDataSet)dsm).findMember(name.substring(dsIndex + 1, name.length() - 1), (IProgressMonitor)new NullProgressMonitor());
                }
                if (dsm instanceof IAbstractResource) {
                    return (IAbstractResource)dsm;
                }
            }
        }
        return null;
    }
}

