/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultInfo;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.ccresults.CCResultExporter;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultsViewUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ResultAdapter
extends AbstractResultAdapter
implements IAdaptable {
    protected final boolean fIsDir;
    protected boolean fIsCCResult;
    private Image fCCResultImage;
    protected Properties fProperties = new Properties();
    private static SequentialRule fRule = new SequentialRule();

    public ResultAdapter(String resultPath) {
        super(resultPath);
        this.fIsCCResult = CCResultExporter.isValidExtension((String)resultPath);
        if (this.fIsCCResult) {
            this.fIsDir = false;
        } else {
            boolean bl = this.fIsDir = !resultPath.toLowerCase().endsWith(".clcoveragedata".toLowerCase());
        }
        if (this.getLocalPath() != null) {
            Job j = new Job("Computing result"){

                protected IStatus run(IProgressMonitor arg0) {
                    ResultAdapter.this.analyze(true);
                    return Status.OK_STATUS;
                }
            };
            j.setRule((ISchedulingRule)fRule);
            j.setSystem(true);
            j.schedule();
        }
        this.fLocalInitTime = System.currentTimeMillis();
    }

    public boolean isCCResult() {
        return this.fIsCCResult;
    }

    @Override
    protected boolean exists() {
        String dataFileName = this.getDataFileName();
        File dataFile = new File(dataFileName);
        return dataFile.exists();
    }

    @Override
    public String getDataFileName() {
        if (this.getLocalPath() != null) {
            if (this.fIsCCResult) {
                return null;
            }
            if (this.fIsDir) {
                return this.getLocalPath() + this.getSeparator() + this.getName() + ".clcoveragedata";
            }
            return this.getLocalPath();
        }
        return null;
    }

    private String getDataFileBaseName() {
        String datafileName = this.getDataFileName();
        if (datafileName != null) {
            return new Path(datafileName).removeFileExtension().lastSegment();
        }
        return null;
    }

    public String getComponentMapFileName() {
        if (this.getLocalPath() != null) {
            if (this.fIsCCResult) {
                return null;
            }
            return this.getLocalPath() + this.getSeparator() + this.getDataFileBaseName() + ".componentMap";
        }
        return null;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public String getName() {
        if (this.isResultAvailable()) {
            if (this.fIsDir) {
                return this.getResult().getName();
            }
            if (this.fIsCCResult) {
                Path path = new Path(this.getResult().getName());
                return path.removeFileExtension().toOSString();
            }
            int idx = this.getResult().getName().lastIndexOf(".");
            return idx > 0 ? this.getResult().getName().substring(0, idx) : this.getResult().getName();
        }
        String resultPath = this.getResultPath();
        if (this.fIsDir) {
            int lastSeparatorIndex = resultPath.lastIndexOf(this.getSeparator());
            return lastSeparatorIndex > 0 ? this.getResultPath().substring(lastSeparatorIndex + 1) : resultPath;
        }
        int idx = resultPath.lastIndexOf(this.getSeparator());
        String result = idx > 0 ? resultPath.substring(idx + 1) : resultPath;
        idx = result.lastIndexOf(".");
        return idx > -1 ? result.substring(0, idx) : result;
    }

    @Override
    protected void doAnalysis(boolean useResultAPI) {
        if (useResultAPI) {
            String localPath = this.getLocalPath();
            this.setResult(localPath);
        }
    }

    @Override
    public String getTestcaseID() {
        if (this.fProperties.containsKey("testcase")) {
            return this.fProperties.getProperty("testcase");
        }
        if (this.isResultAvailable()) {
            StringBuffer sb = new StringBuffer();
            ICCTestcase[] testcases = this.getResult().getTestcases();
            int i = 0;
            while (i < testcases.length) {
                if (this.isTestidSet(testcases[i])) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(testcases[i].getName());
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    private boolean isTestidSet(ICCTestcase test) {
        String[] messages;
        String[] stringArray = messages = test.getMessages();
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (message.startsWith("ACRRDG7202W")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public long getElapsedTime() {
        ICCResultInfo resultInfo;
        if (this.fProperties.containsKey("elapsedTime")) {
            return Long.parseLong(this.fProperties.getProperty("elapsedTime"));
        }
        if (this.isResultAvailable() && (resultInfo = this.getResult().getInfo()) != null) {
            return resultInfo.getElapsedTime();
        }
        return -1L;
    }

    @Override
    public void cleanup(boolean deleteDataFiles) {
        super.cleanup(deleteDataFiles);
        if (deleteDataFiles) {
            this.closeOpenSourceEditors();
            try {
                String resultPath = this.getResultPath(true);
                if (resultPath != null) {
                    File file = new File(resultPath);
                    this.delete(file);
                }
            }
            catch (IOException e) {
                ResultsViewPlugin.log(e);
            }
        }
        this.setResult((ICCResult)null);
    }

    private void closeOpenSourceEditors() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    IEditorReference[] editorRefs;
                    IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
                    int n = editorRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorRef = iEditorReferenceArray[n2];
                        IEditorPart editor = editorRef.getEditor(false);
                        if (editor != null) {
                            File srcFile;
                            URI uri;
                            IEditorInput editorInput = editor.getEditorInput();
                            IPath srcFilePath = null;
                            if (editorInput instanceof FileEditorInput) {
                                srcFilePath = ((FileEditorInput)editorInput).getPath();
                            } else if (editorInput instanceof IURIEditorInput && (uri = ((IURIEditorInput)editorInput).getURI()) != null && (srcFile = new File(uri)).exists()) {
                                srcFilePath = new Path(srcFile.getAbsolutePath());
                            }
                            Path resultPath = new Path(ResultAdapter.this.getResultPath());
                            if (srcFilePath != null && resultPath.isPrefixOf(srcFilePath)) {
                                page.closeEditor(editor, false);
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void delete(File file) throws IOException {
        if (file.isDirectory() && file.exists()) {
            File[] children = file.listFiles();
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child);
                    ++n2;
                }
            }
            if (!file.delete()) {
                ResultsViewPlugin.log("Unable to delete: " + String.valueOf(file));
            }
        } else {
            if (!file.setWritable(true, false)) {
                ResultsViewPlugin.log("Unable to set write attribute: " + String.valueOf(file));
            }
            Files.deleteIfExists(file.toPath());
        }
    }

    @Override
    public String rename(String newResultName) {
        try {
            Files.deleteIfExists(this.getPropFilePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File oldResultDir = new File(this.getResultPath());
        File newResultDir = new File(oldResultDir.getParentFile(), newResultName);
        if (!oldResultDir.exists()) {
            return NLS.bind((String)CCResultViewMessages.CRRDG9311, (Object)this.getName());
        }
        if (newResultDir.exists()) {
            return NLS.bind((String)CCResultViewMessages.CRRDG9310, (Object)newResultDir.getName());
        }
        File dataFile = new File(this.getDataFileName());
        File newDataFile = ResultAdapter.renameFile(dataFile, newResultName, ".clcoveragedata");
        if (newDataFile != null) {
            File baselineFile = new File(this.getBaselineFileName());
            File newBaselineFile = null;
            if (baselineFile != null && (newBaselineFile = ResultAdapter.renameFile(baselineFile, newResultName, ".metadata")) == null) {
                return NLS.bind((String)CCResultViewMessages.CRRDG9312, (Object)baselineFile.getName());
            }
            File componentMapFile = new File(this.getComponentMapFileName());
            File newComponentMapFile = null;
            if (componentMapFile != null && (newComponentMapFile = ResultAdapter.renameFile(componentMapFile, newResultName, ".componentMap")) == null) {
                return NLS.bind((String)CCResultViewMessages.CRRDG9312, (Object)componentMapFile.getName());
            }
            File newFolder = ResultAdapter.renameFile(dataFile.getParentFile(), newResultName, null);
            if (newFolder != null) {
                this.setResultPath(newFolder.getAbsolutePath());
            }
            this.setResult((ICCResult)null);
        }
        return null;
    }

    public static File renameFile(File file, String newBaseName, String extension) {
        if (!ResultAdapter.validateName(newBaseName)) {
            return null;
        }
        if (extension == null) {
            Path dir = new Path(file.getParent());
            if (file.renameTo((dir = dir.append(newBaseName)).toFile())) {
                return dir.toFile();
            }
            return null;
        }
        File parent = file.getParentFile();
        File newFile = new File(parent, newBaseName + extension);
        if (file.renameTo(newFile)) {
            return newFile;
        }
        return null;
    }

    private static boolean validateName(String name) {
        File f = new File(name);
        if (f.getParent() != null) {
            return false;
        }
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            ResultsViewPlugin.log(e);
            return false;
        }
        return f.getName().equals(name);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ResultAdapter.class) {
            return this;
        }
        Object result = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (result == null) {
            result = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return result;
    }

    @Override
    public void closeOpenedReportViewer() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editor = ResultAdapter.this.getOpenEditor();
                if (editor != null) {
                    editor.getSite().getPage().closeEditor(editor, false);
                }
            }
        });
    }

    @Override
    public IEditorPart getOpenEditor() {
        IEditorPart editor = super.getOpenEditor();
        if (editor != null) {
            return editor;
        }
        return null;
    }

    @Override
    public Image getImage() {
        if (this.fCCResultImage == null) {
            this.fCCResultImage = this.fIsCCResult ? ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/targets_dgm16.png") : ResultsViewPlugin.getDefault().getImageRegistry().get("icons/view16/coverage_history.png");
        }
        return this.fCCResultImage;
    }

    @Override
    public String getBaselineFileName() {
        if (this.getLocalPath() != null) {
            if (this.fIsCCResult) {
                return null;
            }
            if (this.fIsDir) {
                return this.getLocalPath() + this.getSeparator() + this.getName() + ".metadata";
            }
            return this.getLocalPath();
        }
        return null;
    }

    @Override
    public void setTestCaseId(String name) {
        super.setTestCaseId(name);
    }

    @Override
    public void setTags(String tags) {
        super.setTags(tags);
    }

    @Override
    public void open(String mode, Shell shell) {
    }

    @Override
    public boolean copyTo(File directory, boolean unpack) {
        String path = this.getResultPath();
        File f = new File(path);
        if (!this.fIsDir) {
            f = f.getParentFile();
        }
        return ResultsViewUtilities.copyFiles(f, directory);
    }

    static class SequentialRule
    implements ISchedulingRule {
        SequentialRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

