/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.AbstractResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class LocalResultLocation
extends AbstractResultLocation {
    private IResultContentProvider[] fSupportProviders = null;

    public LocalResultLocation(String path, String name, boolean isDefault, IResultContentProvider provider) {
        super(path, name, isDefault, provider);
        if (path == null) {
            return;
        }
        File localDir = new File(path);
        if (!isDefault && !localDir.isDirectory()) {
            this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9309, (Object)path));
        }
    }

    @Override
    public boolean exists() {
        String directoryName = this.getPath();
        File dir = new File(directoryName);
        return dir.exists();
    }

    @Override
    protected boolean isFileSupported(File file) {
        String fullName = file.getAbsolutePath();
        IResultContentProvider[] iResultContentProviderArray = this.getProviders();
        int n = iResultContentProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultContentProvider provider = iResultContentProviderArray[n2];
            if (provider.isSupportedFileName(fullName)) {
                Path p = new Path(fullName);
                String extension = p.getFileExtension();
                if (extension != null && extension.equalsIgnoreCase("clcoveragedata")) {
                    IPath componentMapPath = p.removeFileExtension().addFileExtension("componentMap");
                    File componentMapFile = new File(componentMapPath.toOSString());
                    return componentMapFile.exists();
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IResultContentProvider[] getProviders() {
        if (this.fSupportProviders == null) {
            this.fSupportProviders = ResultsViewContentProviders.getContentProviders();
        }
        return this.fSupportProviders;
    }

    @Override
    public void refreshResults() {
        this.refreshResults(2);
    }

    protected void refreshResults(int max_search_depth) {
        if (!this.exists()) {
            this.setErrorMessage(Labels.INVALID_RESULT_LOCATION_TITLE);
            this.removeAllResults();
            return;
        }
        this.setErrorMessage(null);
        String directoryName = this.getPath();
        File dir = new File(directoryName);
        File[] results = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return LocalResultLocation.this.isFileSupported(pathname) || pathname.isDirectory();
            }
        });
        if (results == null) {
            return;
        }
        ArrayList<IResultAdapter> newResults = new ArrayList<IResultAdapter>();
        this.getResults(newResults, results, max_search_depth);
        ArrayList<IResultAdapter> currentResults = new ArrayList<IResultAdapter>();
        currentResults.addAll(this.getResults());
        for (IResultAdapter adapter : newResults) {
            if (this.containsResult(adapter)) {
                currentResults.remove(adapter);
                continue;
            }
            this.addResult(adapter);
        }
        for (IResultAdapter adapter : currentResults) {
            this.removeResult(adapter);
        }
    }

    private void getResults(List<IResultAdapter> newResults, File[] results, int max_depth) {
        if (max_depth <= 0) {
            return;
        }
        if (results != null) {
            File[] fileArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                File result = fileArray[n2];
                if (!this.isHidden(result)) {
                    if (result.isDirectory()) {
                        File[] children = result.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return LocalResultLocation.this.isFileSupported(pathname) || pathname.isDirectory();
                            }
                        });
                        this.getResults(newResults, children, max_depth - 1);
                    } else {
                        String resultPath = result.getAbsolutePath();
                        IResultAdapter existingResult = this.findResult(resultPath);
                        if (existingResult != null) {
                            newResults.add(existingResult);
                        } else if (this.hasResultsToImport(result)) {
                            IResultAdapter adapter = null;
                            IResultContentProvider[] iResultContentProviderArray = ResultsViewContentProviders.getContentProviders();
                            int n3 = iResultContentProviderArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResultContentProvider provider = iResultContentProviderArray[n4];
                                if (provider.isResultHandled(result.getAbsolutePath())) {
                                    adapter = provider.getResultAdapter(result.getAbsolutePath());
                                    if (adapter == null) break;
                                    adapter.setResultLocation(this);
                                    break;
                                }
                                ++n4;
                            }
                            if (adapter != null) {
                                if (adapter.getResultLocation().isDefaultLocation()) {
                                    adapter.analyze(false);
                                }
                                newResults.add(adapter);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public Image getImage() {
        return ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/local_location_obj.png");
    }

    @Override
    public boolean expandLocationOnRestart() {
        return this.isDefaultLocation();
    }

    @Override
    public boolean isSaveRestoreable() {
        return true;
    }

    @Override
    protected void addSaveProperties(IMemento child) {
    }
}

