/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CCResultEventManager {
    private static final CCResultEventManager fInstance = new CCResultEventManager();
    private Set<ICCResultListener> fListeners;
    private ISchedulingRule fRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule arg0) {
            return arg0.equals(CCResultEventManager.this.fRule);
        }

        public boolean contains(ISchedulingRule arg0) {
            return arg0.equals(CCResultEventManager.this.fRule);
        }
    };

    private CCResultEventManager() {
        this.fListeners = Collections.synchronizedSet(new HashSet());
    }

    public static CCResultEventManager getDefault() {
        return fInstance;
    }

    public void addListener(ICCResultListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ICCResultListener listener) {
        this.fListeners.remove(listener);
    }

    public void fireResultEvent(final CCResultEvent event) {
        Job j = new Job("CC event"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Set<ICCResultListener> set = CCResultEventManager.this.fListeners;
                synchronized (set) {
                    for (ICCResultListener listener : CCResultEventManager.this.fListeners) {
                        listener.resultNotification(event);
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(CCResultEventManager.this);
            }
        };
        j.setSystem(true);
        j.setRule(this.fRule);
        j.schedule();
    }

    public void fireResultLocationEvent(final CCResultEvent event) {
        Job j = new Job("CC event"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Set<ICCResultListener> set = CCResultEventManager.this.fListeners;
                synchronized (set) {
                    for (ICCResultListener listener : CCResultEventManager.this.fListeners) {
                        listener.resultLocationNotification(event);
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(CCResultEventManager.this);
            }
        };
        j.setSystem(true);
        j.setRule(this.fRule);
        j.schedule();
    }
}

