/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.resultsview;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultContentProvider;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public abstract class AbstractResultLocation
implements IAdaptable,
IResultLocation {
    protected String fName;
    protected String fPath;
    private List<IResultAdapter> fResultAdapters;
    private String fErrorMessage;
    private boolean fIsDefault = false;
    protected IResultContentProvider fProvider;
    private UUID fID;
    private Path fPropFileDir = null;

    public AbstractResultLocation(String path, String name, boolean isDefault, IResultContentProvider provider) {
        this.fPath = path;
        this.fName = name == null || name.isEmpty() ? path : name;
        this.fResultAdapters = Collections.synchronizedList(new ArrayList());
        this.fIsDefault = isDefault;
        this.fProvider = provider;
        this.fID = UUID.nameUUIDFromBytes(this.getPath().getBytes(Charset.defaultCharset()));
        if (this.getPropFileDir() == null) {
            this.generatePropFileDir();
        }
    }

    private void generatePropFileDir() {
        IPath localResultFolder = ResultsViewPlugin.getDefault().getStateLocation().append("propertiesCache");
        localResultFolder = localResultFolder.append(AbstractResultLocation.normalizeName(this.getName()) + "_" + this.getID().toString());
        boolean directoryCreated = false;
        if (!localResultFolder.toFile().exists()) {
            directoryCreated = localResultFolder.toFile().mkdirs();
        }
        this.setPropFileDir(Paths.get(localResultFolder.toOSString(), new String[0]));
        if (this.getPropFileDir() == null && !directoryCreated) {
            ResultsViewPlugin.log("Creation of properties file cache for this location was unsuccessful.");
        }
    }

    @Override
    public Path getPropFileDir() {
        if (this.fPropFileDir == null) {
            this.generatePropFileDir();
        }
        return this.fPropFileDir;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public UUID getID() {
        return this.fID;
    }

    @Override
    public boolean isDefaultLocation() {
        return this.fIsDefault;
    }

    @Override
    public final boolean addResult(IResultAdapter resultAdapter) {
        resultAdapter.setResultLocation(this);
        if (this.fResultAdapters.contains(resultAdapter)) {
            return false;
        }
        this.fResultAdapters.add(resultAdapter);
        return true;
    }

    @Override
    public int getNumberOfResults() {
        return this.fResultAdapters.size();
    }

    @Override
    public List<IResultAdapter> getResults() {
        return Collections.unmodifiableList(this.fResultAdapters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultAdapter findResult(String resultPath) {
        List<IResultAdapter> list = this.fResultAdapters;
        synchronized (list) {
            for (IResultAdapter adapter : this.fResultAdapters) {
                if (adapter.getDataFileName() == null || !adapter.getDataFileName().equals(resultPath)) continue;
                if (adapter.isAdapterExpired()) break;
                return adapter;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsResult(String resultPath) {
        List<IResultAdapter> list = this.fResultAdapters;
        synchronized (list) {
            IResultAdapter adapter;
            Iterator<IResultAdapter> iterator = this.fResultAdapters.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(adapter = iterator.next()).getResultPath().equals(resultPath));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultAdapter findResultWithName(String resultName) {
        List<IResultAdapter> list = this.fResultAdapters;
        synchronized (list) {
            for (IResultAdapter adapter : this.fResultAdapters) {
                if (!adapter.getName().equalsIgnoreCase(resultName)) continue;
                return adapter;
            }
        }
        return null;
    }

    @Override
    public void removeResult(IResultAdapter adapter) {
        this.fResultAdapters.remove(adapter);
        adapter.cleanup(false);
    }

    protected void removeAllResults() {
        this.cleanup();
        this.fResultAdapters.clear();
    }

    public String toString() {
        return this.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        List<IResultAdapter> list = this.fResultAdapters;
        synchronized (list) {
            for (IResultAdapter adapter : this.fResultAdapters) {
                adapter.cleanup(false);
            }
        }
        if (this.getPropFileDir() != null) {
            try {
                ResultViewImportExportUtils.deleteDir(this.getPropFileDir().toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AbstractResultLocation.class) {
            return (T)this;
        }
        return null;
    }

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public IResultContentProvider getProvider() {
        return this.fProvider;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    protected boolean hasResultsToImport(File file) {
        if (file.isDirectory()) {
            File[] datafiles = file.listFiles();
            if (datafiles != null) {
                File[] fileArray = datafiles;
                int n = datafiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (this.isFileSupported(f)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        if (file.isFile()) {
            return this.isFileSupported(file);
        }
        return false;
    }

    @Override
    public void importResultToLocation(File sourceFile) throws CLCoverageZipException {
        File targetFolder = new File(this.getPath());
        try {
            ResultViewImportExportUtils.copyLocalFile(sourceFile, targetFolder);
        }
        catch (IOException e) {
            throw new CLCoverageZipException(e);
        }
    }

    protected boolean isFileSupported(File file) {
        return false;
    }

    protected boolean isHidden(File file) {
        return file.isHidden() && (!file.isDirectory() || !file.getName().equals(".junitcoverage"));
    }

    @Override
    public boolean containsResult(IResultAdapter result) {
        return this.fResultAdapters.contains(result);
    }

    public IResultAdapter getResultAdapter(IResultAdapter result) {
        int idx = this.fResultAdapters.indexOf(result);
        if (idx >= 0) {
            return this.fResultAdapters.get(idx);
        }
        return null;
    }

    public void sortResultAdapters(Comparator<IResultAdapter> comp) {
        Collections.sort(this.fResultAdapters, comp);
    }

    @Override
    public void addSaveMemento(XMLMemento root) {
        if (!this.isSaveRestoreable()) {
            return;
        }
        IMemento child = root.createChild("resultLocation");
        child.putString("path", this.getPath());
        child.putString("name", this.getName());
        this.addSaveProperties(child);
    }

    protected abstract void addSaveProperties(IMemento var1);

    @Override
    public boolean isRemote() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceResult(IResultAdapter existing, IResultAdapter replacement) {
        List<IResultAdapter> list = this.fResultAdapters;
        synchronized (list) {
            this.fResultAdapters.remove(existing);
            existing.cleanup(true);
            replacement.setResultLocation(this);
            this.fResultAdapters.add(replacement);
        }
    }

    protected void setPropFileDir(Path fPropFileDir) {
        this.fPropFileDir = fPropFileDir;
    }

    protected static String normalizeName(String fileName) {
        return fileName.replaceAll(Matcher.quoteReplacement("(:|\\|/)+"), "_");
    }
}

