/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.percentPainter;

import com.ibm.debug.pdt.codecoverage.ui.percentPainter.IProgressPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DefaultPainter
implements IProgressPainter {
    private Color fColorCoveredBack = null;
    private Color fColorCoveredFore = null;
    private Color fColorUncoveredBack = null;
    private Color fColorUncoveredFore = null;

    public DefaultPainter(Color cBack, Color cFore, Color uBack, Color uFore) {
        this.fColorCoveredBack = cBack;
        this.fColorCoveredFore = cFore;
        this.fColorUncoveredBack = uBack;
        this.fColorUncoveredFore = uFore;
    }

    boolean isLinux() {
        return false;
    }

    @Override
    public void paintProgress(GC gc, int x, int y, int width, int height, int percentage, int leftOffset, int rightOffset) {
        if (percentage != 0 && percentage != 100) {
            int offset = width * percentage / 100 + leftOffset;
            int min = Math.min(offset - leftOffset - 1, width - rightOffset);
            gc.setForeground(this.fColorCoveredFore);
            gc.setBackground(this.fColorCoveredBack);
            gc.fillGradientRectangle(x + leftOffset + 1, y, min, height, true);
            gc.setForeground(this.fColorUncoveredFore);
            gc.setBackground(this.fColorUncoveredBack);
            int remainder = width - offset - leftOffset - 1;
            if (remainder > 0) {
                if (this.isLinux()) {
                    gc.fillRectangle(x + offset, y, remainder, height);
                } else {
                    gc.fillGradientRectangle(x + offset, y, remainder, height, true);
                }
                Display display = PlatformUI.getWorkbench().getDisplay();
                gc.setForeground(display.getSystemColor(2));
                gc.setLineWidth(3);
                gc.drawLine(x + offset, y, x + offset, y + height);
            }
        } else {
            gc.setForeground(percentage == 0 ? this.fColorUncoveredFore : this.fColorCoveredFore);
            gc.setBackground(percentage == 0 ? this.fColorUncoveredBack : this.fColorCoveredBack);
            if (this.isLinux()) {
                gc.fillRectangle(x + leftOffset + 1, y, width - rightOffset - 1, height);
            } else {
                gc.fillGradientRectangle(x + leftOffset + 1, y, width - rightOffset - 1, height, true);
            }
        }
    }
}

