/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.percentPainter;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.ui.percentPainter.CoverageColorUtilities;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public abstract class AbstractTattColorFontItem {
    private final ITheme fCurrentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
    private final IPropertyChangeListener fPropertyListener = new ThemePropertyListener();
    private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Color fColorCoveredBack = null;
    private Color fColorCoveredFore = null;
    private Color fColorUncoveredBack = null;
    private Color fColorUncoveredFore = null;
    private Font fCoveredFont = null;
    private Font fUnCoveredFont = null;

    public AbstractTattColorFontItem() {
        IThemeManager manager = PlatformUI.getWorkbench().getThemeManager();
        manager.addPropertyChangeListener(this.fPropertyListener);
        this.fCurrentTheme.addPropertyChangeListener(this.fPropertyListener);
        this.createColors(CoverageColorUtilities.THRESHOLD_COLORS, manager.getCurrentTheme());
        this.createFonts(CoverageColorUtilities.RULER_FONTS, PlatformUI.getWorkbench().getThemeManager().getCurrentTheme());
    }

    private void createColors(String[] colors, ITheme theme) {
        ColorRegistry registry = theme.getColorRegistry();
        RGB rgb = new RGB(255, 255, 255);
        this.fColorCoveredBack = registry.get("com.ibm.rational.llc.color.covered");
        this.fColorUncoveredBack = registry.get("com.ibm.rational.llc.color.uncovered");
        if (this.fColorCoveredBack == null) {
            this.fColorCoveredBack = Display.getDefault().getSystemColor(6);
        }
        if (this.fColorUncoveredBack == null) {
            this.fColorUncoveredBack = Display.getDefault().getSystemColor(3);
        }
        try {
            this.fColorCoveredFore = this.fResourceManager.createColor(ColorUtil.blend((RGB)this.fColorCoveredBack.getRGB(), (RGB)rgb));
            this.fColorUncoveredFore = this.fResourceManager.createColor(ColorUtil.blend((RGB)this.fColorUncoveredBack.getRGB(), (RGB)rgb));
        }
        catch (DeviceResourceException e) {
            ResultsViewPlugin.log("Unable to blend colors");
        }
    }

    private void createFonts(String[] fonts, final ITheme theme) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FontRegistry registry = theme.getFontRegistry();
                AbstractTattColorFontItem.this.fCoveredFont = registry.get("com.ibm.rational.llc.font.covered");
                AbstractTattColorFontItem.this.fUnCoveredFont = registry.get("com.ibm.rational.llc.font.covered");
                if (AbstractTattColorFontItem.this.fCoveredFont == null) {
                    AbstractTattColorFontItem.this.fCoveredFont = JFaceResources.getTextFont();
                }
                if (AbstractTattColorFontItem.this.fUnCoveredFont == null) {
                    AbstractTattColorFontItem.this.fUnCoveredFont = JFaceResources.getTextFont();
                }
            }
        });
    }

    public void dispose() {
        this.fResourceManager.dispose();
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyListener);
        this.fCurrentTheme.removePropertyChangeListener(this.fPropertyListener);
        this.fColorCoveredBack = null;
        this.fColorCoveredFore = null;
        this.fColorUncoveredBack = null;
        this.fColorUncoveredFore = null;
    }

    protected abstract void doRedraw();

    public Color getCoveredBackgroundColor() {
        return this.fColorCoveredBack;
    }

    public Color getUncoveredBackgroundColor() {
        return this.fColorUncoveredBack;
    }

    public Color getCoveredForegroundColor() {
        return this.fColorCoveredFore;
    }

    public Color getUncoveredForegroundColor() {
        return this.fColorUncoveredFore;
    }

    public Font getCoveredFont() {
        return this.fCoveredFont;
    }

    public Font getUncoveredFont() {
        return this.fUnCoveredFont;
    }

    private final class ThemePropertyListener
    implements IPropertyChangeListener {
        private ThemePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property;
            Assert.isNotNull((Object)event);
            Object source = event.getSource();
            if ((source instanceof ColorRegistry || source instanceof FontRegistry) && ((property = event.getProperty()).equals("com.ibm.rational.llc.color.covered") || property.equals("com.ibm.rational.llc.color.uncovered") || property.equals("CHANGE_CURRENT_THEME") || property.equals("com.ibm.rational.llc.font.covered") || property.equals("com.ibm.rational.llc.font.uncovered"))) {
                AbstractTattColorFontItem.this.createColors(CoverageColorUtilities.THRESHOLD_COLORS, PlatformUI.getWorkbench().getThemeManager().getCurrentTheme());
                AbstractTattColorFontItem.this.createFonts(CoverageColorUtilities.RULER_FONTS, PlatformUI.getWorkbench().getThemeManager().getCurrentTheme());
                AbstractTattColorFontItem.this.doRedraw();
            }
        }
    }
}

