/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCFlowPoint;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTestcase;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CCAnnotationModel;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ruler.CumulativeAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulerAnnotationUtilities {
    public static IAnnotationModel getAnnotationModel(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        IAnnotationModelExtension editorModel = (IAnnotationModelExtension)provider.getAnnotationModel((Object)editor.getEditorInput());
        CCAnnotationModel ccModel = (CCAnnotationModel)editorModel.getAnnotationModel((Object)"CC");
        if (ccModel == null) {
            ccModel = new CCAnnotationModel();
            editorModel.addAnnotationModel((Object)"CC", (IAnnotationModel)ccModel);
        }
        return ccModel;
    }

    public static CumulativeAnnotation getCumulativeAnnotation(IAnnotationModel model, int offset, int length) {
        if (model == null) {
            return null;
        }
        Iterator i = null;
        boolean isIteratorHaveOffset = model instanceof IAnnotationModelExtension2;
        i = isIteratorHaveOffset && offset > -1 && length > -1 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!(a instanceof CumulativeAnnotation) || !isIteratorHaveOffset && offset != -1 && !RulerAnnotationUtilities.isAnnotationInRange(model.getPosition(a), offset, length)) continue;
            return (CumulativeAnnotation)a;
        }
        return null;
    }

    public static IDocument getDocument(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IDocument result = editor.getDocumentProvider().getDocument((Object)editorInput);
        return result;
    }

    private static int getLengthOfLine(IDocument document, int lineNumber) {
        if (lineNumber > -1) {
            try {
                return document.getLineLength(lineNumber);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getLengthOfLine(ISourceViewer sourceViewer, int lineNumber) {
        IDocument document = sourceViewer.getDocument();
        return RulerAnnotationUtilities.getLengthOfLine(document, lineNumber);
    }

    public static int getLengthOfLine(ITextEditor editor, int lineNumber) {
        IDocument document = RulerAnnotationUtilities.getDocument(editor);
        return RulerAnnotationUtilities.getLengthOfLine(document, lineNumber);
    }

    private static int getOffsetOfLine(IDocument document, int lineNumber) {
        if (lineNumber > -1) {
            try {
                return document.getLineOffset(lineNumber);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getOffsetOfLine(ISourceViewer sourceViewer, int lineNumber) {
        IDocument document = sourceViewer.getDocument();
        return RulerAnnotationUtilities.getOffsetOfLine(document, lineNumber);
    }

    public static int getOffsetOfLine(ITextEditor editor, int line) {
        if (line > -1) {
            IDocument doc = RulerAnnotationUtilities.getDocument(editor);
            try {
                return doc.getLineOffset(line);
            }
            catch (BadLocationException e) {
                ResultsViewPlugin.log(e);
            }
        }
        return -1;
    }

    private static boolean isAnnotationInRange(Position position, int offset, int length) {
        return position.getOffset() >= offset && position.getOffset() <= offset + length || position.getOffset() < offset && position.getOffset() + length >= offset;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null ? window.getActivePage() : null;
    }

    public static void generateAnnotations(Integer[] cumulativeCoveredLines, Integer[] executableLines, ICCTestcase[] tests, ICCFile file, ITextEditor editor) {
        final IAnnotationModel model = RulerAnnotationUtilities.getAnnotationModel(editor);
        if (model == null) {
            return;
        }
        final ArrayList<CumulativeAnnotation> annotationsToRemove = new ArrayList<CumulativeAnnotation>();
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Object a = i.next();
            if (!(a instanceof CumulativeAnnotation)) continue;
            annotationsToRemove.add((CumulativeAnnotation)((Object)a));
        }
        final HashMap<Annotation, Position> annotations = new HashMap<Annotation, Position>();
        IDocument document = RulerAnnotationUtilities.getDocument(editor);
        annotations.putAll(RulerAnnotationUtilities.getAnnotations(cumulativeCoveredLines, executableLines, tests, file, document));
        if (model instanceof IAnnotationModelExtension) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((IAnnotationModelExtension)model).replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), annotations);
                }
            });
        }
    }

    private static Map<Annotation, Position> getAnnotations(Integer[] coveredLines, Integer[] executableLines, ICCTestcase[] tests, ICCFile file, IDocument document) {
        HashMap<Annotation, Position> result = new HashMap<Annotation, Position>();
        int startLine = 0;
        int endLine = 0;
        boolean covered = false;
        int coveredIdx = 0;
        HashMap<Integer, String> includeFileDetails = new HashMap<Integer, String>();
        ICCFlowPoint[] iCCFlowPointArray = file.getFlowPoints();
        int n = iCCFlowPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileDetails;
            ICCFlowPoint i = iCCFlowPointArray[n2];
            if (i.getType() == 10 && (fileDetails = (String)i.getProperty("details")) != null) {
                includeFileDetails.put(i.getLine(), fileDetails);
            }
            ++n2;
        }
        int i = 0;
        while (i < executableLines.length) {
            int line = executableLines[i];
            if (startLine == 0) {
                endLine = startLine = line;
                if (coveredIdx < coveredLines.length && (covered = coveredLines[coveredIdx].equals(startLine))) {
                    ++coveredIdx;
                }
            } else {
                boolean isLineCovered;
                boolean bl = isLineCovered = coveredIdx < coveredLines.length && coveredLines[coveredIdx].equals(line);
                if (isLineCovered) {
                    ++coveredIdx;
                }
                if (line - endLine > 1 || isLineCovered != covered) {
                    if (startLine > 0 && endLine > 0) {
                        RulerAnnotationUtilities.addAnnotation(covered, tests, file, document, startLine, endLine, result, includeFileDetails);
                    }
                    startLine = line;
                    endLine = line;
                    covered = isLineCovered;
                } else {
                    endLine = line;
                }
            }
            ++i;
        }
        if (startLine > 0 && endLine > 0) {
            RulerAnnotationUtilities.addAnnotation(covered, tests, file, document, startLine, endLine, result, includeFileDetails);
        }
        return result;
    }

    private static void addAnnotation(boolean covered, ICCTestcase[] tests, ICCFile file, IDocument document, int startLine, int endLine, Map<Annotation, Position> result, Map<Integer, String> includeFileDetails) {
        CumulativeAnnotation a = new CumulativeAnnotation(covered, tests, file, startLine, endLine, includeFileDetails);
        try {
            int offset = document.getLineOffset(startLine - 1);
            int endOffset = endLine == document.getNumberOfLines() ? document.getLength() : document.getLineOffset(endLine);
            Position position = new Position(offset, endOffset - offset);
            result.put(a, position);
        }
        catch (BadLocationException e) {
            ResultsViewPlugin.log(4, String.format("Adding annotation to line %s in file %s,  which has %d lines, ", startLine, file.getName(), document.getNumberOfLines()), e);
        }
    }
}

