/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.handlers;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCAPIResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCZipResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IJavaResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ResultsViewPropertyTester
extends PropertyTester {
    public static final String DEFAULT_LOCATION = "defaultResultLocation";
    public static final String SAME_CC_LEVEL = "sameCCLevel";
    public static final String CONNECTED_LOCATION = "connectedLocation";
    public static final String VALID_LOCATION = "validLocation";
    public static final String CAN_MODIFY_RESULT = "canModifyResult";
    public static final String RESULT_AVAILABLE = "resultAvailable";
    public static final String IMPORT_AVAILABLE = "importAvailable";
    public static final String MERGE_AVAILABLE = "mergeAvailable";
    public static final String CAN_EXPORT_CCZIP = "canExportCCzip";
    public static final String IMPORT_JAVA_AVAILABLE = "importJavaAvailable";
    public static final String CC_COMPARE_ENABLED = "isCompareAllowed";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals(DEFAULT_LOCATION)) {
            return this.checkDefaultLocation(receiver, expectedValue);
        }
        if (property.equals(SAME_CC_LEVEL)) {
            return this.checkCCLevel(receiver, expectedValue);
        }
        if (property.equals(CONNECTED_LOCATION)) {
            return this.checkConnectedLocation(receiver, expectedValue);
        }
        if (property.equals(VALID_LOCATION)) {
            return this.checkValidLocation(receiver, expectedValue);
        }
        if (property.equals(CAN_MODIFY_RESULT)) {
            return this.checkCanModifyResult(receiver, expectedValue);
        }
        if (property.equals(RESULT_AVAILABLE)) {
            return this.checkResultAvailable(receiver, expectedValue);
        }
        if (property.equals(IMPORT_AVAILABLE)) {
            return this.checkImportAvailable(receiver, expectedValue);
        }
        if (property.equals(MERGE_AVAILABLE)) {
            return this.checkMergeAvailable(receiver, expectedValue);
        }
        if (property.equals(CAN_EXPORT_CCZIP)) {
            return this.canExportCCZipResult(receiver, expectedValue);
        }
        if (property.equals(IMPORT_JAVA_AVAILABLE)) {
            return this.checkImportJavaAvailable(receiver, expectedValue);
        }
        if (property.equals(CC_COMPARE_ENABLED)) {
            return this.isCompareEnabled(receiver, expectedValue);
        }
        return false;
    }

    private boolean isCompareEnabled(Object receiver, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            Object[] items = ((IStructuredSelection)receiver).toArray();
            if (items.length != 2) {
                return this.matchesExpectedValue(false, expectedValue);
            }
            if (items[0] instanceof IResultAdapter && items[1] instanceof IResultAdapter) {
                String report1Level = ((IResultAdapter)items[0]).getLevel();
                String report2Level = ((IResultAdapter)items[1]).getLevel();
                if (!report1Level.equalsIgnoreCase(Labels.LINE) && !report1Level.isEmpty() || !report2Level.equalsIgnoreCase(Labels.LINE) && !report2Level.isEmpty()) {
                    return this.matchesExpectedValue(false, expectedValue);
                }
            }
        }
        return this.matchesExpectedValue(true, expectedValue);
    }

    private boolean checkImportAvailable(Object receiver, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            Object[] items;
            Object[] objectArray = items = ((IStructuredSelection)receiver).toArray();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IResultLocation) {
                    return this.matchesExpectedValue(((IResultLocation)item).isDefaultLocation() && ((IResultLocation)item).getProvider() != null && ((IResultLocation)item).getProvider().getImportHandler((IResultLocation)item) != null, expectedValue);
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkCCLevel(Object receiver, Object expectedValue) {
        Object[] items;
        if (receiver instanceof IStructuredSelection && (items = ((IStructuredSelection)receiver).toArray()).length == 2 && items[0] instanceof IResultAdapter && items[1] instanceof IResultAdapter) {
            return this.matchesExpectedValue(this.isSameCCLevel((IResultAdapter)items[0], (IResultAdapter)items[1]), expectedValue);
        }
        return false;
    }

    protected boolean isSameCCLevel(IResultAdapter adapter1, IResultAdapter adapter2) {
        if (adapter1 != null && adapter2 != null) {
            return adapter1.getLevel().equals(adapter2.getLevel());
        }
        return false;
    }

    private boolean checkDefaultLocation(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (this.isDefaultLocation(item)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.isDefaultLocation(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean checkConnectedLocation(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            result = true;
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!this.isConnectedLocation(item)) {
                    result = false;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.isConnectedLocation(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean checkValidLocation(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            result = true;
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!this.isValidLocation(item)) {
                    result = false;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.isValidLocation(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean isConnectedLocation(Object item) {
        if (item instanceof IResultLocation) {
            return !(item instanceof IRemoteResultLocation) || ((IRemoteResultLocation)item).isConnected();
        }
        return false;
    }

    private boolean isValidLocation(Object item) {
        if (item instanceof IResultLocation && !(item instanceof IResultAdapter) && !(item instanceof IJavaResultLocation)) {
            return ((IResultLocation)item).getErrorMessage() == null;
        }
        return false;
    }

    private boolean checkMergeAvailable(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            result = false;
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!this.isLocationEmpty(item)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        } else {
            result = !this.isLocationEmpty(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean isLocationEmpty(Object item) {
        int result = 0;
        if (item instanceof IResultLocation) {
            result += ((IResultLocation)item).getNumberOfResults();
        }
        return result == 0;
    }

    private boolean checkCanModifyResult(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            result = true;
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!this.canModifyResult(item)) {
                    result = false;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.canModifyResult(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean canModifyResult(Object item) {
        if (item instanceof IResultAdapter) {
            IResultAdapter adapter = (IResultAdapter)item;
            if (adapter instanceof IRemoteResultAdapter) {
                IRemoteResultLocation remoteLocation = ((IRemoteResultAdapter)adapter).getResultLocation();
                return remoteLocation.isConnected();
            }
            return true;
        }
        return false;
    }

    private boolean checkResultAvailable(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            result = true;
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (!this.isResultAvailable(item)) {
                    result = false;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.isResultAvailable(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean isResultAvailable(Object item) {
        if (item instanceof IResultAdapter) {
            IResultAdapter adapter = (IResultAdapter)item;
            if (adapter instanceof IRemoteResultAdapter) {
                IRemoteResultLocation remoteLocation = ((IRemoteResultAdapter)adapter).getResultLocation();
                return remoteLocation.isConnected() || adapter.isAnalyzed();
            }
            return true;
        }
        return false;
    }

    private boolean matchesExpectedValue(boolean value, Object expectedValue) {
        return expectedValue.equals(value);
    }

    private boolean isDefaultLocation(Object item) {
        return item instanceof IResultLocation && ((IResultLocation)item).isDefaultLocation();
    }

    private boolean canExportCCZipResult(Object receiver, Object expectedValue) {
        boolean atLeastOneCCZip = false;
        if (receiver instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IResultAdapter) {
                    if (item instanceof CCZipResultAdapter || item instanceof CCAPIResultAdapter) {
                        atLeastOneCCZip = true;
                    }
                } else {
                    return false;
                }
                ++n2;
            }
        }
        return this.matchesExpectedValue(atLeastOneCCZip, expectedValue);
    }

    private boolean checkImportJavaAvailable(Object receiver, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)receiver).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (this.canImportJavaResult(item)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        } else {
            result = this.canImportJavaResult(receiver);
        }
        return this.matchesExpectedValue(result, expectedValue);
    }

    private boolean canImportJavaResult(Object item) {
        IResultLocation location;
        return item instanceof IResultLocation && ((location = (IResultLocation)item) instanceof IJavaResultLocation || !location.isDefaultLocation());
    }
}

