/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterItem;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.ICCFilterEventListener;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

class CCFilterTableEditingSupport
extends EditingSupport
implements IResultViewConstants {
    private int fIndex;
    private CellEditor fCellEditor;
    private ICCFilterEventListener fListener;

    public CCFilterTableEditingSupport(ColumnViewer viewer, int columnIdx, ICCFilterEventListener listener) {
        super(viewer);
        this.fIndex = columnIdx;
        this.fListener = listener;
    }

    protected void setValue(Object element, Object value) {
        Object input = this.getViewer().getInput();
        if (input instanceof List) {
            List ccFilterItems = (List)input;
            if (value instanceof String) {
                String newValue = (String)value;
                if (element instanceof CCFilterItem) {
                    CCFilterItem lastItem;
                    boolean defaultAddItem;
                    CCFilterItem item = (CCFilterItem)element;
                    boolean update = false;
                    if (!item.fSelect.equals(Labels.ADD_NEW_ITEM) || this.fIndex == 0) {
                        switch (this.fIndex) {
                            case 0: {
                                String nvalue = newValue.trim().isEmpty() ? "+" : newValue;
                                update = !item.fSelect.equals(nvalue);
                                item.fSelect = nvalue;
                                break;
                            }
                            case 1: {
                                String nvalue = newValue.trim().isEmpty() ? ".*" : newValue;
                                update = !item.fModule.equals(nvalue);
                                item.fModule = nvalue;
                                break;
                            }
                            case 2: {
                                String nvalue = newValue.trim().isEmpty() ? ".*" : newValue;
                                update = !item.fPart.equals(nvalue);
                                item.fPart = nvalue;
                                break;
                            }
                            case 3: {
                                String nvalue = newValue.trim().isEmpty() ? ".*" : newValue;
                                update = !item.fFile.equals(nvalue);
                                item.fFile = nvalue;
                                break;
                            }
                        }
                    }
                    if (item.fSelect.trim().isEmpty() && item.fModule.trim().isEmpty() && item.fPart.trim().isEmpty() && item.fFile.trim().isEmpty()) {
                        ccFilterItems.remove(element);
                        this.getViewer().refresh();
                    } else if (update) {
                        this.getViewer().refresh((Object)item);
                    }
                    if (ccFilterItems.size() < 8 && !(defaultAddItem = CCFilterItem.isDefaultAddItem(lastItem = (CCFilterItem)ccFilterItems.get(ccFilterItems.size() - 1)))) {
                        ccFilterItems.add(new CCFilterItem());
                        this.getViewer().refresh();
                    }
                    if (this.fListener != null) {
                        this.fListener.ccFilterValuesUpdated();
                    }
                }
            }
        }
    }

    protected Object getValue(Object element) {
        if (element instanceof CCFilterItem && !CCFilterItem.isDefaultAddItem((CCFilterItem)element)) {
            String value = "";
            switch (this.fIndex) {
                case 0: {
                    value = ((CCFilterItem)element).fSelect;
                    break;
                }
                case 1: {
                    value = ((CCFilterItem)element).fModule;
                    break;
                }
                case 2: {
                    value = ((CCFilterItem)element).fPart;
                    break;
                }
                case 3: {
                    value = ((CCFilterItem)element).fFile;
                    break;
                }
            }
            return value.trim().isEmpty() ? ".*" : value;
        }
        return "";
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.fIndex == 0) {
            this.fCellEditor = new ComboBoxViewerCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), 8);
            ((ComboBoxViewerCellEditor)this.fCellEditor).setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            ((ComboBoxViewerCellEditor)this.fCellEditor).setLabelProvider((IBaseLabelProvider)new LabelProvider());
            ((ComboBoxViewerCellEditor)this.fCellEditor).setInput((Object)new Object[]{"+", "-"});
        } else {
            this.fCellEditor = new TextCellEditor((Composite)this.getViewer().getControl(), 0);
            this.fCellEditor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    String result = null;
                    if (value != null && !value.toString().isEmpty() && value instanceof String) {
                        result = CCFilterTableEditingSupport.this.validateRegEx(value.toString());
                    }
                    if (result != null && CCFilterTableEditingSupport.this.fListener != null) {
                        CCFilterTableEditingSupport.this.fListener.ccFilterValuesUpdated();
                    }
                    return result;
                }
            });
        }
        return this.fCellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    public String getErrorMessage() {
        return this.fCellEditor != null ? this.fCellEditor.getErrorMessage() : null;
    }

    private String validateRegEx(String text) {
        try {
            Pattern.compile(text);
        }
        catch (PatternSyntaxException ex) {
            return ex.getMessage();
        }
        return null;
    }
}

