/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultsViewImageConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterFile;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterItem;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterLabelProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterTableContentProvider;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterTableEditingSupport;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.ICCFilterEventListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CCFilterTableComposite
extends Composite
implements IResultViewConstants,
IResultsViewImageConstants,
ICCFilterEventListener,
ISelectionChangedListener {
    private TableViewer fViewer;
    private List<CCFilterItem> fCCFilterItems = new ArrayList<CCFilterItem>(10);
    private CCFilterTableEditingSupport fCCFilterEditingSupport;
    private Set<ICCFilterEventListener> fListeners = new HashSet<ICCFilterEventListener>();
    static final int SELECT_COLUMN_IDX = 0;
    static final int MODULE_COLUMN_IDX = 1;
    static final int PART_COLUMN_IDX = 2;
    static final int FILE_COLUMN_IDX = 3;
    static final int COLUMN_WIDTH = 50;
    static final int MAX_ITEMS = 8;
    private Set<ISelectionChangedListener> fListenersSelection = new HashSet<ISelectionChangedListener>();

    public CCFilterTableComposite(Composite parent, int style, int rowCount, String col2, String col3, String col4) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this);
        Composite tableComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tableComposite);
        this.fViewer = new TableViewer(tableComposite, 67584);
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.getTable().setLinesVisible(true);
        for (ISelectionChangedListener selectionListener : this.fListenersSelection) {
            this.addSelectionListener(selectionListener);
        }
        this.fListenersSelection.clear();
        this.initMenuManager();
        TableViewerColumn selectColumn = new TableViewerColumn(this.fViewer, 0);
        selectColumn.getColumn().setText(Labels.INCLUDE_EXCLUDE);
        selectColumn.setLabelProvider((CellLabelProvider)new CCFilterLabelProvider(0));
        this.fCCFilterEditingSupport = new CCFilterTableEditingSupport((ColumnViewer)this.fViewer, 0, this);
        selectColumn.setEditingSupport((EditingSupport)this.fCCFilterEditingSupport);
        TableViewerColumn moduleColumn = new TableViewerColumn(this.fViewer, 0);
        moduleColumn.getColumn().setText(col2);
        moduleColumn.setLabelProvider((CellLabelProvider)new CCFilterLabelProvider(1));
        this.fCCFilterEditingSupport = new CCFilterTableEditingSupport((ColumnViewer)this.fViewer, 1, this);
        moduleColumn.setEditingSupport((EditingSupport)this.fCCFilterEditingSupport);
        TableViewerColumn partsColumn = new TableViewerColumn(this.fViewer, 0);
        partsColumn.getColumn().setText(col3);
        partsColumn.setLabelProvider((CellLabelProvider)new CCFilterLabelProvider(2));
        this.fCCFilterEditingSupport = new CCFilterTableEditingSupport((ColumnViewer)this.fViewer, 2, this);
        partsColumn.setEditingSupport((EditingSupport)this.fCCFilterEditingSupport);
        TableViewerColumn fileColumn = new TableViewerColumn(this.fViewer, 0);
        fileColumn.getColumn().setText(col4);
        fileColumn.setLabelProvider((CellLabelProvider)new CCFilterLabelProvider(3));
        this.fCCFilterEditingSupport = new CCFilterTableEditingSupport((ColumnViewer)this.fViewer, 3, this);
        fileColumn.setEditingSupport((EditingSupport)this.fCCFilterEditingSupport);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)selectColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, false));
        layout.setColumnData((Widget)moduleColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, false));
        layout.setColumnData((Widget)partsColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, false));
        layout.setColumnData((Widget)fileColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, false));
        tableComposite.setLayout((Layout)layout);
        this.fViewer.setItemCount(rowCount);
        int minHeight = this.fViewer.getTable().computeSize((int)-1, (int)-1).y;
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, minHeight).applyTo((Control)tableComposite);
        this.fViewer.getTable().setItemCount(0);
        this.fCCFilterItems.add(new CCFilterItem());
        this.fViewer.setContentProvider((IContentProvider)new CCFilterTableContentProvider());
        this.fViewer.setInput(this.fCCFilterItems);
        this.makeTableAccessible();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
    }

    private void initMenuManager() {
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new Action(Labels.BTN_REMOVE){

                    public ImageDescriptor getImageDescriptor() {
                        return ResultsViewPlugin.getDefault().getImageRegistry().getDescriptor("icons/elcl16/remove_16.png");
                    }

                    public boolean isEnabled() {
                        ISelection selection = (this).CCFilterTableComposite.this.fViewer.getSelection();
                        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                            Object item = ((IStructuredSelection)selection).getFirstElement();
                            return item instanceof CCFilterItem && !CCFilterItem.isDefaultAddItem((CCFilterItem)item);
                        }
                        return !selection.isEmpty();
                    }

                    public void run() {
                        Object item;
                        ISelection selection = (this).CCFilterTableComposite.this.fViewer.getSelection();
                        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (item = ((IStructuredSelection)selection).getFirstElement()) instanceof CCFilterItem && !CCFilterItem.isDefaultAddItem((CCFilterItem)item)) {
                            (this).CCFilterTableComposite.this.fCCFilterItems.remove(item);
                            if ((this).CCFilterTableComposite.this.fCCFilterItems.size() == 7) {
                                (this).CCFilterTableComposite.this.fCCFilterItems.add(new CCFilterItem());
                            }
                            (this).CCFilterTableComposite.this.fViewer.refresh();
                            for (ICCFilterEventListener l : (this).CCFilterTableComposite.this.fListeners) {
                                l.ccFilterValuesUpdated();
                            }
                        }
                    }
                });
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.fViewer.getControl().setMenu(menuManager.createContextMenu(this.fViewer.getControl()));
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        for (ICCFilterEventListener l : this.fListeners) {
            l.ccFilterValuesUpdated();
        }
    }

    public void widgetSelected(SelectionEvent arg0) {
        for (ICCFilterEventListener l : this.fListeners) {
            l.ccFilterValuesUpdated();
        }
    }

    @Override
    public void ccFilterValuesUpdated() {
        for (ICCFilterEventListener l : this.fListeners) {
            l.ccFilterValuesUpdated();
        }
    }

    public void addCCFilterListener(ICCFilterEventListener listener) {
        this.fListeners.add(listener);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fViewer == null) {
            this.fListenersSelection.add(listener);
        } else if (listener != null) {
            this.fViewer.addSelectionChangedListener(listener);
        }
    }

    public void init(List<CCFilterFile.LoadCCFilter> loadCCFilter) {
        this.fCCFilterItems.clear();
        if (loadCCFilter != null) {
            int i = 0;
            while (i < loadCCFilter.size() && i < 8) {
                CCFilterFile.LoadCCFilter filters = loadCCFilter.get(i);
                this.fCCFilterItems.add(new CCFilterItem(filters.getLoadSelect(), filters.getLoadModule(), filters.getLoadPart(), filters.getLoadFile()));
                ++i;
            }
        }
        this.fCCFilterItems.add(new CCFilterItem());
        this.fViewer.refresh();
    }

    public String getErrorMessage() {
        if (this.fCCFilterEditingSupport.getErrorMessage() != null) {
            return this.fCCFilterEditingSupport.getErrorMessage();
        }
        return this.fCCFilterItems.size() == 1 ? CCResultViewMessages.CRRDG9327 : null;
    }

    public List<CCFilterItem> getCCFilterItems() {
        return this.fCCFilterItems;
    }

    public boolean canMove(boolean up) {
        ISelection selection = this.fViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object item = ((IStructuredSelection)selection).getFirstElement();
            int idx = this.fCCFilterItems.indexOf((CCFilterItem)item);
            return !(up && idx == 0 || !up && idx == this.fCCFilterItems.size() - 2) && idx != this.fCCFilterItems.size() - 1;
        }
        return false;
    }

    public void doMove(boolean up) {
        Object item;
        ISelection selection = this.fViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (item = ((IStructuredSelection)selection).getFirstElement()) instanceof CCFilterItem && !CCFilterItem.isDefaultAddItem((CCFilterItem)item)) {
            int idx = this.fCCFilterItems.indexOf((CCFilterItem)item);
            if (up && idx == 0 || !up && idx == this.fCCFilterItems.size() - 2) {
                return;
            }
            int newIdx = up ? idx - 1 : idx + 1;
            this.fCCFilterItems.remove(idx);
            this.fCCFilterItems.add(newIdx, (CCFilterItem)item);
            this.fViewer.refresh();
        }
    }

    public void removeAll() {
        this.fCCFilterItems.clear();
        this.fCCFilterItems.add(new CCFilterItem());
        this.fViewer.refresh();
        for (ICCFilterEventListener l : this.fListeners) {
            l.ccFilterValuesUpdated();
        }
    }

    private void makeTableAccessible() {
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    CCFilterTableComposite.this.fViewer.getTable().showColumn(CCFilterTableComposite.this.fViewer.getTable().getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.fViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fViewer), naviStrat);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 32 && event.stateMask == 262144) || event.eventType == 4;
            }
        };
        actSupport.setEnableEditorActivationWithKeyboard(true);
        int feature = 58;
        TableViewerEditor.create((TableViewer)this.fViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
    }

    public int getFCCFilterSize() {
        return this.fCCFilterItems.size();
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }
}

