/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CCFilterFile
implements IResultViewConstants {
    private List<LoadCCFilter> fLoadCCFilters;
    private String fFilePath;
    private List<String> fComments;

    public CCFilterFile(String filePath) {
        this.fFilePath = filePath;
        this.fLoadCCFilters = new ArrayList<LoadCCFilter>();
        this.fComments = new ArrayList<String>();
    }

    public List<LoadCCFilter> getLoadCCFilters() {
        return new ArrayList<LoadCCFilter>(this.fLoadCCFilters);
    }

    public void addLoadCCFilter(String loadSelect, String loadModule, String loadPart, String loadFile) {
        this.fLoadCCFilters.add(new LoadCCFilter(loadSelect, loadModule, loadPart, loadFile));
    }

    public void clearLoadFilters() {
        this.fLoadCCFilters.clear();
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public void setFilePath(String newPath) {
        this.fFilePath = newPath;
    }

    public String getName() {
        String fileName = "";
        File file = new File(this.getFilePath());
        fileName = file.getName().replaceFirst("[.](txt)$", "");
        return fileName;
    }

    public void addComments(String comment) {
        this.fComments.add(comment);
    }

    public List<String> getComments() {
        return this.fComments;
    }

    public void clearComments() {
        this.fComments.clear();
    }

    public static class LoadCCFilter {
        String fLoadSelect;
        String fLoadModule;
        String fLoadPart;
        String fLoadFile;

        public LoadCCFilter(String loadSelect, String loadModule, String loadPart, String loadFile) {
            this.fLoadSelect = loadSelect.trim().isEmpty() ? "+" : loadSelect;
            this.fLoadModule = loadModule.trim().isEmpty() ? ".*" : loadModule;
            this.fLoadPart = loadPart.trim().isEmpty() ? ".*" : loadPart;
            this.fLoadFile = loadFile.trim().isEmpty() ? ".*" : loadFile;
        }

        public String getLoadSelect() {
            return this.fLoadSelect;
        }

        public String getLoadModule() {
            return this.fLoadModule;
        }

        public String getLoadPart() {
            return this.fLoadPart;
        }

        public String getLoadFile() {
            return this.fLoadFile;
        }
    }
}

