/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PdfPropertiesDialog
extends TrayDialog
implements Listener {
    private Combo fTypeCombo;
    private Combo fSourceCombo;
    private Combo fSortByCombo;
    private Combo fSortOrderCombo;
    private Combo fLineMarkerCombo;
    private Combo fHideEmptyModuleCombo;
    private Text fThresholdText;
    private Text fMessageText;
    private Text fTitleText;
    private File fFile;
    private Button fResetButton;
    private CLabel fStatusText;
    private boolean fFirstFocus = true;
    private boolean fCompareReport = false;
    private IDialogSettings settings = ResultsViewPlugin.getDefault().getDialogSettings();
    private static final String PDF_PROPERTIES_TRUE = "true";
    private static final String PDF_PROPERTIES_FALSE = "false";
    private static final String PDF_PROPERTIES_TYPE_MODULE = "module";
    private static final String PDF_PROPERTIES_TYPE_FILE = "file";
    private static final String PDF_PROPERTIES_SORT_COVERAGE = "coverage";
    private static final String PDF_PROPERTIES_SORT_NAME = "name";
    private static final String PDF_PROPERTIES_SORT_ASC = "ascending";
    private static final String PDF_PROPERTIES_SORT_DESC = "descending";
    private static final String PDF_PROPERTIES_MESSAGE_DEFAULT = "E,W,I";
    private static final String REPORT_TITLE = "reportTitle";
    private static final String REPORT_TYPE = "reportType";
    private static final String INCLUDE_SOURCE = "includeSource";
    private static final String THRESHOLD_PERCENTAGE = "thresholdPercentage";
    private static final String SHOW_MESSAGE = "showMessage";
    private static final String SORT_BY = "sortBy";
    private static final String SORT_ORDER = "sortOrder";
    private static final String LINE_MARKER = "lineMarker";
    private static final String HIDE_EMPTY_MODULE = "hideEmptyModule";
    private static final int fTextWidth = 200;
    private static final Image fErrorImage = ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/error_obj.png");

    public PdfPropertiesDialog(Shell shell, File file, boolean isCompareReport) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fFile = file;
        this.fCompareReport = isCompareReport;
    }

    protected void initPage() {
        this.initCombo(this.settings.get(REPORT_TYPE), this.fTypeCombo);
        this.initCombo(this.settings.get(INCLUDE_SOURCE), this.fSourceCombo);
        this.initCombo(this.settings.get(SORT_BY), this.fSortByCombo);
        this.initCombo(this.settings.get(SORT_ORDER), this.fSortOrderCombo);
        this.initCombo(this.settings.get(LINE_MARKER), this.fLineMarkerCombo);
        this.initCombo(this.settings.get(HIDE_EMPTY_MODULE), this.fHideEmptyModuleCombo);
        this.initTextBox(this.settings.get(REPORT_TITLE), this.fTitleText, "");
        this.initTextBox(this.settings.get(THRESHOLD_PERCENTAGE), this.fThresholdText, "");
        this.initTextBox(this.settings.get(SHOW_MESSAGE), this.fMessageText, PDF_PROPERTIES_MESSAGE_DEFAULT);
        if (this.fCompareReport) {
            this.fHideEmptyModuleCombo.select(1);
            this.fHideEmptyModuleCombo.setEnabled(false);
        }
        if (this.fSortByCombo.getText().equalsIgnoreCase(PDF_PROPERTIES_SORT_NAME)) {
            this.fSortOrderCombo.select(0);
            this.fSortOrderCombo.setEnabled(false);
        }
        if (this.fSourceCombo.getText().equalsIgnoreCase(PDF_PROPERTIES_FALSE)) {
            this.fLineMarkerCombo.select(0);
            this.fLineMarkerCombo.setEnabled(false);
        }
    }

    protected void initTextBox(String text, Text textBox, String defaultText) {
        if (text == null || text.isEmpty()) {
            textBox.setText(defaultText);
        } else {
            textBox.setText(text);
        }
    }

    protected void initCombo(String text, Combo comboBox) {
        if (text == null || text.isEmpty()) {
            comboBox.select(0);
        } else {
            comboBox.setText(text);
        }
        comboBox.setEnabled(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Labels.PDF_PROPERTIES_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        GridLayoutFactory.swtDefaults().applyTo((Composite)sc);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sc);
        Composite container = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.createMessageArea(container);
        this.createContentArea(container);
        this.createResetButton(container);
        PdfPropertiesDialog.applyDialogFont((Control)parent);
        sc.setContent((Control)container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        FontReflowUtil.installListeners(sc);
        this.initPage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.PDF_properties_dialog");
        return sc;
    }

    private void createMessageArea(Composite messageContainer) {
        this.fStatusText = new CLabel(messageContainer, 0);
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).span(2, 0).applyTo((Control)this.fStatusText);
        this.fStatusText.setImage(null);
    }

    private void createContentArea(Composite entryContainer) {
        new Label(entryContainer, 0).setText(Labels.REPORT_TITLE);
        String title = null;
        if (this.settings.get(REPORT_TITLE) != null) {
            title = this.settings.get(REPORT_TITLE);
        }
        this.fTitleText = this.createTextBox(entryContainer, Labels.REPORT_TITLE_COMMENT, title);
        new Label(entryContainer, 0).setText(Labels.REPORT_TYPE);
        this.fTypeCombo = this.createComboBox(entryContainer, Labels.REPORT_TYPE_COMMENT, Labels.REPORT_TYPE);
        this.fTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PdfPropertiesDialog.this.fCompareReport) {
                    PdfPropertiesDialog.this.fHideEmptyModuleCombo.setEnabled(true);
                } else {
                    PdfPropertiesDialog.this.fHideEmptyModuleCombo.setEnabled(false);
                }
            }
        });
        new Label(entryContainer, 0).setText(Labels.HIDE_EMPTY_MODULE);
        this.fHideEmptyModuleCombo = this.createComboBox(entryContainer, Labels.HIDE_EMPTY_MODULE_COMMENT, Labels.HIDE_EMPTY_MODULE);
        new Label(entryContainer, 0).setText(Labels.INCLUDE_SOURCE);
        this.fSourceCombo = this.createComboBox(entryContainer, Labels.INCLUDE_SOURCE_COMMENT, Labels.INCLUDE_SOURCE);
        this.fSourceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PdfPropertiesDialog.this.fSourceCombo.getText().equalsIgnoreCase(PdfPropertiesDialog.PDF_PROPERTIES_TRUE)) {
                    PdfPropertiesDialog.this.fLineMarkerCombo.setEnabled(true);
                } else {
                    PdfPropertiesDialog.this.fLineMarkerCombo.select(0);
                    PdfPropertiesDialog.this.fLineMarkerCombo.setEnabled(false);
                }
            }
        });
        new Label(entryContainer, 0).setText(Labels.LINE_MARKER);
        this.fLineMarkerCombo = this.createComboBox(entryContainer, Labels.LINE_MARKER_COMMENT, Labels.LINE_MARKER);
        new Label(entryContainer, 0).setText(Labels.THRESHOLD_PERCENTAGE);
        String threshold = null;
        if (this.settings.get(THRESHOLD_PERCENTAGE) != null) {
            threshold = this.settings.get(THRESHOLD_PERCENTAGE);
        }
        this.fThresholdText = this.createTextBox(entryContainer, Labels.THRESHOLD_PERCENTAGE_COMMENT, threshold);
        new Label(entryContainer, 0).setText(Labels.SHOW_MESSAGE);
        String message = null;
        if (this.settings.get(SHOW_MESSAGE) != null) {
            message = this.settings.get(SHOW_MESSAGE);
        }
        this.fMessageText = this.createTextBox(entryContainer, Labels.SHOW_MESSAGE_COMMENT, message);
        new Label(entryContainer, 0).setText(Labels.SORT_BY);
        this.fSortByCombo = this.createComboBox(entryContainer, Labels.SORT_BY_COMMENT, Labels.SORT_BY);
        this.fSortByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PdfPropertiesDialog.this.fSortByCombo.getText().equalsIgnoreCase(PdfPropertiesDialog.PDF_PROPERTIES_SORT_NAME)) {
                    PdfPropertiesDialog.this.fSortOrderCombo.select(0);
                    PdfPropertiesDialog.this.fSortOrderCombo.setEnabled(false);
                } else {
                    PdfPropertiesDialog.this.fSortOrderCombo.setEnabled(true);
                }
            }
        });
        new Label(entryContainer, 0).setText(Labels.SORT_ORDER);
        this.fSortOrderCombo = this.createComboBox(entryContainer, Labels.SORT_ORDER_COMMENT, Labels.SORT_ORDER);
    }

    private void createResetButton(Composite composite) {
        GridData data = new GridData(896);
        data.horizontalSpan = 2;
        this.fResetButton = new Button(composite, 8);
        this.fResetButton.setLayoutData((Object)data);
        this.fResetButton.setText(Labels.BUTTON_RESET);
        this.fResetButton.setToolTipText(Labels.BUTTON_RESET_COMMENT);
        this.fResetButton.addListener(13, (Listener)this);
    }

    protected void okPressed() {
        if (this.validateProperties()) {
            if (this.fFile != null) {
                this.saveProperties(this.fFile);
            }
            this.saveDialogSetting(this.settings);
            super.okPressed();
        }
    }

    private void saveProperties(File file) {
        try {
            Properties props = new Properties();
            props.setProperty(REPORT_TYPE, this.fTypeCombo.getText());
            props.setProperty(REPORT_TITLE, this.fTitleText.getText());
            props.setProperty(INCLUDE_SOURCE, this.fSourceCombo.getText());
            props.setProperty(THRESHOLD_PERCENTAGE, this.fThresholdText.getText());
            props.setProperty(SHOW_MESSAGE, this.fMessageText.getText());
            props.setProperty(SORT_BY, this.fSortByCombo.getText());
            props.setProperty(SORT_ORDER, this.fSortOrderCombo.getText());
            props.setProperty(LINE_MARKER, this.fLineMarkerCombo.getText());
            props.setProperty(HIDE_EMPTY_MODULE, this.fHideEmptyModuleCombo.getText());
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                props.store(out, Labels.PDF_PROPERTIES_DIALOG_TITLE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ResultsViewPlugin.log(e);
        }
    }

    protected void saveDialogSetting(IDialogSettings settings) {
        settings.put(REPORT_TYPE, this.fTypeCombo.getText().trim());
        settings.put(REPORT_TITLE, this.fTitleText.getText().trim());
        settings.put(INCLUDE_SOURCE, this.fSourceCombo.getText().trim());
        settings.put(THRESHOLD_PERCENTAGE, this.fThresholdText.getText().trim());
        settings.put(SHOW_MESSAGE, this.fMessageText.getText().trim());
        settings.put(SORT_BY, this.fSortByCombo.getText().trim());
        settings.put(SORT_ORDER, this.fSortOrderCombo.getText().trim());
        settings.put(LINE_MARKER, this.fLineMarkerCombo.getText().trim());
        settings.put(HIDE_EMPTY_MODULE, this.fHideEmptyModuleCombo.getText().trim());
    }

    private Combo createComboBox(Composite entryContainer, String toolTipText, String str) {
        Combo comboBox = new Combo(entryContainer, 12);
        comboBox.setToolTipText(toolTipText);
        GridDataFactory.fillDefaults().hint(200, -1).grab(true, false).applyTo((Control)comboBox);
        if (str.equals(Labels.REPORT_TYPE)) {
            comboBox.add(PDF_PROPERTIES_TYPE_FILE);
            comboBox.add(PDF_PROPERTIES_TYPE_MODULE);
        } else if (str.equals(Labels.INCLUDE_SOURCE)) {
            comboBox.add(PDF_PROPERTIES_FALSE);
            comboBox.add(PDF_PROPERTIES_TRUE);
        } else if (str.equals(Labels.SORT_ORDER)) {
            comboBox.add(PDF_PROPERTIES_SORT_ASC);
            comboBox.add(PDF_PROPERTIES_SORT_DESC);
        } else if (str.equals(Labels.SORT_BY)) {
            comboBox.add(PDF_PROPERTIES_SORT_NAME);
            comboBox.add(PDF_PROPERTIES_SORT_COVERAGE);
        } else if (str.equals(Labels.LINE_MARKER)) {
            comboBox.add(PDF_PROPERTIES_FALSE);
            comboBox.add(PDF_PROPERTIES_TRUE);
        } else if (str.equals(Labels.HIDE_EMPTY_MODULE)) {
            comboBox.add(PDF_PROPERTIES_FALSE);
            comboBox.add(PDF_PROPERTIES_TRUE);
        }
        comboBox.select(0);
        return comboBox;
    }

    private Text createTextBox(Composite entryContainer, String toolTipText, final String str) {
        final Text textBox = new Text(entryContainer, 2048);
        textBox.setTextLimit(30);
        textBox.setToolTipText(toolTipText);
        GridDataFactory.fillDefaults().hint(200, -1).grab(true, false).applyTo((Control)textBox);
        textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (PdfPropertiesDialog.this.hasMessage()) {
                    PdfPropertiesDialog.this.clearErrorMessage();
                }
            }
        });
        textBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (PdfPropertiesDialog.this.fFirstFocus) {
                    textBox.setText("");
                    PdfPropertiesDialog.this.fFirstFocus = false;
                }
            }

            public void focusLost(FocusEvent e) {
                if (textBox.getText().isEmpty()) {
                    if (str == null || str.isEmpty()) {
                        textBox.setText("");
                    } else {
                        textBox.setText(str);
                    }
                    PdfPropertiesDialog.this.fFirstFocus = true;
                }
            }
        });
        return textBox;
    }

    private void setErrorMessage(String msg) {
        this.fStatusText.setImage(fErrorImage);
        this.fStatusText.setText(msg);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    private void clearErrorMessage() {
        this.fStatusText.setImage(null);
        this.fStatusText.setText("");
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(true);
        }
    }

    private boolean hasMessage() {
        String text = this.fStatusText.getText();
        return text != null && text.trim().length() > 0;
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget instanceof Button) {
            this.resetToDefault();
        }
    }

    private boolean validateProperties() {
        Object errorMsg = null;
        if (!this.ValidateMessageTypes(this.fMessageText.getText())) {
            errorMsg = Labels.INVALID_MESSAGETYPE_ERROR_MSG;
        }
        if (!this.validateThreshold(this.fThresholdText.getText())) {
            errorMsg = errorMsg != null ? (String)errorMsg + " && " + Labels.INVALID_THRESHOLD_ERROR_MSG : Labels.INVALID_THRESHOLD_ERROR_MSG;
        }
        if (errorMsg != null) {
            this.setErrorMessage((String)errorMsg);
            return false;
        }
        return true;
    }

    private void resetToDefault() {
        this.fTypeCombo.select(0);
        this.fSourceCombo.select(0);
        this.fLineMarkerCombo.select(0);
        this.fSortByCombo.select(0);
        this.fHideEmptyModuleCombo.select(1);
        this.fSortOrderCombo.select(0);
        this.fSortOrderCombo.setEnabled(false);
        if (this.fCompareReport) {
            this.fLineMarkerCombo.setEnabled(false);
            this.fHideEmptyModuleCombo.setEnabled(false);
        }
        this.fTitleText.setText("");
        this.fThresholdText.setText("");
        this.fMessageText.setText(PDF_PROPERTIES_MESSAGE_DEFAULT);
    }

    private boolean ValidateMessageTypes(String value) {
        String message = value;
        if (message == null || message.isEmpty()) {
            message = "E,W";
        }
        HashSet<String> messageTypeSet = new HashSet<String>(Arrays.asList(message.split(",")));
        for (String messageType : messageTypeSet) {
            if (messageType.equalsIgnoreCase("E") || messageType.equalsIgnoreCase("W") || messageType.equalsIgnoreCase("I")) continue;
            return false;
        }
        return true;
    }

    private boolean validateThreshold(String value) {
        return value.matches("^[0-9]?[0-9]{1}$|^100$") || value.isEmpty();
    }
}

