/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.core.results.CCAbstractException;
import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultModifier;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImporter;
import com.ibm.debug.pdt.codecoverage.internal.jacoco.importer.JaCoCoImporter;
import com.ibm.debug.pdt.codecoverage.internal.jacoco.importer.JacocoCCResultModifier;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ImportWizardUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

class JacocoImportWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private static final String ENCODING = "encoding";
    private static final String SOURCE_LOCATIONS = "sourceLocations";
    private static final String CLASS_LOCATIONS = "classLocations";
    private static final String EXEC_LOCATIONS = "execLocations";
    private static final String JA_CO_CO_IMPORT = "JaCoCoImport";
    private IDialogSettings fDialogSettings;
    private Combo fExecFilesCombo;
    private IResultLocation fResultLocation;
    private Button fExecFilesBrowseButton;
    private Combo fClassFilesCombo;
    private Button fClassFilesBrowseButton;
    private Combo fSourceFilesCombo;
    private Button fSourceFilesBrowseButton;
    private Combo fEncodingCombo;
    private boolean fMirrorCombo = true;
    private boolean fPerformingMirror = false;
    protected String fExecFileLocation;
    protected String fClassFileLocation;
    protected String fSourceFileLocation;
    protected String fEncoding;

    public JacocoImportWizardPage(IStructuredSelection selection, IResultLocation resultLocation) {
        super(JA_CO_CO_IMPORT);
        this.fResultLocation = resultLocation;
        this.setTitle(Labels.JACOCOIMPORTWIZARDPAGE_TITLE);
        this.setDescription(Labels.JACOCOIMPORTWIZARDPAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.fDialogSettings = this.getWizard().getDialogSettings();
        Composite scrollParent = new Composite(parent, 0);
        scrollParent.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)scrollParent);
        ScrolledComposite sc = new ScrolledComposite(scrollParent, 768);
        Composite mainComposite = new Composite((Composite)sc, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(mainComposite);
        GridDataFactory.swtDefaults().grab(true, true).span(1, 1).applyTo((Control)mainComposite);
        Label execFilesLabel = new Label(mainComposite, 0);
        execFilesLabel.setText(Labels.EXEC_FILES);
        this.fExecFilesCombo = new Combo(mainComposite, 2048);
        this.fExecFilesCombo.addModifyListener((ModifyListener)this);
        this.fExecFilesCombo.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fExecFilesCombo);
        this.fExecFilesBrowseButton = new Button(mainComposite, 8);
        this.fExecFilesBrowseButton.setText(Labels.BROWSE);
        this.fExecFilesBrowseButton.addSelectionListener((SelectionListener)this);
        Label classFilesLabel = new Label(mainComposite, 0);
        classFilesLabel.setText(Labels.CLASS_FILES);
        this.fClassFilesCombo = new Combo(mainComposite, 2048);
        this.fClassFilesCombo.addModifyListener((ModifyListener)this);
        this.fClassFilesCombo.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fClassFilesCombo);
        this.fClassFilesBrowseButton = new Button(mainComposite, 8);
        this.fClassFilesBrowseButton.setText(Labels.BROWSE);
        this.fClassFilesBrowseButton.addSelectionListener((SelectionListener)this);
        Label sourceFilesLabel = new Label(mainComposite, 0);
        sourceFilesLabel.setText(Labels.SOURCE_FILES);
        this.fSourceFilesCombo = new Combo(mainComposite, 2048);
        this.fSourceFilesCombo.addModifyListener((ModifyListener)this);
        this.fSourceFilesCombo.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fSourceFilesCombo);
        this.fSourceFilesBrowseButton = new Button(mainComposite, 8);
        this.fSourceFilesBrowseButton.setText(Labels.BROWSE);
        this.fSourceFilesBrowseButton.addSelectionListener((SelectionListener)this);
        Label encodingLabel = new Label(mainComposite, 0);
        encodingLabel.setText(Labels.ENCODING);
        this.fEncodingCombo = new Combo(mainComposite, 2048);
        this.fEncodingCombo.addModifyListener((ModifyListener)this);
        this.fEncodingCombo.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEncodingCombo);
        sc.setContent((Control)mainComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.addListener(11, event -> {
            int width = composite.getClientArea().width;
            sc.setMinSize(mainComposite.computeSize(width, -1));
        });
        FontReflowUtil.installListeners(sc);
        this.loadComboHistory();
        this.setPageComplete(false);
        this.setControl((Control)scrollParent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)scrollParent, "com.ibm.debug.pdt.codecoverage.ui.view.import_jacoco");
    }

    private void validatePage() {
        boolean result = this.validateWidget((Widget)this.fExecFilesCombo);
        if (result) {
            this.validateWidget((Widget)this.fClassFilesCombo);
        }
        if (result) {
            this.validateWidget((Widget)this.fSourceFilesCombo);
        }
        if (result) {
            this.validateWidget((Widget)this.fEncodingCombo);
        }
        this.setPageComplete(result);
    }

    private void loadComboHistory() {
        IDialogSettings section = this.fDialogSettings.getSection(JA_CO_CO_IMPORT);
        if (section == null) {
            return;
        }
        this.loadComboHistory(this.fExecFilesCombo, EXEC_LOCATIONS, section);
        this.loadComboHistory(this.fClassFilesCombo, CLASS_LOCATIONS, section);
        this.loadComboHistory(this.fSourceFilesCombo, SOURCE_LOCATIONS, section);
        this.loadComboHistory(this.fEncodingCombo, ENCODING, section);
    }

    private void loadComboHistory(Combo combo, String key, IDialogSettings section) {
        String utf8 = StandardCharsets.UTF_8.name();
        String[] items = section.getArray(key);
        if (items == null) {
            if (combo == this.fEncodingCombo) {
                combo.add(utf8);
            }
            return;
        }
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            combo.add(i);
            ++n2;
        }
        if (combo == this.fEncodingCombo && !Arrays.asList(items).contains(utf8)) {
            combo.add(utf8);
        }
    }

    private void handleBrowse(Combo comboToUpdate) {
        String newLocation;
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 4096);
        if (!comboToUpdate.getText().trim().isEmpty()) {
            dialog.setFilterPath(comboToUpdate.getText().trim());
        }
        if ((newLocation = dialog.open()) != null) {
            comboToUpdate.setText(newLocation);
        }
    }

    public boolean performFinish(IProgressMonitor monitor) {
        monitor.beginTask(Labels.IMPORTING_PROGRESS, 7);
        monitor.worked(1);
        File tempDir = null;
        File cczipFile = null;
        try {
            try {
                String[] stringArray;
                CCResultsFactory.getInstance().clearRegisteredImporters();
                monitor.worked(1);
                ResultViewImportExportUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        JacocoImportWizardPage.this.fExecFileLocation = JacocoImportWizardPage.this.fExecFilesCombo.getText();
                        JacocoImportWizardPage.this.fClassFileLocation = JacocoImportWizardPage.this.fClassFilesCombo.getText();
                        JacocoImportWizardPage.this.fSourceFileLocation = JacocoImportWizardPage.this.fSourceFilesCombo.getText();
                        JacocoImportWizardPage.this.fEncoding = JacocoImportWizardPage.this.fEncodingCombo.getText();
                    }
                });
                this.fSourceFileLocation = this.fSourceFileLocation.trim().isEmpty() ? null : this.fSourceFileLocation;
                this.fEncoding = this.fEncoding.trim().isEmpty() ? null : this.fEncoding;
                monitor.worked(1);
                String[] stringArray2 = new String[]{this.fExecFileLocation};
                String[] stringArray3 = new String[]{this.fClassFileLocation};
                if (this.fSourceFileLocation == null) {
                    stringArray = null;
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = this.fSourceFileLocation;
                }
                JacocoCCResultModifier jccResultModifier = new JacocoCCResultModifier(stringArray2, stringArray3, stringArray, this.fEncoding);
                CCResultsFactory.getInstance().registerImporter((ICCImporter)new JaCoCoImporter());
                ICCResult result = CCResultsFactory.getInstance().createResult(new String[]{this.fExecFileLocation}, (ICCResultModifier)jccResultModifier, new String[]{this.fExecFileLocation});
                monitor.worked(1);
                tempDir = Files.createTempDirectory(result.getName(), new FileAttribute[0]).toFile();
                cczipFile = new File(tempDir.getAbsolutePath() + File.separator + result.getName() + ".cczip");
                monitor.worked(1);
                ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
                exporter.exportResult(result, null, cczipFile.getPath(), true);
                monitor.worked(1);
                CLCoverageZip ccZip = new CLCoverageZip(cczipFile, true);
                ccZip.importFromZip((IProgressMonitor)new NullProgressMonitor(), this.fResultLocation);
                monitor.worked(1);
            }
            catch (CCResultException | CCExportException | CLCoverageZipException | IOException e) {
                String msg = e.getMessage();
                if (e instanceof CCAbstractException) {
                    CCAbstractException[] exceptions = ((CCResultException)e).getExceptions();
                    msg = CCMessageUtilities.getMessage((String)"ACRRDG7265W", (String[])new String[0]);
                    if (exceptions == null || exceptions.length > 1) {
                        ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, (Throwable[])exceptions);
                    } else {
                        ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, (Throwable)exceptions[0]);
                    }
                } else {
                    ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, e);
                }
                CCResultsFactory.getInstance().resetRegisteredImporters();
                if (cczipFile != null && cczipFile.exists() && !cczipFile.delete()) {
                    ResultsViewPlugin.log("unable to remove temp file: " + cczipFile.getAbsolutePath());
                }
                if (tempDir != null && tempDir.exists() && !tempDir.delete()) {
                    ResultsViewPlugin.log("unable to remove temp dir: " + tempDir.getAbsolutePath());
                }
                this.saveComboHistory();
                monitor.done();
                return false;
            }
        }
        finally {
            CCResultsFactory.getInstance().resetRegisteredImporters();
            if (cczipFile != null && cczipFile.exists() && !cczipFile.delete()) {
                ResultsViewPlugin.log("unable to remove temp file: " + cczipFile.getAbsolutePath());
            }
            if (tempDir != null && tempDir.exists() && !tempDir.delete()) {
                ResultsViewPlugin.log("unable to remove temp dir: " + tempDir.getAbsolutePath());
            }
            this.saveComboHistory();
            monitor.done();
        }
        return true;
    }

    private void saveComboHistory() {
        IDialogSettings section = this.fDialogSettings.getSection(JA_CO_CO_IMPORT);
        if (section == null) {
            section = this.fDialogSettings.addNewSection(JA_CO_CO_IMPORT);
        }
        this.saveComboHistory(this.fExecFileLocation, EXEC_LOCATIONS, section);
        this.saveComboHistory(this.fClassFileLocation, CLASS_LOCATIONS, section);
        this.saveComboHistory(this.fSourceFileLocation, SOURCE_LOCATIONS, section);
        this.saveComboHistory(this.fEncoding, ENCODING, section);
    }

    private void saveComboHistory(String comboText, String key, IDialogSettings section) {
        ArrayList<String> execs;
        int location;
        if (comboText == null || comboText.trim().isEmpty()) {
            return;
        }
        String[] savedItems = section.getArray(key);
        if (savedItems == null) {
            savedItems = new String[]{};
        }
        if ((location = (execs = new ArrayList<String>(Arrays.asList(savedItems))).indexOf(comboText)) > -1) {
            execs.remove(location);
        }
        execs.add(0, comboText);
        while (execs.size() > 10) {
            execs.remove(execs.size() - 1);
        }
        section.put(key, execs.toArray(new String[execs.size()]));
    }

    public void modifyText(ModifyEvent e) {
        this.doMirror(e.widget);
        this.setErrorMessage(null);
        if (this.validateWidget(e.widget)) {
            this.validatePage();
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fExecFilesBrowseButton) {
            this.handleBrowse(this.fExecFilesCombo);
        } else if (e.widget == this.fClassFilesBrowseButton) {
            this.handleBrowse(this.fClassFilesCombo);
        } else if (e.widget == this.fSourceFilesBrowseButton) {
            this.handleBrowse(this.fSourceFilesCombo);
        } else if (e.widget instanceof Combo) {
            this.doMirror(e.widget);
        }
        this.setErrorMessage(null);
        if (this.validateWidget(e.widget)) {
            this.validatePage();
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private boolean validateWidget(Widget widget) {
        if (widget == this.fExecFilesCombo) {
            return this.validateDirectory(this.fExecFilesCombo.getText(), CCResultViewMessages.CRRDG9331);
        }
        if (widget == this.fClassFilesCombo) {
            return this.validateDirectory(this.fClassFilesCombo.getText(), CCResultViewMessages.CRRDG9332);
        }
        if (widget == this.fSourceFilesCombo) {
            return this.validateDirectory(this.fSourceFilesCombo.getText(), null);
        }
        if (widget == this.fEncodingCombo) {
            return this.validateEncoding(this.fEncodingCombo.getText());
        }
        return false;
    }

    private boolean validateEncoding(String encoding) {
        if (encoding.trim().isEmpty()) {
            return true;
        }
        if (!Charset.isSupported(encoding)) {
            this.setErrorMessage(NLS.bind((String)CCMessageUtilities.getMessage((String)"ACRRDG7280E"), (Object)encoding));
            return false;
        }
        return true;
    }

    private boolean validateDirectory(String text, String emptyMessage) {
        if (text.trim().isEmpty()) {
            if (emptyMessage != null) {
                this.setErrorMessage(emptyMessage);
                return false;
            }
            return true;
        }
        File directory = new File(text);
        if (directory.exists() && directory.isDirectory() && directory.canWrite()) {
            return true;
        }
        this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9309, (Object)text));
        return false;
    }

    private void doMirror(Widget widget) {
        if (this.fMirrorCombo && !this.fPerformingMirror) {
            if (widget == this.fExecFilesCombo) {
                this.fPerformingMirror = true;
                this.fClassFilesCombo.setText(this.fExecFilesCombo.getText());
                this.fSourceFilesCombo.setText(this.fExecFilesCombo.getText());
                this.fPerformingMirror = false;
            } else if (widget != this.fEncodingCombo) {
                this.fMirrorCombo = false;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fExecFilesCombo != null) {
            this.fExecFilesCombo.forceFocus();
        }
    }
}

