/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.compiled.ICCResultConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZip;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CLCoverageZipException;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ImportWizardUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ImportJavaCCDataWizardPage
extends WizardResourceImportPage
implements Listener,
ICCResultConstants {
    private Text coverageFileSourceField;
    private Button coverageFileSourceButton;
    private IStructuredSelection selection;
    private File fDataFile;

    public ImportJavaCCDataWizardPage(IStructuredSelection sel) {
        super(Labels.ImportCoverageDataWizard_1, sel);
        this.setTitle(Labels.ImportCoverageDataWizardPage_0);
        this.setDescription(Labels.ImportCoverageDataWizardPage_1);
        this.selection = sel;
    }

    private Control[] createTextFieldWithBrowse(Composite parent, String labelName) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(labelName);
        groupLabel.setFont(parent.getFont());
        Text sourceNameField = new Text(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        sourceNameField.setLayoutData((Object)data);
        sourceNameField.setFont(parent.getFont());
        sourceNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportJavaCCDataWizardPage.this.checkPageValid();
            }
        });
        Button sourceBrowseButton = new Button(sourceContainerGroup, 8);
        sourceBrowseButton.setText(Labels.ImportCoverageDataWizardPage_3);
        sourceBrowseButton.addListener(13, (Listener)this);
        GridData g = new GridData(256);
        sourceBrowseButton.setLayoutData((Object)g);
        sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(sourceBrowseButton);
        return new Control[]{sourceNameField, sourceBrowseButton};
    }

    public void createControl(Composite composite) {
        Composite scrollParent = new Composite(composite, 0);
        scrollParent.setLayout((Layout)new FillLayout());
        scrollParent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 1).create());
        ScrolledComposite sc = new ScrolledComposite(scrollParent, 768);
        Composite mainComposite = new Composite((Composite)sc, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setLayoutData((Object)new GridData(1808));
        Composite coverageContainer = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        coverageContainer.setLayout((Layout)layout);
        coverageContainer.setFont(composite.getFont());
        coverageContainer.setLayoutData((Object)new GridData(1808));
        Control[] widgets = this.createTextFieldWithBrowse(coverageContainer, Labels.ImportCoverageDataWizardPage_2);
        this.coverageFileSourceField = (Text)widgets[0];
        this.coverageFileSourceButton = (Button)widgets[1];
        sc.setContent((Control)mainComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.addListener(11, event -> {
            int width = composite.getClientArea().width;
            sc.setMinSize(mainComposite.computeSize(width, -1));
        });
        FontReflowUtil.installListeners(sc);
        this.setControl((Control)scrollParent);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)scrollParent, "com.ibm.debug.pdt.codecoverage.ui.view.import_file");
    }

    public void handleEvent(Event event) {
        if (event.widget == this.coverageFileSourceButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    protected void handleSourceBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.coverageFileSourceField.getShell(), 4096);
        String dataFileExtension = "*.coveragedata";
        StringBuffer filterName = new StringBuffer();
        filterName.append("Coverage Data Files ");
        filterName.append(dataFileExtension);
        dialog.setFilterNames(new String[]{filterName.toString()});
        dialog.setFilterExtensions(new String[]{dataFileExtension});
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.setErrorMessage(null);
            this.coverageFileSourceField.setText(selectedFile);
            this.coverageFileSourceField.setFocus();
        }
    }

    protected IPath queryForContainer(IContainer initialSelection, String msg, String title) {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), initialSelection, true, msg);
        if (title != null) {
            dialog.setTitle(title);
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    protected IPath getContainerFullPath() {
        return null;
    }

    protected void createSourceGroup(Composite arg0) {
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider();
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider();
    }

    protected boolean ensureSourceIsValid() {
        this.fDataFile = new File(this.coverageFileSourceField.getText());
        return this.fDataFile.isFile();
    }

    public boolean performFinish() {
        IResultLocation location = null;
        if (this.selection.isEmpty()) {
            return false;
        }
        location = (IResultLocation)this.selection.getFirstElement();
        if (this.fDataFile.getName().endsWith(".coveragedata")) {
            File tempDir = null;
            File cczipFile = null;
            try {
                try {
                    ICCResult jResult = CCResultsFactory.getInstance().createResult(this.fDataFile.getPath());
                    ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
                    tempDir = Files.createTempDirectory(this.fDataFile.getName(), new FileAttribute[0]).toFile();
                    String newName = this.fDataFile.getName().substring(0, this.fDataFile.getName().length() - ".coveragedata".length());
                    cczipFile = new File(tempDir.getAbsolutePath() + File.separator + newName + ".cczip");
                    exporter.exportResult(jResult, null, cczipFile.getAbsolutePath(), true);
                    CLCoverageZip ccZip = new CLCoverageZip(cczipFile, true);
                    ccZip.importFromZip((IProgressMonitor)new NullProgressMonitor(), location);
                }
                catch (CCResultException | CCExportException | CLCoverageZipException | IOException e) {
                    String msg = e.getMessage();
                    ImportWizardUtilities.openError(Labels.COVERAGEIMPORTWIZARDPAGE_ZIP_IMPORT_ERROR_TITLE, msg, e);
                    ResultsViewPlugin.log(e);
                    if (cczipFile != null && cczipFile.exists() && !cczipFile.delete()) {
                        ResultsViewPlugin.log("unable to remove temp file: " + cczipFile.getAbsolutePath());
                    }
                    if (tempDir != null && tempDir.exists() && !tempDir.delete()) {
                        ResultsViewPlugin.log("unable to remove temp dir: " + tempDir.getAbsolutePath());
                    }
                }
            }
            finally {
                if (cczipFile != null && cczipFile.exists() && !cczipFile.delete()) {
                    ResultsViewPlugin.log("unable to remove temp file: " + cczipFile.getAbsolutePath());
                }
                if (tempDir != null && tempDir.exists() && !tempDir.delete()) {
                    ResultsViewPlugin.log("unable to remove temp dir: " + tempDir.getAbsolutePath());
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkPageValid() {
        if (this.ensureSourceIsValid()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return true;
        }
        this.setErrorMessage(CCResultViewMessages.CRRDG9320);
        this.setPageComplete(false);
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.coverageFileSourceField != null) {
            this.coverageFileSourceField.forceFocus();
        }
    }
}

