/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.CommonImportWizardPage;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.IImportResultWizardContribution;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ImportWizardUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.JacocoImportWizardPage;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.SelectImportTypeWizardPage;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEvent;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.CCResultEventManager;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IResultLocation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CommonImportWizard
extends Wizard
implements IImportWizard {
    private static final String MAIN_ID = "main";
    private static final String WIZARD_SETTINGS_KEY = "CommonImportWizard";
    static final String CCZIP_ID = "CCZIP";
    static final String JaCoCo_ID = "JaCoCo";
    private Map<String, WizardPage> fPages = new HashMap<String, WizardPage>();
    protected IStructuredSelection fSelection;
    protected boolean fComplete = false;
    protected IResultLocation fResultLocation = null;

    public CommonImportWizard() {
        IDialogSettings pluginSettings = ResultsViewPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(WIZARD_SETTINGS_KEY);
        if (wizardSettings == null) {
            wizardSettings = pluginSettings.addNewSection(WIZARD_SETTINGS_KEY);
        }
        this.setDialogSettings(wizardSettings);
    }

    public CommonImportWizard(IResultLocation resultLocation) {
        this();
        this.fResultLocation = resultLocation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Labels.COVERAGEIMPORTWIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
        this.fSelection = selection;
    }

    public void addPages() {
        SelectImportTypeWizardPage fMainPage = new SelectImportTypeWizardPage();
        this.fPages.put(MAIN_ID, fMainPage);
        this.addPage((IWizardPage)fMainPage);
        WizardPage page = new CommonImportWizardPage(this.fSelection, this.fResultLocation);
        this.fPages.put(CCZIP_ID, page);
        this.addPage((IWizardPage)page);
        page = new JacocoImportWizardPage(this.fSelection, this.fResultLocation);
        this.fPages.put(JaCoCo_ID, page);
        this.addPage((IWizardPage)page);
        for (Map.Entry<String, IImportResultWizardContribution> entry : ImportWizardUtilities.getWizardPageContributions().entrySet()) {
            page = entry.getValue().getImportPage(this.fSelection, this.fResultLocation);
            this.fPages.put(entry.getKey(), page);
            this.addPage((IWizardPage)page);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectImportTypeWizardPage) {
            String id = ((SelectImportTypeWizardPage)page).getSelectedId();
            return (IWizardPage)this.fPages.get(id);
        }
        return null;
    }

    public boolean canFinish() {
        SelectImportTypeWizardPage selectionPage = (SelectImportTypeWizardPage)this.fPages.get(MAIN_ID);
        String id = selectionPage.getSelectedId();
        WizardPage wizardPage = this.fPages.get(id);
        return selectionPage.isPageComplete() && wizardPage.isPageComplete();
    }

    public boolean performFinish() {
        if (!this.fComplete) {
            SelectImportTypeWizardPage selectionPage = (SelectImportTypeWizardPage)this.fPages.get(MAIN_ID);
            String id = selectionPage.getSelectedId();
            final WizardPage wizardPage = this.fPages.get(id);
            final IImportResultWizardContribution contribution = ImportWizardUtilities.getWizardPageContributions().get(id);
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (wizardPage != null) {
                            if (contribution != null) {
                                CommonImportWizard.this.fComplete = contribution.performFinish(monitor, wizardPage);
                            } else if (wizardPage instanceof CommonImportWizardPage) {
                                CommonImportWizard.this.fComplete = ((CommonImportWizardPage)wizardPage).performFinish(monitor);
                            } else if (wizardPage instanceof JacocoImportWizardPage) {
                                CommonImportWizard.this.fComplete = ((JacocoImportWizardPage)wizardPage).performFinish(monitor);
                            }
                        } else {
                            monitor.done();
                        }
                        if (CommonImportWizard.this.fComplete) {
                            CommonImportWizard.this.performFinish();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ResultsViewPlugin.log(e);
                return false;
            }
            catch (InterruptedException e) {
                ResultsViewPlugin.log(e);
                return false;
            }
        }
        if (this.fComplete) {
            CCResultEventManager.getDefault().fireResultLocationEvent(new CCResultEvent(this.fResultLocation, 3));
        }
        return this.fComplete;
    }
}

