/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterFile;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterItem;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.CCFilterTableComposite;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.filter.ICCFilterEventListener;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CCTitleAreaDialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CCFilterEditDialog
extends CCTitleAreaDialog
implements IResultViewConstants,
ICCFilterEventListener {
    private Text fNameText;
    private Group fFilterGroup;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveAllButton;
    private CCFilterTableComposite fCCFilterTableComposite;
    private CCFilterFile fCCFilterFile;
    private static final int BUTTON_WIDTH = 150;
    private static final int COL_COUNT = 2;
    private String fTableCol2 = Labels.MODULES;
    private String fTableCol3 = Labels.PARTS;
    private String fTableCol4 = Labels.FILES;
    private Set<IUpdateFilterFilePathListener> fListeners = new HashSet<IUpdateFilterFilePathListener>();

    public void addUpdateFilterFilePathListener(IUpdateFilterFilePathListener listener) {
        if (listener != null) {
            this.fListeners.add(listener);
        }
    }

    public CCFilterEditDialog(Shell shell, String filePath) {
        super(shell);
        this.fCCFilterFile = new CCFilterFile(filePath);
    }

    public CCFilterEditDialog(Shell shell, String filePath, String program, String module, String file) {
        this(shell, filePath);
        this.fTableCol2 = program;
        this.fTableCol3 = module;
        this.fTableCol4 = file;
    }

    public void create() {
        super.create();
        this.setTitle(Labels.FILTER_DIALOG_TITLE);
        this.setMessage(Labels.FILTER_DIALOG_INFO);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Labels.FILTER_DIALOG_TITLE);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        Point size = container.computeSize(-1, -1);
        int MIN_WIDTH = 800;
        int MIN_HEIGHT = 500;
        GridDataFactory.fillDefaults().grab(true, true).hint(Math.max(MIN_WIDTH, size.x), Math.max(MIN_HEIGHT, size.y)).applyTo((Control)container);
        this.createFileNameArea(container);
        this.createFilterTable(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.cc_filter_dialog");
        return composite;
    }

    private void createFileNameArea(Composite container) {
        Composite Composite2 = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(Composite2);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)Composite2);
        Label label = new Label(Composite2, 0);
        label.setText(Labels.FILE_NAME);
        this.fNameText = new Text(Composite2, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNameText);
        this.fNameText.setText(this.fCCFilterFile.getName());
    }

    private void createFilterTable(Composite container) {
        this.fFilterGroup = new Group(container, 20);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.fFilterGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fFilterGroup);
        this.fFilterGroup.setText(Labels.GROUP_FILTER_TITLE);
        Label label = new Label((Composite)this.fFilterGroup, 16384);
        label.setText(Labels.FILTER_TABLE_DESCRIPTION);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).span(2, 0).applyTo((Control)label);
        this.fCCFilterTableComposite = new CCFilterTableComposite((Composite)this.fFilterGroup, 0, 5, this.fTableCol2, this.fTableCol3, this.fTableCol4);
        this.fCCFilterTableComposite.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                CCFilterEditDialog.this.enableButtons(true);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)this.fCCFilterTableComposite);
        this.fCCFilterTableComposite.addCCFilterListener(this);
        Composite buttonComposite = new Composite((Composite)this.fFilterGroup, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(buttonComposite);
        buttonComposite.setLayoutData((Object)new GridData(144));
        this.fUpButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)this.fUpButton);
        this.fUpButton.setText(Labels.BTN_UP);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)this.fDownButton);
        this.fDownButton.setText(Labels.BTN_DOWN);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        new Label(buttonComposite, 0);
        this.fRemoveAllButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)this.fRemoveAllButton);
        this.fRemoveAllButton.setText(Labels.BTN_REMOVE_ALL);
        this.fRemoveAllButton.addSelectionListener((SelectionListener)this);
        if (new File(this.fCCFilterFile.getFilePath()).exists()) {
            try {
                this.loadFilterTable(this.fCCFilterFile);
            }
            catch (FileNotFoundException e) {
                this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9329, (Object)this.fCCFilterFile.getFilePath()));
                ResultsViewPlugin.log(e);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Labels.BTN_SAVE, false);
        this.createButton(parent, 100, Labels.BTN_SAVE_AS, false);
        this.createButton(parent, 12, Labels.BTN_CLOSE, false);
        this.validateFilters();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fUpButton) {
            this.fCCFilterTableComposite.doMove(true);
        } else if (event.widget == this.fDownButton) {
            this.fCCFilterTableComposite.doMove(false);
        } else if (event.widget == this.fRemoveAllButton) {
            this.fCCFilterTableComposite.removeAll();
        }
        this.enableButtons(true);
    }

    @Override
    public void ccFilterValuesUpdated() {
        this.validateFilters();
    }

    protected void buttonPressed(int btnID) {
        if (btnID == 12) {
            this.close();
        }
        if (btnID == 0 || btnID == 100) {
            if (!this.validateFilters()) {
                return;
            }
            try {
                if (btnID == 100) {
                    String newFilePath = this.handleSaveAsButtonPressed();
                    if (newFilePath == null) {
                        return;
                    }
                    this.fCCFilterFile.setFilePath(newFilePath);
                    for (IUpdateFilterFilePathListener listener : this.fListeners) {
                        listener.updateFilterListField(this.fCCFilterFile.getFilePath());
                    }
                }
                this.writeFiltersToFile(new File(this.fCCFilterFile.getFilePath()));
            }
            catch (IOException e) {
                this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9328, (Object)this.fCCFilterFile.getFilePath()));
                ResultsViewPlugin.log(e);
                return;
            }
            this.fCCFilterFile.clearLoadFilters();
            this.fCCFilterFile.clearComments();
            super.buttonPressed(btnID);
            this.close();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private String handleSaveAsButtonPressed() throws IOException {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String extension = "*.txt";
        dialog.setFilterExtensions(new String[]{extension});
        dialog.setFileName("CCFilterListFile.txt");
        dialog.setFilterPath(new File(this.fCCFilterFile.getFilePath()).getParent());
        File newFile = null;
        if (dialog.open() != null && !(newFile = new File(dialog.getFilterPath() + File.separator + dialog.getFileName())).createNewFile()) {
            ResultsViewPlugin.log("CCFilterEditDialog: Unable to create file: " + String.valueOf(newFile));
        }
        return newFile != null ? newFile.getPath() : null;
    }

    private void enableButtons(boolean enabled) {
        Button saveAsButton;
        this.fUpButton.setEnabled(this.fCCFilterTableComposite.canMove(true) && enabled);
        this.fDownButton.setEnabled(this.fCCFilterTableComposite.canMove(false) && enabled);
        this.fRemoveAllButton.setEnabled(this.fCCFilterTableComposite.getFCCFilterSize() > 1 && enabled);
        Button saveButton = this.getButton(0);
        if (saveButton != null) {
            saveButton.setEnabled(enabled);
        }
        if ((saveAsButton = this.getButton(100)) != null) {
            saveAsButton.setEnabled(enabled);
        }
    }

    private void clearErrorMessage() {
        this.setErrorMessage(null);
        this.setMessage(Labels.FILTER_DIALOG_INFO);
        this.enableButtons(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFilterTable(CCFilterFile file) throws FileNotFoundException {
        Scanner scanner;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            scanner = new Scanner(new File(file.getFilePath()), Charset.defaultCharset().name());
            try {
                if (!scanner.hasNext()) {
                    return;
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        {
            while (true) {
                String line;
                if ((line = scanner.nextLine().trim()).isEmpty()) {
                    continue;
                }
                StringTokenizer tokenizer = new StringTokenizer(line);
                int count = tokenizer.countTokens();
                String[] filter = new String[4];
                Boolean validFilter = true;
                int i = 0;
                block21: while (i < count) {
                    String token = tokenizer.nextToken();
                    block3 : switch (i) {
                        case 0: {
                            switch (token) {
                                case "+": {
                                    filter[i] = "+";
                                    break block3;
                                }
                                case "-": {
                                    filter[i] = "-";
                                    break block3;
                                }
                                case "#": {
                                    this.fCCFilterFile.addComments(line);
                                }
                            }
                            validFilter = false;
                            break block21;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            filter[i] = token.isEmpty() ? ".*" : token;
                        }
                    }
                    ++i;
                }
                if (!validFilter.booleanValue()) continue;
                this.fCCFilterFile.addLoadCCFilter(filter[0], filter[1] == null ? ".*" : filter[1], filter[2] == null ? ".*" : filter[2], filter[3] == null ? ".*" : filter[3]);
            }
        }
    }

    private void writeFiltersToFile(File file) throws IOException {
        File parentFile;
        if (!file.exists() && !(parentFile = new File(file.getParent())).mkdirs()) {
            ResultsViewPlugin.log("CCFilterEditDialog: Unable to create parent: " + String.valueOf(parentFile));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter bWriter = Files.newBufferedWriter(Paths.get(file.getPath(), new String[0]), Charset.defaultCharset(), new OpenOption[0]);){
            List<String> comments = this.fCCFilterFile.getComments();
            for (String commentLine : comments) {
                bWriter.write(commentLine);
                bWriter.newLine();
            }
            List<CCFilterItem> filters = this.fCCFilterTableComposite.getCCFilterItems();
            for (CCFilterItem filter : filters) {
                if (!CCFilterItem.isDefaultAddItem(filter)) {
                    String line = filter.getIncl() + " " + filter.getModule() + " " + filter.getPart() + " " + filter.getFile();
                    bWriter.write(line);
                }
                bWriter.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean validateFilters() {
        String error = this.fCCFilterTableComposite.getErrorMessage();
        if (error != null && !error.isEmpty()) {
            this.setErrorMessage(error);
            this.enableButtons(false);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public static interface IUpdateFilterFilePathListener {
        public void updateFilterListField(String var1);
    }
}

