/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.CCResultViewMessages;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.IResultViewConstants;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewContentProviders;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ResultsViewPlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.ConnectLocationFields;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.FontReflowUtil;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.ResultViewImportExportUtils;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ICCResultsView;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddResultLocationDialog
extends TrayDialog
implements IResultViewConstants {
    private static final Image fErrorImage = ResultsViewPlugin.getDefault().getImageRegistry().get("icons/obj16/error_obj.png");
    private CLabel fStatusText;
    private Text fNameText;
    private static final int ncol = 3;
    private static final String ADD_LOCATION_SETTINGS_KEY = "AddResultLocationDialog";
    private ConnectLocationFields fConnectLocationObject;
    private IDialogSettings fDialogSettings;

    public AddResultLocationDialog(Shell shell, ICCResultsView resultsView) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public AddResultLocationDialog(Shell shell) {
        this(shell, null);
    }

    private IDialogSettings getDialogSetting() {
        IDialogSettings pluginSettings = ResultsViewPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = pluginSettings.getSection(ADD_LOCATION_SETTINGS_KEY);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = pluginSettings.addNewSection(ADD_LOCATION_SETTINGS_KEY);
        }
        return this.fDialogSettings;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Labels.ADD_RESULT_LOCATION_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        GridLayoutFactory.fillDefaults().applyTo((Composite)sc);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sc);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite container = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.createNameArea(container);
        this.fConnectLocationObject = new ConnectLocationFields(container, this.getShell(), this.getDialogSetting(), Labels.ExportCCZipWizardPage_Connection, Labels.COVERAGEIMPORTWIZARDPAGE_LOCATION_LABEL, false, false);
        this.fConnectLocationObject.addConnectLocationListener(new ConnectLocationFields.IConnectLocationListener(){

            @Override
            public void modifyText() {
                AddResultLocationDialog.this.validateFields();
            }
        });
        this.createMessageArea(container);
        AddResultLocationDialog.applyDialogFont((Control)composite);
        sc.setContent((Control)container);
        sc.setMinSize(container.computeSize(-1, -1));
        FontReflowUtil.installListeners(sc);
        this.validateFields();
        if (ResultsViewContentProviders.getRemoteDialogContentProviders().length == 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.add_result_location_dialog_no_rse");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.view.add_result_location_dialog");
        }
        return sc;
    }

    private void createNameArea(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Labels.NAME);
        this.fNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).span(2, 0).applyTo((Control)this.fNameText);
    }

    private void createMessageArea(Composite container) {
        this.fStatusText = new CLabel(container, 0);
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).span(2, 0).applyTo((Control)this.fStatusText);
        this.fStatusText.setImage(null);
    }

    protected void okPressed() {
        if (!this.validateFields()) {
            return;
        }
        if (ResultViewImportExportUtils.addNewLocation(this.fConnectLocationObject, this.getShell(), this.fNameText.getText())) {
            this.fConnectLocationObject.saveDialogSettings(this.fDialogSettings);
            super.okPressed();
        }
    }

    private void setErrorMessage(String msg) {
        this.fStatusText.setImage(fErrorImage);
        this.fStatusText.setText(msg);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    private void clearErrorMessage() {
        this.fStatusText.setImage(null);
        this.fStatusText.setText("");
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(true);
        }
    }

    private boolean validateFields() {
        switch (this.fConnectLocationObject.validate()) {
            case INVALID_LOCATION: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9303);
                return false;
            }
            case HOST_NOT_CONNECTED: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9300);
                return false;
            }
            case EXISTS_LOCATION: {
                this.setErrorMessage(NLS.bind((String)CCResultViewMessages.CRRDG9304, (Object)this.fConnectLocationObject.getLocation()));
                return false;
            }
            case INVALID_CCAAS_URL: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9301);
                return false;
            }
            case INVALID_CCAAS_HOST_PORT: {
                this.setErrorMessage(CCResultViewMessages.CRRDG9302);
                return false;
            }
        }
        this.clearErrorMessage();
        return true;
    }
}

