/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.ccaas.security;

import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.Labels;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.util.CCTrayDialog;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CCSImportCertificatePage
extends WizardPage {
    private List<Certificate> fCertificates;
    private Button fProperties;
    private TableViewer fViewer;

    public CCSImportCertificatePage(List<Certificate> certs) {
        super("NewCCSCertificate");
        this.setTitle(Labels.UNTRUSTED_CERTIFICATE);
        this.setDescription(Labels.WIZARD_DESCRIPTION);
        this.fCertificates = certs;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.codecoverage.ui.view.ccs_certificate_import_dialog");
        Composite info = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(info);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)info);
        Label label = new Label(info, 0);
        label.setText(Labels.CERTIFICATE_INFO);
        this.createTableViewer(info);
        this.fProperties = new Button(info, 8);
        this.fProperties.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection sel = (IStructuredSelection)CCSImportCertificatePage.this.fViewer.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof X509Certificate) {
                    CCSCertificateDetailsDialog d = new CCSCertificateDetailsDialog(CCSImportCertificatePage.this.getShell(), (X509Certificate)first);
                    d.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.fProperties.setText(Labels.PROPERTIES_BUTTON);
        GridDataFactory.swtDefaults().align(3, 2).applyTo((Control)this.fProperties);
        this.setControl((Control)info);
    }

    private void createTableViewer(Composite parent) {
        this.fViewer = new TableViewer(parent, 2056);
        Table table = this.fViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(80, 30).applyTo((Control)table);
        TableLayout tableLayout = new TableLayout();
        TableColumn toColumn = new TableColumn(table, 16384);
        toColumn.setText(Labels.ISSUED_TO);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, 90, true));
        TableColumn frmColumn = new TableColumn(table, 16384);
        frmColumn.setText(Labels.ISSUED_BY);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, 90, true));
        TableColumn expColumn = new TableColumn(table, 131072);
        expColumn.setText(Labels.EXPIRATION_DATE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 90, true));
        table.setLayout((Layout)tableLayout);
        String[] properties = new String[]{"STRING", "STRING", "NUMBER"};
        this.fViewer.setColumnProperties(properties);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CCSCertLabelProvider());
        if (this.fCertificates != null) {
            int i = 0;
            while (i < this.fCertificates.size()) {
                this.fViewer.add((Object)this.fCertificates.get(i));
                if (i == 0) {
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fCertificates.get(i)));
                }
                ++i;
            }
        }
    }

    private static class CCSCertLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static int CERT_NAME = 0;
        private static int CERT_UNIT = 1;
        private static int CERT_ORGANIZATION = 2;

        private CCSCertLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof X509Certificate) {
                switch (columnIndex) {
                    case 0: {
                        String name = this.extract(((X509Certificate)element).getSubjectX500Principal().getName(), CERT_NAME);
                        if ((name == null || name.isEmpty()) && ((name = this.extract(((X509Certificate)element).getSubjectX500Principal().getName(), CERT_UNIT)) == null || name.isEmpty())) {
                            name = this.extract(((X509Certificate)element).getSubjectX500Principal().getName(), CERT_ORGANIZATION);
                        }
                        return name;
                    }
                    case 1: {
                        String name = this.extract(((X509Certificate)element).getIssuerX500Principal().getName(), CERT_NAME);
                        if ((name == null || name.isEmpty()) && ((name = this.extract(((X509Certificate)element).getIssuerX500Principal().getName(), CERT_UNIT)) == null || name.isEmpty())) {
                            name = this.extract(((X509Certificate)element).getIssuerX500Principal().getName(), CERT_ORGANIZATION);
                        }
                        return name;
                    }
                    case 2: {
                        Date date = ((X509Certificate)element).getNotAfter();
                        String result = DateFormat.getDateInstance(1).format(date);
                        return result;
                    }
                }
            }
            return "";
        }

        private String extract(String full, int index) {
            String[] pairs = this.parse(full);
            String match = pairs[index].split("=")[1];
            return match;
        }

        private String[] parse(String full) {
            StringBuffer result = new StringBuffer();
            char[] chars = full.toCharArray();
            boolean inQuotes = false;
            int i = 0;
            while (i < chars.length) {
                int c = chars[i];
                if (c == 34) {
                    inQuotes = !inQuotes;
                } else if (c == 44 && !inQuotes) {
                    c = 59;
                }
                result.append((char)c);
                ++i;
            }
            return result.toString().split(";");
        }
    }

    private static class CCSCertificateDetailsDialog
    extends CCTrayDialog {
        private X509Certificate fCertificate;

        protected CCSCertificateDetailsDialog(Shell shell, X509Certificate certificate) {
            super(shell);
            this.fCertificate = certificate;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Labels.CERTIFICATE_DETAILS);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.pdt.codecoverage.ui.view.ccs_certificate_details_dialog");
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite itemComposite = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)itemComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(itemComposite);
            Label labelVersion = new Label(itemComposite, 0);
            labelVersion.setText(Labels.VERSION);
            GridDataFactory.fillDefaults().applyTo((Control)labelVersion);
            Label valueVersion = new Label(itemComposite, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)valueVersion);
            valueVersion.setText(this.fCertificate.getType() + " V." + this.fCertificate.getVersion());
            Label labelIssuedTo = new Label(itemComposite, 0);
            labelIssuedTo.setText(Labels.ISSUED_TO_COLON);
            GridDataFactory.fillDefaults().applyTo((Control)labelIssuedTo);
            Text issuedToValue = new Text(itemComposite, 2120);
            GridDataFactory.fillDefaults().grab(true, false).hint(1, 60).applyTo((Control)issuedToValue);
            issuedToValue.setText(this.fCertificate.getSubjectX500Principal().getName());
            Label labelIssuedBy = new Label(itemComposite, 0);
            labelIssuedBy.setText(Labels.ISSUED_BY_COLON);
            GridDataFactory.fillDefaults().applyTo((Control)labelVersion);
            Text issuedByValue = new Text(itemComposite, 2120);
            GridDataFactory.fillDefaults().grab(true, false).hint(1, 60).applyTo((Control)issuedByValue);
            issuedByValue.setText(this.fCertificate.getIssuerX500Principal().getName());
            Label labelValidity = new Label(itemComposite, 0);
            labelValidity.setText(Labels.VALIDITY);
            GridDataFactory.fillDefaults().applyTo((Control)labelVersion);
            Label validityValue = new Label(itemComposite, 0);
            DateFormat df = DateFormat.getDateInstance(1);
            validityValue.setText(NLS.bind((String)Labels.VALID_FROM_to, (Object)df.format(this.fCertificate.getNotBefore()), (Object)df.format(this.fCertificate.getNotAfter())));
            GridDataFactory.fillDefaults().applyTo((Control)validityValue);
            Label labelAlgorithm = new Label(itemComposite, 0);
            labelAlgorithm.setText(Labels.ALGORITHM);
            GridDataFactory.fillDefaults().applyTo((Control)labelAlgorithm);
            Label algorithmValue = new Label(itemComposite, 0);
            algorithmValue.setText(this.fCertificate.getSigAlgName());
            GridDataFactory.fillDefaults().applyTo((Control)algorithmValue);
            return composite;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

